/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractBatchAddInstructorUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainInstructorPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BatchAddInstructorUI
extends AbstractBatchAddInstructorUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchAddInstructorUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private static final String SYS_RESOURCE = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String VERIFY_PATH = "com.kingdee.eas.hr.train.TrainVerifyResource";
    private Map personDegrees;
    private TrainInstructorPromptBox instructorPromptBox;
    private List instructors;
    private TrainCourseInfo trainCourseInfo;
    private boolean canceled = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.prmtTrainCourse.setEditable(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        TrainCoursePromptBox promptBox = new TrainCoursePromptBox((IUIObject)this);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CourseHour"));
        sic.add(new SelectorItemInfo("CourseHourUnit"));
        sic.add(new SelectorItemInfo("CourseJoinner"));
        sic.add(new SelectorItemInfo("CourseTarget"));
        sic.add(new SelectorItemInfo("courseCost"));
        sic.add(new SelectorItemInfo("CourseKind.name"));
        sic.add(new SelectorItemInfo("treeid.name"));
        promptBox.setSelector(sic);
        this.prmtTrainCourse.setSelector((KDPromptSelector)promptBox);
        TrainUtils.setMutilTableFromBIM(this.contInstructor, this.tblMain);
        JButton button = this.contInstructor.add((Action)((Object)this.actionAddInstructor));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        button.setToolTipText(EASResource.getString((String)RESOURCE, (String)"addInstructor"));
        this.actionAddInstructor.setEnabled(true);
        button = this.contInstructor.add((Action)((Object)this.actionRemoveInstructor));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        button.setToolTipText(EASResource.getString((String)RESOURCE, (String)"removeInstructor"));
        this.actionRemoveInstructor.setEnabled(true);
        this.instructorPromptBox = new TrainInstructorPromptBox((IUIObject)this);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isOuter"));
        sic.add(new SelectorItemInfo("MobilePhone"));
        sic.add(new SelectorItemInfo("Special"));
        sic.add(new SelectorItemInfo("Employee.name"));
        sic.add(new SelectorItemInfo("Employee.cell"));
        sic.add(new SelectorItemInfo("InstructorType.name"));
        this.instructorPromptBox.setSelector(sic);
        this.instructorPromptBox.setSingleSelect(false);
    }

    public void actionAddInstructor_actionPerformed(ActionEvent e) throws Exception {
        this.instructorPromptBox.show();
        if (!this.instructorPromptBox.isCanceled() && this.instructorPromptBox.getData() instanceof Object[]) {
            final Object[] objs = (Object[])this.instructorPromptBox.getData();
            if (objs.length > 10) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        BatchAddInstructorUI.this.dealAddInstructor(objs);
                    }
                };
                new ProgressManager(this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddInstructor(objs);
            }
        }
    }

    public void actionRemoveInstructor_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.tblMain);
    }

    private void dealAddInstructor(Object[] objs) throws BOSException {
        if (objs != null && objs.length > 0) {
            IRow row = null;
            TrainInstructorInfo trainInstructorInfo = null;
            this.setPersonSpecial(objs);
            int length = objs.length;
            for (int i = 0; i < length; ++i) {
                trainInstructorInfo = (TrainInstructorInfo)objs[i];
                if (TrainUtils.isRepeatRowInTable(this.tblMain, trainInstructorInfo.getNumber(), "number")) continue;
                row = this.tblMain.addRow();
                this.setDataToRow(trainInstructorInfo, row);
            }
        }
    }

    private void setPersonSpecial(Object[] objs) throws BOSException {
        HashSet<String> personIds = null;
        TrainInstructorInfo trainInstructorInfo = null;
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            trainInstructorInfo = (TrainInstructorInfo)objs[i];
            if (trainInstructorInfo.isIsOuter()) continue;
            if (personIds == null) {
                personIds = new HashSet<String>();
            }
            personIds.add(trainInstructorInfo.getEmployee().getId().toString());
        }
        if (personIds != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("specialty"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isHighest", (Object)1));
            viewInfo.setFilter(filterInfo);
            PersonDegreeCollection degreeCollection = PersonDegreeFactory.getRemoteInstance().getPersonDegreeCollection(viewInfo);
            if (degreeCollection != null && degreeCollection.size() > 0) {
                if (this.personDegrees == null) {
                    this.personDegrees = new HashMap();
                } else {
                    this.personDegrees.clear();
                }
                PersonDegreeInfo personDegreeInfo = null;
                int size = degreeCollection.size();
                for (int i = 0; i < size; ++i) {
                    personDegreeInfo = degreeCollection.get(i);
                    this.personDegrees.put(personDegreeInfo.getPerson().getId(), personDegreeInfo.getSpecialty());
                }
            }
        }
    }

    private void setDataToRow(Object object, IRow row) {
        TrainInstructorInfo info = (TrainInstructorInfo)object;
        row.getCell("instructorObject").setValue((Object)info);
        row.getCell("number").setValue((Object)info.getNumber());
        if (info.getInstructorType() != null) {
            row.getCell("type").setValue((Object)info.getInstructorType().getName());
        }
        if (info.isIsOuter()) {
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("backgroud").setValue((Object)info.getSpecial());
            row.getCell("phone").setValue((Object)info.getMobilePhone());
            row.getCell("kind").setValue((Object)EASResource.getString((String)SYS_RESOURCE, (String)"OuterInstructor"));
        } else {
            PersonInfo person = info.getEmployee();
            row.getCell("name").setValue((Object)person.getName());
            if (this.personDegrees != null) {
                row.getCell("backgroud").setValue(this.personDegrees.get(person.getId()));
            }
            row.getCell("phone").setValue((Object)person.getCell());
            row.getCell("kind").setValue((Object)EASResource.getString((String)SYS_RESOURCE, (String)"InnerInstructor"));
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeValues();
        this.canceled = this.instructors == null || this.instructors.size() <= 0;
        this.getUIWindow().close();
    }

    private void storeValues() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainCourse);
        this.trainCourseInfo = (TrainCourseInfo)this.prmtTrainCourse.getValue();
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.contInstructor.getTitle() + EASResource.getString((String)VERIFY_PATH, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
        this.instructors = new ArrayList();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.instructors.add(this.tblMain.getRow(i).getCell("instructorObject").getValue());
        }
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    public List getInstructors() {
        return this.instructors;
    }

    public TrainCourseInfo getTrainCourseInfo() {
        return this.trainCourseInfo;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

