/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChannelCoursE1Factory;
import com.kingdee.eas.hr.train.ChannelCoursE1Info;
import com.kingdee.eas.hr.train.client.AbstractChannelCourseListUI;
import com.kingdee.eas.hr.train.client.ChannelCoursEditUI;
import com.kingdee.eas.hr.train.client.ChannelCoursListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ChannelCourseListUI
extends AbstractChannelCourseListUI {
    private static final Logger logger = CoreUIObject.getLogger(ChannelCoursListUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.train.client.TrainSysResource";
    FilterInfo filterInfo = null;
    String flag;

    protected String getEditUIName() {
        return ChannelCoursEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChannelCoursE1Factory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ChannelCoursE1Info objectValue = new ChannelCoursE1Info();
        return objectValue;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.filterInfo;
    }

    public void onLoad() throws Exception {
        this.fetchUIContext();
        super.onLoad();
        this.initTableCellPaintFormat();
        this.initTable();
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                boolean isOuter;
                String trainChannelSupplierType = rowSet.getString("trainChanneCategory.name");
                String trainChannelName = rowSet.getString("Trainchannel.name");
                String courseHour = null;
                if (trainChannelSupplierType != null && trainChannelName != null) {
                    rowSet.updateString("channelCourse", trainChannelSupplierType + " - " + trainChannelName);
                }
                if (isOuter = rowSet.getBoolean("Instructor.IsOuter")) {
                    rowSet.updateString("instructorType", EASResource.getString((String)resourcePath, (String)"OuterInstructor"));
                } else {
                    rowSet.updateString("instructorType", EASResource.getString((String)resourcePath, (String)"InnerInstructor"));
                }
                courseHour = rowSet.getBigDecimal("TrainCourse.CourseHour") != null ? TrainClientUtil.formatBigDecimal(rowSet.getBigDecimal("TrainCourse.CourseHour"), 2) : "0.00";
                String courseUnit = rowSet.getString("TrainCourse.CourseHourUnit");
                rowSet.updateString("courseAndUnit", courseHour + courseUnit);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    private void initTable() {
        if ("course".equals(this.flag)) {
            this.tblMain.getColumn("TrainCourse.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("TrainCourse.number").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("TrainCourse.CourseTarget").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("treeid.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("CourseKind.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("courseAndUnit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("TrainCourse.CourseJoinner").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("TrainCourse.CourseHourUnit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("trainChanneCategory.name").getStyleAttributes().setHided(true);
        } else if ("instructor".equals(this.flag)) {
            this.tblMain.getColumn("Instructor.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("channelCourse").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("instructorType").getStyleAttributes().setHided(true);
        }
    }

    private void initTableCellPaintFormat() {
        this.tblMain.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                int hourAndHourUnitColumn = ChannelCourseListUI.this.tblMain.getColumnIndex("courseAndUnit");
                if (colIndex == hourAndHourUnitColumn - 2 && rowIndex >= 0) {
                    ChannelCourseListUI.this.setHourAndHourUnit(rowIndex);
                }
                return value;
            }
        });
    }

    private void setHourAndHourUnit(int rowIndex) {
        if (this.tblMain.getRow(rowIndex).getCell("TrainCourse.CourseHour").getValue() == null || this.tblMain.getRow(rowIndex).getCell("TrainCourse.CourseHourUnit").getValue() == null) {
            return;
        }
        String str = TrainClientUtil.formatBigDecimal((BigDecimal)this.tblMain.getRow(rowIndex).getCell("TrainCourse.CourseHour").getValue(), 2);
        if (str == null) {
            str = "0";
        }
        str = str + this.tblMain.getRow(rowIndex).getCell("TrainCourse.CourseHourUnit").getValue().toString();
        this.tblMain.getRow(rowIndex).getCell("courseAndUnit").setValue((Object)str);
    }

    private void fetchUIContext() {
        this.filterInfo = (FilterInfo)this.getUIContext().get("filter");
        this.flag = this.getUIContext().get("flag").toString();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

