/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractImportTrainCourseUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ImportTrainCourseUI
extends AbstractImportTrainCourseUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportTrainCourseUI.class);
    private boolean isConfirm = false;
    ArrayList params;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtTrainCourseType.setEnabledMultiSelection(false);
        this.tblMain.getColumn("taskName").getStyleAttributes().setLocked(true);
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.params = (ArrayList)this.getUIContext().get("params");
        if (this.getUIContext().get("courseType") != null) {
            this.prmtTrainCourseType.setValue(this.getUIContext().get("courseType"));
        }
        this.prmtTrainCourseType.setEditFormat("$number$");
        this.prmtTrainCourseType.setCommitFormat("$number$");
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenTen);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFifty);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenhundred);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        super.actionCancel_actionPerformed(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = true;
        if (((Boolean)this.tblMain.getRow(0).getCell("isSelect").getValue()).booleanValue()) {
            Object obj = this.prmtTrainCourseType.getValue();
            if (obj == null || !(obj instanceof TrainCourseTreeInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"please_select_courseType"));
                this.prmtTrainCourseType.requestFocusInWindow();
                return;
            }
            ArrayList list = (ArrayList)this.getUIContext().get("params");
            ErrorHandleModeEnum errorHandleMode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
            for (int i = 0; i < list.size(); ++i) {
                DatataskParameter param = (DatataskParameter)list.get(i);
                param.putContextParam((Object)"trainCourseType", obj);
                param.putContextParam((Object)"errorHandleMode", (Object)errorHandleMode);
            }
        }
        super.actionConfirm_actionPerformed(e);
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        if (this.tblMain.getRowCount() >= 0) {
            this.initSheet();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initSheet();
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        String str = path.substring(path.lastIndexOf("."));
        if (!".xls".equals(str)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"please_select_right_file"));
            this.txtFile.setText("");
            SysUtil.abort();
        }
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        public void itemStateChanged(ItemEvent e) {
            Object obj = ImportTrainCourseUI.this.comboLabel.getSelectedItem();
            if (obj != null) {
                ICell cell = ImportTrainCourseUI.this.tblMain.getCell(0, "excelTabName");
                cell.setValue((Object)obj.toString());
            }
        }
    }
}

