/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.CertifiedCompetencyFactory;
import com.kingdee.eas.hr.base.CertifiedCompetencyInfo;
import com.kingdee.eas.hr.base.client.CertifiedCompetencyPromptBox;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.PersonCheckUpFactory;
import com.kingdee.eas.hr.train.PersonCheckUpInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.client.AbstractPersonCheckUpEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonCheckUpEditUI
extends AbstractPersonCheckUpEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonCheckUpEditUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String certificate = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"CERTIFICATEISNOTNULL");
    private String recordId = null;
    private boolean fromActRecordEditUI = false;
    private boolean fromCourseRecordEditUI = false;
    private HashMap hmUIState = new HashMap();
    private boolean isLoadField = false;

    public void loadFields() {
        super.loadFields();
        this.btnAddNew.setVisible(false);
        if (this.editData == null) {
            this.btnAddNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
        } else {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
        }
        try {
            this.chkIsGetCertificate_actionPerformed(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.editData.getPersonCertifyCmp() != null) {
            CertifiedCompetencyInfo competencyInfo = this.editData.getPersonCertifyCmp().getCertifiedCompetency();
            this.prmpGrade.setData((Object)competencyInfo);
            if (this.editData.getPersonCertifyCmp() != null && this.editData.getPersonCertifyCmp().getCertifiedCompetency() != null) {
                this.prmpWorkType.setValue((Object)this.editData.getPersonCertifyCmp().getCertifiedCompetency().getCategory());
            } else {
                this.prmpWorkType.setValue(null);
            }
            if (competencyInfo != null && competencyInfo.getId() != null) {
                this.editData.put("CertifiedCompetencyID", competencyInfo.getId().toString());
            }
        }
    }

    public void storeFields() {
        super.storeFields();
        if (this.prmpGrade.getData() != null) {
            this.editData.put("CertifiedCompetencyID", ((CertifiedCompetencyInfo)this.prmpGrade.getData()).getId().toString());
        }
    }

    protected void prmpGrade_dataChanged(DataChangeEvent e) throws Exception {
        super.prmpGrade_dataChanged(e);
        if (this.isLoadField) {
            return;
        }
        if (this.prmpGrade.getData() != null) {
            CertifiedCompetencyInfo competencyInfo = (CertifiedCompetencyInfo)this.prmpGrade.getData();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("category.id"));
            sic.add(new SelectorItemInfo("category.name"));
            sic.add(new SelectorItemInfo("category.number"));
            CertifiedCompetencyInfo info = CertifiedCompetencyFactory.getRemoteInstance().getCertifiedCompetencyInfo((IObjectPK)new ObjectUuidPK(competencyInfo.getId().toString()), sic);
            this.prmpWorkType.setData((Object)info.getCategory());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnSubmit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnCopy.setVisible(false);
        } else {
            this.btnSubmit.setVisible(true);
            this.btnRemove.setVisible(true);
            this.btnCopy.setVisible(true);
        }
    }

    protected void prmtPerson_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLoadField) {
            return;
        }
        PersonInfo personInfo = (PersonInfo)this.prmtPerson.getData();
        if (personInfo != null) {
            personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId().toString()), this.getPersonSelector());
            this.prmtHrOrgUnit.setValue((Object)personInfo.getHrOrgUnit());
        } else {
            this.prmtHrOrgUnit.setValue(null);
        }
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("editUI") != null) {
            String comeFrom = (String)this.getUIContext().get("editUI");
            if ("TrainActivityRecordEditUI".equals(comeFrom)) {
                this.fromActRecordEditUI = true;
            } else if ("TrainCourseRecordEditUI".equals(comeFrom)) {
                this.fromCourseRecordEditUI = true;
            }
        }
        this.isLoadField = true;
        super.onLoad();
        this.recordId = (String)this.getUIContext().get("recordId");
        EmployeeMultiF7PromptBox employeePromptBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        employeePromptBox.setUserOrgRangeFilter(true);
        HashSet<String> hrIds = new HashSet<String>();
        hrIds.add(EmployeeClientUtils.getCurrentHRO((Map)this.getUIContext()).getId().toString());
        employeePromptBox.setHROFilter(hrIds);
        employeePromptBox.setIsSingleSelect(true);
        employeePromptBox.setModal(true);
        this.prmtPerson.setSelector((KDPromptSelector)employeePromptBox);
        CertifiedCompetencyPromptBox pmpt = new CertifiedCompetencyPromptBox((IUIObject)this);
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        cuSet.add(EmployeeClientUtils.getCurrentCU((Map)this.getUIContext()));
        pmpt.changeContextByCUSet(cuSet);
        pmpt.setIsSingleSelect(true);
        pmpt.setModal(true);
        this.prmpGrade.setSelector((KDPromptSelector)pmpt);
        if (this.recordId != null) {
            this.editData.setIsFromRecord(false);
        }
        this.isLoadField = false;
    }

    public void initLayout() {
        super.initLayout();
        this.txtScore.setDataType(1);
        this.txtScore.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtScore.setSupportedEmpty(true);
        this.txtScore.setPrecision(2);
    }

    private SelectorItemCollection getPersonSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        return sic;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("personCertifyCmp.certifiedCompetency.name"));
        sic.add(new SelectorItemInfo("personCertifyCmp.certifiedCompetency.category.name"));
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.editData.getId() != null) {
            if (this.fromActRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateActPersonCheckUpID(this.recordId, this.editData.getId().toString());
            }
            if (this.fromCourseRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updatePersonCheckUpID(this.recordId, this.editData.getId().toString());
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object txt;
        super.verifyInput(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkCheckUpDate);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtHrOrgUnit);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtCheckUpNumber);
        if (this.chkIsGetCertificate.isSelected() && ((txt = this.txtCertificate.getSelectedItem()) == null || txt.toString().trim().equals(""))) {
            this.txtCertificate.requestFocus(true);
            MsgBox.showInfo((String)certificate);
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return PersonCheckUpEditUI.class.getName();
    }

    protected IObjectValue createNewData() {
        PersonCheckUpInfo objectValue = new PersonCheckUpInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setSignDate(new Date());
        this.initPerson(objectValue);
        return objectValue;
    }

    private void initPerson(PersonCheckUpInfo objectValue) {
        String personId = (String)this.getUIContext().get("PersonID");
        if (personId != null) {
            PersonInfo personInfo = null;
            try {
                personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId), this.getPersonSelector());
                objectValue.setPerson(personInfo);
                objectValue.setHrOrgUnit(personInfo.getHrOrgUnit());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonCheckUpFactory.getRemoteInstance();
    }

    public IObjectPK runSave() throws Exception {
        this.editData.setHrOrgUnit(EmployeeClientUtils.getCurrentHRO((Map)this.getUIContext()));
        this.editData.setCU(EmployeeClientUtils.getCurrentCU((Map)this.getUIContext()));
        IObjectPK objectPK = super.runSave();
        return objectPK;
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(EmployeeClientUtils.getCurrentHRO((Map)this.getUIContext()));
        this.editData.setCU(EmployeeClientUtils.getCurrentCU((Map)this.getUIContext()));
        IObjectPK objectPK = super.runSubmit();
        this.updateState();
        return objectPK;
    }

    private void updateState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    protected void chkIsGetCertificate_actionPerformed(ActionEvent e) throws Exception {
        this.txtCertificate.setRequired(this.chkIsGetCertificate.isSelected());
        this.txtCertificate.repaint();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(EmployeeClientUtils.getCurrentHRO((Map)this.getUIContext()).getId());
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("id", this.getUIContext().get("PersonID"));
        request.put("selector", (Object)this.getPersonSelector());
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }
}

