/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.TrainAssistant;
import com.kingdee.eas.hr.train.client.AbstractRequirementListUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.RequirementEditUI;
import com.kingdee.eas.hr.train.client.RequirementIssueUI;
import com.kingdee.eas.hr.train.client.RequirementQueryPanelUI;
import com.kingdee.eas.hr.train.client.RequirementResponseProcessUI;
import com.kingdee.eas.hr.train.client.RequirementResponseSummaryUI;
import com.kingdee.eas.hr.train.client.ResponseSuggestSummaryUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class RequirementListUI
extends AbstractRequirementListUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private String currentPersonId = null;
    private String userOrgUnitId = null;
    private boolean curRowIsCreatorOrSameOrg = false;
    private RequirementTypeEnum type = null;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.currentPersonId = TrainUtils.getCurrentPersonId();
        AdminOrgUnitInfo orgUnitInfo = TrainAssistant.getUserOrgInfo(this.currentPersonId, null);
        if (orgUnitInfo != null) {
            this.userOrgUnitId = orgUnitInfo.getId().toString();
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JMenuItem item = this.btnBatchAddNew.addAssistMenuItem((Action)((Object)this.actionAddCourseRequirement));
        item.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAddCourseRequirement), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        item = this.btnBatchAddNew.addAssistMenuItem((Action)((Object)this.actionAddItemRequirement));
        item.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAddItemRequirement), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnBatchAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnProcess.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.btnGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnResponseSuggest.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemProcess.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.menuItemGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemResponseSuggest.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.actionPublish.setEnabled(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return RequirementClientUtil.getRequirementFilterInfo(this.currentPersonId, this.userOrgUnitId);
    }

    protected String getEditUIName() {
        return RequirementEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"currentPersonId", (Object)this.currentPersonId);
        uiContext.put((Object)"userOrgUnitId", (Object)this.userOrgUnitId);
        uiContext.put((Object)"isCreatorOrSameOrg", (Object)this.curRowIsCreatorOrSameOrg);
        uiContext.put((Object)"requirementType", (Object)this.type);
    }

    public void actionAddCourseRequirement_actionPerformed(ActionEvent e) throws Exception {
        this.type = RequirementTypeEnum.COURSE_TYPE;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionAddItemRequirement_actionPerformed(ActionEvent e) throws Exception {
        this.type = RequirementTypeEnum.ITEM_TYPE;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int curIndex = TrainUtils.getCurrentRowIndex(this.tblMain);
        RequirementInfo requirementInfo = new RequirementInfo();
        IRow row = this.tblMain.getRow(curIndex);
        String id = row.getCell("id").getValue().toString();
        BizEnumValueInfo requirementState = (BizEnumValueInfo)row.getCell("state").getValue();
        requirementInfo.setId(BOSUuid.read((String)id));
        requirementInfo.setName((String)row.getCell("name").getValue());
        requirementInfo.setState(RequirementStateEnum.getEnum(requirementState.getInt()));
        UIContext uiContext = new UIContext((Object)this);
        String requirementIssueId = RequirementAssistant.getIssueId(id, this.curRowIsCreatorOrSameOrg, null);
        String state = null;
        if (30 == requirementState.getInt()) {
            if (requirementIssueId == null) {
                TrainClientUtil.showMessageAndAbort(RESOURCE, "UN_PUBLISH", (CoreUI)this);
            } else {
                state = OprtState.VIEW;
                uiContext.put((Object)"ID", (Object)requirementIssueId);
            }
        } else if (requirementIssueId == null) {
            state = OprtState.ADDNEW;
            uiContext.put((Object)"parent", (Object)requirementInfo);
        } else {
            state = OprtState.EDIT;
            uiContext.put((Object)"ID", (Object)requirementIssueId);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RequirementIssueUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
        RequirementIssueUI issueUI = (RequirementIssueUI)uiWindow.getUIObject();
        if (issueUI.isModifiedData() && 10 == requirementState.getInt()) {
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            this.refreshList();
        }
    }

    public void actionProcess_actionPerformed(ActionEvent e) throws Exception {
        this.showResultWindow(RequirementResponseProcessUI.class.getName(), OprtState.VIEW);
    }

    private void showResultWindow(String uiClassName, String state) throws BOSException {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        IRow row = this.tblMain.getRow(TrainUtils.getCurrentRowIndex(this.tblMain));
        String requirementId = row.getCell("id").getValue().toString();
        uiContext.put((Object)"requirement", (Object)requirementId);
        uiContext.put((Object)"requirementName", (Object)row.getCell("name").getValue().toString());
        BizEnumValueInfo type = (BizEnumValueInfo)row.getCell("type").getValue();
        uiContext.put((Object)"requirementType", (Object)RequirementTypeEnum.getEnum(type.getInt()));
        String publisherId = null;
        if (this.curRowIsCreatorOrSameOrg) {
            RequirementIssueInfo issueInfo = RequirementAssistant.getRootIssueInfo(requirementId, null);
            publisherId = issueInfo.getPublisher().getId().toString();
        } else {
            publisherId = TrainUtils.getCurrentPersonId();
        }
        uiContext.put((Object)"publisherId", (Object)publisherId);
        BizEnumValueInfo requirementState = (BizEnumValueInfo)row.getCell("state").getValue();
        uiContext.put((Object)"requirementState", (Object)RequirementStateEnum.getEnum(requirementState.getInt()));
        uiContext.put((Object)"isCreatorOrSameOrg", (Object)this.curRowIsCreatorOrSameOrg);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiContext, null, state);
        uiWindow.show();
    }

    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.showResultWindow(RequirementResponseSummaryUI.class.getName(), OprtState.EDIT);
    }

    public void actionResponseSuggest_actionPerformed(ActionEvent e) throws Exception {
        this.showResultWindow(ResponseSuggestSummaryUI.class.getName(), OprtState.VIEW);
    }

    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!TrainClientUtil.showConfirmMessge(RESOURCE, "CONFIRM_CLOSEREQUIRE", (CoreUI)this)) {
            return;
        }
        String id = this.getSelectedKeyValue();
        RequirementFactory.getRemoteInstance().close((IObjectPK)new ObjectUuidPK(id));
        TrainClientUtil.showMessage(RESOURCE, "CLOSE_SUCCESS", (CoreUI)this);
        this.refreshList();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        try {
            dlg.addUserPanel((KDPanel)new RequirementQueryPanelUI());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dlg;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        this.setActionsState();
    }

    private void setActionsState() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.tblMain);
        if (curIndex < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(curIndex);
        String adminOrgUnitId = (String)row.getCell("adminOrgUnitId").getValue();
        String createPersonId = (String)row.getCell("createPersonId").getValue();
        String requirementId = (String)row.getCell("id").getValue();
        this.curRowIsCreatorOrSameOrg = RequirementClientUtil.isCreatorOrSameOrg(requirementId, createPersonId, adminOrgUnitId, this.currentPersonId, this.userOrgUnitId);
        String state = row.getCell("state").getValue().toString();
        if (this.curRowIsCreatorOrSameOrg) {
            this.actionClose.setEnabled(RequirementStateEnum.PUBLISHED.getAlias().equals(state));
            this.actionEdit.setEnabled(RequirementStateEnum.UN_PUBLISH.getAlias().equals(state));
        } else {
            this.actionEdit.setEnabled(false);
            this.actionClose.setEnabled(false);
        }
        this.actionRemove.setEnabled(RequirementStateEnum.UN_PUBLISH.getAlias().equals(state) && this.currentPersonId.equals(createPersonId));
        BizEnumValueInfo requirementState = (BizEnumValueInfo)row.getCell("state").getValue();
        boolean flag = 10 != requirementState.getInt();
        this.actionProcess.setEnabled(flag);
        this.actionGather.setEnabled(flag);
        this.actionResponseSuggest.setEnabled(flag);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        IUIActionPostman handler = TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
        RequestContext request = new RequestContext();
        request.put("currentPersonId", (Object)TrainUtils.getCurrentPersonId());
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public RequestContext prepareActionGather(IItemAction itemAction) throws Exception {
        return this.prepareRequirementId(super.prepareActionGather(itemAction));
    }

    private RequestContext prepareRequirementId(RequestContext request) {
        if (this.curRowIsCreatorOrSameOrg) {
            this.checkSelected();
            IRow row = this.tblMain.getRow(TrainUtils.getCurrentRowIndex(this.tblMain));
            request.put("requirementId", (Object)row.getCell("id").getValue().toString());
        }
        return request;
    }

    public RequestContext prepareActionProcess(IItemAction itemAction) throws Exception {
        return this.prepareRequirementId(super.prepareActionProcess(itemAction));
    }

    public RequestContext prepareActionResponseSuggest(IItemAction itemAction) throws Exception {
        return this.prepareRequirementId(super.prepareActionResponseSuggest(itemAction));
    }

    public RequestContext prepareActionPublish(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionPublish(itemAction);
        this.checkSelected();
        IRow row = this.tblMain.getRow(TrainUtils.getCurrentRowIndex(this.tblMain));
        request.put("requirementId", (Object)row.getCell("id").getValue().toString());
        request.put("curRowIsCreatorOrSameOrg", (Object)this.curRowIsCreatorOrSameOrg);
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionProcess() {
        return true;
    }

    public boolean isPrepareActionPublish() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddCourseRequirement() {
        return true;
    }

    public boolean isPrepareActionAddItemRequirement() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

