/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponsePublisherUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementResponsePublisherUI
extends AbstractRequirementResponsePublisherUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementResponsePublisherUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private Set responserIds = null;

    public void loadFields() {
        super.loadFields();
        this.txtRequirementRemark.setSelectedItemData((Object)this.editData.getRequirement().getRemark());
        this.setAppointedContentInfo();
        boolean enabled = !OprtState.VIEW.equals(this.getOprtState());
        this.setCompomentsState(enabled);
        this.actionCalculate.setEnabled(enabled);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.menuItemCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        if (!TrainClientUtil.showConfirmMessge(RESOURCE, "CONFIRM_CALCULATE", (CoreUI)this)) {
            return;
        }
        this.storeFields();
        String requirementId = this.editData.getRequirement().getId().toString();
        if (this.responserIds == null) {
            String responserId = this.editData.getResponser().getId().toString();
            this.responserIds = RequirementFacadeFactory.getRemoteInstance().getRequirementReceivers(requirementId, responserId);
        }
        if (!RequirementAssistant.generateResponse(this.editData, requirementId, this.responserIds)) {
            TrainClientUtil.showErrorMessage(RESOURCE, "RESPONSED_EMPTY", new Object[]{this.btnCalculate.getText()}, (CoreUI)this);
        }
        Date now = UserMonitorFactory.getRemoteInstance().getCurrentTime();
        this.editData.setCalculateTime(new Timestamp(now.getTime()));
        this.loadFields();
        this.showSuccessMessage(this.getClassAlise() + " " + EASResource.getString((String)RESOURCE, (String)"Msg_Calculate_OK"));
    }

    protected void initRequirementGrade(KDTable table) throws Exception {
        KDFormattedTextField txtCount = TrainUtils.setTableCellEditorByFormattedTextField(table, "highCount", 0);
        TrainUtils.setPositiveNumberValue(txtCount);
        txtCount = TrainUtils.setTableCellEditorByFormattedTextField(table, "middleCount", 0);
        TrainUtils.setPositiveNumberValue(txtCount);
        txtCount = TrainUtils.setTableCellEditorByFormattedTextField(table, "lowCount", 0);
        TrainUtils.setPositiveNumberValue(txtCount);
    }

    protected IRow setSuggestRowInfo(IRow row) {
        row.getCell("middleCount").setValue((Object)1);
        return row;
    }

    public SelectorItemCollection getSelectors() {
        return TrainUtils.mergeSelectorItemCollection(super.getSelectors(), this.responseSelector);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (RequirementAssistant.responserIsModified(this.editData)) {
            String name = ((KDWorkButton)e.getSource()).getToolTipText();
            if (!TrainClientUtil.showConfirmMessge((CoreUI)this, RESOURCE, "RESPONSE_MODIFIED", new Object[]{name})) {
                SysUtil.abort();
            }
            this.setRequireSubmitPrompt(false);
        }
        super.beforeStoreFields(e);
    }

    protected boolean isModifySave() {
        return this.actionSave.isEnabled();
    }

    protected boolean requireLevelHasValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        return false;
    }

    protected void showRequireLevelWarning(String tableTitle) {
        MsgBox.showWarning((Component)((Object)this), (String)TrainClientUtil.getResource(RESOURCE, "REQUIRELEVEL_PUBLISHER_EMPTY", new Object[]{tableTitle}));
        SysUtil.abort();
    }
}

