/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.train.AbstractTrainActivityInfo;
import com.kingdee.eas.hr.train.AssessMethodInfo;
import com.kingdee.eas.hr.train.ChannelCoursE1Info;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.ITrainInstructor;
import com.kingdee.eas.hr.train.ParticipatorRoleFactory;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorCollection;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorInfo;
import com.kingdee.eas.hr.train.TrainActCourseStateEnum;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainInstructorCollection;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.TrainingMethodInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActCourseEditUI;
import com.kingdee.eas.hr.train.client.TableActionHandler;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TrainActCourseEditUI
extends AbstractTrainActCourseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActCourseEditUI.class);
    private static final String QueryInfo = "com.kingdee.eas.hr.train.app.ChannelCoursForF7Query";
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private HashMap hmUIState = new HashMap();
    private ItemAction[] actions;
    private boolean pubBtnState = false;

    public void loadFields() {
        int i;
        int count;
        super.loadFields();
        if (this.editData.getAssessMethod() != null) {
            String assessMethodId = this.editData.getAssessMethod().getId().toString();
            count = this.comboAssessMethod.getItemCount();
            for (i = 0; i < count; ++i) {
                AssessMethodInfo assessMethodInfo = (AssessMethodInfo)this.comboAssessMethod.getItemAt(i);
                if (!assessMethodId.equals(assessMethodInfo.getId().toString())) continue;
                this.comboAssessMethod.setSelectedIndex(i);
                break;
            }
        }
        if (this.editData.getTrainingMethod() != null) {
            String trainingMethodId = this.editData.getTrainingMethod().getId().toString();
            count = this.comboTrainingMethod.getItemCount();
            for (i = 0; i < count; ++i) {
                TrainingMethodInfo trainingMethodInfo = (TrainingMethodInfo)this.comboTrainingMethod.getItemAt(i);
                if (!trainingMethodId.equals(trainingMethodInfo.getId().toString())) continue;
                this.comboTrainingMethod.setSelectedIndex(i);
                break;
            }
        }
        if (this.editData.getCourseHourUnit() != null) {
            CourseHourUnitEnum courseHourUnit = this.editData.getCourseHourUnit();
            count = this.comboCourseHourUnit.getItemCount();
            for (i = 0; i < count; ++i) {
                CourseHourUnitEnum hourUnit = (CourseHourUnitEnum)((Object)this.comboCourseHourUnit.getItemAt(i));
                if (!courseHourUnit.equals((Object)hourUnit)) continue;
                this.comboCourseHourUnit.setSelectedIndex(i);
                break;
            }
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
        }
        this.setActionState(!OprtState.VIEW.equals(this.getOprtState()));
        try {
            this.setOrgUnitAndPositionByPerson();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setActionState(boolean flag) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setEnabled(flag);
        }
        this.kdtParticipators.getStyleAttributes().setLocked(!flag);
    }

    protected void lockUIForViewStatus() {
    }

    protected void unLockUI() {
        TrainClientUtil.unLockUI(this.hmUIState);
    }

    private void setOrgUnitAndPositionByPerson() throws Exception {
        IRow row = null;
        PersonInfo personInfo = null;
        PositionInfo positionInfo = null;
        int size = this.kdtParticipators.getRowCount();
        for (int i = 0; i < size; ++i) {
            ChannelCoursE1Info channelCourseInfo;
            row = this.kdtParticipators.getRow(i);
            personInfo = (PersonInfo)row.getCell("participator").getValue();
            if (personInfo != null && (positionInfo = TrainActivityHelper.getPositionAndAdminOrgUnit(personInfo.getId().toString())) != null) {
                row.getCell("orgUnit").setValue((Object)positionInfo.getAdminOrgUnit());
                row.getCell("position").setValue((Object)positionInfo);
            }
            if ((channelCourseInfo = (ChannelCoursE1Info)row.getCell("channelCourse").getValue()) == null) continue;
            personInfo = new PersonInfo();
            TrainInstructorInfo instructorInfo = channelCourseInfo.getInstructor();
            if (!instructorInfo.isIsOuter()) {
                personInfo.setName(instructorInfo.getEmployee().getName());
                positionInfo = TrainActivityHelper.getPositionAndAdminOrgUnit(instructorInfo.getEmployee().getId().toString());
                if (positionInfo != null) {
                    row.getCell("orgUnit").setValue((Object)positionInfo.getAdminOrgUnit());
                    row.getCell("position").setValue((Object)positionInfo);
                }
            } else {
                personInfo.setName(instructorInfo.getName());
            }
            row.getCell("participator").setValue((Object)personInfo);
            row.getCell("number").setValue((Object)instructorInfo.getNumber());
        }
    }

    public void onLoad() throws Exception {
        this.pubBtnState = TrainUtils.getParamValueByNumber("hr_train_003");
        this.kdtParticipators.checkParsed();
        this.setComboBox();
        this.pkStartDate.setTimeEnabled(true);
        this.pkEndDate.setTimeEnabled(true);
        this.prmtTrainCourse.setRequired(true);
        this.txtPassStand.setText(null);
        this.initPrmtTrainCourse();
        TrainActivityHelper.initCourseHourUnit(this.comboCourseHourUnit);
        TableActionHandler handler = new TableActionHandler(){

            public IRow afterAddLine(IRow row) {
                row.getCell("isTeacher").setValue((Object)false);
                return row;
            }

            public IRow afterInsertLine(IRow row) {
                return this.afterAddLine(row);
            }
        };
        this.actions = TrainUtils.addButtonsToMutilTable(this.contParticipator, this.kdtParticipators, handler);
        super.onLoad();
        KDCheckBox chkTeacher = new KDCheckBox();
        this.kdtParticipators.getColumn("isTeacher").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkTeacher));
        chkTeacher.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int rowIndex = TrainUtils.getCurrentRowIndex(TrainActCourseEditUI.this.kdtParticipators);
                IRow row = TrainActCourseEditUI.this.kdtParticipators.getRow(rowIndex);
                row.getCell("participator").setValue(null);
                row.getCell("number").setValue(null);
                row.getCell("orgUnit").setValue(null);
                row.getCell("position").setValue(null);
                row.getCell("trainChannel").setValue(null);
                row.getCell("channelCourse").setValue(null);
            }
        });
        KDComboBox cboRole = new KDComboBox();
        cboRole.setModel((ComboBoxModel)TrainUtils.getComboModel(ParticipatorRoleFactory.getRemoteInstance(), TrainUtils.getCurrentHRFilter("hrOrgUnit.id")));
        TrainUtils.setTableCellEditorByComboBox(this.kdtParticipators, cboRole, "role");
        KDBizPromptBox prmtEmployee = new KDBizPromptBox();
        prmtEmployee.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.kdtParticipators.getColumn("participator").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEmployee));
        prmtEmployee.setEditable(false);
        prmtEmployee.setEditFormat("$name$");
        prmtEmployee.setCommitFormat("$name$");
        prmtEmployee.setDisplayFormat("$name$");
        prmtEmployee.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                TrainActCourseEditUI.this.handleResult(e);
            }
        });
        TrainClientUtil.setDisableColor(this.kdtParticipators);
        this.txtNumber.setEnabled(false);
    }

    private void setComboBox() throws BOSException, EASBizException {
        HashMap parameters = new HashMap();
        HashMap<String, Object> trainMethodMap = new HashMap<String, Object>();
        trainMethodMap.put("bosType", new TrainingMethodInfo().getBOSType());
        trainMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("trainMethod", trainMethodMap);
        HashMap<String, Object> assessMethodMap = new HashMap<String, Object>();
        assessMethodMap.put("bosType", new AssessMethodInfo().getBOSType());
        assessMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("assessMethod", assessMethodMap);
        Map result = TrainFacadeFactory.getRemoteInstance().batchGetCollection(parameters);
        this.comboTrainingMethod.setModel((ComboBoxModel)TrainUtils.getComboBoxModel((IObjectCollection)result.get("trainMethod")));
        this.comboAssessMethod.setModel((ComboBoxModel)TrainUtils.getComboBoxModel((IObjectCollection)result.get("assessMethod")));
    }

    private void handleResult(PreChangeEvent e) {
        int rowIndex = TrainUtils.getCurrentRowIndex(this.kdtParticipators);
        IRow row = this.kdtParticipators.getRow(rowIndex);
        String number = null;
        AdminOrgUnitInfo orgUnitInfo = null;
        PositionInfo positionInfo = null;
        String trianChannelName = null;
        if (e.getData() != null) {
            if (e.getData() instanceof PersonInfo) {
                PersonInfo personInfo = (PersonInfo)e.getData();
                number = personInfo.getNumber();
                orgUnitInfo = TrainActivityHelper.getAdminOrgUnit(personInfo.getId().toString());
                positionInfo = TrainActivityHelper.getPosition(personInfo.getId().toString());
            }
            if (e.getData() instanceof ChannelCoursE1Info) {
                ChannelCoursE1Info channelCourseInfo = (ChannelCoursE1Info)e.getData();
                TrainInstructorInfo instructorInfo = channelCourseInfo.getInstructor();
                number = instructorInfo.getNumber();
                if (channelCourseInfo.getTrainChannel() != null) {
                    trianChannelName = channelCourseInfo.getTrainChannel().getName();
                }
                PersonInfo personInfo = new PersonInfo();
                if (!instructorInfo.isIsOuter()) {
                    String personId = instructorInfo.getEmployee().getId().toString();
                    orgUnitInfo = TrainActivityHelper.getAdminOrgUnit(personId);
                    positionInfo = TrainActivityHelper.getPosition(personId);
                    personInfo.setName(instructorInfo.getEmployee().getName());
                } else {
                    personInfo.setName(instructorInfo.getName());
                    try {
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)instructorInfo.getId()));
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        viewInfo.setFilter(filter);
                        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit"));
                        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.name"));
                        ITrainInstructor iti = TrainInstructorFactory.getRemoteInstance();
                        TrainInstructorCollection coll = iti.getTrainInstructorCollection(viewInfo);
                        if (coll != null && coll.size() > 0) {
                            orgUnitInfo = coll.get(0).getOrgUnit();
                        }
                    }
                    catch (Exception ex) {
                        this.handleException(ex);
                    }
                }
                row.getCell("participator").setValue((Object)personInfo);
                row.getCell("channelCourse").setValue((Object)channelCourseInfo);
                e.setResult(0);
            }
        }
        row.getCell("number").setValue(number);
        row.getCell("trainChannel").setValue(trianChannelName);
        row.getCell("orgUnit").setValue(orgUnitInfo);
        row.getCell("position").setValue(positionInfo);
    }

    private void initPrmtTrainCourse() {
        TrainCoursePromptBox pmt = new TrainCoursePromptBox((IUIObject)this);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CourseKind.id"));
        sic.add(new SelectorItemInfo("CourseKind.name"));
        sic.add(new SelectorItemInfo("treeid.id"));
        sic.add(new SelectorItemInfo("treeid.name"));
        sic.add(new SelectorItemInfo("CourseTarget"));
        sic.add(new SelectorItemInfo("courseCost"));
        sic.add(new SelectorItemInfo("CourseHour"));
        sic.add(new SelectorItemInfo("CourseHourUnit"));
        pmt.setSelector(sic);
        this.prmtTrainCourse.setEntityViewInfo(this.getTrainCourseEntityViewInfo());
        this.prmtTrainCourse.setSelector((KDPromptSelector)pmt);
        this.prmtTrainCourse.setEditable(false);
        this.prmtTrainCourse.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (OprtState.VIEW.equals(TrainActCourseEditUI.this.getOprtState())) {
                    e.setCanceled(true);
                }
            }
        });
    }

    private EntityViewInfo getTrainCourseEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("CourseKind.name"));
        evi.getSelector().add(new SelectorItemInfo("treeid.name"));
        evi.getSelector().add(new SelectorItemInfo("CourseTarget"));
        evi.getSelector().add(new SelectorItemInfo("CourseHour"));
        evi.getSelector().add(new SelectorItemInfo("CourseHourUnit"));
        return evi;
    }

    public void storeFields() {
        super.storeFields();
        TrainActCourseParticipatorCollection entrys = this.editData.getParticipators();
        for (int i = 0; i < entrys.size(); ++i) {
            TrainActCourseParticipatorInfo info = entrys.get(i);
            if (info.getParticipator() == null || info.getParticipator().getId() != null) continue;
            info.setParticipator(null);
        }
    }

    protected String getEditUIName() {
        return TrainActCourseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActCourseFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainActCourseInfo objectValue = new TrainActCourseInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        String trainActivityId = (String)this.getUIContext().get("TrainActivityID");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("trainActState"));
        AbstractTrainActivityInfo trainActivityInfo = null;
        try {
            trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), sic);
        }
        catch (Exception e) {
            SysUtil.abort();
        }
        if (trainActivityInfo.getTrainActState().equals((Object)TrainActStateEnum.CLOSED)) {
            objectValue.setCourseState(TrainActCourseStateEnum.END);
        } else {
            objectValue.setCourseState(TrainActCourseStateEnum.NOTEND);
        }
        objectValue.setTrainActivity((TrainActivityInfo)trainActivityInfo);
        objectValue.setCourseHourUnit((CourseHourUnitEnum)((Object)this.comboCourseHourUnit.getSelectedItem()));
        return objectValue;
    }

    protected void prmtTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        int i;
        super.prmtTrainCourse_dataChanged(e);
        TrainCourseInfo trainCourseInfo = (TrainCourseInfo)this.prmtTrainCourse.getData();
        TrainCourseInfo oldData = (TrainCourseInfo)e.getOldValue();
        if (trainCourseInfo != null && !trainCourseInfo.equals(oldData) || oldData != null && !oldData.equals(trainCourseInfo)) {
            for (i = 0; i < this.kdtParticipators.getRowCount(); ++i) {
                IRow row = this.kdtParticipators.getRow(i);
                Boolean isTeacher = (Boolean)row.getCell("isTeacher").getValue();
                if (isTeacher == null || !isTeacher.booleanValue()) continue;
                row.getCell("participator").setValue(null);
                row.getCell("number").setValue(null);
                row.getCell("orgUnit").setValue(null);
                row.getCell("position").setValue(null);
                row.getCell("trainChannel").setValue(null);
                row.getCell("channelCourse").setValue(null);
            }
        }
        if (trainCourseInfo == null) {
            return;
        }
        this.txtNumber.setText(trainCourseInfo.getNumber());
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtTotalCost.setValue((Object)trainCourseInfo.getCourseCost());
        }
        if (trainCourseInfo.getCourseKind() != null) {
            this.txtCourseKind.setText(trainCourseInfo.getCourseKind().getName());
        }
        if (trainCourseInfo.getTreeid() != null) {
            this.txtCourseCate.setText(trainCourseInfo.getTreeid().getName());
        }
        this.txtCourseHour.setValue((Object)trainCourseInfo.getCourseHour());
        if (trainCourseInfo.getCourseHourUnit() != null) {
            int count = this.comboCourseHourUnit.getItemCount();
            for (i = 0; i < count; ++i) {
                CourseHourUnitEnum hourUnit = (CourseHourUnitEnum)((Object)this.comboCourseHourUnit.getItemAt(i));
                if (trainCourseInfo.getCourseHourUnit().getValue() != hourUnit.getValue()) continue;
                this.comboCourseHourUnit.setSelectedIndex(i);
                break;
            }
        }
        this.txtCourseTarget.setText(trainCourseInfo.getCourseTarget());
    }

    protected void chkNeedExam_stateChanged(ChangeEvent e) throws Exception {
        super.chkNeedExam_stateChanged(e);
        if (this.chkNeedExam.isSelected()) {
            this.comboAssessMethod.setEnabled(true);
            this.txtPassStand.setEnabled(true);
        } else {
            this.comboAssessMethod.setEnabled(false);
            this.comboAssessMethod.setSelectedItem(null);
            this.txtPassStand.setEnabled(false);
            this.txtPassStand.setValue(null);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainCourse);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkStartDate);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkEndDate);
        TrainVerifyUtils.verifyDateTimeBigOrSmall((CoreUIObject)this, this.pkStartDate, this.pkEndDate);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtParticipators, "participator");
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtParticipators, "role");
        this.checkRepeatRow();
    }

    private void checkRepeatRow() {
        for (int i = 0; i < this.kdtParticipators.getRowCount(); ++i) {
            IRow row = this.kdtParticipators.getRow(i);
            PersonInfo personInfo = (PersonInfo)row.getCell("participator").getValue();
            CoreBaseInfo channelCourseInfo = (CoreBaseInfo)row.getCell("channelCourse").getValue();
            Boolean isTeacher = (Boolean)row.getCell("isTeacher").getValue();
            if (isTeacher == null) {
                isTeacher = false;
            }
            for (int j = 0; j < this.kdtParticipators.getRowCount(); ++j) {
                if (i == j) continue;
                IRow row2 = this.kdtParticipators.getRow(j);
                if (!personInfo.getNumber().toString().equals(((PersonInfo)row2.getCell("participator").getValue()).getNumber().toString()) && (!isTeacher.equals((Boolean)row2.getCell("isTeacher").getValue()) || (isTeacher != false ? !channelCourseInfo.getId().toString().equals(((CoreBaseInfo)row2.getCell("channelCourse").getValue()).getId().toString()) : !personInfo.getId().toString().equals(((CoreBaseInfo)row2.getCell("participator").getValue()).getId().toString())))) continue;
                this.kdtParticipators.getEditManager().editCellAt(j, this.kdtParticipators.getColumnIndex("participator"));
                MessageFormat format = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainVerifyResource", (String)"CannotRepeated"));
                String msg = format.format(new Object[]{this.contParticipator.getTitle()});
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("TrainActivity.id"));
        sic.add(new SelectorItemInfo("TrainActivity.needDivide"));
        sic.add(new SelectorItemInfo("Participators.channelCourse.Instructor.number"));
        sic.add(new SelectorItemInfo("Participators.channelCourse.Instructor.name"));
        sic.add(new SelectorItemInfo("Participators.channelCourse.Instructor.isOuter"));
        sic.add(new SelectorItemInfo("Participators.channelCourse.Instructor.Employee.name"));
        return sic;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.EDIT) && this.txtTotalCost.getNumberValue() != null) {
            BigDecimal totalCostInChargeItems = TrainActivityHelper.getChargeItemsTotalCost(this.editData.getId().toString());
            if (totalCostInChargeItems == null) {
                super.actionSubmit_actionPerformed(e);
                return;
            }
            if (((BigDecimal)this.txtTotalCost.getNumberValue()).compareTo(totalCostInChargeItems) == 0) {
                super.actionSubmit_actionPerformed(e);
                return;
            }
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmSubmitOnConflict"));
            if (result == 0) {
                super.actionSubmit_actionPerformed(e);
                return;
            }
            if (result != 1) return;
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void kdtParticipators_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtParticipators.getColumn("role").getColumnIndex()) {
            KDComboBox comboBox = (KDComboBox)this.kdtParticipators.getEditManager().getEditor().getComponent();
            TrainUtils.setComboBoxSelected(comboBox, this.kdtParticipators, rowIndex, colIndex);
        }
        if (colIndex == this.kdtParticipators.getColumn("participator").getColumnIndex()) {
            KDBizPromptBox prmtEmployee = (KDBizPromptBox)this.kdtParticipators.getEditManager().getEditor().getComponent();
            prmtEmployee.setEnabled(true);
            Boolean isTeacher = (Boolean)this.kdtParticipators.getRow(rowIndex).getCell("isTeacher").getValue();
            if (isTeacher != null && isTeacher.booleanValue()) {
                this.setPrmtEmployeeByInstructor(prmtEmployee);
            } else {
                EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
                pmt.setIsSingleSelect(true);
                pmt.setModal(true);
                pmt.setHROFilter(TrainUtils.getHRRangeID());
                prmtEmployee.setSelector((KDPromptSelector)pmt);
                prmtEmployee.setEnabledMultiSelection(false);
            }
        }
    }

    private void setPrmtEmployeeByInstructor(KDBizPromptBox prmtEmployee) throws Exception {
        TrainCourseInfo trainCourseInfo = (TrainCourseInfo)this.prmtTrainCourse.getValue();
        if (trainCourseInfo == null || trainCourseInfo.getId() == null) {
            prmtEmployee.setEnabled(false);
        } else {
            prmtEmployee.setQueryInfo(QueryInfo);
            prmtEmployee.setSelector(null);
            prmtEmployee.setEntityViewInfo(this.getChannelCourseEntityViewInfo(trainCourseInfo.getId().toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("Trainchannel.name"));
            sic.add(new SelectorItemInfo("Instructor.name"));
            sic.add(new SelectorItemInfo("Instructor.number"));
            sic.add(new SelectorItemInfo("Instructor.Employee.name"));
            sic.add(new SelectorItemInfo("Instructor.isOuter"));
            prmtEmployee.setSelectorCollection(sic);
        }
    }

    private EntityViewInfo getChannelCourseEntityViewInfo(String courseId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            if (!this.pubBtnState) {
                filterInfo.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, (String)"adminOrgUnit.id"));
                FilterInfo fi = TrainUtils.getRangeFilterInfo("RangeAdminOrgUnit.id");
                filterInfo.mergeFilter(fi, "OR");
            }
            FilterInfo fiCourse = new FilterInfo();
            fiCourse.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)courseId));
            filterInfo.mergeFilter(fiCourse, "AND");
            FilterInfo fil = new FilterInfo();
            fil.getFilterItems().add(new FilterItemInfo("Trainchannel.IsEnabled", (Object)0));
            fil.getFilterItems().add(new FilterItemInfo("trainchannel.id", null, CompareType.EMPTY));
            fil.setMaskString("#0 or #1");
            filterInfo.mergeFilter(fil, "AND");
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        HashMap parameters = new HashMap();
        HashMap<String, Object> trainMethodMap = new HashMap<String, Object>();
        trainMethodMap.put("bosType", new TrainingMethodInfo().getBOSType());
        trainMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("trainMethod", trainMethodMap);
        HashMap<String, Object> assessMethodMap = new HashMap<String, Object>();
        assessMethodMap.put("bosType", new AssessMethodInfo().getBOSType());
        assessMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("assessMethod", assessMethodMap);
        request.put("comboParams", parameters);
        request.put("trainActivityId", this.getUIContext().get("TrainActivityID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }
}

