/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainActCourseWorkloadReportUI;
import com.kingdee.eas.hr.train.client.TrainActCourseWorkloadQueryPanelUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TrainActCourseWorkloadReportUI
extends AbstractTrainActCourseWorkloadReportUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActCourseWorkloadReportUI.class);
    private static String RES = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private static final String ID = "id";
    private static final String PERSONNUMBER = "lastNumber";
    private static final String PERSONNAME = "lastName";
    private static final String ORGUNIT = "lastAdminOrgUnit";
    private static final String ACTNAME = "TrainActivity.name";
    private static final String TRAINOBJECT = "TrainActivity.trainObject";
    private static final String TRAINCOURSE = "TrainCourse.name";
    private static final String STARTENDDATE = "startEndDate";
    private static final String EVALRATE = "trainCourseSummaryParticipator.evaluRate";
    private Date startDate = null;
    private Date endDate = null;
    private IRowSet rowSet = null;
    private CommonQueryDialog dialog = null;
    private TrainActCourseWorkloadQueryPanelUI trainActCourseWorkloadQueryPanelUI = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo entityViewInfo = new EntityViewInfo();
    FilterInfo filterInfo = null;
    private BigDecimal mainUnit = null;
    private Map map = new HashMap();

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setToolTipText(TrainActCourseWorkloadReportUI.getAlias("refresh"));
        this.btnQuery.setToolTipText(TrainActCourseWorkloadReportUI.getAlias("query"));
        this.btnPrint.setToolTipText(TrainActCourseWorkloadReportUI.getAlias("print"));
        this.btnPrintPreview.setToolTipText(TrainActCourseWorkloadReportUI.getAlias("printPreview"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.menuItemRefresh.setEnabled(true);
        this.menuItemPrint.setEnabled(true);
        this.menuItemPrintPreview.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    public void loadFilterUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TrainActCourseWorkloadReportUI.getQueryInfo(this.mainQueryPK).getFullName();
        TrainActCourseWorkloadQueryPanelUI filterUI = new TrainActCourseWorkloadQueryPanelUI();
        filterUI.onLoad();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            this.entityViewInfo = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.entityViewInfo != null && FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfo.getFilter())) {
                FilterInfo orgHrOrgFilter = TrainUtils.getHROrgUnitFilter("trainActHROrgUnit.id");
                if (FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfo.getFilter())) {
                    this.entityViewInfo.getFilter().mergeFilter(orgHrOrgFilter, "AND");
                } else {
                    this.entityViewInfo.setFilter(orgHrOrgFilter);
                }
                this.setStartEndDate();
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    public void showQueryDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setUiObject((IUIObject)this);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            TrainClientUtil.setCommonQueryTitle(this, this.dialog);
            this.dialog.setWidth(450);
            this.dialog.setHeight(350);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setDisShowRowCount(true);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            try {
                this.trainActCourseWorkloadQueryPanelUI = new TrainActCourseWorkloadQueryPanelUI();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.dialog.addUserPanel((KDPanel)this.trainActCourseWorkloadQueryPanelUI);
        }
        if (this.dialog.show()) {
            this.entityViewInfo = this.dialog.getEntityViewInfoResult();
            if (this.entityViewInfo == null) {
                this.entityViewInfo = new EntityViewInfo();
            }
            FilterInfo orgHrOrgFilter = TrainUtils.getHROrgUnitFilter("trainActHROrgUnit.id");
            if (FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfo.getFilter())) {
                this.entityViewInfo.getFilter().mergeFilter(orgHrOrgFilter, "AND");
            } else {
                this.entityViewInfo.setFilter(orgHrOrgFilter);
            }
            this.setStartEndDate();
        } else {
            SysUtil.abort();
        }
    }

    private void setStartEndDate() {
        FilterInfo filter = this.entityViewInfo.getFilter();
        if (filter != null) {
            FilterItemCollection fiColl = filter.getFilterItems();
            FilterItemInfo filterItemInfo = null;
            for (int i = 0; i < fiColl.size(); ++i) {
                filterItemInfo = fiColl.get(i);
                if ("endDate".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().equals((Object)CompareType.GREATER_EQUALS)) {
                    this.startDate = (Date)filterItemInfo.getCompareValue();
                }
                if (!"endDate".equals(filterItemInfo.getPropertyName()) || !filterItemInfo.getCompareType().equals((Object)CompareType.LESS_EQUALS)) continue;
                this.endDate = (Date)filterItemInfo.getCompareValue();
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
        filter.mergeFilter(TrainUtils.getCurrentHRFilter("hrOrgUnit.id"), "AND");
        viewInfo.setFilter(filter);
        MetaDataPK mainUnitQeryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainMainUnitListQuery");
        IQueryExecutor mainUnitExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainUnitQeryPK);
        mainUnitExec.setObjectView(viewInfo);
        IRowSet mainUnitRowSet = mainUnitExec.executeQuery();
        while (mainUnitRowSet.next()) {
            if (mainUnitRowSet.getBigDecimal("mainUnitType") == null) continue;
            this.mainUnit = mainUnitRowSet.getBigDecimal("mainUnitType");
            if (mainUnitRowSet.getBigDecimal("entry.TrainTransferType") == null) continue;
            this.map.put(mainUnitRowSet.getBigDecimal("entry.TrainTransferType"), mainUnitRowSet.getBigDecimal("entry.TransferFormat"));
        }
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.enableExportExcel(this.tblMain);
        this.loadFilterUI();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActCourseWorkloadQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.entityViewInfo);
        this.rowSet = exec.executeQuery();
        try {
            this.rowSet.beforeFirst();
            while (this.rowSet.next()) {
                String lastAdminOrgUnit = this.rowSet.getString(ORGUNIT);
                if (!StringUtil.isEmptyString((String)lastAdminOrgUnit)) continue;
                String instructorOrgUnit = this.rowSet.getString("instructorOrgUnit.displayName");
                this.rowSet.updateString(ORGUNIT, instructorOrgUnit);
            }
            this.rowSet.beforeFirst();
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            this.handleException(e1);
        }
        this.tblMain.checkParsed();
        this.initTable();
        this.fillTable();
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.mergeTable();
        this.fillTitle();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void fillTitle() {
        StringBuffer title = new StringBuffer();
        if (this.startDate != null && this.endDate != null) {
            title.append(DateFormat.getDateInstance(2).format(this.startDate));
            title.append(TrainActCourseWorkloadReportUI.getAlias("to"));
            title.append(DateFormat.getDateInstance(2).format(this.endDate));
        }
        title.append(TrainActCourseWorkloadReportUI.getAlias("courseWorkloadReport"));
        this.labTitle.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.labTitle.setText(title.toString());
    }

    public void fillTable() throws SQLException, BOSException {
        this.mainUnit = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
        filter.mergeFilter(TrainUtils.getCurrentHRFilter("hrOrgUnit.id"), "AND");
        viewInfo.setFilter(filter);
        MetaDataPK mainUnitQeryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainMainUnitListQuery");
        IQueryExecutor mainUnitExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainUnitQeryPK);
        mainUnitExec.setObjectView(viewInfo);
        try {
            IRowSet mainUnitRowSet = mainUnitExec.executeQuery();
            while (mainUnitRowSet.next()) {
                if (mainUnitRowSet.getBigDecimal("mainUnitType") == null) continue;
                this.mainUnit = mainUnitRowSet.getBigDecimal("mainUnitType");
                if (mainUnitRowSet.getBigDecimal("entry.TrainTransferType") != null) {
                    this.map.put(mainUnitRowSet.getBigDecimal("entry.TrainTransferType"), mainUnitRowSet.getBigDecimal("entry.TransferFormat"));
                }
                if (this.map.keySet().contains(this.mainUnit)) continue;
                this.map.put(this.mainUnit, new BigDecimal("1"));
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        IRow iRow = null;
        CourseHourUnitEnum mainUnitType = null;
        while (this.rowSet.next()) {
            iRow = this.tblMain.addRow();
            iRow.getCell(ID).setValue((Object)this.rowSet.getString(ID));
            iRow.getCell(PERSONNUMBER).setValue((Object)this.rowSet.getString(PERSONNUMBER));
            iRow.getCell(PERSONNAME).setValue((Object)this.rowSet.getString(PERSONNAME));
            iRow.getCell(ORGUNIT).setValue((Object)this.rowSet.getString(ORGUNIT));
            iRow.getCell(ACTNAME).setValue((Object)this.rowSet.getString(ACTNAME));
            iRow.getCell(TRAINOBJECT).setValue((Object)this.rowSet.getString(TRAINOBJECT));
            iRow.getCell(TRAINCOURSE).setValue((Object)this.rowSet.getString(TRAINCOURSE));
            if (this.rowSet.getString("startDate") != null && this.rowSet.getString("endDate") != null) {
                iRow.getCell(STARTENDDATE).setValue((Object)(this.rowSet.getString("startDate") + TrainActCourseWorkloadReportUI.getAlias("to") + this.rowSet.getString("endDate")));
            }
            DecimalFormat df = new DecimalFormat("#.####");
            if (this.rowSet.getString("workload") != null) {
                BigDecimal workload = new BigDecimal(this.rowSet.getString("workload"));
                BigDecimal format = null;
                if (this.mainUnit != null) {
                    if (Integer.parseInt(this.mainUnit.toString()) == 1) {
                        mainUnitType = CourseHourUnitEnum.DAY;
                    }
                    if (Integer.parseInt(this.mainUnit.toString()) == 2) {
                        mainUnitType = CourseHourUnitEnum.HOUR;
                    }
                    if (Integer.parseInt(this.mainUnit.toString()) == 3) {
                        mainUnitType = CourseHourUnitEnum.SECTOR;
                    }
                    if (this.rowSet.getString("workloadUnit") != null) {
                        try {
                            format = TrainUtils.transferUnit(this.rowSet.getString("workloadUnit").trim(), this.map);
                        }
                        catch (BOSException e) {
                            this.handUIException(e);
                        }
                        catch (SQLException e) {
                            this.handUIException(e);
                        }
                    }
                    if (format != null) {
                        iRow.getCell(this.rowSet.getString("role.number")).setValue((Object)(df.format(workload.multiply(format)) + mainUnitType.toString()));
                    }
                } else {
                    iRow.getCell(this.rowSet.getString("role.number")).setValue((Object)(df.format(workload) + this.rowSet.getString("workloadUnit")));
                }
            }
            if (this.rowSet.getString(EVALRATE) == null) continue;
            BigDecimal evalrate = new BigDecimal(this.rowSet.getString(EVALRATE));
            iRow.getCell(this.rowSet.getString("role.number") + EVALRATE).setValue((Object)(df.format(evalrate) + "%"));
        }
        this.rowSet.beforeFirst();
    }

    public static String getAlias(String name) {
        return EASResource.getString((String)RES, (String)name);
    }

    public void initTable() throws SQLException {
        int i;
        int i2;
        this.tblMain.removeColumns();
        this.tblMain.setRefresh(false);
        IColumn col = null;
        col = this.tblMain.addColumn();
        col.getStyleAttributes().setHided(true);
        col.setKey(ID);
        col = this.tblMain.addColumn();
        col.setWidth(100);
        col.setKey(PERSONNUMBER);
        col = this.tblMain.addColumn();
        col.setWidth(100);
        col.setKey(PERSONNAME);
        col = this.tblMain.addColumn();
        col.setWidth(200);
        col.setKey(ORGUNIT);
        col = this.tblMain.addColumn();
        col.setWidth(150);
        col.setKey(ACTNAME);
        col = this.tblMain.addColumn();
        col.setWidth(100);
        col.setKey(TRAINOBJECT);
        col = this.tblMain.addColumn();
        col.setWidth(100);
        col.setKey(TRAINCOURSE);
        col = this.tblMain.addColumn();
        col.setWidth(200);
        col.setKey(STARTENDDATE);
        HashMap<String, String> map = new HashMap<String, String>();
        while (this.rowSet.next()) {
            map.put(this.rowSet.getString("role.number"), this.rowSet.getString("role.name"));
        }
        this.rowSet.beforeFirst();
        Set set = map.keySet();
        Object[] headList = set.toArray();
        TreeSet<Object> ts = new TreeSet<Object>();
        for (i2 = 0; i2 < headList.length; ++i2) {
            ts.add(headList[i2]);
        }
        headList = ts.toArray();
        for (i2 = 0; i2 < headList.length; ++i2) {
            col = this.tblMain.addColumn();
            col.setWidth(100);
            col.setKey(headList[i2].toString());
            col = this.tblMain.addColumn();
            col.setWidth(100);
            col.setKey(headList[i2].toString() + EVALRATE);
        }
        IRow iRow = null;
        iRow = this.tblMain.addHeadRow(0);
        iRow.getCell(ID).setValue((Object)ID);
        iRow.getCell(PERSONNUMBER).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("personNumber"));
        iRow.getCell(PERSONNAME).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("personName"));
        iRow.getCell(ORGUNIT).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("orgUnit"));
        iRow.getCell(ACTNAME).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("actName"));
        iRow.getCell(TRAINOBJECT).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("trainObject"));
        iRow.getCell(TRAINCOURSE).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("trainCourse"));
        iRow.getCell(STARTENDDATE).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("courseStratEndDate"));
        for (i = 0; i < headList.length; ++i) {
            iRow.getCell(headList[i].toString()).setValue((Object)((String)map.get(headList[i])));
            iRow.getCell(headList[i].toString() + EVALRATE).setValue((Object)((String)map.get(headList[i])));
        }
        iRow = this.tblMain.addHeadRow(1);
        iRow.getCell(ID).setValue((Object)ID);
        iRow.getCell(PERSONNUMBER).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("personNumber"));
        iRow.getCell(PERSONNAME).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("personName"));
        iRow.getCell(ORGUNIT).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("orgUnit"));
        iRow.getCell(ACTNAME).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("actName"));
        iRow.getCell(TRAINOBJECT).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("trainObject"));
        iRow.getCell(TRAINCOURSE).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("trainCourse"));
        iRow.getCell(STARTENDDATE).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("courseStratEndDate"));
        for (i = 0; i < headList.length; ++i) {
            iRow.getCell(headList[i].toString()).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("workload"));
            iRow.getCell(headList[i].toString() + EVALRATE).setValue((Object)TrainActCourseWorkloadReportUI.getAlias("evalRate"));
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 5, 1, 5);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 6, 1, 6);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 7, 1, 7);
        for (i = 8; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getHeadMergeManager().mergeBlock(0, i++, 0, i);
        }
    }

    public void mergeTable() {
        this.tblMain.getColumn(PERSONNUMBER).setGroup(true);
        this.tblMain.getColumn(PERSONNAME).setGroup(true);
        this.tblMain.getColumn(ORGUNIT).setGroup(true);
        this.tblMain.getColumn(ACTNAME).setGroup(true);
        this.tblMain.getColumn(TRAINOBJECT).setGroup(true);
        this.tblMain.getGroupManager().group();
    }

    public void mergeTableHead() {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.dialog.changeOwner((Component)((Object)this));
        }
        this.loadFilterUI();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActCourseWorkloadQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.entityViewInfo);
        this.rowSet = exec.executeQuery();
        this.tblMain.checkParsed();
        this.initTable();
        this.fillTable();
        this.mergeTable();
        this.tblMain.repaint();
        this.tblMain.revalidate();
        this.fillTitle();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActCourseWorkloadQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.entityViewInfo);
        this.rowSet = exec.executeQuery();
        try {
            this.rowSet.beforeFirst();
            while (this.rowSet.next()) {
                String lastAdminOrgUnit = this.rowSet.getString(ORGUNIT);
                if (!StringUtil.isEmptyString((String)lastAdminOrgUnit)) continue;
                String instructorOrgUnit = this.rowSet.getString("instructorOrgUnit.displayName");
                this.rowSet.updateString(ORGUNIT, instructorOrgUnit);
            }
            this.rowSet.beforeFirst();
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            this.handleException(e1);
        }
        super.onGetRowSet(this.rowSet);
        this.tblMain.checkParsed();
        this.initTable();
        this.fillTable();
        this.mergeTable();
        this.tblMain.repaint();
        this.tblMain.revalidate();
        this.fillTitle();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"HRO");
    }
}

