/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainActRecordReportListUI;
import com.kingdee.eas.hr.train.client.TrainActRecordReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainActivityRecordEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainActRecordReportListUI
extends AbstractTrainActRecordReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActRecordReportListUI.class);
    String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null, CompareType.NOTEQUALS));
            String close = String.valueOf(50);
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.trainActState", (Object)close));
            filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "adminOrgUnit.id"));
            return filterInfo;
        }
        catch (Exception e) {
            this.handleException(e);
            return super.getDefaultFilterForQuery();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mergeTable();
        TrainUtils.setTableNumberFormat(this.tblMain, "actAssessScore", 2);
        TrainUtils.setTableNumberFormat(this.tblMain, "actCost", 2);
        TrainClientUtil.addAssistantMenu((CoreUIObject)this, this.menuFile);
        this.tblMain.getIndexColumn().setWidthAdjustMode((short)0);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("actDate").setWidth(160);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected void mergeTable() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("Employee.number").setGroup(true);
        this.tblMain.getColumn("Employee.name").setGroup(true);
        this.tblMain.getColumn("adminOrgUnit.displayName").setGroup(true);
        this.tblMain.getColumn("position.name").setGroup(true);
        this.tblMain.getColumn("actTrainType").setGroup(true);
        this.tblMain.getColumn("actTrainCategory.name").setGroup(true);
        this.tblMain.getColumn("actTrainingCategory.name").setGroup(true);
        this.tblMain.getColumn("TrainActivity.number").setGroup(true);
        this.tblMain.getColumn("TrainActivity.name").setGroup(true);
        this.tblMain.getColumn("orgUnit.name").setGroup(true);
        this.tblMain.getColumn("actNeedExam").setGroup(true);
        this.tblMain.getColumn("actAssessScore").setGroup(true);
        this.tblMain.getColumn("TrainCoReExt.actAssessValue").setGroup(true);
        this.tblMain.getColumn("actIsPassed").setGroup(true);
        this.tblMain.getColumn("actAttendAll").setGroup(true);
        this.tblMain.getColumn("actDate").setGroup(true);
        this.tblMain.getColumn("actCost").setGroup(true);
        this.tblMain.refresh();
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        if (rowSet == null || rowSet.size() == 0) {
            return;
        }
        try {
            this.replaceRecordID(rowSet);
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void replaceRecordID(IRowSet rowSet) throws SQLException, Exception {
        rowSet.beforeFirst();
        ArrayList<String[]> idArrays = new ArrayList<String[]>();
        String[] ids = null;
        rowSet.beforeFirst();
        while (rowSet.next()) {
            ids = new String[2];
            if (rowSet.getObject("id") != null) {
                ids[0] = rowSet.getString("id");
            }
            if (rowSet.getObject("TrainActivity.id") != null) {
                ids[1] = rowSet.getString("TrainActivity.id");
            }
            idArrays.add(ids);
        }
        Map recordMap = this.getRecordMap(idArrays);
        rowSet.beforeFirst();
        while (rowSet.next()) {
            String personId = rowSet.getString("id");
            String trainActivityId = rowSet.getString("TrainActivity.id");
            rowSet.updateString("id", (String)recordMap.get(personId + "," + trainActivityId));
        }
    }

    private Map getRecordMap(List idArrays) throws Exception {
        Object ids;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        if (!idArrays.isEmpty()) {
            Iterator it = idArrays.iterator();
            ids = null;
            int index = 0;
            while (it.hasNext()) {
                ids = (String[])it.next();
                filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)ids[0]));
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)ids[1]));
                if (sb.length() > 0) {
                    sb.append(" or ");
                }
                sb.append("(");
                sb.append("#");
                sb.append(index++);
                sb.append(" and #");
                sb.append(index++);
                sb.append(")");
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)"-1"));
            sb.append("#0");
        }
        filterInfo.setMaskString(sb.toString());
        filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "adminOrgUnit.id"));
        viewInfo.setFilter(filterInfo);
        IRowSet rowSet = TrainActivityHelper.getRowSet(this.getCourseRecordQuery(), viewInfo);
        ids = new HashMap();
        rowSet.beforeFirst();
        while (rowSet.next()) {
            String id = rowSet.getString("id");
            String personId = rowSet.getString("Employee.id");
            String trainActivityId = rowSet.getString("TrainActivity.id");
            ids.put(personId + "," + trainActivityId, id);
        }
        return ids;
    }

    public String getActivityRecordQuery() {
        return "TrainActivityRecordQuery";
    }

    public String getCourseRecordQuery() {
        return "TrainCourseRecordQuery";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        queryDlg.setDynQueryVisible(true);
        return queryDlg;
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainActRecordReportFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseRecordFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return TrainActivityRecordEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
    }

    protected boolean isSupportDynQuery() {
        return true;
    }
}

