/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActStudentReportFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class TrainActStudentReportFilterUI
extends AbstractTrainActStudentReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActStudentReportFilterUI.class);

    public TrainActStudentReportFilterUI() throws Exception {
        this.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        TrainUtils.initOrgUnit(this.prmtAdminOrg, false, (IUIObject)this);
        TrainActivityHelper.initTrainActivity(this.prmtTrainActivity);
        this.prmtTrainActivity.setEnabledMultiSelection(true);
        this.prmtTrainCourse.setEnabledMultiSelection(true);
        this.prmtTrainCourse.setEditable(false);
    }

    protected void chkIncludeCourse_stateChanged(ChangeEvent e) throws Exception {
        this.prmtTrainCourse.setEnabled(this.chkIncludeCourse.isSelected());
        if (!this.chkIncludeCourse.isSelected()) {
            this.prmtTrainCourse.setValue(null);
        }
    }

    protected void prmtTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtTrainActivity.getValue() != null) {
            this.prmtTrainCourse.setValue(null);
        }
        this.setPrmtTrainCourseFilter();
    }

    private void setPrmtTrainCourseFilter() throws BOSException {
        Set trainActivityIds;
        EntityViewInfo viewInfo = this.prmtTrainCourse.getEntityViewInfo();
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
        }
        FilterInfo filterInfo = viewInfo.getFilter();
        filterInfo.getFilterItems().clear();
        filterInfo.setMaskString(null);
        if (this.prmtTrainActivity.getValue() != null && (trainActivityIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmtTrainActivity.getValue())) != null && trainActivityIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityIds, CompareType.INCLUDE));
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HROrgUnit.id", (String)"orgUnit.id"), "AND");
        } else {
            filterInfo = PFUtils.getHRAndAdminRangeFilterInfo((String)"HROrgUnit.id", (String)"orgUnit.id");
        }
        viewInfo.setFilter(filterInfo);
        this.prmtTrainCourse.setEntityViewInfo(viewInfo);
    }

    public FilterInfo getFilterInfo() {
        Set trainCourseIds;
        FilterInfo filterInfo = new FilterInfo();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrg.getValue();
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)adminOrgUnitInfo)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnitId", (Object)adminOrgUnitInfo.getId().toString()));
        }
        Date startDate = (Date)this.pkStartDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        filterInfo.getFilterItems().add(new FilterItemInfo("actStartDate", (Object)DateTimeUtils.truncateDate((Date)startDate)));
        filterInfo.getFilterItems().add(new FilterItemInfo("actEndDate", (Object)TrainUtils.getDateMaxTime(endDate)));
        Set trainActivityIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmtTrainActivity.getValue());
        if (trainActivityIds != null && trainActivityIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainActivity", (Object)trainActivityIds, CompareType.INCLUDE));
        }
        if ((trainCourseIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmtTrainCourse.getValue())) != null && trainCourseIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainCourse", (Object)trainCourseIds, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("includeCourse", (Object)this.chkIncludeCourse.isSelected()));
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtAdminOrg);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkEndDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainActivity);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainCourse);
        CustomerQueryUtil.storeToCustomerParams(cp, this.chkIncludeCourse);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtAdminOrg, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkEndDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainActivity, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainCourse, TrainCourseInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.chkIncludeCourse);
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrg.getValue();
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)adminOrgUnitInfo)) {
            try {
                adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getId().toString()));
                this.prmtAdminOrg.setValue((Object)adminOrgUnitInfo);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean verify() {
        if (this.verifyEmpty(this.pkStartDate) || this.verifyEmpty(this.pkEndDate)) {
            return false;
        }
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkStartDate, this.pkEndDate, null);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtAdminOrg);
        return true;
    }

    private boolean verifyEmpty(KDDatePicker datePicker) {
        String content = datePicker.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showInfo((Component)((Object)this), (String)TrainVerifyUtils.getMessage((Component)datePicker));
            datePicker.requestFocus(true);
            return true;
        }
        return false;
    }

    public void clear() {
        Calendar now = Calendar.getInstance();
        this.pkEndDate.setValue((Object)new Date(now.getTimeInMillis()));
        now.set(5, 1);
        now.set(2, 0);
        this.pkStartDate.setValue((Object)new Date(now.getTimeInMillis()));
        this.prmtAdminOrg.setValue(null);
        this.prmtTrainActivity.setValue(null);
        this.chkIncludeCourse.setSelected(false);
        this.prmtTrainCourse.setEnabled(false);
        this.prmtTrainCourse.setValue(null);
    }
}

