/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.contract.client.ContractSignBizBillEditUI;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainRecordContractFactory;
import com.kingdee.eas.hr.train.TrainRecordContractInfo;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainContractBatchSignUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class TrainContractBatchSignUI
extends AbstractTrainContractBatchSignUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainContractBatchSignUI.class);
    private String RES = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    private String RESOURCE = "com.kingdee.eas.hr.train.TrainActivityResource";
    private Set personIdsForQuery = new HashSet();
    private JButton btnAddPerson;
    private JButton btnDelPerson;
    private LocateAssistant locateAssistant;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddPerson = this.kDContainer1.add((Action)((Object)new ActionAddPerson()));
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddPerson.setToolTipText(EASResource.getString((String)this.RES, (String)"add_row"));
        this.btnDelPerson = this.kDContainer1.add((Action)((Object)new ActionDelPerson()));
        this.btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelPerson.setToolTipText(EASResource.getString((String)this.RES, (String)"delete_row"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.actionLocate.setEnabled(true);
        this.btnYes.setEnabled(true);
        this.btnExit.setEnabled(true);
        TrainActivityHelper.initTrainActivityByContact(this.promptTrainActivity, null);
        TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
    }

    protected void promptTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainActivity_dataChanged(e);
        if (this.promptTrainActivity.getValue() != null) {
            if (this.promptTrainCourse.getValue() != null) {
                this.promptTrainCourse.setValue(null);
            }
            TrainActivityHelper.initTrainCourseByActivity(this.promptTrainCourse, ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString());
        } else {
            TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
            this.promptTrainCourse.setValue(null);
        }
        this.loadData();
    }

    protected void promptTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainCourse_dataChanged(e);
        this.loadData();
    }

    private void loadData() throws Exception {
        this.removeAllEmployee();
        FilterInfo filterInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (this.promptTrainActivity.getValue() != null) {
            if (this.promptTrainCourse.getValue() != null) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
                entityViewInfo.setFilter(filterInfo);
                TrainStudentCourseCollection studentCourseCollection = TrainStudentCourseFactory.getRemoteInstance().getTrainStudentCourseCollection(entityViewInfo);
                PersonInfo[] obj = new PersonInfo[studentCourseCollection.size()];
                int n = studentCourseCollection.size();
                for (int i = 0; i < n; ++i) {
                    obj[i] = studentCourseCollection.get(i).getPerson();
                }
                this.putDataToTable(obj);
            } else {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("needDivide", (Object)1));
                if (TrainActivityFactory.getRemoteInstance().exists(filterInfo)) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                    entityViewInfo.setFilter(filterInfo);
                    TrainStudentCollection studentCollection = TrainStudentFactory.getRemoteInstance().getTrainStudentCollection(entityViewInfo);
                    PersonInfo[] obj = new PersonInfo[studentCollection.size()];
                    int n = studentCollection.size();
                    for (int i = 0; i < n; ++i) {
                        obj[i] = studentCollection.get(i).getPerson();
                    }
                    this.putDataToTable(obj);
                } else {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                    entityViewInfo.setFilter(filterInfo);
                    TrainStudentCourseCollection studentCourseCollection = TrainStudentCourseFactory.getRemoteInstance().getTrainStudentCourseCollection(entityViewInfo);
                    PersonInfo[] obj = new PersonInfo[studentCourseCollection.size()];
                    int n = studentCourseCollection.size();
                    for (int i = 0; i < n; ++i) {
                        obj[i] = studentCourseCollection.get(i).getPerson();
                    }
                    this.putDataToTable(obj);
                }
            }
        } else if (this.promptTrainCourse.getValue() != null) {
            filterInfo = TrainUtils.getHROrgUnitFilter("hrOrgUnit.id");
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
            entityViewInfo.setFilter(filterInfo);
            TrainCourseRecordCollection collection = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int size = collection.size();
                PersonInfo[] objs = new PersonInfo[size];
                for (int i = 0; i < size; ++i) {
                    objs[i] = collection.get(i).getEmployee();
                }
                Map persons = this.assembleEmployees(objs);
                PersonInfo personInfo = null;
                PersonInfo info = null;
                String split = EASResource.getString((String)this.RESOURCE, (String)"to");
                StringBuffer str = new StringBuffer();
                PersonInfo[] obj = new PersonInfo[size];
                for (int i = 0; i < size; ++i) {
                    personInfo = collection.get(i).getEmployee();
                    if (TrainCommonUtils.isEmpty((CoreBaseInfo)personInfo)) continue;
                    info = (PersonInfo)persons.get(personInfo.getId().toString());
                    personInfo = (PersonInfo)info.clone();
                    str.delete(0, str.length());
                    str.append(personInfo.getName());
                    str.append("(");
                    str.append(TrainClientUtil.assembleDate(collection.get(i).getBeginDateTime(), collection.get(i).getEndDateTime(), "yyyy-MM-dd", split));
                    str.append(")");
                    personInfo.setName(str.toString());
                    personInfo.put("TrainCourseRecord.id", (Object)collection.get(i).getId().toString());
                    obj[i] = personInfo;
                }
                this.putDataToTable(obj);
            }
        }
    }

    private Map assembleEmployees(PersonInfo[] obj) throws BOSException, SQLException, Exception {
        HashSet<String> hashSet = new HashSet<String>();
        int n = obj.length;
        for (int i = 0; i < n; ++i) {
            hashSet.add(obj[i].getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", hashSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "EmployeeF7SelectQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        PersonInfo personInfo = null;
        HashMap<String, PersonInfo> result = new HashMap<String, PersonInfo>();
        while (rowSet.next()) {
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
            personInfo.setNumber(rowSet.getString("number"));
            personInfo.setName(rowSet.getString("name"));
            personInfo.setIdCardNO(rowSet.getString("idCardNO"));
            personInfo.setPassportNO(rowSet.getString("passportNO"));
            personInfo.setGender(Genders.getEnum((int)rowSet.getInt("gender")));
            personInfo.setEmail(rowSet.getString("email"));
            if (rowSet.getBoolean("PositionMember.isPrimary")) {
                personInfo.put("primaryAdminOrg", (Object)this.getAdminOrgUnitInfo(rowSet));
                personInfo.put("primaryPosition", (Object)this.getPositionInfo(rowSet));
            }
            result.put(rowSet.getString("id"), personInfo);
        }
        return result;
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(IRowSet rows) throws Exception {
        AdminOrgUnitInfo adminInfo = null;
        if (rows.getString("AdminOrgUnit.id") != null) {
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)rows.getString("AdminOrgUnit.id")));
            adminInfo.setNumber(rows.getString("AdminOrgUnit.number"));
            adminInfo.setName(rows.getString("AdminOrgUnit.name"));
            adminInfo.setLevel(rows.getInt("AdminOrgUnit.level"));
            adminInfo.setLongNumber(rows.getString("AdminOrgUnit.longNumber"));
            adminInfo.setDisplayName(rows.getString("AdminOrgUnit.displayName"));
        }
        return adminInfo;
    }

    private PositionInfo getPositionInfo(IRowSet rows) throws Exception {
        PositionInfo posiInfo = new PositionInfo();
        if (rows.getString("Position.id") != null) {
            posiInfo = new PositionInfo();
            posiInfo.setId(BOSUuid.read((String)rows.getString("Position.id")));
            posiInfo.setNumber(rows.getString("Position.number"));
            posiInfo.setName(rows.getString("Position.name"));
        }
        return posiInfo;
    }

    private void putDataToTable(PersonInfo[] obj) {
        if (obj == null || obj.length == 0) {
            return;
        }
        PersonInfo[] removeSameObj = this.processObj(obj);
        int len = removeSameObj.length;
        for (int i = 0; i < len; ++i) {
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("name"));
                PersonInfo person = removeSameObj[i];
                PersonInfo info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()), selector);
                info.put("TrainCourseRecord.id", person.get("TrainCourseRecord.id"));
                this.personIdsForQuery.add(info.getId().toString());
                IRow row = this.personTable.addRow();
                row.setUserObject((Object)info);
                row.getCell("personId").setValue((Object)info.getId());
                row.getCell("personName").setValue((Object)info.getName());
                row.getCell("personNumber").setValue((Object)info.getNumber());
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId()));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filterInfo);
                IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "EmployeeF7SelectQuery"));
                iqec.setObjectView(viewInfo);
                IRowSet rowSet = iqec.executeQuery();
                while (rowSet.next()) {
                    if (!rowSet.getBoolean("PositionMember.isPrimary")) continue;
                    AdminOrgUnitInfo unitInfo = this.getAdminOrgUnitInfo(rowSet);
                    PositionInfo positionInfo = this.getPositionInfo(rowSet);
                    row.getCell("adminOrgUnit").setValue((Object)unitInfo.getDisplayName());
                    row.getCell("position").setValue((Object)positionInfo.getName());
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private PersonInfo[] processObj(PersonInfo[] obj) {
        ArrayList<PersonInfo> infos = new ArrayList<PersonInfo>();
        ArrayList<String> hasPersonIds = new ArrayList<String>();
        int len = obj.length;
        for (int i = 0; i < len; ++i) {
            if (hasPersonIds.contains(obj[i].getId().toString())) continue;
            hasPersonIds.add(obj[i].getId().toString());
            infos.add(obj[i]);
        }
        PersonInfo[] tempObj = new PersonInfo[infos.size()];
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            tempObj[i] = (PersonInfo)infos.get(i);
        }
        return tempObj;
    }

    private void removeAllEmployee() {
        this.personTable.removeRows();
        this.personIdsForQuery.clear();
    }

    public void actionYes_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.handleEmployee();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personIdList", (Object)this.getEmployeeIdList());
        uiContext.put((Object)"fromPage", (Object)((Object)((Object)this)).getClass().getName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ContractSignBizBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        this.getUIWindow().close();
        uiWindow.show();
        String billPk = ((ContractSignBizBillEditUI)uiWindow.getUIObject()).getBillID();
        logger.info((Object)("billPk=" + billPk));
        this.operateBatchSaveContacht(billPk);
    }

    private void operateBatchSaveContacht(String billPk) throws EASBizException, BOSException {
        if (StringUtil.isEmptyString((String)billPk)) {
            return;
        }
        List trainCourseRecordIds = this.getTrainCourseRecordIds();
        CoreBaseCollection collection = new CoreBaseCollection();
        if (this.promptTrainCourse.getValue() != null) {
            int size = trainCourseRecordIds.size();
            for (int i = 0; i < size; ++i) {
                TrainRecordContractInfo recordContractInfo = new TrainRecordContractInfo();
                recordContractInfo.setTrainRecordId((String)trainCourseRecordIds.get(i));
                recordContractInfo.setCourseContractBillId(billPk);
                collection.add((CoreBaseInfo)recordContractInfo);
            }
        } else {
            int size = trainCourseRecordIds.size();
            for (int i = 0; i < size; ++i) {
                TrainRecordContractInfo recordContractInfo = new TrainRecordContractInfo();
                recordContractInfo.setTrainRecordId((String)trainCourseRecordIds.get(i));
                recordContractInfo.setActivityContractBillId(billPk);
                collection.add((CoreBaseInfo)recordContractInfo);
            }
        }
        TrainRecordContractFactory.getRemoteInstance().save(collection);
    }

    private List getTrainCourseRecordIds() {
        String activityID = null;
        String courseID = null;
        if (this.promptTrainActivity.getValue() != null) {
            activityID = ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString();
        }
        if (this.promptTrainCourse.getValue() != null) {
            if (this.promptTrainActivity.getValue() == null) {
                ArrayList<String> trainCourseRecordIds = new ArrayList<String>();
                int rowCount = this.personTable.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    IRow row = this.personTable.getRow(i);
                    PersonInfo info = (PersonInfo)row.getUserObject();
                    trainCourseRecordIds.add(info.getString("TrainCourseRecord.id"));
                }
                return trainCourseRecordIds;
            }
            courseID = ((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString();
        }
        FilterInfo filterInfo = new FilterInfo();
        HashSet personIdSet = new HashSet();
        List employeeIdList = this.getEmployeeIdList();
        int size = employeeIdList.size();
        for (int i = 0; i < size; ++i) {
            personIdSet.add(employeeIdList.get(i));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", personIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)activityID));
        if (courseID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)courseID));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            TrainCourseRecordCollection courseRecordCollection = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
            ArrayList<String> trainCourseRecordIds = new ArrayList<String>();
            for (int i = 0; i < courseRecordCollection.size(); ++i) {
                trainCourseRecordIds.add(courseRecordCollection.get(i).getId().toString());
            }
            return trainCourseRecordIds;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return new ArrayList();
        }
    }

    public void checkInput() throws EmployeeException {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() == null) {
            TrainClientUtil.showErrorMessage(this.RES, "activityAndCourseNotNull", this);
        }
        if (this.personTable.getRowCount() == 0) {
            throw new EmployeeException(EmployeeException.PLEASE_SELECT_EMPLOYEE);
        }
    }

    private void handleEmployee() {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() != null) {
            int rowCount = this.personTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.personTable.getRow(i);
                PersonInfo info = (PersonInfo)row.getUserObject();
                String name = info.getName();
                if (name.indexOf("(") == -1) continue;
                name = name.substring(0, name.indexOf("("));
                info.setName(name);
            }
        }
    }

    public List getEmployeeIdList() {
        ArrayList<String> employeeIdList = new ArrayList<String>();
        int rowCount = this.personTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.personTable.getRow(i);
            PersonInfo info = (PersonInfo)row.getUserObject();
            employeeIdList.add(info.getId().toString());
        }
        return employeeIdList;
    }

    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.getUIWindow().close();
    }

    private boolean checkIsExistInTable(String personId) {
        int rowCount = this.personTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.personTable.getRow(i);
            PersonInfo info = (PersonInfo)row.getUserObject();
            if (!info.getId().toString().equals(personId)) continue;
            return true;
        }
        return false;
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.personTable, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"personNumber", "personName", "position", "adminOrgUnit"};
        return locateNames;
    }

    private class ActionDelPerson
    extends ItemAction {
        public ActionDelPerson() {
            this(null);
        }

        public ActionDelPerson(IUIObject uiObj) {
            super(uiObj);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift r"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int[] row = KDTableUtil.getSelectedRows((KDTable)TrainContractBatchSignUI.this.personTable);
            for (int i = row.length - 1; i >= 0; --i) {
                TrainContractBatchSignUI.this.personTable.removeRow(row[i]);
            }
        }
    }

    private class ActionAddPerson
    extends ItemAction {
        public ActionAddPerson() {
            this(null);
        }

        public ActionAddPerson(IUIObject uiObj) {
            super(uiObj);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift q"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            KDCommonPromptDialog dlg = new KDCommonPromptDialog();
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.train.app", "PersonQuery");
            QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
            dlg.setQueryInfo(queryInfo);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi_person = new FilterInfo();
            fi_person.getFilterItems().add(new FilterItemInfo("id", (Object)TrainContractBatchSignUI.this.personIdsForQuery, CompareType.INCLUDE));
            evi.setFilter(fi_person);
            dlg.setEntityViewInfo(evi);
            dlg.setEnabledMultiSelection(true);
            dlg.show();
            if (dlg.isCanceled()) {
                return;
            }
            Object[] obj = (Object[])dlg.getData();
            ArrayList<String> ids = new ArrayList<String>();
            for (i = 0; i < obj.length; ++i) {
                String personId = ((PersonInfo)obj[i]).getId().toString();
                if (ids.contains(personId)) continue;
                ids.add(personId);
            }
            if (ids.size() > 0) {
                for (i = 0; i < ids.size(); ++i) {
                    if (TrainContractBatchSignUI.this.checkIsExistInTable((String)ids.get(i))) continue;
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("number"));
                    selector.add(new SelectorItemInfo("name"));
                    try {
                        PersonInfo info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK((String)ids.get(i)), selector);
                        IRow row = TrainContractBatchSignUI.this.personTable.addRow();
                        row.setUserObject((Object)info);
                        row.getCell("personId").setValue((Object)info.getId());
                        row.getCell("personName").setValue((Object)info.getName());
                        row.getCell("personNumber").setValue((Object)info.getNumber());
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId()));
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        viewInfo.setFilter(filterInfo);
                        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "EmployeeF7SelectQuery"));
                        iqec.setObjectView(viewInfo);
                        IRowSet rowSet = iqec.executeQuery();
                        while (rowSet.next()) {
                            if (!rowSet.getBoolean("PositionMember.isPrimary")) continue;
                            AdminOrgUnitInfo unitInfo = TrainContractBatchSignUI.this.getAdminOrgUnitInfo(rowSet);
                            PositionInfo positionInfo = TrainContractBatchSignUI.this.getPositionInfo(rowSet);
                            row.getCell("adminOrgUnit").setValue((Object)unitInfo.getDisplayName());
                            row.getCell("position").setValue((Object)positionInfo.getName());
                        }
                        continue;
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)e1.getMessage());
                        continue;
                    }
                    catch (BOSException e1) {
                        logger.error((Object)e1.getMessage());
                        continue;
                    }
                    catch (SQLException e1) {
                        logger.error((Object)e1.getMessage());
                        continue;
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage());
                    }
                }
            }
        }
    }
}

