/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.TrainCostSummaryFactory;
import com.kingdee.eas.hr.train.TrainCostSummaryInfo;
import com.kingdee.eas.hr.train.TrainCostSummaryTraCSEntryCollection;
import com.kingdee.eas.hr.train.TrainCostSummaryTraCSEntryInfo;
import com.kingdee.eas.hr.train.TrainCourseCostCollection;
import com.kingdee.eas.hr.train.TrainCourseCostFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCostSummaryEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TrainCostSummaryEditUI
extends AbstractTrainCostSummaryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCostSummaryEditUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainCostSummaryResource";
    String COST = "Cost";
    String ITEM = "ChargeItem";
    HashSet itemSet;

    public void loadFields() {
        super.loadFields();
        this.loadCourse();
        this.countItemAmount();
    }

    private void loadCourse() {
        if (this.editData != null && this.editData.getTrainCourseSumm() != null && this.editData.getTrainCourseSumm().getTrainActCourse() != null && this.editData.getTrainCourseSumm().getTrainActCourse().getTrainCourse() != null) {
            this.txtCourseName.setText(this.editData.getTrainCourseSumm().getTrainActCourse().getTrainCourse().getName());
            this.txtCourseNumber.setText(this.editData.getTrainCourseSumm().getTrainActCourse().getTrainCourse().getNumber());
        } else {
            this.txtCourseName.setText(null);
            this.txtCourseNumber.setText(null);
        }
    }

    public void storeFields() {
        super.storeFields();
        this.removeEmptyRow();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        int option = this.checkReback();
        if (option == 0 || option == 1) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int option = this.operateReback(new BigDecimal("0"), this.fetchTrainCourseCostFromUIContext());
        if (option == 0 || option == 1) {
            super.actionRemove_actionPerformed(e);
            this.setOprtState(OprtState.ADDNEW);
            this.unLockUI();
        }
    }

    protected boolean confirmRemove() {
        return true;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    protected String getEditUIName() {
        return TrainCostSummaryEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCostSummaryFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainCostSummaryInfo objectValue = new TrainCostSummaryInfo();
        objectValue.setTrainCourseSumm(this.fetchTrainCourseSummaryFromUIContext());
        return objectValue;
    }

    private void importChageItem() {
        String trainActCourseID = (String)this.getUIContext().get("trainActCourse");
        if (!TrainClientUtil.objectIsNull(trainActCourseID)) {
            try {
                TrainCourseCostCollection costCollection = this.getTrainCourseCostCollection(trainActCourseID);
                if (costCollection != null) {
                    int n = costCollection.size();
                    for (int i = 0; i < n; ++i) {
                        IRow row = this.kdtTraCSEntry.addRow();
                        row.getCell("ChargeItem").setValue((Object)costCollection.get(i).getChargeItem());
                        row.getCell("ChargeStand").setValue((Object)costCollection.get(i).getChargeStand());
                        row.getCell("Count").setValue((Object)costCollection.get(i).getCount());
                        row.getCell("Cost").setValue((Object)costCollection.get(i).getCost());
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private TrainCourseCostCollection getTrainCourseCostCollection(String trainActCourseID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("ChargeItem.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("ChargeItem.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("ChargeItem.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("ChargeStand"));
        viewInfo.getSelector().add(new SelectorItemInfo("Count"));
        viewInfo.getSelector().add(new SelectorItemInfo("Cost"));
        return TrainCourseCostFactory.getRemoteInstance().getTrainCourseCostCollection(viewInfo);
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        TrainClientUtil.setBimBuildEntryWorkButtonState(this.kdtTraCSEntry, false);
        this.kdtTraCSEntry.setEnabled(false);
        this.btnSubmit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorItemCollection = super.getSelectors();
        selectorItemCollection.add(new SelectorItemInfo("TrainCourseSumm.id"));
        selectorItemCollection.add(new SelectorItemInfo("TrainCourseSumm.TrainActCourse.TrainCourse.name"));
        selectorItemCollection.add(new SelectorItemInfo("TrainCourseSumm.TrainActCourse.TrainCourse.number"));
        return selectorItemCollection;
    }

    public SelectorItemCollection getTrainCourseSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("TrainActCourse.TrainCourse.name"));
        sic.add(new SelectorItemInfo("TrainActCourse.TrainCourse.number"));
        return sic;
    }

    protected void unLockUI() {
        super.unLockUI();
        TrainClientUtil.setBimBuildEntryWorkButtonState(this.kdtTraCSEntry, true);
        this.kdtTraCSEntry.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.btnRemove.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDFormattedTextField txtPeriods = new KDFormattedTextField();
        txtPeriods.setHorizontalAlignment(2);
        txtPeriods.setDataType(1);
        txtPeriods.setMinimumValue((Comparable)new BigDecimal("0.00"));
        txtPeriods.setPrecision(2);
        this.kdtTraCSEntry.getColumn("Cost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPeriods));
        this.setTableDisEnabled();
        this.initFormattedTextDisplayFormatter();
        this.initChangeItemF7();
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        TrainClientUtil.setTableTitle(this.kdtTraCSEntry, this.getUITitle());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInputCost.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnInputCost.setEnabled(false);
        }
    }

    private void initChangeItemF7() {
        KDBizPromptBox kdtTraCSEntry_ChargeItem_PromptBox = new KDBizPromptBox();
        kdtTraCSEntry_ChargeItem_PromptBox.setEntityViewInfo(TrainUtils.getCurrentHREntityViewInfo());
        kdtTraCSEntry_ChargeItem_PromptBox.setQueryInfo("com.kingdee.eas.hr.train.app.ChargeItemQuery");
        kdtTraCSEntry_ChargeItem_PromptBox.setVisible(true);
        kdtTraCSEntry_ChargeItem_PromptBox.setEditable(true);
        kdtTraCSEntry_ChargeItem_PromptBox.setDisplayFormat("$number$");
        kdtTraCSEntry_ChargeItem_PromptBox.setEditFormat("$number$");
        kdtTraCSEntry_ChargeItem_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtTraCSEntry_ChargeItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtTraCSEntry_ChargeItem_PromptBox);
        this.kdtTraCSEntry.getColumn("ChargeItem").setEditor((ICellEditor)kdtTraCSEntry_ChargeItem_CellEditor);
    }

    private void initFormattedTextDisplayFormatter() {
        TrainClientUtil.setBigDecimalDisplayFormatter(this.txtAmount, TrainClientUtil.PRECISION);
    }

    private void setTableDisEnabled() {
        this.kdtTraCSEntry.checkParsed();
        this.kdtTraCSEntry.getColumn(this.ITEM).getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.checkEntry();
    }

    private void checkEntry() {
        this.itemSet = new HashSet();
        TrainCostSummaryTraCSEntryInfo info = new TrainCostSummaryTraCSEntryInfo();
        int count = 0;
        KDTEditManager kdtManager = this.kdtTraCSEntry.getEditManager();
        int n = this.kdtTraCSEntry.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtTraCSEntry.getRow(i);
            IObjectValue obj = (IObjectValue)row.getUserObject();
            this.dataBinder.storeLineFields(this.kdtTraCSEntry, row, obj);
            if (ObjectValueUtil.objectValueEquals((AbstractObjectValue)info, (AbstractObjectValue)((AbstractObjectValue)obj))) continue;
            ++count;
            if (TrainClientUtil.objectIsNull(row.getCell(this.ITEM).getValue())) {
                kdtManager.editCellAt(i, this.kdtTraCSEntry.getColumnIndex(this.ITEM));
                TrainClientUtil.showErrorMessage(RES, "ItemNotNull", (CoreUI)this);
            }
            this.checkLineDup(row, row.getCell(this.ITEM).getValue().toString());
        }
        if (count == 0) {
            TrainClientUtil.showErrorMessage(RES, "trainCostEntryNotNull", (CoreUI)this);
        }
    }

    private void checkLineDup(IRow row, String item) {
        if (this.itemSet.contains(item)) {
            KDTEditManager kdtManager = this.kdtTraCSEntry.getEditManager();
            kdtManager.editCellAt(row.getRowIndex(), this.kdtTraCSEntry.getColumnIndex(this.ITEM));
            TrainClientUtil.showErrorMessage(RES, "ItemDup", (CoreUI)this);
        } else {
            this.itemSet.add(item);
        }
    }

    private void removeEmptyRow() {
        TrainCostSummaryTraCSEntryInfo info = new TrainCostSummaryTraCSEntryInfo();
        TrainCostSummaryTraCSEntryCollection collection = this.editData.getTraCSEntry();
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)collection.get(i), (AbstractObjectValue)info)) continue;
            collection.removeObject(i);
        }
    }

    private BigDecimal fetchTrainCourseCostFromUIContext() {
        return (BigDecimal)this.getUIContext().get("originValue");
    }

    private TrainCourseSummaryInfo fetchTrainCourseSummaryFromUIContext() {
        String id = (String)this.getUIContext().get("trainCourseSummary");
        TrainCourseSummaryInfo courseSummaryInfo = null;
        try {
            if (!TrainClientUtil.objectIsNull(id)) {
                courseSummaryInfo = (TrainCourseSummaryInfo)TrainCourseSummaryFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), this.getTrainCourseSelectors());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return courseSummaryInfo;
    }

    protected void kdtTraCSEntry_editStopped(KDTEditEvent e) throws Exception {
        super.kdtTraCSEntry_editStopped(e);
        if (e.getColIndex() == this.kdtTraCSEntry.getColumnIndex(this.COST)) {
            this.countItemAmount();
        }
    }

    private void countItemAmount() {
        BigDecimal amount = new BigDecimal("0.00");
        int n = this.kdtTraCSEntry.getRowCount();
        for (int i = 0; i < n; ++i) {
            BigDecimal value = (BigDecimal)this.kdtTraCSEntry.getRow(i).getCell(this.COST).getValue();
            if (value == null) continue;
            amount = amount.add(value);
        }
        this.txtAmount.setValue((Object)amount);
    }

    public IObjectPK runSave() throws Exception {
        IObjectPK objectPK = super.runSave();
        return objectPK;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        this.updateState();
        return objectPK;
    }

    private int checkReback() {
        BigDecimal newValue = this.countvalue(this.editData);
        BigDecimal originValue = this.fetchTrainCourseCostFromUIContext();
        return this.operateReback(newValue, originValue);
    }

    private int operateReback(BigDecimal newValue, BigDecimal originValue) {
        boolean flag = false;
        if (originValue == null) {
            flag = true;
        } else {
            if (originValue.compareTo(newValue) == 0) {
                return 0;
            }
            flag = true;
        }
        if (flag) {
            int showConfirm3 = MsgBox.showConfirm3((Component)((Object)this), (String)TrainClientUtil.getResource(RES, "needReback"));
            if (showConfirm3 == 0) {
                this.getUIContext().put("needReback", Boolean.TRUE);
                this.getUIContext().put("newValue", newValue);
            }
            return showConfirm3;
        }
        return 0;
    }

    private BigDecimal countvalue(TrainCostSummaryInfo editData) {
        BigDecimal value = new BigDecimal("0.0");
        int n = editData.getTraCSEntry().size();
        for (int i = 0; i < n; ++i) {
            if (TrainClientUtil.objectIsNull(editData.getTraCSEntry().get(i).getCost())) continue;
            value = value.add(editData.getTraCSEntry().get(i).getCost());
        }
        return value;
    }

    private void updateState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    public void actionInputCost_actionPerformed(ActionEvent e) throws Exception {
        this.importChageItem();
    }
}

