/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChargeItemInfo;
import com.kingdee.eas.hr.train.ITrainCourseCost;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseCostCollection;
import com.kingdee.eas.hr.train.TrainCourseCostFactory;
import com.kingdee.eas.hr.train.TrainCourseCostInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseCostEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainCourseCostEditUI
extends AbstractTrainCourseCostEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseCostEditUI.class);
    public static final String strResource = "com.kingdee.eas.hr.train.TrainResource.";
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private String currentTrainActCourseId;
    private Map historys = new HashMap();
    private Map collectionMap = new HashMap();
    private Map delCollectionMap = new HashMap();
    private boolean isFirstLoad = true;
    private boolean canSave = true;

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.comboTrainActCourse.setActionCommand("INIT");
        TrainActivityHelper.initTrainActCourse((String)this.getUIContext().get("TrainActivityID"), this.comboTrainActCourse);
        this.comboTrainActCourse.setActionCommand(null);
        this.initCollectionMap();
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        TrainUtils.setTableCellEditorByF7Query(this.tblMain, "com.kingdee.eas.hr.train.app.ChargeItemQuery", "chargeItem", evi);
        KDFormattedTextField txtFiled = new KDFormattedTextField();
        TrainUtils.setTableCellEditorByFormattedTextField(this.tblMain, txtFiled, "cost", 2);
        TrainUtils.setTableNumberFormat(this.tblMain, "cost", 2);
        if (this.comboTrainActCourse.getSelectedItem() != null) {
            this.currentTrainActCourseId = ((TrainActCourseInfo)this.comboTrainActCourse.getSelectedItem()).getId().toString();
        }
        TrainCourseCostCollection courseCostCollection = this.getTrainCourseCostCollection(this.getUIContext().get("TrainActivityID").toString());
        this.fillCollectionMap(courseCostCollection);
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            int count = this.comboTrainActCourse.getItemCount();
            for (int i = 0; i < count; ++i) {
                if (!((TrainActCourseInfo)this.comboTrainActCourse.getItemAt(i)).getId().toString().equals(this.getUIContext().get("TrainActCourseID"))) continue;
                this.comboTrainActCourse.setSelectedIndex(i);
                break;
            }
        } else if (this.comboTrainActCourse.getItemCount() > 0) {
            this.comboTrainActCourse.setSelectedIndex(0);
        }
        KDFormattedTextField txt = new KDFormattedTextField();
        txt.setDataType(0);
        TrainUtils.setTableCellEditorByFormattedTextField(this.tblMain, txt, "count", 0);
        TrainUtils.setTableCellEditorByTextField(this.tblMain, "chargeStand", 40);
        this.initUIStatus();
    }

    private void initUIStatus() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.comboTrainActCourse.setReadOnly(false);
            this.comboTrainActCourse.setEditable(true);
        }
    }

    private void initCollectionMap() throws Exception {
        TrainActCourseCollection coll = TrainActivityHelper.getTrainActCourse((String)this.getUIContext().get("TrainActivityID"));
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            TrainCourseCostCollection courseCostColl = new TrainCourseCostCollection();
            this.collectionMap.put(coll.get(i).getId().toString(), courseCostColl);
            this.historys.put(coll.get(i).getId().toString(), courseCostColl.clone());
        }
    }

    private void fillCollectionMap(TrainCourseCostCollection coll) {
        TrainCourseCostInfo info = null;
        TrainCourseCostCollection collInMap = null;
        TrainCourseCostCollection historyMap = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            String trainActCourseId = info.getTrainActCourse().getId().toString();
            collInMap = (TrainCourseCostCollection)((Object)this.collectionMap.get(trainActCourseId));
            historyMap = (TrainCourseCostCollection)((Object)this.historys.get(trainActCourseId));
            if (collInMap == null) {
                collInMap = new TrainCourseCostCollection();
                this.collectionMap.put(trainActCourseId, collInMap);
            }
            collInMap.add(info);
            if (historyMap == null) {
                historyMap = new TrainCourseCostCollection();
                this.historys.put(trainActCourseId, historyMap);
            }
            historyMap.add((TrainCourseCostInfo)info.clone());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddLine = this.contItemCost.add((Action)((Object)this.actionAddLine));
        JButton btnDelLine = this.contItemCost.add((Action)((Object)this.actionDelLine));
        btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        btnDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnAddLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.AddLine"));
        btnDelLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.RemoveLine"));
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return TrainCourseCostEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseCostFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainCourseCostInfo objectValue = new TrainCourseCostInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    private String bigDecimal2SpecialString(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        decimal = decimal.setScale(2);
        String totalString = EASResource.getString((String)this.resourcePath, (String)"TotalCost");
        totalString = totalString.replaceAll("#", decimal.toString());
        return totalString;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.tblMain.addRow();
    }

    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelLine_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        TrainCourseCostCollection delColl = (TrainCourseCostCollection)((Object)this.delCollectionMap.get(this.currentTrainActCourseId));
        if (delColl == null) {
            delColl = new TrainCourseCostCollection();
            this.delCollectionMap.put(this.currentTrainActCourseId, delColl);
        }
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblMain.getRow(rowIndex);
            if (this.isTotalRow(row)) continue;
            if (row.getCell("id").getValue() != null) {
                TrainCourseCostInfo delInfo = new TrainCourseCostInfo();
                delInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                delColl.add(delInfo);
                continue;
            }
            this.tblMain.removeRow(rowIndex);
        }
        this.calculateTotalCost();
    }

    protected void comboTrainActCourse_actionPerformed(ActionEvent e) throws Exception {
        super.comboTrainActCourse_actionPerformed(e);
        this.contItemCost.setTitle(this.bigDecimal2SpecialString(new BigDecimal("0.00")));
        if ("INIT".equals(this.comboTrainActCourse.getActionCommand())) {
            return;
        }
        if (this.comboTrainActCourse.getSelectedItem() == null) {
            return;
        }
        if (this.currentTrainActCourseId != null && !this.isFirstLoad) {
            this.updateCollectionMap(this.collectionMap);
        }
        this.currentTrainActCourseId = ((TrainActCourseInfo)this.comboTrainActCourse.getSelectedItem()).getId().toString();
        TrainCourseCostCollection coll = (TrainCourseCostCollection)((Object)this.collectionMap.get(this.currentTrainActCourseId));
        this.fillTable(coll);
        this.isFirstLoad = false;
    }

    private void fillTable(TrainCourseCostCollection coll) {
        TrainCourseCostInfo info = null;
        IRow row = null;
        this.tblMain.removeRows();
        if (coll != null && coll.size() != 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                row = this.tblMain.addRow();
                if (info.getId() != null) {
                    row.getCell("id").setValue((Object)info.getId().toString());
                }
                row.getCell("chargeItem").setValue((Object)info.getChargeItem());
                row.getCell("chargeStand").setValue((Object)info.getChargeStand());
                row.getCell("count").setValue((Object)info.getCount());
                row.getCell("cost").setValue((Object)info.getCost());
            }
            this.calculateTotalCost();
        }
    }

    private TrainCourseCostCollection getTrainCourseCostCollection(String trainActivityId) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("ChargeItem.id"));
        evi.getSelector().add(new SelectorItemInfo("ChargeItem.name"));
        evi.getSelector().add(new SelectorItemInfo("chargeStand"));
        evi.getSelector().add(new SelectorItemInfo("count"));
        evi.getSelector().add(new SelectorItemInfo("cost"));
        return TrainCourseCostFactory.getRemoteInstance().getTrainCourseCostCollection(evi);
    }

    private void calculateTotalCost() {
        this.contItemCost.setTitle(this.bigDecimal2SpecialString(this.getTotalCost()));
    }

    private BigDecimal getTotalCost() {
        BigDecimal totalCost = new BigDecimal("0.00");
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (this.isTotalRow(row) || row.getCell("cost").getValue() == null) continue;
            totalCost = totalCost.add((BigDecimal)row.getCell("cost").getValue());
        }
        return totalCost;
    }

    private void updateCollectionMap(Map collection) {
        TrainCourseCostCollection coll = (TrainCourseCostCollection)((Object)collection.get(this.currentTrainActCourseId));
        TrainActCourseInfo trainActCourseInfo = new TrainActCourseInfo();
        trainActCourseInfo.setId(BOSUuid.read((String)this.currentTrainActCourseId));
        coll.clear();
        this.assembleCollection(coll, trainActCourseInfo);
    }

    private void assembleCollection(TrainCourseCostCollection coll, TrainActCourseInfo trainActCourseInfo) {
        IRow row = null;
        TrainCourseCostInfo info = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            info = new TrainCourseCostInfo();
            if (row.getCell("id").getValue() != null) {
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            info.setChargeItem((ChargeItemInfo)row.getCell("chargeItem").getValue());
            info.setChargeStand((String)row.getCell("chargeStand").getValue());
            if (row.getCell("count").getValue() != null) {
                info.setCount(String.valueOf(row.getCell("count").getValue()));
            }
            info.setCost((BigDecimal)row.getCell("cost").getValue());
            info.setTrainActCourse(trainActCourseInfo);
            coll.add(info);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        TrainCourseCostCollection delColl;
        int result;
        if (!this.canSave) {
            this.canSave = true;
            return;
        }
        this.verifyInput();
        boolean isNeedOverWrite = true;
        String trainActCourseId = ((TrainActCourseInfo)this.comboTrainActCourse.getSelectedItem()).getId().toString();
        TrainActCourseInfo courseInfo = TrainActCourseFactory.getRemoteInstance().getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(trainActCourseId));
        if (courseInfo.getTotalCost() != null && courseInfo.getTotalCost().compareTo(this.getTotalCost()) != 0 && (result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmOverWriteTotalCost"))) != 0) {
            if (result == 1) {
                isNeedOverWrite = false;
            } else {
                return;
            }
        }
        TrainCourseCostCollection coll = new TrainCourseCostCollection();
        TrainActCourseInfo trainActCourseInfo = new TrainActCourseInfo();
        trainActCourseInfo.setId(BOSUuid.read((String)trainActCourseId));
        this.assembleCollection(coll, trainActCourseInfo);
        IRow row = null;
        ITrainCourseCost trainCourseCost = TrainCourseCostFactory.getRemoteInstance();
        if (coll.size() > 0) {
            Map idMap = trainCourseCost.submit(coll, isNeedOverWrite);
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                String id;
                row = this.tblMain.getRow(i);
                if (row.getCell("chargeItem").getValue() == null || idMap.size() <= 0 || (id = (String)idMap.get(((ChargeItemInfo)row.getCell("chargeItem").getValue()).getId().toString())) == null) continue;
                row.getCell("id").setValue((Object)id);
            }
        }
        if ((delColl = (TrainCourseCostCollection)((Object)this.delCollectionMap.get(this.currentTrainActCourseId))) != null) {
            HashSet<String> delIdSet = new HashSet<String>();
            int size = delColl.size();
            for (int i = 0; i < size; ++i) {
                delIdSet.add(delColl.get(i).getId().toString());
            }
            FilterInfo fi = new FilterInfo();
            if (delIdSet.size() > 0) {
                fi.getFilterItems().add(new FilterItemInfo("id", delIdSet, CompareType.INCLUDE));
                trainCourseCost.delete(fi);
            }
        }
        this.updateCollectionMap(this.historys);
        MsgBox.showInfo((String)EASResource.getString((String)this.resourcePath, (String)"Success"));
    }

    private void verifyInput() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboTrainActCourse);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, "chargeItem");
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("chargeStand").getValue() == null && row.getCell("count").getValue() == null && row.getCell("cost").getValue() == null || row.getCell("chargeItem").getValue() != null) continue;
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, row, "chargeItem");
        }
    }

    private boolean isTotalRow(IRow row) {
        return "Total".equals((String)row.getCell("id").getValue());
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (colIndex == this.tblMain.getColumn("cost").getColumnIndex()) {
            this.calculateTotalCost();
        }
        if (colIndex == this.tblMain.getColumn("chargeItem").getColumnIndex() && e.getValue() != null) {
            if (this.isExistChargeItemInTable((ChargeItemInfo)e.getValue(), row)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistItem"));
                row.getCell("chargeItem").setValue(null);
                row.getCell("chargeStand").setValue(null);
                row.getCell("count").setValue(null);
                row.getCell("cost").setValue(null);
                this.canSave = false;
                SysUtil.abort();
            } else {
                row.getCell("itemId").setValue((Object)((ChargeItemInfo)e.getValue()).getId().toString());
            }
        }
    }

    private boolean isExistChargeItemInTable(ChargeItemInfo info, IRow editRow) {
        if (info == null) {
            return false;
        }
        IRow row = null;
        int count = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getRowIndex() == editRow.getRowIndex() || row.getCell("chargeItem").getValue() == null || !((ChargeItemInfo)row.getCell("chargeItem").getValue()).getId().toString().equals(info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isModify() {
        if (this.tblMain.getRowCount() == 0) {
            return false;
        }
        if (super.isModify()) {
            return true;
        }
        String trainActCourseId = ((TrainActCourseInfo)this.comboTrainActCourse.getSelectedItem()).getId().toString();
        this.updateCollectionMap(this.collectionMap);
        TrainCourseCostCollection currentCollection = (TrainCourseCostCollection)((Object)this.collectionMap.get(trainActCourseId));
        TrainCourseCostCollection historyCollection = (TrainCourseCostCollection)((Object)this.historys.get(trainActCourseId));
        if (currentCollection.size() != historyCollection.size()) {
            return true;
        }
        TrainCourseCostInfo currentInfo = null;
        TrainCourseCostInfo historyInfo = null;
        int size = currentCollection.size();
        for (int i = 0; i < size; ++i) {
            currentInfo = currentCollection.get(i);
            int count = historyCollection.size();
            for (int j = 0; j < count; ++j) {
                historyInfo = historyCollection.get(j);
                if (currentInfo.getId() != null && historyInfo.getId() != null && currentInfo.getId().equals((Object)historyInfo.getId())) break;
            }
            if (this.objectValueEquals(currentInfo, historyInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean objectValueEquals(TrainCourseCostInfo currentInfo, TrainCourseCostInfo historyInfo) {
        if (currentInfo == null && historyInfo == null) {
            return true;
        }
        if (currentInfo != null && historyInfo != null) {
            boolean flag = this.objectValueEquals(currentInfo.getId(), historyInfo.getId());
            flag &= this.objectValueEquals(currentInfo.getChargeItem(), historyInfo.getChargeItem());
            flag &= this.objectValueEquals(currentInfo.getChargeStand(), historyInfo.getChargeStand());
            flag &= this.objectValueEquals(currentInfo.getCount(), historyInfo.getCount());
            return flag &= this.objectValueEquals(currentInfo.getCost(), historyInfo.getCost());
        }
        return false;
    }

    private boolean objectValueEquals(Object source, Object target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target);
        }
        return false;
    }
}

