/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.CourseKindFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainMaterialInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseTreePromptBox;
import com.kingdee.eas.hr.train.client.TrainMaterialMultiPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;

public class TrainCourseEditUI
extends AbstractTrainCourseEditUI {
    private boolean isViewOnly = false;
    private static final String COURSE_RANGE = TrainClientUtil.getResource("com.kingdee.eas.hr.train.client.TrainResource", "CourseRange");
    private static final String COURSE_MATERIAL = TrainClientUtil.getResource("com.kingdee.eas.hr.train.client.TrainResource", "CourseMaterial");
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private HashMap hmUIState = new HashMap();
    private JButton btnDelOrg;
    private JButton btnAddOrg;

    public void loadFields() {
        super.loadFields();
        if (this.kdtMaterial.getRowCount() > 0) {
            IRow[] rows = new IRow[this.kdtMaterial.getRowCount()];
            int count = this.kdtMaterial.getRowCount();
            for (int i = 0; i < count; ++i) {
                rows[i] = this.kdtMaterial.getRow(i);
            }
            this.showAttachmentIcon(rows);
        }
        if (this.editData.getCourseKind() != null) {
            TrainUtils.setComboBoxSelected(this.cboCourseKind, this.editData.getCourseKind().getId().toString());
        }
        this.actionSupply.setEnabled(!this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW));
        if (OprtState.VIEW.equals(this.getOprtState())) {
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
            boolean bln = false;
            this.setTableState(this.kdtRange, bln);
            this.setTableState(this.kdtMaterial, bln);
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnAddOrg.setEnabled(false);
            this.btnDelOrg.setEnabled(false);
            if (this.editData != null) {
                if (this.editData.isIsEnable()) {
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(true);
                    this.actionRemove.setEnabled(true);
                }
            }
        }
    }

    private void setTableState(KDTable table, boolean bln) {
        table.setEnabled(bln);
        DetailPanel detailPanel = TrainClientUtil.getTableDetailPanel((Component)table);
        if (detailPanel != null) {
            detailPanel.getAddNewLineButton().setEnabled(bln);
            detailPanel.getInsertLineButton().setEnabled(bln);
            detailPanel.getRemoveLinesButton().setEnabled(bln);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtRange.setBounds(new Rectangle(10, 295, 350, 156));
        this.kdtRange.repaint();
        TrainUtils.initOrgUnit(this.prmtorgUnit, (IUIObject)this);
        if (this.getUIContext().get("viewOnly") != null) {
            this.isViewOnly = (Boolean)this.getUIContext().get("viewOnly");
            if (this.isViewOnly) {
                this.actionAddNew.setEnabled(false);
                this.actionSave.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionSubmit.setEnabled(false);
            }
        }
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtCourseHour);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtCourseCost);
        this.replaceKdtRangeRemoveMethod();
        TrainUtils.setKDTableSortable(this.kdtRange);
        TrainClientUtil.setTableTitle(this.kdtRange, COURSE_RANGE);
        TrainClientUtil.setTableTitle(this.kdtMaterial, COURSE_MATERIAL);
    }

    private void replaceKdtRangeRemoveMethod() {
        DetailPanel detailPanel = TrainClientUtil.getTableDetailPanel((Component)this.kdtRange);
        if (detailPanel != null) {
            KDWorkButton removeButton = detailPanel.getRemoveLinesButton();
            ActionListener[] listeners = removeButton.getActionListeners();
            if (listeners != null && listeners.length > 0) {
                for (int j = 0; j < listeners.length; ++j) {
                    removeButton.removeActionListener(listeners[j]);
                }
            }
            removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TrainUtils.removeLine(TrainCourseEditUI.this.kdtRange);
                }
            });
        }
    }

    protected String getEditUIName() {
        return TrainCourseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseFactory.getRemoteInstance();
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState()) && this.getUIContext().get("ParentNode") != null && this.getUIContext().get("ParentNode") instanceof TrainCourseInfo) {
            this.editData.put("treeid", (TrainCourseTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    protected IObjectValue createNewData() {
        TrainCourseInfo objectValue = new TrainCourseInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setIsEnable(true);
        objectValue.setIsPublic(true);
        HashMap map = (HashMap)this.getUIContext();
        if (map.get("ParentNode") instanceof TrainCourseTreeInfo) {
            objectValue.setTreeid((TrainCourseTreeInfo)map.get("ParentNode"));
        }
        objectValue.setCourseHourUnit(CourseHourUnitEnum.SECTOR);
        return objectValue;
    }

    protected void lockUIForViewStatus() {
    }

    protected void unLockUI() {
        boolean bln = true;
        this.kdtRange.setEnabled(bln);
        this.setTableState(this.kdtRange, bln);
        this.setTableState(this.kdtMaterial, bln);
        TrainClientUtil.unLockUI(this.hmUIState);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnReferTrainCourseResearch.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnSupply.setIcon(EASResource.getIcon((String)"imgTbtn_courseoffer"));
        this.menuItemSupply.setIcon(EASResource.getIcon((String)"imgTbtn_courseoffer"));
        try {
            this.cboCourseKind.setModel((ComboBoxModel)TrainUtils.getComboModel(CourseKindFactory.getRemoteInstance(), TrainUtils.getCurrentHRFilter("hrOrgUnit.id")));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.kdtRange.getColumn("AdminOrgUnit").getStyleAttributes().setLocked(true);
        this.kdtRange.getColumn("AdminOrgUnitNumber").getStyleAttributes().setLocked(true);
        KDBizPromptBox materialPrmtBox = new KDBizPromptBox();
        TrainMaterialMultiPromptBox trainMaterialMultiPromptBox = new TrainMaterialMultiPromptBox((IUIObject)this);
        trainMaterialMultiPromptBox.setSingleSelect(true);
        materialPrmtBox.setSelector((KDPromptSelector)trainMaterialMultiPromptBox);
        materialPrmtBox.setEditable(false);
        this.kdtMaterial.getColumn("TrainMaterial").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)materialPrmtBox));
        materialPrmtBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    TrainMaterialInfo materialInfo = (TrainMaterialInfo)e.getData();
                    int rowIndex = KDTableUtil.getSelectedRow((KDTable)TrainCourseEditUI.this.kdtMaterial);
                    IRow row = TrainCourseEditUI.this.kdtMaterial.getRow(rowIndex);
                    row.getCell("TrainMaterial").setValue((Object)materialInfo);
                    row.getCell("TrainMaterialNumber").setValue((Object)materialInfo.getNumber());
                    TrainCourseEditUI.this.showAttachmentIcon(new IRow[]{row});
                } else {
                    TrainCourseEditUI.this.clearMaterialRowData();
                }
            }
        });
        this.prmtCourseTree.setSelector((KDPromptSelector)new TrainCourseTreePromptBox((IUIObject)this));
        this.btnAddOrg = this.contRange.add((Action)((Object)this.actionAddOrg));
        this.btnDelOrg = this.contRange.add((Action)((Object)this.actionDelOrg));
        this.btnAddOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddOrg.setToolTipText(EASResource.getString((String)RES, (String)"add"));
        this.btnDelOrg.setToolTipText(EASResource.getString((String)RES, (String)"remove"));
        String isShare = null;
        try {
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            isShare = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), "hr_train_002");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (isShare != null && isShare.equals("true")) {
            this.btnAddOrg.setEnabled(false);
            this.btnDelOrg.setEnabled(false);
            this.kdtRange.setEditable(false);
        }
    }

    private void showAttachmentIcon(IRow[] rows) {
        if (rows != null && rows.length > 0) {
            IRow row2 = null;
            TrainMaterialInfo materialInfo = null;
            HashSet<String> materialIds = new HashSet<String>();
            int length = rows.length;
            for (int i = 0; i < length; ++i) {
                row2 = rows[i];
                materialInfo = (TrainMaterialInfo)row2.getCell("TrainMaterial").getValue();
                if (TrainCommonUtils.isEmpty((CoreBaseInfo)materialInfo)) continue;
                materialIds.add(materialInfo.getId().toString());
            }
            if (!materialIds.isEmpty()) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("boID", materialIds, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                BoAttchAssoCollection collection = null;
                try {
                    collection = BoAttchAssoFactory.getRemoteInstance().getBoAttchAssoCollection(viewInfo);
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                if (collection != null && collection.size() > 0) {
                    materialIds.clear();
                    int size = collection.size();
                    for (int i = 0; i < size; ++i) {
                        materialIds.add(collection.get(i).getBoID());
                    }
                    Icon icon = EASResource.getIcon((String)"imgTbtn_affixmanage");
                    Icon value = null;
                    for (IRow row2 : rows) {
                        materialInfo = (TrainMaterialInfo)row2.getCell("TrainMaterial").getValue();
                        value = !TrainCommonUtils.isEmpty((CoreBaseInfo)materialInfo) && materialIds.contains(materialInfo.getId().toString()) ? icon : null;
                        row2.getCell("attachmentIcon").setValue(value);
                    }
                }
            }
        }
    }

    private void clearMaterialRowData() {
        int curRowIndex = TrainUtils.getCurrentRowIndex(this.kdtMaterial);
        IRow row = this.kdtMaterial.getRow(curRowIndex);
        row.getCell("TrainMaterialNumber").setValue(null);
        row.getCell("attachmentIcon").setValue(null);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtCourseTree);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtorgUnit);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtRange, "AdminOrgUnit");
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtMaterial, "TrainMaterial");
        TrainVerifyUtils.verifyRepeatRow((CoreUIObject)this, this.kdtRange, "AdminOrgUnit", COURSE_RANGE);
        TrainVerifyUtils.verifyRepeatRow((CoreUIObject)this, this.kdtMaterial, "TrainMaterial", COURSE_MATERIAL);
    }

    public void actionSupply_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)this.editData.getId().toString()));
        TrainUtils.showChanneCourseList(filter, "course");
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("CourseKind.*"));
        return sic;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.actionSupply.setEnabled(false);
    }

    protected void kdtMaterial_tableClicked(KDTMouseEvent e) throws Exception {
        TrainMaterialInfo materialInfo;
        IRow row;
        super.kdtMaterial_tableClicked(e);
        if (e.getClickCount() == 2 && e.getColIndex() == this.kdtMaterial.getColumnIndex("attachmentIcon") && (row = this.kdtMaterial.getRow(e.getRowIndex())).getCell("attachmentIcon").getValue() != null && (materialInfo = (TrainMaterialInfo)row.getCell("TrainMaterial").getValue()) != null) {
            AttachmentManagerFactory.getClientManager().showAttachmentListUIByBoID(materialInfo.getId().toString(), (Object)this, false);
        }
    }

    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOrg_actionPerformed(e);
        super.actionAddOrg_actionPerformed(e);
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        f7.setIsSingleSelect(false);
        Set orgUnitIDs = this.getOrgIds();
        f7.show();
        if (f7.isCanceled()) {
            return;
        }
        Object obj = f7.getData();
        if (obj instanceof Object[]) {
            Object[] datas = (Object[])obj;
            IRow row = null;
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            for (int i = 0; i < datas.length; ++i) {
                adminOrgUnitInfo = (AdminOrgUnitInfo)datas[i];
                if (orgUnitIDs != null && orgUnitIDs.contains(adminOrgUnitInfo.getId().toString())) continue;
                row = this.kdtRange.addRow();
                row.getCell("AdminOrgUnit").setValue((Object)adminOrgUnitInfo);
                row.getCell("AdminOrgUnitNumber").setValue((Object)adminOrgUnitInfo.getNumber());
            }
        }
    }

    private Set getOrgIds() {
        HashSet<String> orgIds = new HashSet<String>();
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        for (int rowIndex = 0; rowIndex < this.kdtRange.getRowCount(); ++rowIndex) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.kdtRange.getRow(rowIndex).getCell("AdminOrgUnit").getValue();
            orgIds.add(adminOrgUnitInfo.getId().toString());
        }
        return orgIds;
    }

    public void actionDelOrg_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtRange);
    }

    protected void setAutoNumberByOrg(String orgType) {
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isOrgUnitRange()) {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isOrgUnitRange()) {
            super.actionRemove_actionPerformed(e);
        }
    }

    private boolean isOrgUnitRange() throws EASBizException, BOSException {
        HashSet<BOSUuid> orgId = new HashSet<BOSUuid>();
        orgId.add(this.editData.getOrgUnit().getId());
        if (TrainFacadeFactory.getRemoteInstance().isInAdminRange(orgId)) {
            return true;
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"notCurrentOrgUnit_Course"));
        return false;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return false;
    }
}

