/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.hr.train.ITrainCourse;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainConstants;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCoursePersonListUI;
import com.kingdee.eas.hr.train.client.TrainActCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseFilterUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class TrainCoursePersonListUI
extends AbstractTrainCoursePersonListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCoursePersonListUI.class);
    private ITrainCourse trainCourse;
    private String userAdminOrgUnitId;
    private FilterInfo adminOrgUnitFilter;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public TrainCoursePersonListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainCourseSelfQuery");
    }

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.setUserAdminOrgUnitId();
        super.onLoad();
        this.tblMain.getColumn("IsEnable").getStyleAttributes().setHided(true);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getStyleAttributes().setBackground(TrainConstants.disableColor);
        this.trainMaterial.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.kDMenu1.setVisible(false);
        this.menuBiz.setVisible(false);
        this.btnAddInstructor.setVisible(false);
        this.menuBiz.setVisible(false);
        this.kDMenu1.setVisible(false);
        this.btnRange.setVisible(false);
        this.btnImport.setVisible(false);
        this.btnExport.setVisible(false);
        this.menuItemImport.setVisible(false);
        this.menuItemExport.setVisible(false);
        this.actionImportData.setVisible(false);
        this.actionExportData.setVisible(false);
    }

    private void setUserAdminOrgUnitId() throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnit;
        PersonInfo personInfo = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (personInfo != null && (adminOrgUnit = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(personInfo.getId())) != null && adminOrgUnit.getId() != null) {
            this.userAdminOrgUnitId = adminOrgUnit.getId().toString();
        }
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo fi = super.getDefaultFilterForTree();
        return fi;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        filterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
        return filterInfo;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String trainCourseId = this.getSelectedKeyValue();
        if (trainCourseId != null) {
            TrainCourseInfo courseInfo;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("IsPublic"));
            if (this.trainCourse == null) {
                this.trainCourse = TrainCourseFactory.getRemoteInstance();
            }
            if (!(courseInfo = this.trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(trainCourseId), sic)).isIsPublic()) {
                this.actionTrainMaterial.setEnabled(false);
            } else {
                this.actionTrainMaterial.setEnabled(true);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainCourseFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return TrainActCourseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActCourseFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainActCourseInfo objectValue = new TrainActCourseInfo();
        return objectValue;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), (ListUI)this, this.mainQueryPK);
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    protected void initPopmenu() {
    }
}

