/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseRecordReportListUI;
import com.kingdee.eas.hr.train.client.TrainCourseRecordEditUI;
import com.kingdee.eas.hr.train.client.TrainCourseRecordReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

public class TrainCourseRecordReportListUI
extends AbstractTrainCourseRecordReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseRecordReportListUI.class);

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            String userID = null;
            userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(userID, "adminOrgUnit.id"));
            return filterInfo;
        }
        catch (Exception e) {
            this.handleException(e);
            return super.getDefaultFilterForQuery();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mergeTable();
        TrainUtils.setTableNumberFormat(this.tblMain, "assessScore", 2);
        TrainUtils.setTableNumberFormat(this.tblMain, "courseCost", 2);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("courseDate").setWidth(270);
    }

    public void onGetRowSet(IRowSet rowSet) {
        this.updateInstractor(rowSet);
        super.onGetRowSet(rowSet);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("BeginDateTime");
        sic.add("EndDateTime");
        return sic;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected void mergeTable() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("name").setGroup(true);
        this.tblMain.getColumn("belongOrgUnit").setGroup(true);
        this.tblMain.getColumn("position").setGroup(true);
        this.tblMain.getColumn("trainType").setGroup(true);
        this.tblMain.getColumn("trainCategory").setGroup(true);
        this.tblMain.getColumn("trainingCategory").setGroup(true);
        this.tblMain.getColumn("trainActivityNumber").setGroup(true);
        this.tblMain.getColumn("trainActivity").setGroup(true);
        this.tblMain.getColumn("orgUnit").setGroup(true);
        this.tblMain.refresh();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        queryDlg.setDynQueryVisible(true);
        return queryDlg;
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainCourseRecordReportFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected String getEditUIName() {
        return TrainCourseRecordEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseRecordFactory.getRemoteInstance();
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    private void updateInstractor(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                StringBuffer sql = new StringBuffer("select T_HR_TrainInstructor.fname_l2 from T_HR_TrainInstructor ");
                sql.append("inner join  T_HR_CHANNELCOURSE on T_HR_CHANNELCOURSE.FInstructorID=T_HR_TrainInstructor.FID ");
                sql.append("inner join T_HR_TrainACP on T_HR_TrainACP.FChannelCourse = T_HR_CHANNELCOURSE.FID ");
                sql.append("inner join T_HR_TrainActCourse on T_HR_TrainActCourse.FID =T_HR_TrainACP.FParentID ");
                sql.append("WHERE T_HR_TrainActCourse.FTrainActivityID='").append(rowSet.getString("TrainActivity.id"));
                sql.append("' and T_HR_TrainActCourse.FTrainCourseID ='").append(rowSet.getString("TrainCourse.id"));
                sql.append("' and T_HR_TrainACP.FIsTeacher=1");
                IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                String instractor = "";
                while (rows.next()) {
                    instractor = instractor + rows.getString("fname_l2") + ";";
                }
                if (instractor.equals("")) continue;
                rowSet.updateString("TrainInstructor.name", instractor.substring(0, instractor.length() - 1));
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

