/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.train.TrainCourseRangeCollection;
import com.kingdee.eas.hr.train.TrainCourseRangeFactory;
import com.kingdee.eas.hr.train.TrainCourseRangeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseReportListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TrainCourseReportListUI
extends AbstractTrainCourseReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseReportListUI.class);
    private TrainCourseReportFilterUI filterUI;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        this.filterUI = new TrainCourseReportFilterUI();
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                BigDecimal courseCost;
                BigDecimal courseHour = null;
                if (rowSet.getBigDecimal("TrainCourse.CourseHour") != null && rowSet.getString("TrainCourse.CourseHourUnit") != null) {
                    courseHour = rowSet.getBigDecimal("TrainCourse.CourseHour", 2);
                    rowSet.updateString("TrainCourse.CourseHourStr", courseHour + rowSet.getString("TrainCourse.CourseHourUnit"));
                } else {
                    rowSet.updateString("TrainCourse.CourseHourStr", null);
                }
                String trainChannel = rowSet.getString("Trainchannel.name");
                String trainChannelType = rowSet.getString("trainChanneCategory.name");
                if (trainChannel != null && trainChannelType != null) {
                    rowSet.updateString("Trainchannel.name", trainChannel + "_" + trainChannelType);
                }
                if ((courseCost = rowSet.getBigDecimal("TrainCourse.courseCost")) == null || courseCost.scale() <= 2) continue;
                courseCost = courseCost.setScale(2, 4);
                rowSet.updateBigDecimal("TrainCourse.courseCost", courseCost);
            }
            rowSet.beforeFirst();
            this.dealOrgUnitRange(rowSet);
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected void dealOrgUnitRange(IRowSet rowSet) throws Exception {
        rowSet.beforeFirst();
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            if (rowSet.getString("TrainCourse.id") == null) continue;
            idSet.add(rowSet.getString("TrainCourse.id"));
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainCourse.id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("trainCourse.id"));
        evi.getSelector().add(new SelectorItemInfo("AdminOrgUnit.name"));
        TrainCourseRangeCollection rangeColl = TrainCourseRangeFactory.getRemoteInstance().getTrainCourseRangeCollection(evi);
        TrainCourseRangeInfo rangeInfo = null;
        String courseId = null;
        HashMap<String, String> orgUnitRanges = new HashMap<String, String>();
        int size = rangeColl.size();
        for (int i = 0; i < size; ++i) {
            rangeInfo = rangeColl.get(i);
            courseId = rangeInfo.getTrainCourse().getId().toString();
            String rangeStr = (String)orgUnitRanges.get(courseId);
            if (rangeStr == null) {
                rangeStr = rangeInfo.getAdminOrgUnit().getName();
                orgUnitRanges.put(courseId, rangeStr);
                continue;
            }
            rangeStr = rangeStr + ";" + rangeInfo.getAdminOrgUnit().getName();
            orgUnitRanges.put(courseId, rangeStr);
        }
        rowSet.beforeFirst();
        while (rowSet.next()) {
            rowSet.updateString("orgUnit.name", (String)orgUnitRanges.get(rowSet.getString("TrainCourse.id")));
        }
        rowSet.beforeFirst();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public TrainCourseReportFilterUI getFilterUI() {
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel((KDPanel)this.getFilterUI());
        return queryDlg;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        try {
            filter = TrainUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "belongOrgUnit.id");
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        return filter;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

