/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCostSummaryCollection;
import com.kingdee.eas.hr.train.TrainCostSummaryFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryCollection;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryInfo;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseSummaryEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCostSummaryEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainCourseSummaryEditUI
extends AbstractTrainCourseSummaryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseSummaryEditUI.class);
    TrainActCourseInfo actCourseInfo = null;
    String trainSummaryID = null;
    static String RES = "com.kingdee.eas.hr.train.client.TrainCourseSummaryResource";
    boolean isExist = false;
    boolean exitSuccess = true;
    private BigDecimal oldCost;
    private boolean oldIsAvgCost;
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String select = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"SELECT");
    private static final String evalCourseSummber = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"EVALCOURSESUMMBER");

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTrainCostSummary.setIcon(EASResource.getIcon((String)"imgTbtn_cycattemper"));
    }

    public void loadFields() {
        this.exitSuccess = true;
        this.clear();
        this.fetchUIContext();
        this.fetchEditData();
        this.adjustState();
        super.loadFields();
        this.loadCourseAndInstructor();
        this.countScore();
    }

    private void countScore() {
        try {
            String trainActivityId = this.actCourseInfo.getTrainActivity().getId().toString();
            String trainActCourseId = this.actCourseInfo.getId().toString();
            String trainCourseId = this.actCourseInfo.getTrainCourse().getId().toString();
            Map datas = TrainCourseSummaryFactory.getRemoteInstance().getSummaryDatas(trainActivityId, trainActCourseId, trainCourseId);
            this.txtTakinCount.setValue(datas.get("actualPersonCount"));
            BigDecimal attendPercent = (BigDecimal)datas.get("attendPercent");
            if (attendPercent == null) {
                attendPercent = new BigDecimal("0.00");
            }
            BigDecimal rate = new BigDecimal("100");
            this.txtAbsentPercent.setValue((Object)attendPercent.multiply(rate));
            this.txtAvgScore.setValue(datas.get("studentAverageScore"));
            BigDecimal passPercent = (BigDecimal)datas.get("studentPassPercent");
            if (passPercent == null) {
                passPercent = new BigDecimal("0.00");
            }
            this.txtPassPercent.setValue((Object)passPercent.multiply(rate));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadCourseAndInstructor() {
        this.txtBudget.setValue((Object)this.actCourseInfo.getTotalCost());
        if (!TrainClientUtil.objectIsNull(this.actCourseInfo.getTrainCourse())) {
            this.txtCourseName.setText(this.actCourseInfo.getTrainCourse().getName());
            this.txtCourseNumber.setText(this.actCourseInfo.getTrainCourse().getNumber());
        }
        String name = null;
        String number = null;
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < this.kdtParticipator.getRowCount(); ++i) {
            IRow row = this.kdtParticipator.getRow(i);
            TrainActCourseParticipatorInfo actParticipatorInfo = (TrainActCourseParticipatorInfo)row.getCell("actParticipator").getValue();
            if (actParticipatorInfo.isIsTeacher()) {
                TrainInstructorInfo instructorInfo = actParticipatorInfo.getChannelCourse().getInstructor();
                if (instructorInfo.isIsOuter()) {
                    name = instructorInfo.getName();
                } else {
                    name = instructorInfo.getEmployee().getName();
                    String personId = instructorInfo.getEmployee().getId().toString();
                    personIds.add(personId);
                }
                number = instructorInfo.getNumber();
            } else {
                PersonInfo personInfo = actParticipatorInfo.getParticipator();
                name = personInfo.getName();
                number = personInfo.getNumber();
                personIds.add(personInfo.getId().toString());
            }
            row.getCell("name").setValue((Object)name);
            row.getCell("number").setValue((Object)number);
            name = null;
            number = null;
        }
        if (personIds.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
            try {
                IRowSet rowSet = TrainActivityHelper.getRowSet("PersonPositionAdminQuery", filterInfo);
                this.setParcitipatorInfo(rowSet);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void setParcitipatorInfo(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return;
        }
        Map personInfos = this.rowSetToMap(rowSet);
        IRow row = null;
        Map personMap = null;
        String personId = null;
        for (int i = 0; i < this.kdtParticipator.getRowCount(); ++i) {
            row = this.kdtParticipator.getRow(i);
            personId = null;
            TrainActCourseParticipatorInfo actParticipatorInfo = (TrainActCourseParticipatorInfo)row.getCell("actParticipator").getValue();
            if (actParticipatorInfo.isIsTeacher()) {
                TrainInstructorInfo instructorInfo = actParticipatorInfo.getChannelCourse().getInstructor();
                if (!TrainCommonUtils.isEmpty((CoreBaseInfo)instructorInfo.getEmployee())) {
                    personId = instructorInfo.getEmployee().getId().toString();
                }
            } else if (!TrainCommonUtils.isEmpty((CoreBaseInfo)actParticipatorInfo.getParticipator())) {
                personId = actParticipatorInfo.getParticipator().getId().toString();
            }
            if (personId == null || (personMap = (Map)personInfos.get(personId)) == null) continue;
            row.getCell("orgUnit").setValue(personMap.get("orgUnit"));
            row.getCell("position").setValue(personMap.get("positionName"));
        }
    }

    private Map rowSetToMap(IRowSet rowSet) throws SQLException {
        HashMap map = null;
        if (rowSet != null) {
            map = new HashMap();
            rowSet.beforeFirst();
            HashMap<String, String> row = null;
            while (rowSet.next()) {
                row = new HashMap<String, String>();
                row.put("positionName", rowSet.getString("positionName"));
                row.put("orgUnit", rowSet.getString("orgUnit"));
                map.put(rowSet.getString("id"), row);
            }
            rowSet.beforeFirst();
        }
        return map;
    }

    private void clear() {
        this.txtCourseName.setText(null);
        this.txtCourseNumber.setText(null);
    }

    private void adjustState() {
        String state = this.getOprtState();
        if (OprtState.EDIT.equals(state) && !this.isExist) {
            this.setOprtState(OprtState.ADDNEW);
            this.btnRemove.setEnabled(false);
        } else if (OprtState.ADDNEW.equals(state) && this.isExist) {
            this.setOprtState(OprtState.EDIT);
            this.unLockUI();
        } else if (OprtState.VIEW.equals(state)) {
            this.kdtParticipator.getStyleAttributes().setLocked(true);
        }
    }

    private void fetchEditData() {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)this.actCourseInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("TrainSummary.id", (Object)this.trainSummaryID, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = this.getSelectors();
            int size = sic.size();
            for (int i = 0; i < size; ++i) {
                viewInfo.getSelector().add(sic.get(i));
            }
            TrainCourseSummaryCollection collection = TrainCourseSummaryFactory.getRemoteInstance().getTrainCourseSummaryCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                this.setDataObject((IObjectValue)collection.get(0));
                this.isExist = true;
            } else {
                this.isExist = false;
                this.setDataObject(this.createNewData());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.StartDate.setEnabled(false);
        this.EndDate.setEnabled(false);
        this.btnSubmit.setEnabled(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.StartDate.setEnabled(true);
        this.EndDate.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.btnRemove.setEnabled(true);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int option;
        if (this.kdtParticipator.getRowCount() > 0) {
            IRow row = null;
            int k = 0;
            for (int i = 0; i < this.kdtParticipator.getRowCount(); ++i) {
                k = i + 1;
                row = this.kdtParticipator.getRow(i);
                BigDecimal evaluRate = null;
                if (row.getCell("evaluRate").getValue() == null || (evaluRate = new BigDecimal(row.getCell("evaluRate").getValue().toString())).compareTo(new BigDecimal("100")) != 1) continue;
                MsgBox.showInfo((String)(select + k + evalCourseSummber));
                SysUtil.abort();
            }
        }
        if ((option = this.checkAvgCost()) != 2) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    private int checkAvgCost() throws BOSException, EASBizException {
        int result = 0;
        if (this.editData.isIsAvgCost()) {
            if (!this.oldIsAvgCost || !this.oldCost.equals(this.editData.getCost())) {
                result = MsgBox.showConfirm3((Component)((Object)this), (String)TrainClientUtil.getResource(RES, "isAvgCost"));
                if (result == 0) {
                    this.editData.put("avgCostFlag", "true");
                } else if (result == 1) {
                    this.chkIsAvgCost.setSelected(false);
                }
            }
        } else if (this.editData.getId() != null && this.oldIsAvgCost && (result = MsgBox.showConfirm3((Component)((Object)this), (String)TrainClientUtil.getResource(RES, "originIsAvgCost"))) == 0) {
            this.editData.put("clearCostFlag", "true");
        }
        return result;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanEdit() throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getTrainSummary())) {
            TrainClientUtil.showErrorMessage(RES, "trainSummaryNotNull", (CoreUI)this);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getTrainSummary().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)50));
        if (TrainSummaryFactory.getRemoteInstance().exists(filterInfo)) {
            TrainClientUtil.showErrorMessage(RES, "auditedNotModify", (CoreUI)this);
        }
        this.kdtParticipator.getStyleAttributes().setLocked(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.setOprtState(OprtState.ADDNEW);
        this.unLockUI();
    }

    protected String getEditUIName() {
        return TrainCourseSummaryEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseSummaryFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainCourseSummaryInfo objectValue = null;
        try {
            if (this.trainSummaryID != null && !TrainCommonUtils.isEmpty((CoreBaseInfo)this.actCourseInfo)) {
                objectValue = TrainCourseSummaryFactory.getRemoteInstance().createNewData(this.trainSummaryID, this.actCourseInfo.getId().toString());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return objectValue;
    }

    protected void inOnload() throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFormattedTextDisplayFormatter();
        this.initFormattedTextRange();
        this.initKdtParticipator();
        Object onlyView = this.getUIContext().get("onlyView");
        if (onlyView != null && "true".equals(onlyView)) {
            this.btnSubmit.setVisible(false);
            this.btnEdit.setVisible(false);
        } else {
            this.btnSubmit.setVisible(true);
            this.btnEdit.setVisible(true);
        }
    }

    private void initFormattedTextRange() {
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtAbsentPercent);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtPassPercent);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtAvgScore);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtBudget);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtCourseEvalu);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtCost);
    }

    private void initFormattedTextDisplayFormatter() {
        this.txtCost.setSupportedEmpty(true);
        this.txtCourseEvalu.setSupportedEmpty(true);
        this.txtAbsentPercent.setRemoveingZeroInDispaly(false);
        this.txtPassPercent.setRemoveingZeroInDispaly(false);
        this.txtPassPercent.setPrecision(2);
        TrainClientUtil.setBigDecimalDisplayFormatter(this.txtAvgScore, TrainClientUtil.PRECISION);
        TrainClientUtil.setBigDecimalDisplayFormatter(this.txtBudget, TrainClientUtil.PRECISION);
        TrainClientUtil.setBigDecimalDisplayFormatter(this.txtCourseEvalu, TrainClientUtil.PRECISION);
        TrainClientUtil.setBigDecimalDisplayFormatter(this.txtCost, TrainClientUtil.PRECISION);
    }

    private void initKdtParticipator() throws Exception {
        KDFormattedTextField txtEvalu = new KDFormattedTextField();
        txtEvalu.setHorizontalAlignment(4);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtParticipator, txtEvalu, "evalu", TrainClientUtil.PRECISION);
        KDFormattedTextField txtEvaluRate = new KDFormattedTextField();
        txtEvaluRate.setHorizontalAlignment(4);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtParticipator, txtEvaluRate, "evaluRate", TrainClientUtil.PRECISION);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtEvalu);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtEvaluRate);
        TrainClientUtil.setDisableColor(this.kdtParticipator);
    }

    private void fetchUIContext() {
        this.actCourseInfo = (TrainActCourseInfo)this.getUIContext().get("trainActCourse");
        if (TrainClientUtil.objectIsNull(this.actCourseInfo)) {
            TrainClientUtil.showErrorMessage(RES, "actCourseNotNull", (CoreUI)this);
        }
        this.trainSummaryID = (String)this.getUIContext().get("trainSummary");
        if (TrainClientUtil.objectIsNull(this.trainSummaryID)) {
            TrainClientUtil.showErrorMessage(RES, "trainSummaryNotNull", (CoreUI)this);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Date endDate;
        Date startDate;
        super.beforeStoreFields(e);
        if (!TrainClientUtil.objectIsNull(this.StartDate.getValue()) && !TrainClientUtil.objectIsNull(this.EndDate.getValue()) && (startDate = (Date)this.StartDate.getValue()).after(endDate = (Date)this.EndDate.getValue())) {
            this.StartDate.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "startDateMustBeforeEndDate", (CoreUI)this);
        }
        if (!TrainClientUtil.objectIsNull(this.txtCourseHour.getText()) || !TrainClientUtil.objectIsNull(this.CourseHourUnit.getSelectedItem())) {
            if (TrainClientUtil.objectIsNull(this.txtCourseHour.getText())) {
                this.txtCourseHour.requestFocus();
                TrainClientUtil.showErrorMessage(RES, "hourAndHourNotNull", (CoreUI)this);
            } else if (TrainClientUtil.objectIsNull(this.CourseHourUnit.getSelectedItem())) {
                this.CourseHourUnit.requestFocus();
                TrainClientUtil.showErrorMessage(RES, "hourAndHourUnitNotNull", (CoreUI)this);
            }
        }
        if (this.chkIsAvgCost.isSelected() && TrainClientUtil.objectIsNull(this.txtCost.getText())) {
            this.txtCost.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "avgCostIsSelectedCostNotNull", (CoreUI)this);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("TrainActCourse.id"));
        sic.add(new SelectorItemInfo("TrainSummary.id"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.channelCourse.Instructor.number"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.channelCourse.Instructor.name"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.channelCourse.Instructor.isOuter"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.channelCourse.Instructor.Employee.id"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.channelCourse.Instructor.Employee.name"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.channelCourse.Instructor.Employee.number"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.participator.id"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.participator.name"));
        sic.add(new SelectorItemInfo("entrys.actParticipator.participator.number"));
        return sic;
    }

    public void actionTrainCostSummary_actionPerformed(ActionEvent e) throws Exception {
        super.actionTrainCostSummary_actionPerformed(e);
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            if (OprtState.VIEW.equals(this.getOprtState())) {
                TrainClientUtil.showErrorMessage(RES, "noResponseTrainCostSummary", (CoreUI)this);
            } else {
                TrainClientUtil.showErrorMessage(RES, "mustSaveCanCostSummary", (CoreUI)this);
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        String oprt = OprtState.VIEW;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourseSumm.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        TrainCostSummaryCollection costSummaryCollection = TrainCostSummaryFactory.getRemoteInstance().getTrainCostSummaryCollection(viewInfo);
        if (costSummaryCollection != null && costSummaryCollection.size() > 0) {
            uiContext.put((Object)"ID", (Object)costSummaryCollection.get(0).getId().toString());
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            oprt = costSummaryCollection != null && costSummaryCollection.size() > 0 ? OprtState.EDIT : OprtState.ADDNEW;
        } else if (OprtState.VIEW.equals(this.getOprtState()) && (costSummaryCollection == null || costSummaryCollection.size() == 0)) {
            TrainClientUtil.showErrorMessage(RES, "noResponseTrainCostSummary", (CoreUI)this);
        }
        uiContext.put((Object)"trainCourseSummary", (Object)this.editData.getId().toString());
        uiContext.put((Object)"trainActCourse", (Object)this.editData.getTrainActCourse().getId().toString());
        uiContext.put((Object)"originValue", (Object)this.txtCost.getBigDecimalValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainCostSummaryEditUI.class.getName(), (Map)uiContext, null, oprt);
        uiWindow.show();
        if (uiWindow.getUIObject().getUIContext().get("needReback") != null && ((Boolean)uiWindow.getUIObject().getUIContext().get("needReback")).booleanValue()) {
            this.txtCost.setValue(uiWindow.getUIObject().getUIContext().get("newValue"));
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText(TrainClientUtil.getResource(RES, "trainCourseSummarySaveSuccess"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(3);
        this.showMessage();
    }

    public IObjectPK runSave() throws Exception {
        IObjectPK objectPK = super.runSave();
        return objectPK;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        this.updateState();
        return objectPK;
    }

    private void updateState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    public boolean getExitSuccess() {
        return this.exitSuccess;
    }

    public void checkModified2() {
        try {
            this.checkModified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void checkModified() throws Exception {
        this.exitSuccess = true;
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    this.exitSuccess = false;
                    SysUtil.abort();
                }
            } else if (result == 2) {
                this.exitSuccess = false;
                SysUtil.abort();
            }
        }
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        this.oldCost = this.editData.getCost() == null ? new BigDecimal("0.00") : this.editData.getCost().setScale(2);
        this.oldIsAvgCost = this.editData.isIsAvgCost();
    }

    public boolean isPrepareActionTrainCostSummary() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionSubmit() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        SelectorItemCollection sic;
        IUIActionPostman postman = super.prepareInit();
        RequestContext request = new RequestContext();
        this.actCourseInfo = (TrainActCourseInfo)this.getUIContext().get("trainActCourse");
        if (this.actCourseInfo != null) {
            request.put("actCourseInfo", (Object)this.actCourseInfo);
        }
        this.trainSummaryID = (String)this.getUIContext().get("trainSummary");
        if (this.trainSummaryID != null) {
            request.put("trainSummaryID", (Object)this.trainSummaryID);
        }
        if ((sic = this.getSelectors()) != null) {
            request.put("selector", (Object)sic);
        }
        postman.setRequestContext((Serializable)request);
        return postman;
    }
}

