/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.hr.train.ITrainEquipment;
import com.kingdee.eas.hr.train.TrainEquipmentCollection;
import com.kingdee.eas.hr.train.TrainEquipmentFactory;
import com.kingdee.eas.hr.train.TrainEquipmentInfo;
import com.kingdee.eas.hr.train.TrainEquipmentTreeFactory;
import com.kingdee.eas.hr.train.TrainEquipmentTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainEquipmentMultiF7UI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainEquipmentEditUI;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TrainEquipmentMultiF7UI
extends AbstractTrainEquipmentMultiF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TrainEquipmentMultiF7UI.class);
    TrainEquipmentCollection trainEquipmentCollection = new TrainEquipmentCollection();
    String resClass = "com.kingdee.eas.hr.perf.client.EvaluResultReportResource";
    public boolean isCanceled = false;
    static String ID = "id";
    static String NAME = "name";
    static String UNIT = "unit";
    static String COUNT = "count";
    static String TRAINCHANNEL = "trainChanne";
    static String INTRODUCE = "introduce";
    static String KEEPADDRESS = "keepAddress";
    static String KEEPER = "keeper";
    static String SUPPLIERTYPE = "supplierType";

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TrainEquipmentTreeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return TrainEquipmentEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initialTableDataRequestEvent();
        this.initialControlProperty();
        TrainUtils.setTableNumberFormat(this.tblMain, COUNT, 0);
        TrainUtils.setTableNumberFormat(this.tblList, COUNT, 0);
    }

    private void initialTableDataRequestEvent() {
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (TrainEquipmentMultiF7UI.this.tblMain.getRowCount() != 0) {
                    TrainEquipmentMultiF7UI.this.tblMain.getSelectManager().select(0, 0);
                }
            }
        });
    }

    private void initialControlProperty() {
        this.tblMain.checkParsed();
        this.tblList.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblList.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblList.getStyleAttributes().setLocked(true);
        this.getUIMenuBar().setVisible(false);
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return TrainEquipmentFactory.getRemoteInstance();
    }

    public void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = e.getPath();
        DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (treenode.getUserObject() != null && treenode.getUserObject() instanceof TrainEquipmentTreeInfo) {
            TrainEquipmentTreeInfo trainEquipmentTreeInfo = (TrainEquipmentTreeInfo)treenode.getUserObject();
            this.mainQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)trainEquipmentTreeInfo.getId().toString()));
            this.mainQuery.setFilter(filter);
        } else {
            this.mainQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)BOSUuid.create((BOSObjectType)new TrainEquipmentTreeInfo().getBOSType()).toString()));
            this.mainQuery.setFilter(filter);
        }
        this.reflesh();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            int[] rowID = TrainHelper.getSelectedRows(this.tblMain);
            this.insertRow(rowID);
            this.reflesh();
        }
    }

    void insertRow(int[] counts) throws EASBizException, BOSException, UuidException {
        TrainEquipmentCollection trainEquipments = new TrainEquipmentCollection();
        String strID = null;
        if (counts.length > 0) {
            for (int i = 0; i < counts.length; ++i) {
                strID = this.tblMain.getRow(counts[i]).getCell("id").getValue().toString();
                TrainEquipmentInfo equipmentInfo = new TrainEquipmentInfo();
                equipmentInfo.setId(BOSUuid.read((String)strID));
                if (this.checkIsExistInList(equipmentInfo)) continue;
                trainEquipments.add(equipmentInfo);
            }
            if (trainEquipments.size() > 0) {
                TrainEquipmentCollection refTrainEquipments = this.getRefTrainEquipment(trainEquipments);
                int n = refTrainEquipments.size();
                for (int j = 0; j < n; ++j) {
                    this.trainEquipmentCollection.add(refTrainEquipments.get(j));
                    this.addDataToTable(this.tblList.addRow(), refTrainEquipments.get(j));
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    private TrainEquipmentCollection getRefTrainEquipment(TrainEquipmentCollection trainEquipments) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        int n = trainEquipments.size();
        for (int i = 0; i < n; ++i) {
            set.add(trainEquipments.get(i).getId().toString());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("Unit"));
        viewInfo.getSelector().add(new SelectorItemInfo("Keeper"));
        viewInfo.getSelector().add(new SelectorItemInfo("Count"));
        viewInfo.getSelector().add(new SelectorItemInfo("KeepAddress"));
        viewInfo.getSelector().add(new SelectorItemInfo("Introduce"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.treeId.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("treeid.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("treeid.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("treeid.id"));
        ITrainEquipment iTrainEquipment = TrainEquipmentFactory.getRemoteInstance();
        return iTrainEquipment.getTrainEquipmentCollection(viewInfo);
    }

    void addDataToTable(IRow curRow, TrainEquipmentInfo equipMentInfo) {
        if (TrainClientUtil.objectIsNull(equipMentInfo)) {
            return;
        }
        curRow.getCell(ID).setValue((Object)equipMentInfo.getId().toString());
        curRow.getCell(NAME).setValue((Object)equipMentInfo.getName());
        curRow.getCell(UNIT).setValue((Object)equipMentInfo.getUnit());
        curRow.getCell(COUNT).setValue((Object)equipMentInfo.getCount());
        if (!TrainClientUtil.objectIsNull(equipMentInfo.getTrainChannel())) {
            curRow.getCell(TRAINCHANNEL).setValue((Object)equipMentInfo.getTrainChannel().getName());
            if (equipMentInfo.getTrainChannel() != null && equipMentInfo.getTrainChannel().getTreeId() != null) {
                curRow.getCell(SUPPLIERTYPE).setValue((Object)equipMentInfo.getTrainChannel().getTreeId().getName());
            }
        }
        curRow.getCell(INTRODUCE).setValue((Object)equipMentInfo.getIntroduce());
        curRow.getCell(KEEPADDRESS).setValue((Object)equipMentInfo.getKeepAddress());
        curRow.getCell(KEEPER).setValue((Object)equipMentInfo.getKeeper());
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.trainEquipmentCollection.size() != 0) {
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    boolean checkIsExistInList(TrainEquipmentInfo trainEquipmentInfo) {
        for (int i = 0; i < this.trainEquipmentCollection.size(); ++i) {
            if (!this.trainEquipmentCollection.get(i).getId().equals((Object)trainEquipmentInfo.getId())) continue;
            return true;
        }
        return false;
    }

    public TrainEquipmentCollection getReturnValues() {
        return this.trainEquipmentCollection;
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDContainer1.addButton((JButton)this.btnInertRow);
        this.kDContainer1.addButton((JButton)this.btnDeleteRow);
        this.kDContainer1.addButton((JButton)this.btnInsertBatchRow);
        this.kDContainer1.addButton((JButton)this.btnDeleteBatchRow);
        this.kDContainer1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 422, 146));
    }

    protected void tabTrainEquipment_stateChanged(ChangeEvent e) throws Exception {
        super.tabEquipment_stateChanged(e);
        if (this.tabEquipment.getSelectedComponent() == this.panelOrg) {
            this.pnlMain.remove((Component)this.splitRight);
            this.pnlMain.add((Component)this.splitRight, (Object)"right");
        } else {
            this.pnlMain.remove((Component)this.splitRight);
        }
    }

    protected void btnDeleteBatchRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteBatchRow_actionPerformed(e);
        this.trainEquipmentCollection.clear();
        this.tblList.removeRows();
        this.reflesh();
    }

    protected void btnDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteRow_actionPerformed(e);
        int[] selectRow = TrainHelper.getSelectedRows(this.tblList);
        if (selectRow.length > 0) {
            String id = null;
            for (int j = 0; j < selectRow.length; ++j) {
                if (this.tblList.getRow(selectRow[j]).getCell("id") != null && this.tblList.getRow(selectRow[j]).getCell("id").getValue() != null) {
                    id = this.tblList.getRow(selectRow[j]).getCell("id").getValue().toString();
                }
                if (id == null) continue;
                for (int i = 0; i < this.trainEquipmentCollection.size(); ++i) {
                    if (!this.trainEquipmentCollection.get(i).getId().toString().equals(id)) continue;
                    this.trainEquipmentCollection.removeObject(i);
                    this.tblList.removeRow(selectRow[j]);
                }
            }
        }
        this.reflesh();
    }

    private void reflesh() {
        this.execQuery();
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            if (!this.isContainTrainEquipment(row.getCell("id").getValue().toString())) continue;
            this.tblMain.removeRow(i);
        }
    }

    private boolean isContainTrainEquipment(String id) {
        for (int i = 0; i < this.trainEquipmentCollection.size(); ++i) {
            if (!this.trainEquipmentCollection.get(i).getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    protected void btnInertRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnInertRow_actionPerformed(e);
        int[] rowID = TrainHelper.getSelectedRows(this.tblMain);
        this.insertRow(rowID);
        this.reflesh();
    }

    protected void btnInsertBatchRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnInsertBatchRow_actionPerformed(e);
        int[] rowID = new int[this.tblMain.getRowCount()];
        for (int i = 0; i < rowID.length; ++i) {
            rowID[i] = i;
        }
        this.insertRow(rowID);
        this.reflesh();
    }

    protected void btnYes_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        this.mainQuery = view;
        this.tblMain.removeRows();
        this.pnlMain.remove((Component)this.splitRight);
        this.pnlMain.add((Component)this.splitRight, (Object)"right");
        this.btnConfirm.setVisible(true);
        this.btnYes2.setVisible(false);
    }

    protected FilterInfo getDefaultFilterForTree() {
        return TrainClientUtil.getCurrentHROFilter();
    }

    protected String getRootName() {
        return TrainClientUtil.getResource("com.kingdee.eas.hr.train.client.TrainEquipmentResource", "trainEquipmentRoot");
    }
}

