/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainExpenseFilterUI;
import com.kingdee.eas.hr.train.client.TrainCourseForReportPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class TrainExpenseFilterUI
extends AbstractTrainExpenseFilterUI
implements ItemListener,
SelectorListener {
    private static final Logger logger = CoreUIObject.getLogger(TrainExpenseFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainReportResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.datePickerStartDate.setValue((Object)this.getStartDate());
        this.datePickerEndDate.setValue((Object)new Date(System.currentTimeMillis()));
        TrainUtils.initOrgUnit(this.promOrg, false, (IUIObject)this);
        if (this.checkBoxActivity.isSelected()) {
            this.prompActivity.setEnabled(true);
        } else {
            this.prompActivity.setEnabled(false);
        }
        if (this.checkBoxCourse.isSelected()) {
            this.promptCourse.setEnabled(true);
        } else {
            this.promptCourse.setEnabled(false);
        }
        this.checkBoxActivity.addItemListener((ItemListener)this);
        this.checkBoxActivity.setName("checkBoxActivity");
        this.checkBoxCourse.addItemListener((ItemListener)this);
        this.checkBoxCourse.setName("checkBoxCourse");
        this.prompActivity.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityQuery");
        this.prompActivity.setEditable(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        this.prompActivity.setEntityViewInfo(viewInfo);
        if (this.prompActivity.getValue() != null) {
            this.promptCourse.setSelector(null);
            this.promptCourse.setEditable(true);
            this.promptCourse.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActCourseWorkloadTrainCourseQuery");
            EntityViewInfo courseViewInfo = new EntityViewInfo();
            FilterInfo courseFilterInfo = new FilterInfo();
            courseFilterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.prompActivity.getValue()).getId().toString()));
            courseFilterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
            courseFilterInfo.setMaskString("#0 and #1");
            courseViewInfo.setFilter(courseFilterInfo);
            this.promptCourse.setEntityViewInfo(courseViewInfo);
        } else {
            TrainCourseForReportPromptBox pmt = new TrainCourseForReportPromptBox((IUIObject)this);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
            pmt.setFilterInfo(fi);
            pmt.setSelector(this.getCourseSelectors());
            this.promptCourse.setSelector((KDPromptSelector)pmt);
            this.promptCourse.setEditable(false);
        }
        this.promptCourse.addSelectorListener((SelectorListener)this);
        this.promptCourse.setEditable(false);
    }

    public void clear() {
        this.datePickerStartDate.setValue((Object)this.getStartDate());
        this.datePickerEndDate.setValue((Object)new Date(System.currentTimeMillis()));
        this.promOrg.setValue(null);
        this.prompActivity.setValue(null);
        this.promptCourse.setValue(null);
        this.checkBoxActivity.setSelected(false);
        this.checkBoxCourse.setSelected(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.promOrg.getData() != null) {
            params.addCustomerParam("orgInfo", this.getOrgUnitInfo().getId().toString());
        }
        if (this.datePickerStartDate.getValue() != null) {
            params.putDate("startDate", (Date)this.datePickerStartDate.getValue());
        }
        if (this.datePickerEndDate.getValue() != null) {
            params.putDate("endDate", (Date)this.datePickerEndDate.getValue());
        }
        if (this.prompActivity.getData() != null) {
            params.addCustomerParam("activity", this.prompActivity.getData().toString());
        }
        if (this.promptCourse.getData() != null) {
            params.addCustomerParam("course", this.promptCourse.getData().toString());
        }
        params.putBoolean("isActivity", this.checkBoxActivity.isSelected());
        if (this.checkBoxActivity.isSelected() && this.prompActivity.getValue() != null) {
            TrainActivityInfo activityInfo = (TrainActivityInfo)this.prompActivity.getValue();
            params.addCustomerParam("activityId", activityInfo.getId().toString());
        }
        params.putBoolean("isCourse", this.checkBoxCourse.isSelected());
        if (this.checkBoxCourse.isSelected() && this.promptCourse.getValue() != null) {
            TrainCourseInfo courseInfo = (TrainCourseInfo)this.promptCourse.getValue();
            params.addCustomerParam("courseId", courseInfo.getId().toString());
        }
        return params;
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public void setCustomerParams(CustomerParams param) {
        this.clear();
        if (param == null) {
            return;
        }
        AdminOrgUnitInfo adminInfo = null;
        TrainActivityInfo activityInfo = null;
        TrainCourseInfo courseInfo = null;
        String orgId = param.getCustomerParam("orgInfo");
        String activityId = param.getCustomerParam("activityId");
        String courseId = param.getCustomerParam("courseId");
        try {
            if (!StringUtils.isEmpty((String)orgId)) {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            }
            if (!StringUtils.isEmpty((String)activityId)) {
                activityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activityId));
            }
            if (!StringUtils.isEmpty((String)courseId)) {
                courseInfo = TrainCourseFactory.getRemoteInstance().getTrainCourseInfo((IObjectPK)new ObjectUuidPK(courseId));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.promOrg.setValue(adminInfo);
        if (param.getDate("startDate") != null) {
            this.datePickerStartDate.setValue((Object)param.getDate("startDate"));
        }
        if (param.getDate("endDate") != null) {
            this.datePickerEndDate.setValue((Object)param.getDate("endDate"));
        }
        this.checkBoxActivity.setSelected(param.getBoolean("isActivity"));
        this.prompActivity.setValue((Object)activityInfo);
        this.checkBoxCourse.setSelected(param.getBoolean("isCourse"));
        this.promptCourse.setValue((Object)courseInfo);
    }

    public boolean verify() {
        Object orgUnit;
        Date startDate = (Date)this.datePickerStartDate.getValue();
        Date endDate = (Date)this.datePickerEndDate.getValue();
        if (startDate == null) {
            this.datePickerStartDate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"beginDateCanNotNull"));
            SysUtil.abort();
        }
        if (endDate == null) {
            this.datePickerEndDate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"endDateCanNotNull"));
            SysUtil.abort();
        }
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            this.datePickerEndDate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"beginDateCanNotLessEndDate"));
            SysUtil.abort();
        }
        if ((orgUnit = this.promOrg.getValue()) == null) {
            this.promOrg.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"orgUnitCanNotNull"));
            SysUtil.abort();
        }
        return true;
    }

    public void setFilterInfo(FilterInfo arg0) {
        super.setFilterInfo(arg0);
    }

    private SelectorItemCollection getCourseSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("treeid.name"));
        sic.add(new SelectorItemInfo("CourseKind.name"));
        sic.add(new SelectorItemInfo("CourseTarget"));
        return sic;
    }

    private OrgUnitInfo getOrgUnitInfo() {
        return (OrgUnitInfo)this.promOrg.getData();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Component comp = (Component)e.getSource();
            if (comp.getName().equals("checkBoxActivity")) {
                this.prompActivity.setEnabled(true);
            } else if (comp.getName().equals("checkBoxCourse")) {
                this.promptCourse.setEnabled(true);
            }
        } else if (e.getStateChange() == 2) {
            Component comp = (Component)e.getSource();
            if (comp.getName().equals("checkBoxActivity")) {
                this.prompActivity.setEnabled(false);
                this.prompActivity.setValue(null);
            } else if (comp.getName().equals("checkBoxCourse")) {
                this.promptCourse.setEnabled(false);
                this.promptCourse.setValue(null);
            }
        }
    }

    public void willShow(SelectorEvent e) {
        Component comp = (Component)e.getSource();
        if (comp.getName().equals("promptCourse") && this.checkBoxCourse.isSelected() && this.checkBoxActivity.isSelected() && this.prompActivity.getValue() != null) {
            this.promptCourse.setSelector(null);
            this.promptCourse.setEditable(true);
            KDCommonPromptDialog d = new KDCommonPromptDialog();
            this.promptCourse.setSelector((KDPromptSelector)d);
            this.promptCourse.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActCourseWorkloadTrainCourseQuery");
            EntityViewInfo courseViewInfo = new EntityViewInfo();
            FilterInfo courseFilterInfo = new FilterInfo();
            courseFilterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.prompActivity.getValue()).getId().toString()));
            courseFilterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
            courseFilterInfo.setMaskString("#0 and #1");
            courseViewInfo.setFilter(courseFilterInfo);
            this.promptCourse.setEntityViewInfo(courseViewInfo);
        }
    }

    private Date getStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int year = cal.get(1);
        String str = String.valueOf(year) + "-1-1";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = df.parse(str);
        }
        catch (Exception e) {
            date = new Date();
        }
        return date;
    }
}

