/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.emp.client.PhotoPanel;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.InnerInstructorLevelFactory;
import com.kingdee.eas.hr.train.InstructorResumeFactory;
import com.kingdee.eas.hr.train.InstructorResumeInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainInnerInstructorEditUI;
import com.kingdee.eas.hr.train.client.InstructorResumeEditUI;
import com.kingdee.eas.hr.train.client.InstructorTypePromptBox;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseHistoryByInstructorListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JTextField;

public class TrainInnerInstructorEditUI
extends AbstractTrainInnerInstructorEditUI {
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainResource";
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private AdminOrgUnitInfo adminOrgUnitInfo = null;
    private HashMap hmUIState = new HashMap();
    private PhotoPanel pPanel = new PhotoPanel();
    private boolean hasCodingRule = false;
    private boolean pubBtnState = false;

    public void loadFields() {
        CodingRuleHelper.setAutoNumber((EditUI)this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState(), "IsOuter");
        super.loadFields();
        try {
            if (!OprtState.VIEW.equals(this.getOprtState())) {
                this.chkIsEnable_actionPerformed(null);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.oprtState.equals(OprtState.EDIT) || this.oprtState.equals(OprtState.ADDNEW)) {
            this.actionDelOrg.setEnabled(true);
            this.actionAddOrg.setEnabled(true);
        }
        if (this.oprtState.equals(OprtState.VIEW) || this.pubBtnState) {
            TrainUtils.disableTable(this.kdtRange);
            this.actionDelOrg.setEnabled(false);
            this.actionAddOrg.setEnabled(false);
        }
        this.initWorkButtonState();
        if (this.editData != null && this.editData.getId() != null) {
            try {
                PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(this.editData.getEmployee().getId()));
                this.setEmployeeAboutInfos(personInfo);
                this.txtNumber.setText(this.editData.getNumber());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.editData != null && this.editData.getInnerLevel() != null) {
            TrainUtils.setComboBoxSelected(this.cboInnerLevel, this.editData.getInnerLevel().getId().toString());
        }
    }

    private void initWorkButtonState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnPrimaryCourse.setEnabled(false);
            this.btnCourseHistory.setEnabled(false);
            this.btnResumeManage.setEnabled(false);
        } else {
            this.btnPrimaryCourse.setEnabled(true);
            this.btnCourseHistory.setEnabled(true);
            this.btnResumeManage.setEnabled(true);
        }
    }

    public void storeFields() {
        super.storeFields();
        this.editData.setHireDate(DateTimeUtils.truncateDate((Date)this.editData.getHireDate()));
        this.editData.setFireDate(DateTimeUtils.truncateDate((Date)this.editData.getFireDate()));
    }

    protected String getEditUIName() {
        return TrainInnerInstructorEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainInstructorFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        this.clearEmployeeAboutInfo();
        TrainInstructorInfo objectValue = new TrainInstructorInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setIsOuter(false);
        objectValue.setIsEnable(true);
        this.pPanel.setSelectImage(null);
        return objectValue;
    }

    private void clearEmployeeAboutInfo() {
        if (!this.hasCodingRule) {
            this.txtNumber.setText(null);
        }
        this.txtEmpUnit.setText(null);
        this.txtEmpPosition.setText(null);
        this.txtEmpJob.setText(null);
        this.txtEmpPost.setText(null);
        this.txtEmpHighestDiploma.setText(null);
        this.txtEmpSpecial.setText(null);
        this.txtJobGrade.setText(null);
        this.txtJoinGroupYears.setText(null);
        this.txtEmpSex.setText(null);
        this.txtEmpEmail.setText(null);
        this.txtEmpMobilePhone.setText(null);
        this.txtEmpOfficePhone.setText(null);
    }

    public void onLoad() throws Exception {
        this.pubBtnState = TrainUtils.getParamValueByNumber("hr_train_003");
        super.onLoad();
        this.txtHireYears.setHorizontalAlignment(4);
        this.pPanel.setBounds(0, 0, this.photoPanel.getWidth(), this.photoPanel.getHeight());
        this.photoPanel.add((Component)this.pPanel);
        this.hasCodingRule = CodingRuleHelper.hasNumberRule((CoreBaseInfo)this.editData, (OrgUnitInfo)TrainUtils.getCurrentHROrgUnit(), "IsOuter");
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtEmployee.getData() != null) {
            this.editData.setName(((PersonInfo)this.prmtEmployee.getData()).getName());
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminOrgUnitInfo != null) {
            HashSet<String> ids = new HashSet<String>();
            ids.add(this.adminOrgUnitInfo.getId().toString());
            if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentInnerOrgUnit"));
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
        this.loadFields();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.INNERINSTRUCTOR_SAVESUCCESS"));
        this.showMessage();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrimaryCourse.setIcon(EASResource.getIcon((String)"imgTbtn_maincourse"));
        this.btnCourseHistory.setIcon(EASResource.getIcon((String)"imgTbtn_schoolhistory"));
        this.prmtInstructorType.setSelector((KDPromptSelector)new InstructorTypePromptBox((IUIObject)this));
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Set hroSet = new HashSet();
        try {
            hroSet = TrainFacadeFactory.getRemoteInstance().getPersonHRRange(userID);
        }
        catch (EASBizException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        pmt.setHROFilter(hroSet);
        pmt.setIsSingleSelect(true);
        pmt.setIsPluralityIsChooseContral(false);
        pmt.setModal(true);
        this.prmtEmployee.setSelector((KDPromptSelector)pmt);
        this.prmtEmployee.setEditable(false);
        this.prmtEmployee.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    PersonInfo personInfo = (PersonInfo)e.getData();
                    if (personInfo != null) {
                        TrainInstructorInfo instructorInfo = TrainInnerInstructorEditUI.this.getInstructorHasExist(personInfo);
                        if (instructorInfo == null) {
                            if (TrainInnerInstructorEditUI.this.hasCodingRule) {
                                personInfo.setNumber(null);
                            }
                            TrainInnerInstructorEditUI.this.setEmployeeAboutInfos(personInfo);
                        } else {
                            int result = MsgBox.showConfirm2((String)EASResource.getString((String)TrainInnerInstructorEditUI.resourcePath, (String)"HasInnerInstructor"));
                            if (result == 0) {
                                TrainInnerInstructorEditUI.this.setEmployeeAboutInfos(personInfo);
                                TrainInnerInstructorEditUI.this.setOtherInfo(instructorInfo);
                            } else if (result == 2) {
                                e.setResult(0);
                                return;
                            }
                        }
                    } else {
                        TrainInnerInstructorEditUI.this.clearEmployeeAboutInfo();
                    }
                }
                catch (EASBizException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                catch (BOSException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        try {
            this.cboInnerLevel.setModel((ComboBoxModel)TrainUtils.getComboModel(InnerInstructorLevelFactory.getRemoteInstance(), TrainUtils.getCurrentHRFilter("hrOrgUnit.id")));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        JButton btnAddOrg = this.conRange.add((Action)((Object)this.actionAddOrg));
        JButton btnDelOrg = this.conRange.add((Action)((Object)this.actionDelOrg));
        btnAddOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnDelOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnResumeManage.setIcon(EASResource.getIcon((String)"imgTbtn_aptitude"));
    }

    private TrainInstructorInfo getInstructorHasExist(PersonInfo personInfo) throws BOSException, EASBizException {
        return TrainInstructorFactory.getRemoteInstance().isReAppointment(personInfo);
    }

    private void setOtherInfo(TrainInstructorInfo instructorInfo) {
        if (instructorInfo.getDescription() != null) {
            this.txtDescription.setSelectedItem((Object)instructorInfo.getDescription().toString());
        }
    }

    private void setEmployeeAboutInfos(PersonInfo personInfo) throws BOSException, EASBizException {
        if (!TrainCommonUtils.isEmpty(personInfo.getNumber())) {
            this.txtNumber.setText(personInfo.getNumber());
        }
        Map employeeInfo = TrainFacadeFactory.getRemoteInstance().getEmployeeRelationInfo(personInfo.getId().toString());
        this.adminOrgUnitInfo = (AdminOrgUnitInfo)employeeInfo.get("adminOrgUnit");
        if (this.adminOrgUnitInfo != null) {
            this.txtEmpUnit.setText(this.adminOrgUnitInfo.getName());
        }
        this.txtEmpPosition.setText((String)employeeInfo.get("position"));
        this.txtEmpJob.setText((String)employeeInfo.get("job"));
        this.txtEmpPost.setText((String)employeeInfo.get("technicalPost"));
        this.txtEmpHighestDiploma.setText((String)employeeInfo.get("diploma"));
        this.txtEmpSpecial.setText((String)employeeInfo.get("special"));
        this.txtJobGrade.setText((String)employeeInfo.get("grade"));
        if (employeeInfo.get("joinGroupDate") != null) {
            float adjustYear = employeeInfo.get("adjustGroupVal") != null ? ((Float)employeeInfo.get("adjustGroupVal")).floatValue() : 0.0f;
            this.txtJoinGroupYears.setText(this.computeDate((Date)employeeInfo.get("joinGroupDate"), new Date(), adjustYear));
        } else {
            this.txtJoinGroupYears.setText(null);
        }
        personInfo = (PersonInfo)employeeInfo.get("person");
        if (personInfo.getGender() != null) {
            this.txtEmpSex.setText(personInfo.getGender().getAlias());
        }
        this.txtEmpEmail.setText(personInfo.getEmail());
        this.txtEmpMobilePhone.setText(personInfo.getCell());
        this.txtEmpOfficePhone.setText(personInfo.getOfficePhone());
        this.setPhotoImage(personInfo);
    }

    private String computeDate(Date oldDate, Date nowDate, float adjustYear) {
        int year = 0;
        int month = 0;
        if (oldDate != null && nowDate != null) {
            int adjustValue;
            int totalMonth;
            Calendar dateCal = Calendar.getInstance();
            dateCal.setTime(oldDate);
            Calendar nowCal = Calendar.getInstance();
            nowCal.setTime(nowDate);
            nowCal.add(5, 1);
            int dateYear = dateCal.get(1);
            int nowYear = nowCal.get(1);
            int dateMonth = dateCal.get(2) + 1;
            int nowMonth = nowCal.get(2) + 1;
            int dateDay = dateCal.get(5);
            int nowDay = nowCal.get(5);
            int tempYear = nowYear - dateYear;
            int tempMonth = nowMonth - dateMonth;
            int tempDay = nowDay - dateDay;
            if (tempDay < 0) {
                --tempMonth;
            }
            if ((totalMonth = tempYear * 12 + tempMonth - (adjustValue = Math.round(adjustYear * 12.0f))) > 0) {
                year = totalMonth / 12;
                month = totalMonth % 12;
            }
        }
        StringBuffer str = new StringBuffer();
        str.append(year);
        str.append(EASResource.getString((String)resourcePath, (String)"YEAR"));
        str.append(month);
        str.append(EASResource.getString((String)resourcePath, (String)"MONTH"));
        return str.toString();
    }

    private void setPhotoImage(PersonInfo personInfo) {
        if (personInfo != null) {
            BufferedImage bfg = TrainClientUtil.getPersonPhoto(personInfo);
            this.pPanel.setSelectImage(bfg);
            this.pPanel.repaint();
        }
    }

    protected void showMessageForStatus() {
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtEmployee);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.dateHireDate, this.dateFireDate, null);
    }

    public void actionPrimaryCourse_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Instructor.id", (Object)this.editData.getId().toString()));
        TrainUtils.showChanneCourseList(filter, "instructor");
    }

    protected void chkIsEnable_actionPerformed(ActionEvent e) throws Exception {
        boolean enable = this.chkIsEnable.isSelected();
        this.dateHireDate.setEnabled(enable);
        this.dateFireDate.setEnabled(enable);
        this.txtHireYears.setEnabled(enable);
        if (!enable) {
            this.dateHireDate.setValue(null);
            this.dateFireDate.setValue(null);
            this.txtHireYears.setValue(null);
        }
    }

    public void actionCourseHistory_actionPerformed(ActionEvent e) throws Exception {
        super.actionCourseHistory_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"isOuter", (Object)"N");
        uiContext.put((Object)"TrainInstructorID", (Object)this.editData.getEmployee().getId().toString());
        uiContext.put((Object)"participatorID", (Object)this.editData.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainCourseHistoryByInstructorListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPk = super.runSubmit();
        return objectPk;
    }

    protected void txtHireYears_keyReleased(KeyEvent e) throws Exception {
        double hireYears = TrainUtils.numberMustPositive((JTextField)this.txtHireYears);
        if (hireYears == -1.0) {
            return;
        }
        int months = (int)Math.round(hireYears * 12.0);
        Date hireDate = (Date)this.dateHireDate.getValue();
        if (hireDate != null) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(hireDate);
            if (months != 0) {
                instance.add(2, months);
                instance.add(5, -1);
            }
            this.dateFireDate.setValue((Object)instance.getTime());
        }
    }

    public void actionResumeManage_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            InstructorResumeInfo resumeInfo = InstructorResumeFactory.getRemoteInstance().getResumeByInstructor((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
            String state = null;
            UIContext uiContext = new UIContext((Object)this);
            if (resumeInfo != null) {
                uiContext.put((Object)"ID", (Object)resumeInfo.getId());
                state = this.getOprtState();
            } else {
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    TrainClientUtil.showErrorMessage(resourcePath, "noResponseInstructorResume", (CoreUI)this);
                }
                if (OprtState.EDIT.equals(this.getOprtState())) {
                    uiContext.put((Object)"InstructorResume", (Object)this.editData);
                    state = OprtState.ADDNEW;
                }
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InstructorResumeEditUI.class.getName(), (Map)uiContext, null, state);
            uiWindow.show();
        }
    }

    protected void lockUIForViewStatus() {
        TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEdit(itemAction);
        request.setValue((CoreBaseInfo)this.editData);
        return request;
    }

    protected void unLockUI() {
        TrainClientUtil.unLockUI(this.hmUIState);
    }

    public boolean isPrepareActionSubmit() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOrg_actionPerformed(e);
        super.actionAddOrg_actionPerformed(e);
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        f7.setIsSingleSelect(false);
        Set orgUnitIDs = this.getOrgIds();
        f7.show();
        if (f7.isCanceled()) {
            return;
        }
        Object obj = f7.getData();
        if (obj instanceof Object[]) {
            Object[] datas = (Object[])obj;
            IRow row = null;
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            for (int i = 0; i < datas.length; ++i) {
                adminOrgUnitInfo = (AdminOrgUnitInfo)datas[i];
                if (orgUnitIDs != null && orgUnitIDs.contains(adminOrgUnitInfo.getId().toString())) continue;
                row = this.kdtRange.addRow();
                row.getCell("AdminOrgUnit").setValue((Object)adminOrgUnitInfo);
                row.getCell("AdminOrgUnitNumber").setValue((Object)adminOrgUnitInfo.getNumber());
            }
        }
    }

    private Set getOrgIds() {
        HashSet<String> orgIds = new HashSet<String>();
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        for (int rowIndex = 0; rowIndex < this.kdtRange.getRowCount(); ++rowIndex) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.kdtRange.getRow(rowIndex).getCell("AdminOrgUnit").getValue();
            orgIds.add(adminOrgUnitInfo.getId().toString());
        }
        return orgIds;
    }

    public void actionDelOrg_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtRange);
    }
}

