/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChargeItemFactory;
import com.kingdee.eas.hr.train.IChargeItem;
import com.kingdee.eas.hr.train.TrainPlanCourseFactory;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanCourseTrainPlanCourseCostInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanCourseFormalEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class TrainPlanCourseFormalEditUI
extends AbstractTrainPlanCourseFormalEditUI {
    private Icon newLineIcon = EASResource.getIcon((String)"imgTbtn_addline");
    private Icon removeLineIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String costTitle = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"totalCost");
    private static final String costUnit = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"costUnit");
    private static final String title = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"trainPlanCourseCost");
    private static final Color YELLOW = new Color(16579551);
    private BigDecimal totalCost = new BigDecimal("0.00");
    private BigDecimal costTotal = new BigDecimal("0.00");
    private boolean isFirst = true;
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String totalCostMention = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TotalCostCourse");

    public void onLoad() throws Exception {
        this.kdtTrainPlanCourseCost.checkParsed();
        if (OprtState.VIEW.equals(this.oprtState)) {
            TrainUtils.disableTable(this.kdtTrainPlanCourseCost);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        if (this.getUIContext().get("costTotal") != null) {
            this.costTotal = new BigDecimal(this.getUIContext().get("costTotal").toString());
        }
        super.onLoad();
        this.setCostTypeEditor();
        this.setCostEditor();
        this.kdtTrainPlanCourseCost.getColumn("ChargeItem").getStyleAttributes().setBackground(YELLOW);
        this.kdtTrainPlanCourseCost.getColumn("TotalCost").getStyleAttributes().setBackground(YELLOW);
        TrainUtils.setTableCellEditorByTextField(this.kdtTrainPlanCourseCost, "ChargeStand", 40);
        TrainUtils.setTableCellEditorByTextField(this.kdtTrainPlanCourseCost, "Remark", 80);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtTrainPlanCourseCost, "Count", 0);
    }

    protected void kdtTrainPlanCourseCost_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.kdtTrainPlanCourseCost.getColumnIndex("TotalCost")) {
            this.cacuTotalCostEdit();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    private void setTitle() {
        StringBuffer sb = new StringBuffer();
        sb.append(costTitle);
        sb.append(this.costTotal.toString());
        sb.append(costUnit);
        this.contMain.setTitle(sb.toString());
    }

    protected boolean confirmRemoveEnable() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)totalCostMention));
    }

    private void cacuTotalCostEdit() {
        this.totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        int n = this.kdtTrainPlanCourseCost.getRowCount();
        for (int i = 0; i < n; ++i) {
            int col = this.kdtTrainPlanCourseCost.getColumnIndex("TotalCost");
            cost = (BigDecimal)this.kdtTrainPlanCourseCost.getRow(i).getCell(col).getValue();
            if (cost == null) continue;
            this.totalCost = this.totalCost.add(cost);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtils.formatBigDecimal(this.totalCost, 2));
        this.contMain.setTitle(sb.toString());
    }

    private void cacuTotalCost() {
        this.totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        int n = this.kdtTrainPlanCourseCost.getRowCount();
        for (int i = 0; i < n; ++i) {
            int col = this.kdtTrainPlanCourseCost.getColumnIndex("TotalCost");
            cost = (BigDecimal)this.kdtTrainPlanCourseCost.getRow(i).getCell(col).getValue();
            if (cost == null) continue;
            this.totalCost = this.totalCost.add(cost);
        }
        if (!(this.totalCost.compareTo(this.costTotal) != 1 && this.totalCost.compareTo(this.costTotal) != -1 || this.confirmRemoveEnable())) {
            SysUtil.abort();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtils.formatBigDecimal(this.totalCost, 2));
        this.contMain.setTitle(sb.toString());
        this.isFirst = false;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setTitle();
        if (this.isFirst) {
            this.cacuTotalCostEdit();
            this.isFirst = false;
        }
    }

    private void setCostTypeEditor() throws Exception {
        KDComboBox ret = new KDComboBox();
        IChargeItem ici = ChargeItemFactory.getRemoteInstance();
        CoreBaseCollection coll = ici.getCollection(TrainUtils.getCurrentHREntityViewInfo());
        if (coll != null && coll.size() > 0) {
            ret.addItems(coll.toArray());
        }
        this.kdtTrainPlanCourseCost.getColumn("ChargeItem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)ret));
    }

    private void setCostEditor() {
        KDFormattedTextField txtCost = new KDFormattedTextField();
        txtCost.setHorizontalAlignment(2);
        txtCost.setDataType(1);
        txtCost.setPrecision(2);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtCost);
        this.kdtTrainPlanCourseCost.getColumn("TotalCost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCost));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddLine = this.contMain.add((Action)((Object)this.actionAddLine));
        btnAddLine.setIcon(this.newLineIcon);
        btnAddLine.setToolTipText(EASResource.getString((String)RES, (String)"add"));
        JButton btnRemoveLine = this.contMain.add((Action)((Object)this.actionRemoveLine));
        btnRemoveLine.setIcon(this.removeLineIcon);
        btnRemoveLine.setToolTipText(EASResource.getString((String)RES, (String)"remove"));
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        TrainPlanCourseTrainPlanCourseCostInfo info = new TrainPlanCourseTrainPlanCourseCostInfo();
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        this.addLine(this.kdtTrainPlanCourseCost, (IObjectValue)info);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtTrainPlanCourseCost);
    }

    protected IObjectValue createNewData() {
        TrainPlanCourseInfo ret = new TrainPlanCourseInfo();
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainPlanCourseFactory.getRemoteInstance();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    private void addLine(KDTable table, IObjectValue obj) {
        IRow row = table.addRow();
        this.loadLineFields(table, row, obj);
    }

    protected void showSaveSuccess() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setNextMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setNextMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        }
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected void showAddNew() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showEdit() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showView() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_View"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    public TrainPlanCourseInfo getEditDataInfo() {
        return this.editData;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        int chargeItemIndex = this.kdtTrainPlanCourseCost.getColumnIndex("ChargeItem");
        int totalCostIndex = this.kdtTrainPlanCourseCost.getColumnIndex("TotalCost");
        IRow row = null;
        KDTEditManager km = this.kdtTrainPlanCourseCost.getEditManager();
        int n = this.kdtTrainPlanCourseCost.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtTrainPlanCourseCost.getRow(i);
            if (row.getCell(chargeItemIndex).getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullChargeItem"));
                km.editCellAt(row.getRowIndex(), chargeItemIndex);
                SysUtil.abort();
            }
            if (row.getCell(totalCostIndex).getValue() != null) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTotalCost"));
            km.editCellAt(row.getRowIndex(), totalCostIndex);
            SysUtil.abort();
        }
    }

    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Cost"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        this.cacuTotalCost();
        if (this.totalCost != null && this.totalCost.compareTo(new BigDecimal("0.00")) > 0) {
            this.editData.setCost(this.totalCost);
        }
        return super.runSubmit();
    }
}

