/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.workflow.WorkflowUtils;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.ITrainActivity;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainPlanFactory;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityCollection;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanListUI;
import com.kingdee.eas.hr.train.client.TrainActivityFastExeEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainPlanActivityQueryUI;
import com.kingdee.eas.hr.train.client.TrainPlanFormalEditUI;
import com.kingdee.eas.hr.train.client.TrainPlanParticipantScopeListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TrainPlanListUI
extends AbstractTrainPlanListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainPlanListUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String TO = " " + EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"to") + " ";
    private WindowListener listenerForEditWindow = null;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onGetRowSet(IRowSet rowSet) {
        try {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
            String content = null;
            Date planDate = null;
            Date endDate = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                planDate = rowSet.getDate("PlanDate");
                endDate = rowSet.getDate("endDate");
                content = null;
                if (planDate != null && endDate != null) {
                    content = formater.format(planDate) + TO + formater.format(endDate);
                }
                rowSet.updateString("description", content);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    public void onShow() throws Exception {
        super.onShow();
        int[] selectRowsIndex = TrainHelper.getSelectedRows(this.tblMain);
        if (selectRowsIndex.length > 0) {
            if (this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState") != null) {
                if (TrainAuditStateEnum.PASS.toString().equals(this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState").getValue().toString())) {
                    this.btnPublish.setEnabled(true);
                    this.menuItemPublish.setEnabled(true);
                } else {
                    this.btnPublish.setEnabled(false);
                    this.menuItemPublish.setEnabled(false);
                }
            } else {
                this.btnPublish.setEnabled(false);
                this.menuItemPublish.setEnabled(false);
            }
        } else {
            this.btnPublish.setEnabled(false);
            this.menuItemPublish.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        TrainClientUtil.checkValidPerson((CoreUI)this);
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPublish.setEnabled(false);
        this.btnModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemPublish.setEnabled(false);
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionCopy.setEnabled(true);
        this.btnObsolet.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.actionObsolet.setEnabled(true);
        try {
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), "hr_train_001");
            boolean flag = "false".equals(val);
            this.btnAudit.setVisible(flag);
            this.btnAntiAudit.setVisible(flag);
            this.kDSeparator3.setVisible(flag);
            this.menuItemAudit.setVisible(flag);
            this.menuItemAntiAudit.setVisible(flag);
            this.kDSeparator4.setVisible(flag);
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        int[] selectRowsIndex = TrainHelper.getSelectedRows(this.tblMain);
        if (selectRowsIndex.length > 0) {
            if (this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState").getValue() != null) {
                if (TrainAuditStateEnum.PASS.toString().equals(this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState").getValue().toString()) || TrainAuditStateEnum.AUDITED.toString().equals(this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState").getValue().toString())) {
                    this.btnPublish.setEnabled(true);
                    this.menuItemPublish.setEnabled(true);
                } else {
                    this.btnPublish.setEnabled(false);
                    this.menuItemPublish.setEnabled(false);
                }
                if (this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState").getValue().toString().equals(TrainAuditStateEnum.UNSUBMIT.toString())) {
                    this.btnAudit.setEnabled(false);
                    this.btnAntiAudit.setEnabled(false);
                    this.menuItemAudit.setEnabled(false);
                    this.menuItemAntiAudit.setEnabled(false);
                    this.actionRemove.setEnabled(true);
                } else {
                    this.btnAudit.setEnabled(true);
                    this.btnAntiAudit.setEnabled(true);
                    this.menuItemAudit.setEnabled(true);
                    this.menuItemAntiAudit.setEnabled(true);
                    this.actionRemove.setEnabled(false);
                }
            } else {
                this.btnPublish.setEnabled(false);
                this.menuItemPublish.setEnabled(false);
                this.btnAudit.setEnabled(false);
                this.btnAntiAudit.setEnabled(false);
                this.menuItemAudit.setEnabled(false);
                this.menuItemAntiAudit.setEnabled(false);
                this.actionRemove.setEnabled(true);
            }
        } else {
            this.btnPublish.setEnabled(false);
            this.menuItemPublish.setEnabled(false);
            this.btnAudit.setEnabled(false);
            this.btnAntiAudit.setEnabled(false);
            this.menuItemAudit.setEnabled(false);
            this.menuItemAntiAudit.setEnabled(false);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int[] selectRowsIndex = TrainHelper.getSelectedRows(this.tblMain);
        if (selectRowsIndex.length > 0) {
            BizEnumValueDTO auditstate = (BizEnumValueDTO)this.tblMain.getRow(selectRowsIndex[0]).getCell("AuditState").getValue();
            if (auditstate != null) {
                if (20 == auditstate.getInt() || 70 == auditstate.getInt()) {
                    this.actionObsolet.setEnabled(false);
                } else {
                    this.actionObsolet.setEnabled(true);
                }
                if (70 == auditstate.getInt() || 20 == auditstate.getInt() || 50 == auditstate.getInt() || 40 == auditstate.getInt()) {
                    this.actionEdit.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(true);
                }
                if (20 == auditstate.getInt() || 70 == auditstate.getInt()) {
                    this.actionModify.setEnabled(false);
                } else {
                    this.actionModify.setEnabled(true);
                }
            } else {
                this.actionObsolet.setEnabled(true);
                this.actionEdit.setEnabled(true);
            }
        } else {
            this.actionObsolet.setEnabled(true);
            this.actionEdit.setEnabled(true);
        }
    }

    protected String getEditUIName() {
        return TrainPlanFormalEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainPlanFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainPlanInfo objectValue = new TrainPlanInfo();
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return objectValue;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        try {
            filter = TrainUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "OrgUnit.id");
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        return filter;
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublish_actionPerformed(e);
        this.getUIContext().put("ID", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainPlanParticipantScopeListUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        TrainAuditStateEnum state = this.getSelectedAuditState();
        if (TrainAuditStateEnum.AUDITED.equals((Object)state) || TrainAuditStateEnum.PASS.equals((Object)state)) {
            int result;
            if (this.isCurrentRefered()) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"referedLockForAntiAudit"));
                SysUtil.abort();
            }
            if ((result = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"doYouRealyWantToUnAudit"))) == 2) {
                SysUtil.abort();
            }
            String id = this.getSelectedKeyValue();
            TrainPlanFactory.getRemoteInstance().setNotAudited(BOSUuid.read((String)id));
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"unAuditOK"));
            this.execQuery();
        } else if (TrainAuditStateEnum.UNAUDITED.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"unAuditedFobidenUnAudit"));
            SysUtil.abort();
        } else if (TrainAuditStateEnum.UNSUBMIT.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"unSubmitFobidenUnAudit"));
            SysUtil.abort();
        } else if (TrainAuditStateEnum.AUDITING.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"workFlowAntiAudit"));
            SysUtil.abort();
        } else if (TrainAuditStateEnum.UNPASS.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"unPassFobidenUnAudit"));
            SysUtil.abort();
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        TrainAuditStateEnum state = this.getSelectedAuditState();
        if (TrainAuditStateEnum.UNAUDITED.equals((Object)state) || TrainAuditStateEnum.UNSUBMIT.equals((Object)state) || TrainAuditStateEnum.UNPASS.equals((Object)state)) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"doYouRealyWantToAudit"));
            if (result == 2) {
                SysUtil.abort();
            }
            String id = this.getSelectedKeyValue();
            TrainPlanFactory.getRemoteInstance().setAudited(BOSUuid.read((String)id));
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditOK"));
            this.execQuery();
        } else if (TrainAuditStateEnum.AUDITED.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noAgainManualAudit"));
            SysUtil.abort();
        } else if (TrainAuditStateEnum.PASS.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"workFlowAuditNoAgain"));
            SysUtil.abort();
        } else if (TrainAuditStateEnum.AUDITING.equals((Object)state)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"workFlowAudit"));
            SysUtil.abort();
        }
    }

    protected TrainAuditStateEnum getSelectedAuditState() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("AuditState");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return TrainAuditStateEnum.getEnum(((BizEnumValueInfo)keyValue).getInt());
            }
        }
        return null;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        if (this.isSelectedEditable()) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditedFobiden"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        if (this.isSelectedEditable()) {
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditedFobiden"));
            SysUtil.abort();
        }
    }

    private boolean isSelectedEditable() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object value;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return true;
            }
            ICell cell = row.getCell("AuditState");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((value = cell.getValue()) == null) {
                return true;
            }
            BizEnumValueInfo enumValue = (BizEnumValueInfo)value;
            int result = enumValue.getInt();
            return result == 60 || result == 10 || result == 30 || result == 70;
        }
        return true;
    }

    public void actionExeActivity_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        String planID = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("TrainPlanActivity.id"));
        sic.add(new SelectorItemInfo("TrainPlanActivity.name"));
        TrainPlanInfo info = (TrainPlanInfo)TrainPlanFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(planID), sic);
        TrainPlanTrainPlanActivityCollection coll = info.getTrainPlanActivity();
        if (coll == null || coll.size() == 0) {
            MsgBox.showInfo((String)"");
        }
        UIContext uiContext = new UIContext((Object)this);
        if (coll != null) {
            uiContext.put((Object)"ID", (Object)coll.get(0).getId().toString());
        }
        uiContext.put((Object)"hr_train_plan", (Object)coll);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActivityFastExeEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private boolean isCurrentRefered() throws Exception {
        String id = this.getSelectedKeyValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planActivity.trainPlan.id", (Object)id));
        ITrainActivity ita = TrainActivityFactory.getRemoteInstance();
        return ita.exists(filter);
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainPlanActivityQueryUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        WorkflowUtils.viewWorkFlowGraph((CoreUIObject)this, (String)id);
    }

    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        super.actionModify_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"IsModifyTrainActivity", (Object)true);
        BizEnumValueInfo AuditState = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("AuditState").getValue();
        if (this.tblMain.getRow(selectedRow).getCell("AuditState").getValue().toString().equals(TrainAuditStateEnum.AUDITING.toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"cannotModify"));
            return;
        }
        uiContext.put((Object)AuditState, (Object)TrainAuditStateEnum.getEnum(AuditState.getInt()));
        uiContext.put((Object)"isModify", (Object)"modify");
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (this.isRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        String trainPlanId = this.getSelectedKeyValue();
        TrainPlanFactory.getRemoteInstance().copy(trainPlanId);
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"copy_success"));
        this.refreshList();
    }

    public void actionObsolet_actionPerformed(ActionEvent e) throws Exception {
        super.actionObsolet_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int state = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"confirm_obsolet"));
        if (state == 0) {
            String trainPlanId = this.getSelectedKeyValue();
            TrainPlanFactory.getRemoteInstance().obsolet(trainPlanId);
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"obsolet_success"));
            this.refreshList();
        }
    }

    protected final boolean isRefresh(IUIWindow uiWindow) {
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            return !(uiWindow.getUIObject() instanceof EditUI) || ((EditUI)uiWindow.getUIObject()).isSave();
        }
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (this.listenerForEditWindow == null) {
            this.listenerForEditWindow = new WindowAdapter(){

                public void windowClosed(WindowEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            TrainPlanListUI.this.refresh(null);
                        }
                    }
                    catch (Exception e) {
                        TrainPlanListUI.this.handleException(e);
                    }
                }
            };
        }
        window.removeWindowListener(this.listenerForEditWindow);
        window.addWindowListener(this.listenerForEditWindow);
        return false;
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public boolean isPrepareActionAntiAudit() {
        return true;
    }

    public boolean isPrepareActionAudit() {
        return true;
    }

    public boolean isPrepareActionPublish() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }
}

