/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ITrainActivity;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanPersonAddListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainPlanPersonAddListUI
extends AbstractTrainPlanPersonAddListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainPlanPersonAddListUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSignResource";
    private boolean isCanceled = true;
    private Collection selectedCollection;
    private String trainPlanId = null;
    Set personIds = new HashSet();

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void onLoad() throws Exception {
        String str = this.getUIContext().get("TrainActivityID").toString();
        ITrainActivity iTrainActivity = TrainActivityFactory.getRemoteInstance();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("id"));
        selectorColl.add(new SelectorItemInfo("TrainPlan.id"));
        TrainActivityInfo trainActivityInfo = iTrainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(str), selectorColl);
        if (trainActivityInfo != null && trainActivityInfo.getTrainPlan() != null) {
            this.trainPlanId = trainActivityInfo.getTrainPlan().getId().toString();
        }
        this.initTable();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblSelected.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddOne = this.contSelectedStudent.add((Action)((Object)this.actionAddOne));
        JButton btnDelOne = this.contSelectedStudent.add((Action)((Object)this.actionDelOne));
        JButton btnAddAll = this.contSelectedStudent.add((Action)((Object)this.actionAddAll));
        JButton btnDelAll = this.contSelectedStudent.add((Action)((Object)this.actionDelAll));
        btnAddOne.setText(EASResource.getString((String)RES, (String)"addLine"));
        btnDelOne.setText(EASResource.getString((String)RES, (String)"removeLine"));
        btnAddAll.setText(EASResource.getString((String)RES, (String)"addAll"));
        btnDelAll.setText(EASResource.getString((String)RES, (String)"removeAll"));
        btnAddOne.setToolTipText(EASResource.getString((String)RES, (String)"addLine"));
        btnDelOne.setToolTipText(EASResource.getString((String)RES, (String)"removeLine"));
        btnAddAll.setToolTipText(EASResource.getString((String)RES, (String)"addAll"));
        btnDelAll.setToolTipText(EASResource.getString((String)RES, (String)"removeAll"));
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        IRow row = null;
        String str = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            str = row.getCell("id").getValue().toString();
            if (this.existInSelectedPerson(str)) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.tblMain.removeRow(i);
            this.personIds.add(str);
        }
    }

    public void actionAddOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        String str = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblMain.getRow(rowIndex);
            str = row.getCell("id").getValue().toString();
            if (this.existInSelectedPerson(str)) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.tblMain.removeRow(rowIndex);
            this.personIds.add(str);
        }
    }

    private boolean existInSelectedPerson(String personId) {
        return this.personIds.contains(personId);
    }

    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelAll_actionPerformed(e);
        IRow row = null;
        String str = null;
        for (int i = this.tblSelected.getRowCount() - 1; i >= 0; --i) {
            row = this.tblSelected.getRow(i);
            str = row.getCell("id").getValue().toString();
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(i);
            this.personIds.remove(str);
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    public void actionDelOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblSelected);
        IRow row = null;
        String str = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblSelected.getRow(rowIndex);
            if (row == null) continue;
            str = row.getCell("id").getValue().toString();
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(rowIndex);
            this.personIds.remove(str);
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionAddOne_actionPerformed(null);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionDelOne_actionPerformed(null);
        }
    }

    public boolean isCancel() {
        return this.isCanceled;
    }

    public Object getData() {
        Object[] objs = null;
        if (this.selectedCollection != null && this.selectedCollection.size() > 0) {
            objs = this.selectedCollection.toArray();
        }
        return objs;
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        int size = this.tblSelected.getRowCount();
        if (size > 0) {
            this.selectedCollection = new ArrayList();
            IRow row = null;
            for (int i = 0; i < size; ++i) {
                row = this.tblSelected.getRow(i);
                PersonInfo info = new PersonInfo();
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                this.selectedCollection.add(info);
            }
            this.isCanceled = false;
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NotSelected"));
            SysUtil.abort();
        }
        this.getUIWindow().close();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.personIds != null && !this.personIds.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.personIds, CompareType.NOTINCLUDE));
        }
        if (this.trainPlanId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainPlan.id", (Object)this.trainPlanId));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainPlan.id", null, CompareType.IS));
        }
        return filterInfo;
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (e != null) {
            this.mainQuery = new EntityViewInfo();
            FilterInfo filterInfo = this.getDefaultFilterForQuery();
            this.mainQuery.setFilter(filterInfo);
        }
        super.refresh(e);
    }
}

