/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainRecordCourseHourFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TrainRecordCourseHourFilterUI
extends AbstractTrainRecordCourseHourFilterUI {
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainReportResource";

    public TrainRecordCourseHourFilterUI() throws Exception {
        this.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HashSet hroSet = TrainActivityFacadeFactory.getRemoteInstance().getHRRange();
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setHROFilter(hroSet);
        pmt.setModal(true);
        pmt.setReturnPositionAndUnit(false);
        this.prmtPerson.setSelector((KDPromptSelector)pmt);
        this.prmtPerson.setEnabledMultiSelection(true);
        this.prmtPerson.setEditable(false);
        AdminByOrgRangePromptBox adminByOrgRangePromptBox = new AdminByOrgRangePromptBox((IUIObject)this);
        adminByOrgRangePromptBox.setHROFilter(hroSet);
        adminByOrgRangePromptBox.setIsSingleSelect(false);
        this.prmtAdminOrgUnit.setEditable(false);
        this.prmtAdminOrgUnit.setQueryInfo(null);
        this.prmtAdminOrgUnit.setEnabledMultiSelection(true);
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)adminByOrgRangePromptBox);
        TrainActivityHelper.initTrainActivity(this.prmtTrainActivity);
        TrainUtils.addComboBoxEmptyItem(this.comboCategory);
    }

    public FilterInfo getFilterInfo() {
        Object trainType;
        Set adminOrgUnitIds;
        Set personIds;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isTrainActivity", (Object)this.rdTrainActivity.isSelected()));
        TrainActivityInfo trainActivityInfo = (TrainActivityInfo)this.prmtTrainActivity.getValue();
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)trainActivityInfo)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainActivityId", (Object)trainActivityInfo.getId().toString()));
        }
        if ((personIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmtPerson.getValue())) != null && personIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("employeeId", (Object)personIds, CompareType.INCLUDE));
        }
        if ((adminOrgUnitIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmtAdminOrgUnit.getValue())) != null && adminOrgUnitIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnitId", (Object)adminOrgUnitIds, CompareType.INCLUDE));
        }
        if ((trainType = this.comboCategory.getSelectedItem()) != null && trainType instanceof TrainTypeEnum) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)((TrainTypeEnum)((Object)trainType)).getValue()));
        }
        if (this.pkEndDate.getValue() != null) {
            Date startDate = (Date)this.pkEndDate.getValue();
            if (this.rdTrainActivity.isSelected()) {
                startDate = DateTimeUtils.truncateDate((Date)startDate);
            } else {
                Calendar date = Calendar.getInstance();
                date.setTimeInMillis(startDate.getTime());
                date.set(10, 23);
                date.set(12, 59);
                date.set(13, 59);
                startDate = new Date(date.getTimeInMillis());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)startDate, CompareType.LESS_EQUALS));
        }
        if (this.pkStartDate.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkStartDate.getValue())), CompareType.GREATER_EQUALS));
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.rdTrainActivity);
        CustomerQueryUtil.storeToCustomerParams(cp, this.rdTrainCourse);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainActivity);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtPerson);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtAdminOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkEndDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.comboCategory);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.rdTrainActivity);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.rdTrainCourse);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainActivity, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtPerson, PersonInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtAdminOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkEndDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.comboCategory);
    }

    public void clear() {
        super.clear();
        this.rdTrainActivity.setSelected(true);
        this.prmtTrainActivity.setValue(null);
        this.prmtPerson.setValue(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.comboCategory.setSelectedIndex(-1);
        Calendar now = Calendar.getInstance();
        this.pkEndDate.setValue((Object)new Date(now.getTimeInMillis()));
        now.set(5, 1);
        this.pkStartDate.setValue((Object)new Date(now.getTimeInMillis()));
    }

    public boolean verify() {
        return true;
    }
}

