/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainRecordHourDetailUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainRecordHourDetailUI
extends AbstractTrainRecordHourDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainRecordHourDetailUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private Map parameters;
    private boolean isTrainActivity;
    private int hourColumnWidth;

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.btnAudit.setVisible(false);
        this.btnAntiAudit.setVisible(false);
    }

    private void init() {
        this.tblMain.checkParsed();
        this.parameters = (Map)this.getUIContext().get("trainRecordParameters");
        this.isTrainActivity = this.parameters.get("isTrainActivity") != null ? (Boolean)this.parameters.get("isTrainActivity") : true;
        this.setIsTrainActivityRecord(this.isTrainActivity);
        this.setMainQueryPK();
        this.lbEmployeeName.setText((String)this.parameters.get("employeeName"));
        this.setDateRangText();
        if (this.isTrainActivity) {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"trainActRecord"));
        } else {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"trainCourseRecord"));
        }
        this.setIsNeedDefaultFilter(false);
        this.tblMain.getColumn("trainCategory").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("trainingCategory").getStyleAttributes().setHided(true);
        this.hourColumnWidth = this.tblMain.getColumn("actHour").getWidth();
        if (this.hourColumnWidth <= 0) {
            this.hourColumnWidth = this.tblMain.getColumn("courseHour").getWidth();
        }
    }

    private void setDateRangText() {
        Date startDate = (Date)this.parameters.get("startDate");
        Date endDate = (Date)this.parameters.get("endDate");
        String text = null;
        if (startDate != null && endDate != null) {
            String str = EASResource.getString((String)RESOURCE, (String)"dateRang");
            String startDateString = DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
            String endDateString = DateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            text = MessageFormat.format(str, startDateString, endDateString);
        }
        this.lbDateRang.setText(text);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.parameters.get("employeeId") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)((String)this.parameters.get("employeeId"))));
        }
        if (this.parameters.get("trainActivityId") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((String)this.parameters.get("trainActivityId"))));
        }
        if (this.parameters.get("startDate") != null) {
            if (this.isTrainActivity) {
                filterInfo.getFilterItems().add(new FilterItemInfo("actEndDate", (Object)((Date)this.parameters.get("startDate")), CompareType.GREATER_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("EndDateTime", (Object)((Date)this.parameters.get("startDate")), CompareType.GREATER_EQUALS));
            }
        }
        if (this.parameters.get("endDate") != null) {
            if (this.isTrainActivity) {
                filterInfo.getFilterItems().add(new FilterItemInfo("actBeginDate", (Object)((Date)this.parameters.get("endDate")), CompareType.LESS_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("BeginDateTime", (Object)((Date)this.parameters.get("endDate")), CompareType.LESS_EQUALS));
            }
        }
        if (this.parameters.get("trainType") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)((String)this.parameters.get("trainType"))));
        }
        if (!FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString()));
        }
        return filterInfo;
    }

    protected void mergeTable() {
        super.mergeTable();
    }

    protected void setColumnVisiable(boolean isVisiable) {
        super.setColumnVisiable(isVisiable);
        this.tblMain.getColumn("actHour").getStyleAttributes().setHided(isVisiable);
        this.tblMain.getColumn("actHourUnit").getStyleAttributes().setHided(isVisiable);
        this.tblMain.getColumn("courseHour").getStyleAttributes().setHided(!isVisiable);
        this.tblMain.getColumn("courseHourUnit").getStyleAttributes().setHided(!isVisiable);
        if (isVisiable) {
            this.tblMain.getColumn("actHour").setWidth(this.hourColumnWidth);
            this.tblMain.getColumn("actHourUnit").setWidth(this.hourColumnWidth);
        } else {
            this.tblMain.getColumn("courseHour").setWidth(this.hourColumnWidth);
            this.tblMain.getColumn("courseHourUnit").setWidth(this.hourColumnWidth);
        }
    }

    protected void setQueryResultLines() {
        String nexts = null;
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        Object[] objs = new Object[]{this.tblMain.getRowCount()};
        nexts = MessageFormat.format(msg, objs);
        super.setMessageBarText(nexts);
    }
}

