/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryFactory;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.train.EmployeeCourseCollection;
import com.kingdee.eas.hr.train.EmployeeCourseEntryCollection;
import com.kingdee.eas.hr.train.EmployeeCourseEntryInfo;
import com.kingdee.eas.hr.train.EmployeeCourseFactory;
import com.kingdee.eas.hr.train.EmployeeCourseInfo;
import com.kingdee.eas.hr.train.IEmployeeCourse;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainRecordContractCollection;
import com.kingdee.eas.hr.train.TrainRecordContractFactory;
import com.kingdee.eas.hr.train.TrainRecordContractInfo;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainRecordInfoEditUI;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseForReportPromptBox;
import com.kingdee.eas.hr.train.client.TrainItemF7UI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.hr.train.client.TreeBasePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;

public class TrainRecordInfoEditUI
extends AbstractTrainRecordInfoEditUI {
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private String employeeId = null;
    private static final String queryInfo = "TrainRecordInfoQuery";
    private Map isPasseds = new HashMap();
    private EmployeeTreeEditUI treeEditUI;
    static String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private static final String NoAttachment = EASResource.getString((String)RES, (String)"NoAttachment");
    private static final String mustSaveCanAttachment = EASResource.getString((String)RES, (String)"mustSaveCanAttachment");
    private int sort;
    private KDTSortManager sm;
    private boolean isFristSortTable = true;
    private EmployeeContractCollection employeeContractColl = null;
    private Map kdtRecordsFieldRelation = new HashMap();

    public void onLoad() throws Exception {
        this.initKdtRecordsFieldRelation();
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        if (this.getUIContext().get("FromPage") == null) {
            this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        } else {
            this.menuBar.setVisible(false);
            this.btnSubmit.setVisible(false);
        }
        TrainUtils.setMutilTableFromBIM(this.contCourses, this.kdtEntrys);
        TrainUtils.initMutilTableFromBIM(this.contCourses, (Action)((Object)this.actionAddLine), (Action)((Object)this.actionInsertLine), (Action)((Object)this.actionDeleteLine));
        this.initkdtEntrys();
        super.onLoad();
        this.kdtRecords.getSelectManager().setSelectMode(2);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.mergeKdtEntrys();
        }
    }

    public void initLayout() {
        super.initLayout();
        this.kdtRecords.getStyleAttributes().setLocked(true);
    }

    private void mergeKdtRecords() {
        this.kdtRecords.getGroupManager().group();
    }

    private void mergeKdtEntrys() {
        int size = this.kdtEntrys.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.kdtEntrys.getColumn(i).setGroup(true);
        }
        this.kdtEntrys.getGroupManager().group();
    }

    private void setKdtRecordsData() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)this.employeeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("enterPersonInfo", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCoReExt.isApproved", (Object)Boolean.TRUE));
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sortName = new SorterItemInfo("actBeginDate");
        sortName.setSortType(SortType.DESCEND);
        sorters.add(sortName);
        sortName = new SorterItemInfo("actEndDate");
        sortName.setSortType(SortType.DESCEND);
        sorters.add(sortName);
        view.setSorter(sorters);
        view.setFilter(filterInfo);
        IRowSet rowSet = TrainActivityHelper.getRowSet(queryInfo, view);
        this.kdtRecords.checkParsed();
        this.kdtRecords.removeRows();
        IRow row = null;
        String courseId = null;
        String isPassed = null;
        while (rowSet.next()) {
            int i;
            HashSet billEntryIds = new HashSet();
            Set contractIdSet = new HashSet();
            String trianCourseRecordId = rowSet.getString("id");
            String EmployeeId = rowSet.getString("Employee.id");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("trainRecordId", (Object)trianCourseRecordId));
            evi.getSelector().add(new SelectorItemInfo("activityContractBillId"));
            evi.getSelector().add(new SelectorItemInfo("courseContractBillId"));
            evi.setFilter(fi);
            TrainRecordContractCollection col = TrainRecordContractFactory.getRemoteInstance().getTrainRecordContractCollection(evi);
            String activityContractBillId = null;
            String courseContractBillId = null;
            String contractBillId = null;
            int size = col.size();
            for (i = 0; i < size; ++i) {
                TrainRecordContractInfo recordContractInfo = col.get(i);
                activityContractBillId = recordContractInfo.getActivityContractBillId();
                courseContractBillId = recordContractInfo.getCourseContractBillId();
                contractBillId = activityContractBillId != null ? activityContractBillId : courseContractBillId;
                billEntryIds.addAll(this.getBillEntryIds(EmployeeId, contractBillId));
            }
            contractIdSet = this.getContractIds(billEntryIds);
            if (contractIdSet != null && contractIdSet.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", contractIdSet, CompareType.INCLUDE));
                viewInfo.getSelector().add(new SelectorItemInfo("contractNo"));
                viewInfo.setFilter(filter);
                this.employeeContractColl = EmployeeContractFactory.getRemoteInstance().getEmployeeContractCollection(viewInfo);
            }
            if (this.employeeContractColl != null && this.employeeContractColl.size() > 0) {
                size = this.employeeContractColl.size();
                for (i = 0; i < size; ++i) {
                    row = this.kdtRecords.addRow();
                    this.setTableRowValue(rowSet, row, this.employeeContractColl.get(i));
                }
            } else {
                row = this.kdtRecords.addRow();
                this.setTableRowValue(rowSet, row, null);
            }
            courseId = rowSet.getString("TrainCourse.id");
            isPassed = (String)this.isPasseds.get(courseId);
            if (TrainRecordIsPassedEnum.PASSED.toString().equals(isPassed)) continue;
            this.isPasseds.put(courseId, rowSet.getString("ISPASSED"));
        }
    }

    private Set getBillEntryIds(String personId, String billId) throws BOSException {
        HashSet<String> billEntryIds = new HashSet<String>();
        EntityViewInfo entryEvi = new EntityViewInfo();
        FilterInfo entryFi = new FilterInfo();
        entryFi.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId));
        entryFi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        entryEvi.setFilter(entryFi);
        ContractSignBizBillEntryCollection col = ContractSignBizBillEntryFactory.getRemoteInstance().getContractSignBizBillEntryCollection(entryEvi);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            billEntryIds.add(col.get(i).getId().toString());
        }
        return billEntryIds;
    }

    private Set getContractIds(Set billEntryIds) throws BOSException {
        EntityViewInfo contractEvi = new EntityViewInfo();
        FilterInfo contractFi = new FilterInfo();
        contractFi.getFilterItems().add(new FilterItemInfo("entryID", (Object)billEntryIds, CompareType.INCLUDE));
        contractEvi.setFilter(contractFi);
        SorterItemInfo sorter = new SorterItemInfo("recordDate");
        sorter.setSortType(SortType.DESCEND);
        contractEvi.getSorter().add(sorter);
        contractEvi.getSelector().add(new SelectorItemInfo("id"));
        EmployeeContractCollection contractCol = EmployeeContractFactory.getRemoteInstance().getEmployeeContractCollection(contractEvi);
        HashSet<String> contractIds = new HashSet<String>();
        int size = contractCol.size();
        for (int i = 0; i < size; ++i) {
            contractIds.add(contractCol.get(i).getId().toString());
        }
        return contractIds;
    }

    protected void setTableRowValue(IRowSet rowSet, IRow row, EmployeeContractInfo info) throws SQLException {
        if (!rowSet.getBoolean("TrainCoReExt.isApproved")) {
            return;
        }
        row.getCell("trainActivity").setValue((Object)rowSet.getString("TRAINACTIVITY.NAME"));
        row.getCell("actBeginEndDate").setValue((Object)TrainClientUtil.assembleDate(rowSet.getDate("actBeginDate"), rowSet.getDate("actEndDate"), "yyyy-MM-dd", EASResource.getString((String)resourcePath, (String)"to")));
        row.getCell("trainItem").setValue((Object)rowSet.getString("TRAINITEM.NAME"));
        row.getCell("actAssessMethod").setValue((Object)rowSet.getString("ACTASSESSMETHOD.NAME"));
        row.getCell("actAssessScore").setValue((Object)rowSet.getString("ACTASSESSSCORE"));
        row.getCell("actPass").setValue((Object)rowSet.getString("ACTISPASSED"));
        if (info != null && info.getContractNo() != null) {
            row.getCell("actContractNumber").setValue((Object)info.getContractNo());
        }
        row.getCell("actCertificateNumber").setValue((Object)rowSet.getString("ACTCERTIFICATE.NUMBER"));
        row.getCell("actCertificateName").setValue((Object)rowSet.getString("ACTCERTIFICATE.NAME"));
        row.getCell("course").setValue((Object)rowSet.getString("TRAINCOURSE.NAME"));
        row.getCell("assessMethod").setValue((Object)rowSet.getString("ASSESSMETHOD.NAME"));
        row.getCell("assessScore").setValue((Object)rowSet.getString("ASSESSSCORE"));
        row.getCell("assessValue").setValue((Object)rowSet.getString("TrainCoReExt.AssessValue"));
        row.getCell("actAssessValue").setValue((Object)rowSet.getString("TrainCoReExt.actAssessValue"));
        row.getCell("pass").setValue((Object)rowSet.getString("ISPASSED"));
        row.getCell("emp_certifcateNumber").setValue((Object)rowSet.getString("EMPCERTIFICATIO.CERTIFICATENUMBER"));
        row.getCell("emp_certifcateName").setValue((Object)rowSet.getString("EMPCERTIFICATIO.CERTIFICATENAME"));
        row.getCell("beginEndDate").setValue((Object)TrainClientUtil.assembleDate(rowSet.getDate("BeginDateTime"), rowSet.getDate("EndDateTime"), "yyyy-MM-dd", EASResource.getString((String)resourcePath, (String)"to")));
    }

    private void setEmployeeInfo() {
        this.employeeId = this.getUIContext().get("FromPage") == null ? this.treeEditUI.curEmpID : (String)this.getUIContext().get("ID");
    }

    private void initkdtEntrys() throws Exception {
        this.kdtEntrys.checkParsed();
        this.initTrainItemF7();
        this.initTrainCourse();
        TrainUtils.setTableCellEditorByCheckBox(this.kdtEntrys, "isRequired");
        TrainClientUtil.setDisableColor(this.kdtEntrys);
    }

    private void initTrainItemF7() {
        KDBizPromptBox prmtTrainItem = new KDBizPromptBox();
        prmtTrainItem.setVisible(true);
        prmtTrainItem.setDisplayFormat("$name$");
        prmtTrainItem.setEditFormat("$number$");
        prmtTrainItem.setCommitFormat("$number$");
        String uiName = TrainItemF7UI.class.getName();
        TreeBasePromptBox promptBox = new TreeBasePromptBox((IUIObject)this, uiName);
        promptBox.setHRUntiInfo(EmployeeClientUtils.getCurrentHRO((EmployeeTreeEditUI)this.treeEditUI));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1));
        promptBox.setFilterInfo(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("Course.course.*"));
        sic.add(new SelectorItemInfo("Course.course.treeid.name"));
        sic.add(new SelectorItemInfo("Course.course.CourseKind.name"));
        promptBox.setSelector(sic);
        promptBox.setSingleSelect(false);
        prmtTrainItem.setSelector((KDPromptSelector)promptBox);
        prmtTrainItem.setEnabledMultiSelection(true);
        prmtTrainItem.setEditable(false);
        KDTDefaultCellEditor kdtEntrys_TrainItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtTrainItem);
        this.kdtEntrys.getColumn("trainItem").setEditor((ICellEditor)kdtEntrys_TrainItem_CellEditor);
        prmtTrainItem.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    TrainRecordInfoEditUI.this.handleTrainItemResult(e);
                    e.setResult(0);
                }
            }
        });
    }

    private void handleTrainItemResult(PreChangeEvent e) {
        Object[] infos = (Object[])e.getData();
        if (infos != null && infos.length > 0) {
            Object[] objects = this.assembleEmployeeCourse(infos);
            RowDataHandler handler = new RowDataHandler(){

                public boolean setRowData(IRow row, Object object) {
                    boolean result = false;
                    if (row != null && object != null) {
                        EmployeeCourseEntryInfo entry = (EmployeeCourseEntryInfo)object;
                        row.getCell("trainItem").setValue((Object)entry.getTrainItem());
                        TrainRecordInfoEditUI.this.setRowCourseInfo(row, entry.getCourse());
                        row.getCell("course").getStyleAttributes().setLocked(true);
                        result = true;
                    }
                    return result;
                }
            };
            TrainUtils.batchAddRowWithData(this.kdtEntrys, objects, "trainItem", handler);
        }
    }

    private Object[] assembleEmployeeCourse(Object[] infos) {
        ArrayList<EmployeeCourseEntryInfo> result = new ArrayList<EmployeeCourseEntryInfo>();
        for (int i = 0; i < infos.length; ++i) {
            TrainItemInfo info = (TrainItemInfo)infos[i];
            Iterator it = info.getCourse().iterator();
            while (it.hasNext()) {
                TrainItemCourseInfo itemCourse = (TrainItemCourseInfo)it.next();
                EmployeeCourseEntryInfo entry = new EmployeeCourseEntryInfo();
                entry.setTrainItem(info);
                entry.setCourse(itemCourse.getCourse());
                result.add(entry);
            }
        }
        return result.toArray();
    }

    private void initTrainCourse() {
        KDBizPromptBox courseBox = new KDBizPromptBox();
        TrainCourseForReportPromptBox box = new TrainCourseForReportPromptBox((IUIObject)this);
        box.setHRUntiInfo(EmployeeClientUtils.getCurrentHRO((EmployeeTreeEditUI)this.treeEditUI));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CourseHour"));
        selector.add(new SelectorItemInfo("CourseHourUnit"));
        selector.add(new SelectorItemInfo("treeid.id"));
        selector.add(new SelectorItemInfo("treeid.name"));
        selector.add(new SelectorItemInfo("CourseKind.name"));
        selector.add(new SelectorItemInfo("CourseKind.id"));
        selector.add(new SelectorItemInfo("CourseTarget"));
        selector.add(new SelectorItemInfo("Content"));
        selector.add(new SelectorItemInfo("CourseJoinner"));
        selector.add(new SelectorItemInfo("description"));
        box.setSelector(selector);
        box.setSingleSelect(false);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        box.setFilterInfo(filterInfo);
        courseBox.setSelector((KDPromptSelector)box);
        courseBox.setDisplayFormat("$name$");
        courseBox.setEditFormat("$number$");
        courseBox.setCommitFormat("$number$");
        courseBox.setEnabledMultiSelection(true);
        courseBox.setEditable(false);
        this.kdtEntrys.getColumn("course").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)courseBox));
        courseBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    TrainRecordInfoEditUI.this.handleResult(e);
                    e.setResult(0);
                } else {
                    TrainRecordInfoEditUI.this.clearRow();
                }
            }
        });
    }

    private void handleResult(PreChangeEvent e) {
        RowDataHandler handler = new RowDataHandler(){

            public boolean setRowData(IRow row, Object object) {
                boolean result = false;
                if (row != null && object != null) {
                    TrainRecordInfoEditUI.this.setRowCourseInfo(row, (TrainCourseInfo)object);
                    result = true;
                }
                return result;
            }
        };
        TrainUtils.batchAddRowWithData(this.kdtEntrys, (Object[])e.getData(), "course", handler);
    }

    private void setRowCourseInfo(IRow row, TrainCourseInfo courseInfo) {
        row.getCell("course").setValue((Object)courseInfo);
        row.getCell("courseNumber").setValue((Object)courseInfo.getNumber());
        row.getCell("courseHour").setValue((Object)courseInfo.getCourseHour());
        row.getCell("courseHourUnit").setValue((Object)courseInfo.getCourseHourUnit());
        row.getCell("courseTarget").setValue((Object)courseInfo.getCourseTarget());
        row.getCell("courseContent").setValue((Object)courseInfo.getContent());
        row.getCell("courseObject").setValue((Object)courseInfo.getCourseJoinner());
        row.getCell("remark").setValue((Object)courseInfo.getDescription());
        if (courseInfo.getCourseKind() != null) {
            row.getCell("courseKind").setValue((Object)courseInfo.getCourseKind().getName());
        } else {
            row.getCell("courseKind").setValue(null);
        }
        if (courseInfo.getTreeid() != null) {
            row.getCell("courseType").setValue((Object)courseInfo.getTreeid().getName());
        } else {
            row.getCell("courseType").setValue(null);
        }
        if (row.getCell("isRequired").getValue() == null) {
            row.getCell("isRequired").setValue((Object)true);
        }
    }

    private void clearRow() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.kdtEntrys);
        IRow row = this.kdtEntrys.getRow(curIndex);
        row.getCell("courseNumber").setValue(null);
        row.getCell("courseHour").setValue(null);
        row.getCell("courseHourUnit").setValue(null);
        row.getCell("courseKind").setValue(null);
        row.getCell("courseType").setValue(null);
        row.getCell("courseTarget").setValue(null);
        row.getCell("courseContent").setValue(null);
        row.getCell("courseObject").setValue(null);
        row.getCell("remark").setValue(null);
    }

    public void loadFields() {
        this.setEmployeeInfo();
        try {
            this.initKdtRecords();
            this.setDataObject((IObjectValue)this.getEmployeeCourseInfo());
            super.loadFields();
            EmployeeCourseEntryCollection collection = EmployeeCourseFactory.getRemoteInstance().getCoursesFromSysCate(this.employeeId);
            this.addCoursesTotable(collection);
            this.setCourseIsComplate();
            this.setCourseDisabled();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
        } else {
            this.setActionState(true);
        }
        this.storeFields();
        this.editData.copyNewToOld();
    }

    protected void initKdtRecords() throws Exception {
        this.setKdtRecordsData();
        this.mergeKdtRecords();
    }

    private void addCoursesTotable(EmployeeCourseEntryCollection collection) {
        EmployeeCourseEntryCollection entrys = this.editData.getEntrys();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                EmployeeCourseEntryInfo info = collection.get(i);
                if (this.exist(entrys, info)) continue;
                IRow row = this.kdtEntrys.addRow(0);
                this.setCourseRowData(row, info);
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    private boolean exist(EmployeeCourseEntryCollection entrys, EmployeeCourseEntryInfo info) {
        boolean result = false;
        String courseId = info.getCourse().getId().toString();
        String trainItemId = "";
        if (info.getTrainItem() != null && info.getTrainItem().getId() != null) {
            trainItemId = info.getTrainItem().getId().toString();
        }
        for (int j = 0; j < entrys.size(); ++j) {
            EmployeeCourseEntryInfo entry = entrys.get(j);
            String itemId = "";
            if (entry.getTrainItem() != null && entry.getTrainItem().getId() != null) {
                itemId = entry.getTrainItem().getId().toString();
            }
            if (!courseId.equals(entry.getCourse().getId().toString()) || !trainItemId.equals(itemId)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void setCourseRowData(IRow row, EmployeeCourseEntryInfo info) {
        row.getCell("trainItem").setValue((Object)info.getTrainItem());
        row.getCell("isRequired").setValue((Object)info.isIsRequired());
        row.getCell("course").setValue((Object)info.getCourse());
        row.getCell("courseNumber").setValue((Object)info.getCourse().getNumber());
        row.getCell("courseTarget").setValue((Object)info.getCourse().getCourseTarget());
        row.getCell("courseHour").setValue((Object)info.getCourse().getCourseHour());
        row.getCell("courseHourUnit").setValue((Object)info.getCourse().getCourseHourUnit());
        row.getCell("courseContent").setValue((Object)info.getCourse().getContent());
        row.getCell("courseObject").setValue((Object)info.getCourse().getCourseJoinner());
        row.getCell("remark").setValue((Object)info.getCourse().getDescription());
        row.getCell("fromSysCate").setValue((Object)info.isFromSysCate());
        if (info.getCourse().getTreeid() != null) {
            row.getCell("courseType").setValue((Object)info.getCourse().getTreeid().getName());
        }
        if (info.getCourse().getCourseKind() != null) {
            row.getCell("courseKind").setValue((Object)info.getCourse().getCourseKind().getName());
        }
    }

    private EmployeeCourseInfo getEmployeeCourseInfo() throws BOSException, Exception {
        if (this.employeeId == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = this.getMergedSelector();
        for (int i = 0; i < sic.size(); ++i) {
            viewInfo.getSelector().add(sic.get(i));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", (Object)this.employeeId));
        viewInfo.setFilter(filterInfo);
        EmployeeCourseInfo employeeCourseInfo = null;
        EmployeeCourseCollection collection = ((IEmployeeCourse)this.getBizInterface()).getEmployeeCourseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            employeeCourseInfo = (EmployeeCourseInfo)collection.getObject(0);
        } else {
            employeeCourseInfo = new EmployeeCourseInfo();
            PersonInfo employee = new PersonInfo();
            employee.setId(BOSUuid.read((String)this.employeeId));
            employeeCourseInfo.setEmployee(employee);
        }
        return employeeCourseInfo;
    }

    private void setCourseIsComplate() {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            TrainCourseInfo course = (TrainCourseInfo)row.getCell("course").getValue();
            String str = (String)this.isPasseds.get(course.getId().toString());
            Boolean flag = null;
            flag = TrainRecordIsPassedEnum.PASSED.toString().equals(str) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            row.getCell("complate").setValue((Object)flag);
        }
    }

    private void setCourseDisabled() {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            TrainItemInfo trainItem = (TrainItemInfo)row.getCell("trainItem").getValue();
            if (trainItem == null || trainItem.getId() == null) continue;
            row.getCell("course").getStyleAttributes().setLocked(true);
        }
    }

    private void setActionState(boolean flag) {
        this.actionAddLine.setEnabled(flag);
        this.actionInsertLine.setEnabled(flag);
        this.actionDeleteLine.setEnabled(flag);
        this.kdtEntrys.getStyleAttributes().setLocked(!flag);
    }

    protected IObjectValue createNewData() {
        EmployeeCourseInfo model = new EmployeeCourseInfo();
        model.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return model;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeCourseFactory.getRemoteInstance();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return new EmployeeCourseInfo();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtEntrys, "course");
        this.verifyRepeatRow();
        this.removeFromSysCateCourses();
    }

    private void removeFromSysCateCourses() {
        EmployeeCourseEntryCollection collection = (EmployeeCourseEntryCollection)((Object)this.kdtEntrys.getUserObject());
        for (int i = this.kdtEntrys.getRowCount() - 1; i >= 0; --i) {
            IRow row = this.kdtEntrys.getRow(i);
            Boolean fromSysCate = (Boolean)row.getCell("fromSysCate").getValue();
            if (fromSysCate == null || !fromSysCate.booleanValue()) continue;
            IObjectValue detailData = (IObjectValue)row.getUserObject();
            if (detailData != null) {
                collection.removeObject(detailData);
            }
            this.kdtEntrys.removeRow(i);
        }
    }

    private void verifyRepeatRow() {
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            Boolean fromSysCate = (Boolean)row.getCell("fromSysCate").getValue();
            if (fromSysCate != null && fromSysCate.booleanValue()) continue;
            TrainCourseInfo trainCourseInfo = (TrainCourseInfo)row.getCell("course").getValue();
            String trainCourseId = trainCourseInfo.getId().toString();
            TrainItemInfo trainItemInfo = (TrainItemInfo)row.getCell("trainItem").getValue();
            String trainItemId = "";
            if (trainItemInfo != null && trainItemInfo.getId() != null) {
                trainItemId = trainItemInfo.getId().toString();
            }
            for (int j = 0; j < count; ++j) {
                if (j == i) continue;
                IRow row2 = this.kdtEntrys.getRow(j);
                TrainCourseInfo courseInfo = (TrainCourseInfo)row2.getCell("course").getValue();
                TrainItemInfo itemInfo = (TrainItemInfo)row2.getCell("trainItem").getValue();
                String itemId = "";
                if (itemInfo != null && itemInfo.getId() != null) {
                    itemId = itemInfo.getId().toString();
                }
                if (!trainCourseId.equals(courseInfo.getId().toString()) || !trainItemId.equals(itemId)) continue;
                this.kdtEntrys.getEditManager().editCellAt(i, this.kdtEntrys.getColumnIndex("course"));
                MessageFormat format = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainVerifyResource", (String)"CannotRepeated"));
                String msg = format.format(new Object[]{this.contCourses.getTitle()});
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void kdtEntrys_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex;
        IRow row;
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        if (e.getType() != 0 && (row = this.kdtEntrys.getRow(rowIndex = e.getRowIndex())) != null) {
            Boolean fromSysCate = (Boolean)row.getCell("fromSysCate").getValue();
            boolean flag = false;
            if (fromSysCate != null) {
                flag = fromSysCate;
            }
            this.actionDeleteLine.setEnabled(!flag);
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.addLine(this.kdtEntrys);
    }

    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.kdtEntrys);
        int currentIndex = TrainUtils.getCurrentRowIndex(this.kdtEntrys);
        IRow currentRow = this.kdtEntrys.getRow(currentIndex);
        TrainItemInfo trainItemInfo = (TrainItemInfo)currentRow.getCell("trainItem").getValue();
        if (trainItemInfo != null && trainItemInfo.getId() != null) {
            String trainItemId = trainItemInfo.getId().toString();
            EmployeeCourseEntryCollection collection = (EmployeeCourseEntryCollection)((Object)this.kdtEntrys.getUserObject());
            for (int i = this.kdtEntrys.getRowCount() - 1; i >= 0; --i) {
                TrainItemInfo info;
                IRow row = this.kdtEntrys.getRow(i);
                Boolean fromSysCate = (Boolean)row.getCell("fromSysCate").getValue();
                if (fromSysCate != null && fromSysCate.booleanValue() || (info = (TrainItemInfo)row.getCell("trainItem").getValue()) == null || info.getId() == null || !info.getId().toString().equals(trainItemId)) continue;
                IObjectValue detailData = (IObjectValue)row.getUserObject();
                if (detailData != null) {
                    collection.removeObject(detailData);
                }
                this.kdtEntrys.removeRow(i);
            }
        } else {
            TrainUtils.removeLine(this.kdtEntrys);
        }
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.insertLine(this.kdtEntrys);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            if (OprtState.VIEW.equals(this.getOprtState())) {
                MsgBox.showWarning((String)NoAttachment);
                SysUtil.abort();
            } else {
                MsgBox.showWarning((String)mustSaveCanAttachment);
                SysUtil.abort();
            }
        }
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, false);
        } else {
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, true);
        }
    }

    private String getHrOrgUintId() {
        return this.getUIContext().get("hrOrgUnitId") == null ? null : this.getUIContext().get("hrOrgUnitId").toString();
    }

    private void checkFieldPermission() throws Exception {
        IColumn column;
        String fieldName;
        int i;
        BOSObjectType empCourse = EmployeeCourseFactory.getRemoteInstance().getType();
        BOSObjectType bizObjectType = TrainCourseFactory.getRemoteInstance().getType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        String columnName = null;
        fields = PermissionHelper.getFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK);
        FieldPermission fields2 = PermissionHelper.getFieldPermission((BOSObjectType)empCourse, (IObjectPK)userPK, (IObjectPK)orgPK);
        fields.addAllFieldAccess(fields2.getAllFieldAccesses());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("treeid", "courseType");
        map.put("name", "course");
        map.put("number", "courseNumber");
        map.put("CourseKind", "courseKind");
        map.put("CourseTarget", "courseTarget");
        map.put("CourseHour", "courseHour");
        map.put("CourseHourUnit", "courseHourUnit");
        map.put("Content", "courseContent");
        map.put("CourseJoinner", "courseObject");
        map.put("entrys.trainItem", "trainItem");
        map.put("entrys.isRequired", "isRequired");
        map.put("entrys.course", "course");
        for (i = 0; i < fields.size(); ++i) {
            fieldAccess = fields.get(i);
            fieldName = fieldAccess.getFieldName();
            columnName = fieldName.lastIndexOf(46) > 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1, fieldName.length()) : fieldName;
            if (!map.containsKey(columnName) || !fields.isEnableFieldPermission(fieldName)) continue;
            column = this.kdtEntrys.getColumn(map.get(columnName).toString());
            if (fieldAccess.isViewable() && column != null && !column.getStyleAttributes().isHided()) {
                column.getStyleAttributes().setLocked(true);
                column.getStyleAttributes().setHided(false);
            }
            if (fieldAccess.isEditable() && column != null && !column.getStyleAttributes().isHided()) {
                column.getStyleAttributes().setLocked(false);
                column.getStyleAttributes().setHided(false);
            }
            if (fieldAccess.isViewable() || fieldAccess.isEditable() || column == null || column.getStyleAttributes().isHided()) continue;
            column.getStyleAttributes().setHided(true);
        }
        for (i = 0; i < fields2.size(); ++i) {
            fieldAccess = fields.get(i);
            fieldName = fieldAccess.getFieldName();
            if (!"entrys.course".equals(fieldName)) continue;
            column = this.kdtEntrys.getColumn("course");
            if (fieldAccess.isViewable() && column != null) {
                column.getStyleAttributes().setLocked(true);
                column.getStyleAttributes().setHided(false);
            }
            if (fieldAccess.isEditable() && column != null) {
                column.getStyleAttributes().setLocked(false);
                column.getStyleAttributes().setHided(false);
            }
            if (fieldAccess.isViewable() || fieldAccess.isEditable()) continue;
            String[] str = new String[]{"courseType", "course", "courseNumber", "courseKind", "courseTarget", "courseHour", "courseHourUnit", "courseContent", "courseObject"};
            for (int k = 0; k < str.length; ++k) {
                IColumn column2 = this.kdtEntrys.getColumn(str[k]);
                if (column2 == null) continue;
                column.getStyleAttributes().setHided(true);
            }
        }
    }

    private void checkRecordPermission() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TrainActivity", "trainActivity");
        map.put("TrainCourse", "course");
        map.put("trainItem", "trainItem");
        map.put("actAssessMethod", "actAssessMethod");
        map.put("actAssessScore", "actAssessScore");
        map.put("actIsPassed", "actPass");
        map.put("actContract", "actContractName");
        map.put("actCertificate", "actCertificateName");
        map.put("actBeginDate", "actBeginEndDate");
        map.put("AssessScore", "assessScore");
        map.put("isPassed", "pass");
        map.put("AssessMethod", "assessMethod");
        BOSObjectType record = TrainCourseRecordFactory.getRemoteInstance().getType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        fields = PermissionHelper.getFieldPermission((BOSObjectType)record, (IObjectPK)userPK, (IObjectPK)orgPK);
        for (int i = 0; i < fields.size(); ++i) {
            String columnName;
            fieldAccess = fields.get(i);
            String fieldName = fieldAccess.getFieldName();
            if (!fields.isEnableFieldPermission(fieldName) || !map.containsKey(fieldName) || (columnName = map.get(fieldName).toString()) == null || columnName.trim().length() == 0) continue;
            IColumn column = this.kdtRecords.getColumn(columnName);
            if (fieldAccess.isViewable() && column != null && !column.getStyleAttributes().isHided()) {
                column.getStyleAttributes().setLocked(true);
                column.getStyleAttributes().setHided(false);
            }
            if (fieldAccess.isEditable() && column != null && !column.getStyleAttributes().isHided()) {
                column.getStyleAttributes().setLocked(false);
                column.getStyleAttributes().setHided(false);
            }
            if (fieldAccess.isViewable() || fieldAccess.isEditable() || column == null || column.getStyleAttributes().isHided()) continue;
            column.getStyleAttributes().setHided(true);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setCU(EmployeeClientUtils.getCurrentCU((EmployeeTreeEditUI)this.treeEditUI));
        return super.runSubmit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(EmployeeClientUtils.getCurrentHRO((EmployeeTreeEditUI)this.treeEditUI).getId());
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("queryName", (Object)queryInfo);
        if (this.getUIContext().get("FromPage") == null) {
            this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
            request.put("employeeId", (Object)this.treeEditUI.curEmpID);
        } else {
            request.put("employeeId", this.getUIContext().get("ID"));
        }
        request.put("NO_PERMISSION", this.getPermission());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    private Object getPermission() {
        if (this.getUIContext() == null || this.getUIContext().get("NO_PERMISSION") == null) {
            return null;
        }
        return this.getUIContext().get("NO_PERMISSION");
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    protected void kdtRecords_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtRecords_tableClicked(e);
        this.kdtRecords.checkParsed();
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            SorterItemInfo sortName;
            String columnName;
            if (this.isFristSortTable) {
                this.sm = new KDTSortManager(this.kdtRecords);
                this.isFristSortTable = false;
            }
            if ((columnName = this.kdtRecords.getColumn(e.getColIndex()).getKey()) == null) {
                return;
            }
            if (this.kdtRecordsFieldRelation.get(columnName) == null) {
                return;
            }
            String fieldName = (String)this.kdtRecordsFieldRelation.get(columnName);
            if (fieldName == null) {
                return;
            }
            this.sort = this.sort == 0 ? 1 : 0;
            this.sm.sort(e.getColIndex(), this.sort);
            FilterInfo filterInfo = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection sorters = new SorterItemCollection();
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)this.employeeId));
            filterInfo.getFilterItems().add(new FilterItemInfo("enterPersonInfo", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCoReExt.isApproved", (Object)Boolean.TRUE));
            view.setFilter(filterInfo);
            if (this.sort == 0) {
                sortName = new SorterItemInfo(fieldName);
                sortName.setSortType(SortType.ASCEND);
                sorters.add(sortName);
            } else {
                sortName = new SorterItemInfo(fieldName);
                sortName.setSortType(SortType.DESCEND);
                sorters.add(sortName);
            }
            view.setSorter(sorters);
            IRowSet rowSet = TrainActivityHelper.getRowSet(queryInfo, view);
            this.kdtRecords.removeRows();
            IRow row = null;
            while (rowSet.next()) {
                int i;
                HashSet billEntryIds = new HashSet();
                Set contractIdSet = new HashSet();
                String trianCourseRecordId = rowSet.getString("id");
                String EmployeeId = rowSet.getString("Employee.id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("trainRecordId", (Object)trianCourseRecordId));
                evi.getSelector().add(new SelectorItemInfo("activityContractBillId"));
                evi.getSelector().add(new SelectorItemInfo("courseContractBillId"));
                evi.setFilter(fi);
                TrainRecordContractCollection col = TrainRecordContractFactory.getRemoteInstance().getTrainRecordContractCollection(evi);
                String activityContractBillId = null;
                String courseContractBillId = null;
                String contractBillId = null;
                int size = col.size();
                for (i = 0; i < size; ++i) {
                    TrainRecordContractInfo recordContractInfo = col.get(i);
                    activityContractBillId = recordContractInfo.getActivityContractBillId();
                    courseContractBillId = recordContractInfo.getCourseContractBillId();
                    contractBillId = activityContractBillId != null ? activityContractBillId : courseContractBillId;
                    billEntryIds.addAll(this.getBillEntryIds(EmployeeId, contractBillId));
                }
                contractIdSet = this.getContractIds(billEntryIds);
                if (contractIdSet != null && contractIdSet.size() > 0) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", contractIdSet, CompareType.INCLUDE));
                    viewInfo.getSelector().add(new SelectorItemInfo("contractNo"));
                    viewInfo.setFilter(filter);
                    this.employeeContractColl = EmployeeContractFactory.getRemoteInstance().getEmployeeContractCollection(viewInfo);
                }
                if (this.employeeContractColl != null && this.employeeContractColl.size() > 0) {
                    size = this.employeeContractColl.size();
                    for (i = 0; i < size; ++i) {
                        row = this.kdtRecords.addRow();
                        this.setTableRowValue(rowSet, row, this.employeeContractColl.get(i));
                    }
                    continue;
                }
                row = this.kdtRecords.addRow();
                this.setTableRowValue(rowSet, row, null);
            }
            this.mergeKdtRecords();
        }
    }

    private void initKdtRecordsFieldRelation() {
        this.kdtRecordsFieldRelation.put("trainActivity", "TRAINACTIVITY.NAME");
        this.kdtRecordsFieldRelation.put("trainItem", "TRAINITEM.NAME");
        this.kdtRecordsFieldRelation.put("actAssessMethod", "ACTASSESSMETHOD.NAME");
        this.kdtRecordsFieldRelation.put("actAssessScore", "ACTASSESSSCORE");
        this.kdtRecordsFieldRelation.put("actAssessValue", "TrainCoReExt.actAssessValue");
        this.kdtRecordsFieldRelation.put("actPass", "ACTISPASSED");
        this.kdtRecordsFieldRelation.put("actContractNumber", "ACTCONTRACT.CONTRACTNO");
        this.kdtRecordsFieldRelation.put("actContractName", "ACTCONTRACTTEMP.NAME");
        this.kdtRecordsFieldRelation.put("actCertificateNumber", "ACTCERTIFICATE.NUMBER");
        this.kdtRecordsFieldRelation.put("actCertificateName", "ACTCERTIFICATE.NAME");
        this.kdtRecordsFieldRelation.put("actBeginEndDate", "actBeginDate");
        this.kdtRecordsFieldRelation.put("course", "TRAINCOURSE.NAME");
        this.kdtRecordsFieldRelation.put("beginEndDate", "BeginDateTime");
        this.kdtRecordsFieldRelation.put("assessMethod", "ASSESSMETHOD.NAME");
        this.kdtRecordsFieldRelation.put("assessScore", "ASSESSSCORE");
        this.kdtRecordsFieldRelation.put("assessValue", "TrainCoReExt.AssessValue");
        this.kdtRecordsFieldRelation.put("pass", "ISPASSED");
        this.kdtRecordsFieldRelation.put("emp_certifcateNumber", "EMPCERTIFICATIO.CERTIFICATENUMBER");
        this.kdtRecordsFieldRelation.put("emp_certifcateName", "EMPCERTIFICATIO.CERTIFICATENAME");
    }
}

