/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainSignerPersonF7UI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainSignerPersonF7UI
extends AbstractTrainSignerPersonF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSignerPersonF7UI.class);
    private PersonCollection personCollection = new PersonCollection();
    protected boolean isCanceled = true;
    String trainActivityID;
    String trainCourseID;
    boolean showAllCoursePerson = false;
    String ID = "id";
    String NAME = "name";
    String NUMBER = "number";
    String GENDER = "gender";
    String POSITION = "positionName";
    String ORGUNIT = "orgUnit";
    String DEGREE = "degree.name";
    private final String JOB_NAME = "job";
    private final String POST_NAME = "technicalPost";
    private final String OFFICE_PHONE = "officePhone";
    private final String MOBILE_PHONE = "cell";
    private final String EMAIL = "email";
    HashMap personMap;
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSignResource";

    public void onLoad() throws Exception {
        this.fetchUIContext();
        this.initTable();
        super.onLoad();
    }

    private void bindValueToTable(HashMap map, KDTable table) {
        if (map == null || table == null) {
            return;
        }
        IRow row = table.addRow();
        row.getCell(this.ID).setValue(map.get(this.ID));
        row.getCell(this.NAME).setValue(map.get(this.NAME));
        row.getCell(this.NUMBER).setValue(map.get(this.NUMBER));
        row.getCell(this.GENDER).setValue(map.get(this.GENDER));
        row.getCell(this.POSITION).setValue(map.get(this.POSITION));
        row.getCell(this.DEGREE).setValue(map.get(this.DEGREE));
        row.getCell(this.ORGUNIT).setValue(map.get(this.ORGUNIT));
        row.getCell(this.JOB_NAME).setValue(map.get("job"));
        row.getCell(this.POST_NAME).setValue(map.get("technicalPost"));
        row.getCell(this.OFFICE_PHONE).setValue(map.get("officePhone"));
        row.getCell(this.MOBILE_PHONE).setValue(map.get("cell"));
        row.getCell(this.EMAIL).setValue(map.get("email"));
    }

    private void fetchUIContext() {
        this.trainActivityID = (String)this.getUIContext().get("trainActivity");
        if (TrainClientUtil.objectIsNull(this.trainActivityID)) {
            TrainClientUtil.showErrorMessage(RES, "trainActivityNotNull", (CoreUI)this);
        }
        this.trainCourseID = (String)this.getUIContext().get("course");
        if (TrainClientUtil.objectIsNull(this.trainCourseID)) {
            this.showAllCoursePerson = true;
        }
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblSelected.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddOne = this.contSelectedStudent.add((Action)((Object)this.actionAddOne));
        JButton btnDelOne = this.contSelectedStudent.add((Action)((Object)this.actionDelOne));
        JButton btnAddAll = this.contSelectedStudent.add((Action)((Object)this.actionAddAll));
        JButton btnDelAll = this.contSelectedStudent.add((Action)((Object)this.actionDelAll));
        btnAddOne.setText(EASResource.getString((String)RES, (String)"addLine"));
        btnDelOne.setText(EASResource.getString((String)RES, (String)"removeLine"));
        btnAddAll.setText(EASResource.getString((String)RES, (String)"addAll"));
        btnDelAll.setText(EASResource.getString((String)RES, (String)"removeAll"));
        btnAddOne.setToolTipText(EASResource.getString((String)RES, (String)"addLine"));
        btnDelOne.setToolTipText(EASResource.getString((String)RES, (String)"removeLine"));
        btnAddAll.setToolTipText(EASResource.getString((String)RES, (String)"addAll"));
        btnDelAll.setToolTipText(EASResource.getString((String)RES, (String)"removeAll"));
    }

    public PersonCollection getPersonCollection() {
        return this.personCollection;
    }

    public void setPersonCollection(PersonCollection personCollection) {
        this.personCollection = personCollection;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionAddOne_actionPerformed(null);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionDelOne_actionPerformed(null);
        } else {
            super.tblSelected_tableClicked(e);
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        int size = this.tblSelected.getRowCount();
        if (size > 0) {
            IRow row = null;
            for (int i = 0; i < size; ++i) {
                row = this.tblSelected.getRow(i);
                PersonInfo info = new PersonInfo();
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                this.personCollection.add(info);
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    private void addSelectedRow(String personID) {
        if (!this.isExist(personID)) {
            this.addPerson(personID);
            this.bindValueToTable((HashMap)this.personMap.get(personID), this.tblSelected);
        }
    }

    private void removePerson(String personID) {
        if (TrainClientUtil.objectIsNull(personID)) {
            return;
        }
        personID = personID.trim();
        int n = this.personCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!this.personCollection.get(i).getId().toString().equals(personID)) continue;
            this.personCollection.removeObject(i);
            break;
        }
    }

    private void addPerson(String personID) {
        PersonInfo info = new PersonInfo();
        info.setId(BOSUuid.read((String)personID));
        this.personCollection.add(info);
    }

    private boolean isExist(String personID) {
        if (TrainClientUtil.objectIsNull(personID)) {
            return true;
        }
        personID = personID.trim();
        int n = this.personCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!this.personCollection.get(i).getId().toString().equals(personID)) continue;
            return true;
        }
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)this.trainActivityID));
        if (!TrainClientUtil.objectIsNull(this.trainCourseID)) {
            filter.getFilterItems().add(new FilterItemInfo("trainCourse.id", (Object)this.trainCourseID));
        } else {
            try {
                Set personIds = TrainActivityFacadeFactory.getRemoteInstance().getSignupAllPerson(this.trainActivityID);
                if (personIds != null && personIds.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)personIds, CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("id", null));
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return filter;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            if (this.existInSelectedPerson(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.tblMain.removeRow(i);
        }
    }

    private boolean existInSelectedPerson(String personId) {
        IRow row = null;
        int count = this.tblSelected.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblSelected.getRow(i);
            if (!personId.equals(row.getCell("id").getValue().toString())) continue;
            return true;
        }
        return false;
    }

    public void actionAddOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblMain.getRow(rowIndex);
            if (this.existInSelectedPerson(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.tblMain.removeRow(rowIndex);
        }
    }

    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelAll_actionPerformed(e);
        IRow row = null;
        for (int i = this.tblSelected.getRowCount() - 1; i >= 0; --i) {
            row = this.tblSelected.getRow(i);
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(i);
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    public void actionDelOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblSelected);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblSelected.getRow(rowIndex);
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(rowIndex);
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }
}

