/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSummaryListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseSummaryUI;
import com.kingdee.eas.hr.train.client.TrainSummaryEditUI;
import com.kingdee.eas.hr.train.client.TrainSummaryPublishScopeListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainSummaryListUI
extends AbstractTrainSummaryListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSummaryListUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainSummaryResource";
    static String AUDITSTATE = "auditState";
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanUpdate();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanDelete();
        super.actionRemove_actionPerformed(e);
    }

    protected String getEditUIName() {
        return TrainSummaryEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSummaryFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainSummaryInfo objectValue = new TrainSummaryInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanAudit();
        super.actionAudit_actionPerformed(e);
        TrainSummaryFactory.getRemoteInstance().audit((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        TrainClientUtil.showMessage(RES, "auditSuccess", (CoreUI)this);
        if (this.isPrepareActionAudit()) {
            this.prepareRefresh(null).callHandler();
        }
        this.refresh(e);
    }

    public void actionCourseSummary_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)TrainClientUtil.getResource(RES, "noSelectedNoCourseSummary"));
            SysUtil.abort();
        }
        String trainActCourseID = TrainClientUtil.getSelectedRow(this.tblMain).getCell("TrainActivity.id").getValue().toString();
        TrainActivityInfo info = new TrainActivityInfo();
        info.setId(BOSUuid.read((String)trainActCourseID));
        String trainSummaryID = this.getSelectedKeyValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActCourseID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("TrainSummary.id", (Object)trainSummaryID, CompareType.EQUALS));
        if (!TrainCourseSummaryFactory.getRemoteInstance().exists(filter)) {
            TrainClientUtil.showMessageAndAbort(RES, "noResponseTrainCourseSummary", (CoreUI)this);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"trainActivity", (Object)info);
        uiContext.put((Object)"trainSummary", (Object)trainSummaryID);
        uiContext.put((Object)"onlyView", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainCourseSummaryUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanUnaudit();
        super.actionUnaudit_actionPerformed(e);
        TrainSummaryFactory.getRemoteInstance().unAudit((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        TrainClientUtil.showMessage(RES, "unAuditSuccess", (CoreUI)this);
        this.refresh(e);
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex > -1) {
            String trainSummaryId = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"TRAINSUMMARYID", (Object)trainSummaryId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainSummaryPublishScopeListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows == null || rows.length != 1) {
            this.btnPublish.setEnabled(false);
            this.menuItemPublish.setEnabled(false);
        } else {
            IRow row = TrainClientUtil.getSelectedRow(this.tblMain);
            String state = row.getCell(AUDITSTATE).getValue().toString();
            if (TrainAuditStateEnum.AUDITED.toString().equals(state)) {
                this.btnPublish.setEnabled(true);
                this.menuItemPublish.setEnabled(true);
                this.btnAudit.setEnabled(false);
                this.menuAudit.setEnabled(false);
                this.btnUnaudit.setEnabled(true);
                this.menuUnaudit.setEnabled(true);
            } else {
                this.btnPublish.setEnabled(false);
                this.menuItemPublish.setEnabled(false);
                this.btnAudit.setEnabled(true);
                this.menuAudit.setEnabled(true);
                this.btnUnaudit.setEnabled(false);
                this.menuUnaudit.setEnabled(false);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnCourseSummary.setIcon(EASResource.getIcon((String)"imgTbtn_coursesummarize"));
        this.btnUnaudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuCourseSummary.setIcon(EASResource.getIcon((String)"imgTbtn_coursesummarize"));
        this.menuUnaudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
    }

    private void checkCanUpdate() {
        if (!this.canUpdateOrDelete()) {
            TrainClientUtil.showMessageAndAbort(RES, "canNotUpdate", (CoreUI)this);
        }
    }

    private void checkCanDelete() {
        if (!this.canUpdateOrDelete()) {
            TrainClientUtil.showMessageAndAbort(RES, "canNotDelete", (CoreUI)this);
        }
    }

    private void checkCanAudit() {
        if (!this.canAuditOrUnaudit(TrainAuditStateEnum.UNAUDITED)) {
            TrainClientUtil.showMessageAndAbort(RES, "canNotAudit", (CoreUI)this);
        }
    }

    private void checkCanUnaudit() {
        if (!this.canAuditOrUnaudit(TrainAuditStateEnum.AUDITED)) {
            TrainClientUtil.showMessageAndAbort(RES, "canNotUnaudit", (CoreUI)this);
        }
    }

    private boolean canAuditOrUnaudit(TrainAuditStateEnum auditState) {
        this.checkSelected();
        IRow row = TrainClientUtil.getSelectedRow(this.tblMain);
        String state = row.getCell(AUDITSTATE).getValue().toString();
        if (state == null) {
            return false;
        }
        return auditState.toString().equals(state);
    }

    private boolean canUpdateOrDelete() {
        this.checkSelected();
        IRow row = TrainClientUtil.getSelectedRow(this.tblMain);
        String state = row.getCell(AUDITSTATE).getValue().toString();
        if (state == null) {
            return false;
        }
        return TrainAuditStateEnum.UNAUDITED.toString().equals(state);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        try {
            filter = TrainUtils.getHRAndAdminRangeFilterInfo("HrOrgUnit.id", "belongOrgUnit.id");
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        return filter;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public RequestContext prepareActionCourseSummary(IItemAction itemAction) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)TrainClientUtil.getResource(RES, "noSelectedNoCourseSummary"));
            SysUtil.abort();
        }
        RequestContext request = super.prepareActionCourseSummary(itemAction);
        String trainSummaryID = this.getSelectedKeyValue();
        String trainActCourseID = TrainClientUtil.getSelectedRow(this.tblMain).getCell("TrainActivity.id").getValue().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActCourseID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("TrainSummary.id", (Object)trainSummaryID, CompareType.EQUALS));
        request.put("filterInfo", (Object)filter);
        return request;
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public RequestContext prepareActionAudit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAudit(itemAction);
        request.setId(this.getSelectedKeyValue());
        return request;
    }

    public boolean isPrepareActionAudit() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionCourseSummary() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

