/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainItemCourseCollection;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSysFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainCourseForReportPromptBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TrainSysFilterUI
extends AbstractTrainSysFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSysFilterUI.class);
    private TrainCourseForReportPromptBox pmt;
    private HashSet courseIdSet = new HashSet();
    private HashSet itemIdSet = new HashSet();

    public void onLoad() throws Exception {
        this.isLikeQueryTrainItem.setActionCommand("Item");
        this.isLikeQueryTrainCourse.setActionCommand("Course");
        this.prmtTrainCourse.setName("prmtTrainCourse");
        this.prmtTrainItem.setName("prmtTrainItem");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("Course");
        sic.add("Course.course.id");
        this.prmtTrainItem.setSelectorCollection(sic);
        this.pmt = new TrainCourseForReportPromptBox((IUIObject)this);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        this.pmt.setFilterInfo(fi);
        this.prmtTrainCourse.setSelector((KDPromptSelector)this.pmt);
        this.isLikeQueryTrainItem.addItemListener((ItemListener)new ItemListenerImpl());
        this.isLikeQueryTrainCourse.addItemListener((ItemListener)new ItemListenerImpl());
        this.prmtTrainCourse.addDataChangeListener((DataChangeListener)new DataChangeListenerImpl());
        this.prmtTrainItem.addDataChangeListener((DataChangeListener)new DataChangeListenerImpl());
        this.prmtTrainCourse.setEditable(false);
        this.prmtTrainItem.setEditable(false);
        super.onLoad();
    }

    public FilterInfo getFilterInfo() {
        Object obj;
        FilterInfo fi = new FilterInfo();
        FilterItemCollection filterItems = fi.getFilterItems();
        if (this.isLikeQueryTrainItem.isSelected()) {
            obj = this.txtTrainItemName.getText();
            if (obj != null && obj.toString().trim().length() > 0) {
                filterItems.add(new FilterItemInfo("trainItem.name", (Object)("%" + obj.toString() + "%"), CompareType.LIKE));
            }
        } else {
            obj = this.prmtTrainItem.getValue();
            if (obj != null) {
                TrainItemInfo trainItemInfo = (TrainItemInfo)obj;
                filterItems.add(new FilterItemInfo("trainItem.id", (Object)trainItemInfo.getId().toString()));
            }
        }
        if (this.isLikeQueryTrainCourse.isSelected()) {
            obj = this.txtTrainCourseName.getText();
            if (obj != null && obj.toString().trim().length() > 0) {
                filterItems.add(new FilterItemInfo("TrainCourse.name", (Object)("%" + obj.toString() + "%"), CompareType.LIKE));
            }
        } else {
            obj = this.prmtTrainCourse.getValue();
            if (obj != null) {
                TrainCourseInfo trainCourseInfo = (TrainCourseInfo)obj;
                filterItems.add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseInfo.getId().toString()));
            }
        }
        return fi;
    }

    public CustomerParams getCustomerParams() {
        Object obj;
        CustomerParams params = new CustomerParams();
        params.putBoolean("isLikeQueryTrainItem", this.isLikeQueryTrainItem.isSelected());
        if (this.isLikeQueryTrainItem.isSelected()) {
            obj = this.txtTrainItemName.getText();
            if (obj != null && obj.toString().trim().length() > 0) {
                params.addCustomerParam("trainItemName", obj.toString());
            }
        } else {
            obj = this.prmtTrainItem.getValue();
            if (obj != null) {
                CustomerQueryUtil.storeToCustomerParams(params, this.prmtTrainItem);
            }
        }
        params.putBoolean("isLikeQueryTrainCourse", this.isLikeQueryTrainCourse.isSelected());
        if (this.isLikeQueryTrainCourse.isSelected()) {
            obj = this.txtTrainCourseName.getText();
            if (obj != null && obj.toString().trim().length() > 0) {
                params.addCustomerParam("trainCourseName", obj.toString());
            }
        } else {
            CustomerQueryUtil.storeToCustomerParams(params, this.prmtTrainCourse);
        }
        return params;
    }

    public void setCustomerParams(CustomerParams cp) {
        boolean isLikeQueryItem = cp.getBoolean("isLikeQueryTrainItem");
        boolean isLikeQueryCourse = cp.getBoolean("isLIkeQueryTrainCourse");
        this.isLikeQueryTrainItem.setSelected(isLikeQueryItem);
        if (isLikeQueryItem) {
            String itemName = cp.getCustomerParam("trainItemName");
            this.txtTrainItemName.setText(itemName);
        } else {
            CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainItem, "com.kingdee.eas.hr.train.TrainItemInfo");
        }
        this.isLikeQueryTrainCourse.setSelected(isLikeQueryCourse);
        if (isLikeQueryCourse) {
            String courseName = cp.getCustomerParam("trainCourseName");
            this.txtTrainCourseName.setText(courseName);
        } else {
            CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainCourse, "com.kingdee.eas.hr.train.TrainCourseInfo");
        }
    }

    public void clear() {
        this.prmtTrainItem.setValue(null);
        this.prmtTrainCourse.setValue(null);
        this.txtTrainItemName.setText("");
        this.txtTrainCourseName.setText("");
        this.isLikeQueryTrainItem.setSelected(false);
        this.isLikeQueryTrainCourse.setSelected(false);
    }

    private void setItemAndCourseFilter() {
        if (this.prmtTrainCourse.getValue() != null) {
            TrainCourseInfo courseInfo = (TrainCourseInfo)this.prmtTrainCourse.getValue();
            EntityViewInfo itemView = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("course.id", (Object)courseInfo.getId().toString()));
            itemView.setFilter(fi);
            this.prmtTrainItem.setEntityViewInfo(itemView);
        }
        if (this.courseIdSet != null && this.itemIdSet.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.courseIdSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)new Integer(1)));
            this.pmt.setFilterInfo(fi);
        }
    }

    private class DataChangeListenerImpl
    implements DataChangeListener {
        private DataChangeListenerImpl() {
        }

        public void dataChanged(DataChangeEvent event) {
            Object value;
            Object source = event.getSource();
            if (source instanceof KDPromptBox && (value = event.getNewValue()) != null) {
                KDPromptBox prmp = (KDPromptBox)source;
                String name = prmp.getName();
                if ("prmtTrainItem".equals(name)) {
                    TrainItemInfo trainItemInfo = (TrainItemInfo)value;
                    TrainItemCourseCollection items = trainItemInfo.getCourse();
                    TrainSysFilterUI.this.courseIdSet.clear();
                    int j = items.size();
                    for (int i = 0; i < j; ++i) {
                        TrainSysFilterUI.this.courseIdSet.add(items.get(i).getCourse().getId().toString());
                    }
                }
                TrainSysFilterUI.this.setItemAndCourseFilter();
            }
        }
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object obj = event.getSource();
            if (obj instanceof KDCheckBox) {
                KDCheckBox box = (KDCheckBox)obj;
                String command = box.getActionCommand();
                int stateChange = event.getStateChange();
                if ("Item".equals(command)) {
                    if (stateChange == 1) {
                        TrainSysFilterUI.this.contTrainItem.setVisible(false);
                        TrainSysFilterUI.this.contTrainItemName.setVisible(true);
                        TrainSysFilterUI.this.prmtTrainItem.setValue(null);
                    } else {
                        TrainSysFilterUI.this.contTrainItem.setVisible(true);
                        TrainSysFilterUI.this.contTrainItemName.setVisible(false);
                    }
                } else if ("Course".equals(command)) {
                    if (stateChange == 1) {
                        TrainSysFilterUI.this.contTrainCourse.setVisible(false);
                        TrainSysFilterUI.this.contTrainCourseName.setVisible(true);
                        TrainSysFilterUI.this.prmtTrainCourse.setValue(null);
                    } else {
                        TrainSysFilterUI.this.contTrainCourse.setVisible(true);
                        TrainSysFilterUI.this.contTrainCourseName.setVisible(false);
                    }
                }
            }
        }
    }
}

