/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.ITrainWorkTimeManagerFacade;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStatusEnum;
import com.kingdee.eas.hr.train.TrainWorkTimeInfo;
import com.kingdee.eas.hr.train.TrainWorkTimeManagerFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainWorkTimeUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TrainWorkTimeUI
extends AbstractTrainWorkTimeUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainWorkTimeUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String auditSuccess = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"AUDITSUCCESS");
    private static final String unAuditSuccess = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"UNAUDITSUCCESS");

    public void onLoad() throws Exception {
        this.setOprtState(OprtState.EDIT);
        super.onLoad();
        this.tblMain.checkParsed();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActState", (Object)String.valueOf(40), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("trainActState", (Object)String.valueOf(50), CompareType.EQUALS));
        filter.setMaskString("(#0 or #1)");
        filter.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filter);
        this.prmpTrainActivity.setEntityViewInfo(viewInfo);
        KDFormattedTextField txtWorkTime = TrainUtils.setTableCellEditorByFormattedTextField(this.tblMain, "workTime", TrainClientUtil.PRECISION);
        TrainUtils.setPositiveNumberValue(txtWorkTime);
        TrainUtils.setTableCellEditorByEnum(this.tblMain, CourseHourUnitEnum.class.getName(), "workTimeUint");
        TrainUtils.setTableCellEditorByDatePicker(this.tblMain, "startTime", true);
        TrainUtils.setTableCellEditorByDatePicker(this.tblMain, "endTime", true);
        TrainUtils.setTableCellEditorByEnum(this.tblMain, TrainAuditStatusEnum.class.getName(), "state");
        TrainUtils.setTableCellEditorByCheckBox(this.tblMain, "isTeacher");
        TrainClientUtil.setDisableColor(this.tblMain);
        TrainUtils.setKDTableSortable(this.tblMain);
        this.actionSubmit.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.setActionsState();
    }

    private void setActionsState() {
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        if (this.tblMain.getRowCount() > 0) {
            List rowIndexList;
            TrainAuditStatusEnum state = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                state = (TrainAuditStatusEnum)((Object)this.tblMain.getRow(i).getCell("state").getValue());
                if (!TrainAuditStatusEnum.UNAUDITED.equals((Object)state)) continue;
                this.actionSubmit.setEnabled(true);
                break;
            }
            if ((rowIndexList = TrainUtils.getSelectedRows(this.tblMain)) == null || rowIndexList.size() <= 0) {
                return;
            }
            this.actionAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(true);
            IRow row = null;
            int j = rowIndexList.size();
            for (int i = 0; i < j; ++i) {
                row = this.tblMain.getRow(Integer.parseInt(rowIndexList.get(i).toString()));
                state = (TrainAuditStatusEnum)((Object)row.getCell("state").getValue());
                if (TrainAuditStatusEnum.AUDITED.equals((Object)state)) {
                    this.actionAudit.setEnabled(false);
                }
                if (!TrainAuditStatusEnum.UNAUDITED.equals((Object)state)) continue;
                this.actionUnAudit.setEnabled(false);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected void prmpTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.prmpTrainActivity_dataChanged(e);
        this.fillTableData();
    }

    private void fillTableData() throws Exception {
        TrainUtils.removeRows(this.tblMain);
        if (this.prmpTrainActivity.getValue() != null) {
            String id = ((TrainActivityInfo)this.prmpTrainActivity.getValue()).getId().toString();
            this.fillOrgDate(id);
            this.fillRelDate(id);
            if (this.tblMain.getRowCount() > 0) {
                this.tblMain.getEditManager().editCellAt(0, this.tblMain.getColumnIndex("startTime"));
            }
        }
        this.setActionsState();
    }

    private void fillOrgDate(String trainActivity) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivity));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActivityOrganigerForManagerQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        IRow row = null;
        ICell cell = null;
        rowSet.beforeFirst();
        while (rowSet.next()) {
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("Entries.id"));
            row.getCell("role").setValue((Object)rowSet.getString("Entries.role.name"));
            row.getCell("number").setValue((Object)rowSet.getString("role.number"));
            row.getCell("person").setValue((Object)rowSet.getString("Entries.organiger.name"));
            row.getCell("workTime").setValue((Object)rowSet.getBigDecimal("Entries.workload"));
            cell = row.getCell("startTime");
            if (rowSet.getTimestamp("Entries.startDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("Entries.startDate"));
            } else if (rowSet.getTimestamp("trainActivity.trainStartDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("trainActivity.trainStartDate"));
            } else {
                cell.setValue(null);
            }
            cell = row.getCell("endTime");
            if (rowSet.getTimestamp("Entries.endDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("Entries.endDate"));
            } else if (rowSet.getTimestamp("trainActivity.trainEndDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("trainActivity.trainEndDate"));
            } else {
                cell.setValue(null);
            }
            int workLoadUnit = 3;
            if (rowSet.getString("Entries.workloadUnit") != null && !"0".equals(rowSet.getString("Entries.workloadUnit"))) {
                workLoadUnit = rowSet.getInt("Entries.workloadUnit");
            }
            row.getCell("workTimeUint").setValue((Object)CourseHourUnitEnum.getEnum(workLoadUnit));
            int state = 60;
            if (rowSet.getString("Entries.status") != null && !"0".equals(rowSet.getString("Entries.status"))) {
                state = rowSet.getInt("Entries.status");
            }
            row.getCell("state").setValue((Object)TrainAuditStatusEnum.getEnum(state));
            if (!TrainAuditStatusEnum.AUDITED.equals((Object)((TrainAuditStatusEnum)((Object)row.getCell("state").getValue())))) continue;
            row.getStyleAttributes().setLocked(true);
        }
        rowSet.beforeFirst();
    }

    private void fillRelDate(String trainActivity) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivity));
        filter.getFilterItems().add(new FilterItemInfo("parent.CourseState", (Object)10, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActCourseForManagerQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        IRow row = null;
        ICell cell = null;
        rowSet.beforeFirst();
        while (rowSet.next()) {
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("id"));
            cell = row.getCell("trainCourse");
            row.getCell("trainCourse").setValue((Object)rowSet.getString("trainCourse.name"));
            row.getCell("isTeacher").setValue((Object)rowSet.getBoolean("isTeacher"));
            row.getCell("role").setValue((Object)rowSet.getString("role.name"));
            row.getCell("number").setValue((Object)rowSet.getString("role.number"));
            cell = row.getCell("person");
            if (rowSet.getString("participator.name") != null) {
                cell.setValue((Object)rowSet.getString("participator.name"));
            } else if ("true".equals(rowSet.getString("Instructor.IsOuter"))) {
                cell.setValue((Object)rowSet.getString("Instructor.name"));
            } else {
                cell.setValue((Object)rowSet.getString("Employee.name"));
            }
            cell = row.getCell("startTime");
            if (rowSet.getTimestamp("startDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("startDate"));
            } else if (rowSet.getTimestamp("parent.StartDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("parent.StartDate"));
            } else {
                cell.setValue(null);
            }
            cell = row.getCell("endTime");
            if (rowSet.getTimestamp("endDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("endDate"));
            } else if (rowSet.getTimestamp("parent.EndDate") != null) {
                cell.setValue((Object)rowSet.getTimestamp("parent.EndDate"));
            } else {
                cell.setValue(null);
            }
            cell = row.getCell("workTime");
            if (rowSet.getBigDecimal("workload") != null) {
                cell.setValue((Object)rowSet.getBigDecimal("workload"));
            } else if (rowSet.getBigDecimal("parent.CourseHour") != null) {
                cell.setValue((Object)rowSet.getBigDecimal("parent.CourseHour"));
            }
            int workLoadUnit = 3;
            if (rowSet.getString("workloadUnit") != null && !"0".equals(rowSet.getString("workloadUnit"))) {
                workLoadUnit = rowSet.getInt("workloadUnit");
            } else if (rowSet.getString("parent.CourseHourUnit") != null && !"0".equals(rowSet.getString("parent.CourseHourUnit"))) {
                workLoadUnit = rowSet.getInt("parent.CourseHourUnit");
            }
            row.getCell("workTimeUint").setValue((Object)CourseHourUnitEnum.getEnum(workLoadUnit));
            int state = 60;
            if (rowSet.getString("status") != null && !"0".equals(rowSet.getString("status"))) {
                state = rowSet.getInt("status");
            }
            row.getCell("state").setValue((Object)TrainAuditStatusEnum.getEnum(state));
            if (!TrainAuditStatusEnum.AUDITED.equals((Object)((TrainAuditStatusEnum)((Object)row.getCell("state").getValue())))) continue;
            row.getStyleAttributes().setLocked(true);
        }
        rowSet.beforeFirst();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            ITrainWorkTimeManagerFacade facade = TrainWorkTimeManagerFacadeFactory.getRemoteInstance();
            int count = this.tblMain.getRowCount();
            int[] rowIndexs = new int[count];
            for (int i = 0; i < count; ++i) {
                rowIndexs[i] = i;
            }
            facade.updateWorkTime(this.getWorkTimeCollection(rowIndexs));
            super.showSubmitSuccess();
        }
    }

    private Vector getWorkTimeCollection(int[] indexs) {
        if (indexs == null || indexs.length == 0) {
            return null;
        }
        Vector<TrainWorkTimeInfo> workTimeCollection = new Vector<TrainWorkTimeInfo>();
        TrainWorkTimeInfo trainWorkTimeInfo = null;
        IRow row = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, row, "startTime");
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, row, "endTime");
            TrainVerifyUtils.verifyDateGreaterThan((CoreUIObject)this, this.tblMain, row, "startTime", "endTime");
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, row, "workTime");
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, row, "workTimeUint");
            trainWorkTimeInfo = new TrainWorkTimeInfo();
            trainWorkTimeInfo.setId(row.getCell("id").getValue().toString());
            if (row.getCell("trainCourse").getValue() != null) {
                trainWorkTimeInfo.setTrainCourse(row.getCell("trainCourse").getValue().toString());
            }
            if (row.getCell("isTeacher").getValue() != null) {
                trainWorkTimeInfo.setIsTeacher((Boolean)row.getCell("isTeacher").getValue());
            }
            if (row.getCell("role").getValue() != null) {
                trainWorkTimeInfo.setRole(row.getCell("role").getValue().toString());
            }
            if (row.getCell("person").getValue() != null) {
                trainWorkTimeInfo.setPerson(row.getCell("person").getValue().toString());
            }
            trainWorkTimeInfo.setStartDate((Date)row.getCell("startTime").getValue());
            trainWorkTimeInfo.setEndDate((Date)row.getCell("endTime").getValue());
            trainWorkTimeInfo.setWorkTime((BigDecimal)row.getCell("workTime").getValue());
            trainWorkTimeInfo.setWorkTimeUnit((CourseHourUnitEnum)((Object)row.getCell("workTimeUint").getValue()));
            trainWorkTimeInfo.setAuditor((TrainAuditStatusEnum)((Object)row.getCell("state").getValue()));
            workTimeCollection.add(trainWorkTimeInfo);
        }
        return workTimeCollection;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        ITrainWorkTimeManagerFacade facade = TrainWorkTimeManagerFacadeFactory.getRemoteInstance();
        facade.audit(this.getWorkTimeCollection(TrainHelper.getSelectedRows(this.tblMain)));
        super.setMessageBarText(auditSuccess);
        this.fillTableData();
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        ITrainWorkTimeManagerFacade facade = TrainWorkTimeManagerFacadeFactory.getRemoteInstance();
        facade.antiAudit(this.getWorkTimeCollection(TrainHelper.getSelectedRows(this.tblMain)));
        super.setMessageBarText(unAuditSuccess);
        this.fillTableData();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected void inOnload() throws Exception {
    }
}

