/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.AbstractBgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.IBgDimSettingsMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgSchemeInfo
extends AbstractBgSchemeInfo
implements Serializable {
    private static final long serialVersionUID = 6902047847990118654L;

    public BgSchemeInfo() {
    }

    protected BgSchemeInfo(String pkField) {
        super(pkField);
    }

    public String getLogInfo() {
        return this.getNumber() + "-" + this.getName();
    }

    public boolean equals(Object that) {
        if (that instanceof BgSchemeInfo) {
            BgSchemeInfo thatScheme = (BgSchemeInfo)that;
            if (this.getId() != null && thatScheme.getId() != null) {
                if (this.getId().toString().equals(thatScheme.getId().toString())) {
                    return true;
                }
            } else {
                return super.equals(that);
            }
        }
        return false;
    }

    public BOSUuid getEditOrgViewId() {
        BOSUuid bgOrgViewId = null;
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            block0: for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equalsIgnoreCase(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    if (2 != member.getType().getValue()) continue;
                    bgOrgViewId = member.getMemberID();
                    continue block0;
                }
            }
        }
        return bgOrgViewId;
    }

    public List<BOSUuid> getBgPeriodViewIds() {
        ArrayList<BOSUuid> viewIds = new ArrayList<BOSUuid>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (!DimensionConstants.DEF_PERIOD_NUMBER.equalsIgnoreCase(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    if (member.getMemberID() == null || member.getType() == null || 1 != member.getType().getValue()) continue;
                    viewIds.add(member.getMemberID());
                }
            }
        }
        return viewIds;
    }

    public Set<String> getOrgViewIds() {
        HashSet<String> orgViewIds = new HashSet<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equalsIgnoreCase(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    if (member.getMemberID() == null || member.getType() == null || 2 != member.getType().getValue()) continue;
                    orgViewIds.add(member.getMemberID().toString());
                }
            }
        }
        return orgViewIds;
    }

    public BOSUuid getViewId(String mbgDimNumber) {
        BOSUuid viewId = null;
        if (StringUtils.isEmpty((String)mbgDimNumber)) {
            return viewId;
        }
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (mbgDimNumber.equals(setting.getDimNumber())) {
                    int jn = setting.getMembers().size();
                    for (int j = 0; j < jn && viewId == null; ++j) {
                        member = setting.getMembers().get(j);
                        viewId = member.getMemberID();
                    }
                }
                if (viewId != null) break;
            }
        }
        return viewId;
    }

    public List<BOSUuid> getViewIds(String mbgDimNumber) {
        ArrayList<BOSUuid> viewIds = new ArrayList<BOSUuid>();
        if (StringUtils.isEmpty((String)mbgDimNumber)) {
            return viewIds;
        }
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (!mbgDimNumber.equals(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    viewIds.add(member.getMemberID());
                }
            }
        }
        return viewIds;
    }

    public List<BOSUuid> getExtDimViewIds() {
        ArrayList<BOSUuid> viewIds = new ArrayList<BOSUuid>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (DimUtils.checkBaseDimension(setting.getDimNumber()) || DimensionConstants.DEF_ACCOUNT_NUMBER.equals(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    if (1 != member.getType().getValue()) continue;
                    viewIds.add(member.getMemberID());
                }
            }
        }
        return viewIds;
    }

    public Set<String> getExtDimViewIdSet() {
        HashSet<String> viewIds = new HashSet<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (DimUtils.checkBaseDimension(setting.getDimNumber()) || DimensionConstants.DEF_ACCOUNT_NUMBER.equals(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    if (1 != member.getType().getValue()) continue;
                    viewIds.add(member.getMemberID().toString());
                }
            }
        }
        return viewIds;
    }

    public Set<String> getDimNums() {
        HashSet<String> dimNums = new HashSet<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                dimNums.add(setting.getDimNumber());
            }
        }
        return dimNums;
    }

    public Set<String> getExtDimNums(int valueType) {
        HashSet<String> dimNums = new HashSet<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (DimUtils.checkBaseDimension(setting.getDimNumber()) || DimensionBaseConstants.DEF_INDEX_NUMBER.equals(setting.getDimNumber())) continue;
                dimNums.add(setting.getDimNumber());
            }
        }
        if (valueType != 64 && valueType != DimensionConstants.CFS_DATA_TYPE && valueType != 128 && valueType != DimensionConstants.CFS_ADJUST_DATA_TYPE) {
            dimNums.remove(DimensionBaseConstants.DEF_CSL_NUMBER);
        }
        return dimNums;
    }

    public Set<String> getExtDimNums() {
        HashSet<String> dimNums = new HashSet<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (DimUtils.checkBaseDimension(setting.getDimNumber()) || DimensionBaseConstants.DEF_INDEX_NUMBER.equals(setting.getDimNumber())) continue;
                dimNums.add(setting.getDimNumber());
            }
        }
        return dimNums;
    }

    public Set<String> getExtDimNumsWithoutCsl() {
        Set<String> extDimNums = this.getExtDimNums();
        extDimNums.remove(DimensionBaseConstants.DEF_CSL_NUMBER);
        return extDimNums;
    }

    public List<String> getRefFields(Connection conn) throws EASBizException {
        return this.getRefFields(conn, 1);
    }

    public List<String> getRefFields(Connection conn, int valueType) throws EASBizException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(DimensionBaseConstants.DEF_BGINDEX_FIELD);
        if (conn == null || this.getId() == null) {
            return fields;
        }
        String sql = "select m.FRefField from T_MBG_BgDimSettings t join T_MBG_BgDimSettingsMember ms on t.FId = ms.FBgDimSettingsId join T_MBG_MbgView v on v.FId = ms.FMemberId join T_MBG_MbgDim m on m.fid = v.FMbgDimId where t.fbgschemeid = ? and ms.ftype = 1";
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{this.getId().toString()});
            while (rst.next()) {
                fields.add(rst.getString("FRefField"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (valueType != 64 && valueType != DimensionConstants.CFS_DATA_TYPE && valueType != 128 && valueType != DimensionConstants.CFS_ADJUST_DATA_TYPE) {
            fields.remove(DimensionBaseConstants.DEF_CSL_FIELD);
        }
        DimUtils.sortFields(fields);
        return fields;
    }

    public List<String> getRefFields(Context ctx, int valueType) throws BOSException, EASBizException {
        List<String> fields = new ArrayList<String>();
        if (ctx == null || this.getId() == null) {
            return fields;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            fields = this.getRefFields(conn, valueType);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return fields;
    }

    public boolean checkHasUnionDim() {
        boolean check = false;
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in && !check; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (!DimensionConstants.DEF_CSL_NUMBER.equals(setting.getDimNumber())) continue;
                check = true;
            }
        }
        return check;
    }

    public List<BOSUuid> getUnionDebt() {
        ArrayList<BOSUuid> unionIds = new ArrayList<BOSUuid>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    if (3 != member.getType().getValue()) continue;
                    unionIds.add(member.getMemberID());
                }
            }
        }
        return unionIds;
    }

    public List<String> getMemberNumber(String dimNumber) {
        if (StringUtils.isEmpty((String)dimNumber)) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (!dimNumber.equals(setting.getDimNumber())) continue;
                int jn = setting.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    member = setting.getMembers().get(j);
                    members.add(member.getNumber());
                }
            }
        }
        return members;
    }

    public Set<String> getCslDim(Connection conn) throws SQLException {
        HashSet<String> cslDim = new HashSet<String>();
        if (conn == null || this.getId() == null) {
            return cslDim;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FMbgDimNumber from T_MBG_DimGroup where FBgSchemeId = ?", (Object[])new Object[]{this.getId().toString()});
            while (rst.next()) {
                cslDim.add(rst.getString("FMbgDimNumber"));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return cslDim;
    }

    public Set<String> getCslSumDim(Connection conn) throws SQLException {
        HashSet<String> cslDim = new HashSet<String>();
        if (conn == null || this.getId() == null) {
            return cslDim;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FMbgDimNumber from T_MBG_DimGroup where FBgSchemeId = ? and FMbgMemNumberData is null", (Object[])new Object[]{this.getId().toString()});
            while (rst.next()) {
                cslDim.add(rst.getString("FMbgDimNumber"));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return cslDim;
    }

    public Set<String> getStandbyDim(Connection conn) throws SQLException {
        HashSet<String> standbyDim = new HashSet<String>();
        if (conn == null || this.getId() == null) {
            return standbyDim;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FNumber from T_MBG_MbgDim d join T_MBG_MbgView v on d.FID = v.FMbgDimId where v.FStandby = 1 and v.FID IN (select FMemberId from T_MBG_BgDimSettingsMember where FBgDimSettingsId in (select FID from T_MBG_BgDimSettings where FbgSchemeId = ?) and Ftype = ?)");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{this.getId().toString(), 1});
            while (rst.next()) {
                standbyDim.add(rst.getString("FNumber"));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return standbyDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExtRootMember(Connection conn) throws SQLException {
        HashMap<String, String> rootMember = new HashMap<String, String>();
        if (conn == null || this.getId() == null) {
            return rootMember;
        }
        List<BOSUuid> extViewIds = this.getExtDimViewIds();
        if (extViewIds == null || extViewIds.isEmpty()) {
            return rootMember;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FReffield, m.FNumber from T_MBG_MbgMember m join T_MBG_MbgView v on m.FViewId = v.FId join T_MBG_MbgDim d on v.FMbgDimId = d.FId where m.FViewId in (");
        for (BOSUuid viewId : extViewIds) {
            sql.append("'" + viewId.toString() + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") and m.FParentId is null and d.fnumber <> ?");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{DimensionBaseConstants.DEF_CSL_NUMBER});
            while (rst.next()) {
                rootMember.put(rst.getString("FReffield"), rst.getString("FNumber"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return rootMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getNotDistMember(Connection conn) throws SQLException {
        HashMap<String, String> rootMember = new HashMap<String, String>();
        if (conn == null || this.getId() == null) {
            return rootMember;
        }
        List<BOSUuid> extViewIds = this.getExtDimViewIds();
        if (extViewIds == null || extViewIds.isEmpty()) {
            return rootMember;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FReffield, d.FSrcNumber, m.FNumber from T_MBG_MbgMember m join T_MBG_MbgView v on m.FViewId = v.FId join T_MBG_MbgDim d on v.FMbgDimId = d.FId where m.FViewId in (");
        for (BOSUuid viewId : extViewIds) {
            sql.append("'" + viewId.toString() + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") and m.FParentId is not null and m.FIsSystemDefault = 1");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                rootMember.put(rst.getString("FReffield"), DimUtils.getDimNumber(rst.getString("FSrcNumber"), rst.getString("FNumber")));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return rootMember;
    }

    public Set<String> getAuditMbgDim(boolean isCsl) {
        HashSet<String> mbgDimNums = new HashSet<String>();
        if (this.getBgDimSettings() != null && !this.getBgDimSettings().isEmpty()) {
            BgDimSettingsInfo setting = null;
            int in = this.getBgDimSettings().size();
            for (int i = 0; i < in; ++i) {
                setting = this.getBgDimSettings().get(i);
                if (DimUtils.checkBaseDimension(setting.getDimNumber()) || !setting.isAudit() || !isCsl && DimensionBaseConstants.DEF_CSL_NUMBER.equals(setting.getDimNumber())) continue;
                mbgDimNums.add(setting.getDimNumber());
            }
        }
        return mbgDimNums;
    }

    public static String getViewId(Context ctx, String bgSchemeId, String dimNumber) throws EASBizException, BOSException {
        return BgSchemeInfo.getViewId(ctx, bgSchemeId, dimNumber, false);
    }

    public static String getViewId(Context ctx, String bgSchemeId, String dimNumber, boolean isCsl) throws EASBizException, BOSException {
        IBgDimSettingsMember biz = null;
        biz = ctx == null ? BgDimSettingsMemberFactory.getRemoteInstance() : BgDimSettingsMemberFactory.getLocalInstance(ctx);
        BgDimSettingsMemberInfo info = null;
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) {
            int type = 2;
            if (isCsl) {
                type = 3;
            }
            info = biz.getBgDimSettingsMemberInfo("select memberID where bgDimSettings.dimNumber = '" + dimNumber + "' and bgDimSettings.bgScheme.id = '" + bgSchemeId + "' and type = " + type);
        } else {
            info = biz.getBgDimSettingsMemberInfo("select memberID where bgDimSettings.dimNumber = '" + dimNumber + "' and bgDimSettings.bgScheme.id = '" + bgSchemeId + "'");
        }
        if (info != null) {
            return info.getMemberID().toString();
        }
        return null;
    }
}

