/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.base.BgExamineException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperandExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.mbg.BgExamineDataCheckResult;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.BgExamineFacadeControllerBean;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BizCalcObj;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class MbgExamCalcObj {
    private static Logger logger = Logger.getLogger((String)MbgExamCalcObj.class.getName());
    public BgExamineInfo mbgExamine = null;
    public BgExamineSubsetInfo subSetInfo = null;
    public IExpress expr = null;
    public BgExamineFacadeControllerBean.ExprDimQuery query = null;
    public String planScript = null;
    public String script = null;
    public String scriptEval = null;
    public String scriptError = null;
    private boolean hasEquals = false;
    public Map<String, IExpress> members = new TreeMap<String, IExpress>();
    public String orignScript = null;
    private Map<String, String> expresMap = new HashMap<String, String>();
    private Map<String, String> avgStrs = new HashMap<String, String>();
    public Boolean isExamineIgnorePrecision = null;
    public CurrencyInfo currencyInfo = null;

    public void parse() {
        if (this.expr == null || !(this.expr instanceof BinaryExpr)) {
            return;
        }
        this.planScript = this.expr.toPlanString();
        this.parse((BinaryExpr)this.expr);
        String tmpStr = this.expr.toString();
        if (tmpStr.indexOf("=") > 0) {
            this.hasEquals = true;
        }
        this.script = this.transScript(tmpStr);
        this.scriptEval = this.getEvalScript(this.script);
        this.scriptError = this.getErrorScript(this.script);
    }

    private String transScript(String script) {
        String _script = script;
        if (_script.indexOf("<>") > 0) {
            _script = _script.replaceAll("<>", "!=");
        }
        return _script;
    }

    private String getEvalScript(String script) {
        int index = -1;
        String scriptEval = script;
        if (this.checkIF(script)) {
            return scriptEval;
        }
        if (script.indexOf(">=") > 0) {
            index = script.indexOf(">=");
            scriptEval = "(" + scriptEval.substring(0, index) + ")-(" + scriptEval.substring(index + 2) + ")>=0";
        } else if (script.indexOf("<=") > 0) {
            index = script.indexOf("<=");
            scriptEval = "(" + scriptEval.substring(0, index) + ")-(" + scriptEval.substring(index + 2) + ")<=0";
        } else if (script.indexOf("==") > 0) {
            index = script.indexOf("==");
            scriptEval = "(" + scriptEval.substring(0, index) + ")-(" + scriptEval.substring(index + 2) + ")==0";
        } else if (script.indexOf("!=") > 0) {
            index = script.indexOf("!=");
            scriptEval = "(" + scriptEval.substring(0, index) + ")-(" + scriptEval.substring(index + 2) + ")!=0";
        } else if (script.indexOf(">") > 0) {
            index = script.indexOf(">");
            scriptEval = "(" + scriptEval.substring(0, index) + ")-(" + scriptEval.substring(index + 1) + ")>0";
        } else if (script.indexOf("<") > 0) {
            index = script.indexOf("<");
            scriptEval = "(" + scriptEval.substring(0, index) + ")-(" + scriptEval.substring(index + 1) + ")<0";
        }
        return scriptEval;
    }

    private String getErrorScript(String script) {
        int index = -1;
        String scriptError = script;
        if (this.checkIF(script)) {
            return scriptError;
        }
        if (script.indexOf(">=") > 0) {
            index = script.indexOf(">=");
            scriptError = "(" + scriptError.substring(0, index) + ")-(" + scriptError.substring(index + 2) + ")";
        } else if (script.indexOf("<=") > 0) {
            index = script.indexOf("<=");
            scriptError = "(" + scriptError.substring(0, index) + ")-(" + scriptError.substring(index + 2) + ")";
        } else if (script.indexOf("==") > 0) {
            index = script.indexOf("==");
            scriptError = "(" + scriptError.substring(0, index) + ")-(" + scriptError.substring(index + 2) + ")";
        } else if (script.indexOf("!=") > 0) {
            index = script.indexOf("!=");
            scriptError = "(" + scriptError.substring(0, index) + ")-(" + scriptError.substring(index + 2) + ")";
        } else if (script.indexOf(">") > 0) {
            index = script.indexOf(">");
            scriptError = "(" + scriptError.substring(0, index) + ")-(" + scriptError.substring(index + 1) + ")";
        } else if (script.indexOf("<") > 0) {
            index = script.indexOf("<");
            scriptError = "(" + scriptError.substring(0, index) + ")-(" + scriptError.substring(index + 1) + ")";
        }
        return scriptError;
    }

    private void parse(BinaryExpr expr) {
        if (expr == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            this.parse((BinaryExpr)expr.left);
        } else if (expr.left instanceof MdxMemberExpr) {
            expr.left = this.parse((MdxMemberExpr)expr.left);
        } else if (expr.left instanceof VariateExpr) {
            expr.left = this.parse((VariateExpr)expr.left);
        } else if (expr.left instanceof FormulaExpr) {
            expr.left = this.parse((FormulaExpr)expr.left);
        } else if (expr.left instanceof FunctionExpr) {
            this.parse((FunctionExpr)expr.left);
        }
        if (expr.right instanceof BinaryExpr) {
            this.parse((BinaryExpr)expr.right);
        } else if (expr.right instanceof MdxMemberExpr) {
            expr.right = this.parse((MdxMemberExpr)expr.right);
        } else if (expr.right instanceof VariateExpr) {
            expr.right = this.parse((VariateExpr)expr.right);
        } else if (expr.right instanceof FormulaExpr) {
            expr.right = this.parse((FormulaExpr)expr.right);
        } else if (expr.right instanceof FunctionExpr) {
            this.parse((FunctionExpr)expr.right);
        } else if (expr.right instanceof ConditionExpr) {
            List conditions = ((ConditionExpr)expr.right).conditions;
            List results = ((ConditionExpr)expr.right).results;
            if (conditions != null) {
                for (IExpress _expr : conditions) {
                    if (_expr instanceof BinaryExpr) {
                        this.parse((BinaryExpr)_expr);
                        continue;
                    }
                    if (_expr instanceof ConditionExpr || _expr instanceof FunctionExpr || !(_expr instanceof VariateExpr)) continue;
                    this.parse((VariateExpr)_expr);
                }
            }
            if (results != null) {
                for (int i = 0; i < results.size(); ++i) {
                    IExpress _expr;
                    _expr = (IExpress)results.get(i);
                    if (_expr instanceof BinaryExpr) {
                        this.parse((BinaryExpr)_expr);
                        continue;
                    }
                    if (_expr instanceof ConditionExpr) continue;
                    if (_expr instanceof FunctionExpr) {
                        this.parse((FunctionExpr)_expr);
                        continue;
                    }
                    if (_expr instanceof FormulaExpr) {
                        _expr = this.parse((FormulaExpr)_expr);
                        ((ConditionExpr)expr.right).results.remove(i);
                        ((ConditionExpr)expr.right).results.add(i, _expr);
                        continue;
                    }
                    if (_expr instanceof VariateExpr) {
                        this.parse((BinaryExpr)_expr);
                        continue;
                    }
                    if (!(_expr instanceof MdxMemberExpr)) continue;
                    _expr = this.parse((MdxMemberExpr)_expr);
                    ((ConditionExpr)expr.right).results.remove(i);
                    ((ConditionExpr)expr.right).results.add(i, _expr);
                }
            }
        }
    }

    private NameExpr parse(VariateExpr expr) {
        if (expr == null || expr.expr == null) {
            return null;
        }
        return this.parse(expr.expr);
    }

    private NameExpr parse(FormulaExpr expr) {
        if (expr == null) {
            return null;
        }
        String name = TableToolkit.int2pos((int)this.members.size());
        if (!this.expresMap.containsKey(expr.toPlanString())) {
            this.expresMap.put(expr.toPlanString(), name);
            this.members.put(name, (IExpress)expr);
        } else {
            name = this.expresMap.get(expr.toPlanString());
        }
        return new NameExpr(name);
    }

    private NameExpr parse(MemberExpr expr) {
        if (expr == null) {
            return null;
        }
        String name = TableToolkit.int2pos((int)this.members.size());
        if (!this.expresMap.containsKey(expr.toPlanString())) {
            this.expresMap.put(expr.toPlanString(), name);
            this.members.put(name, (IExpress)expr);
        } else {
            name = this.expresMap.get(expr.toPlanString());
        }
        return new NameExpr(name);
    }

    private NameExpr parse(MdxMemberExpr expr) {
        if (expr == null) {
            return null;
        }
        String name = TableToolkit.int2pos((int)this.members.size());
        if (!this.expresMap.containsKey(expr.toPlanString())) {
            this.expresMap.put(expr.toPlanString(), name);
            this.members.put(name, (IExpress)expr);
        } else {
            name = this.expresMap.get(expr.toPlanString());
        }
        return new NameExpr(name);
    }

    private void parse(FunctionExpr expr) {
        List params;
        if (expr == null) {
            return;
        }
        if (expr.functionName.equalsIgnoreCase("Abs") || expr.functionName.equalsIgnoreCase("Max") || expr.functionName.equalsIgnoreCase("Min") || expr.functionName.equalsIgnoreCase("Avg")) {
            params = expr.params;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof BinaryExpr) {
                    this.parse((BinaryExpr)params.get(i));
                    continue;
                }
                if (params.get(i) instanceof MdxMemberExpr) {
                    for (int j = 0; j < ((MdxMemberExpr)params.get((int)i)).params.size(); ++j) {
                        if (!(((MdxMemberExpr)params.get((int)i)).params.get(j) instanceof MemberExpr)) continue;
                        NameExpr nameExp = this.parse((MemberExpr)((MdxMemberExpr)params.get((int)i)).params.get(j));
                        ((MdxMemberExpr)params.get((int)i)).params.remove(j);
                        ((MdxMemberExpr)params.get((int)i)).params.add(j, nameExp);
                    }
                    continue;
                }
                if (!(params.get(i) instanceof FunctionExpr)) continue;
                this.parse((FunctionExpr)params.get(i));
            }
        }
        if (expr.functionName.equalsIgnoreCase("Avg")) {
            params = expr.params;
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            for (int i = 0; i < params.size(); ++i) {
                if (!(params.get(i) instanceof MdxMemberExpr)) continue;
                sb.append(params.get(i).toString());
                if (i == params.size() - 1) continue;
                sb.append("+");
            }
            sb.append(")").append("/").append(params.size());
            this.avgStrs.put(expr.toString(), sb.toString());
        }
    }

    public List<BgExamineDataCheckResult> check(Context ctx, ScriptEngine engine, ScriptContext context, MbgDimCollection mbgDims, BgSchemeInfo bgScheme, BOSUuid unionId, OrgUnitInfo orgUnit, Map<String, Set<String>> dimFormMap, Map[] CMPDataMap, Map<String, String> srcFieldMap, Map<String, Map<String, String>> orgParentMap, String processType, Map<String, String> defultMap, Map<String, Map<String, Set<String>>> fieldMap) throws Exception {
        CurrencyCollection colls;
        ArrayList<BgExamineDataCheckResult> checkResults = new ArrayList<BgExamineDataCheckResult>();
        if (ctx == null || mbgDims == null || bgScheme == null || orgUnit == null || dimFormMap == null || CMPDataMap == null) {
            return checkResults;
        }
        int index = 0;
        String field22 = null;
        String[] tmpStrs = null;
        IExpress expr22 = null;
        MdxMemberExpr mdxExpr = null;
        Set<String> dimNumSet = null;
        HashSet mdxFieldSet = new HashSet();
        HashSet<String> tmpMdxFieldSet = new HashSet<String>();
        Set<String> formSet = null;
        List<String[]> dimNums = new ArrayList<String[]>();
        boolean addDims = true;
        HashMap dimNumMap = new HashMap();
        for (IExpress expr22 : this.members.values()) {
            tmpMdxFieldSet.clear();
            if (!(expr22 instanceof MdxMemberExpr)) continue;
            mdxExpr = (MdxMemberExpr)expr22;
            for (IExpress memExpr : mdxExpr.params) {
                if (!(memExpr instanceof MemberExpr) || DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)memExpr).srcNumber) || DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER.equals(((MemberExpr)memExpr).srcNumber)) continue;
                field22 = srcFieldMap.get(((MemberExpr)memExpr).srcNumber);
                tmpMdxFieldSet.add(field22);
            }
            if (addDims) {
                mdxFieldSet.addAll(tmpMdxFieldSet);
                addDims = false;
                continue;
            }
            mdxFieldSet.retainAll(tmpMdxFieldSet);
        }
        for (String field22 : dimFormMap.keySet()) {
            if (dimNumMap.containsKey(field22) || mdxFieldSet.contains(field22)) continue;
            formSet = dimFormMap.get(field22);
            dimNumSet = new HashSet<String>();
            dimNumSet.addAll(formSet);
            dimNumMap.put(field22, dimNumSet);
        }
        Map<String, Set<String>> _dimNumMap = this.subSetInfo.getScopeData(ctx, bgScheme, bgScheme.getEditOrgViewId(), unionId, mbgDims, null);
        Object var29_30 = null;
        for (Map.Entry<String, Set<String>> entry : _dimNumMap.entrySet()) {
            field22 = entry.getKey();
            formSet = entry.getValue();
            if (formSet == null || formSet.isEmpty()) continue;
            if (dimNumMap.containsKey(field22)) {
                dimNumSet = (Set)dimNumMap.get(field22);
                dimNumSet.retainAll(formSet);
                if (!dimNumSet.isEmpty()) continue;
                return checkResults;
            }
            if (!DimensionConstants.DEF_PROCESS_FIELD.equals(field22) || formSet.contains(processType)) continue;
            return checkResults;
        }
        String currencyNumber = null;
        HashMap<Integer, String> fieldIndexMap = new HashMap<Integer, String>();
        for (Map.Entry entry : dimNumMap.entrySet()) {
            Iterator<String> itx;
            field22 = (String)entry.getKey();
            dimNumSet = (Set)entry.getValue();
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field22)) continue;
            fieldIndexMap.put(index++, field22);
            dimNums = this.combineArray(dimNums, dimNumSet);
            if (currencyNumber != null || !DimensionConstants.DEF_CURRENCY_FIELD.equals(field22) || dimNumSet.isEmpty() || !(itx = dimNumSet.iterator()).hasNext()) continue;
            currencyNumber = itx.next();
        }
        TreeMap<String, String> tmpTreeMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        if (this.isExamineIgnorePrecision == null) {
            this.isExamineIgnorePrecision = BgParamNHelper.isExamineIgnorePrecision((Context)ctx);
        }
        if (this.isExamineIgnorePrecision.booleanValue() && this.currencyInfo == null && !StringUtils.isEmpty(currencyNumber) && (colls = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("where number = '" + currencyNumber + "'")) != null && !colls.isEmpty()) {
            this.currencyInfo = colls.get(0);
        }
        if (!dimNums.isEmpty()) {
            HashSet<String> filterSet = new HashSet<String>();
            int in = dimNums.size();
            for (int i = 0; i < in; ++i) {
                tmpStrs = dimNums.get(i);
                this.check(engine, context, bgScheme, orgUnit, tmpStrs, tmpTreeMap, fieldIndexMap, CMPDataMap, srcFieldMap, checkResults, filterSet, orgParentMap, processType, defultMap, fieldMap);
            }
        } else {
            this.check(engine, context, bgScheme, orgUnit, null, tmpTreeMap, fieldIndexMap, CMPDataMap, srcFieldMap, checkResults, null, orgParentMap, processType, defultMap, fieldMap);
        }
        return checkResults;
    }

    private void check(ScriptEngine engine, ScriptContext context, BgSchemeInfo bgScheme, OrgUnitInfo orgUnit, String[] tmpStrs, Map<String, String> tmpTreeMap, Map<Integer, String> fieldIndexMap, Map[] CMPDataMap, Map<String, String> srcFieldMap, List<BgExamineDataCheckResult> checkResults, Set<String> filterSet, Map<String, Map<String, String>> orgParentMap, String processType, Map<String, String> defultMap, Map<String, Map<String, Set<String>>> fieldMap) throws EASBizException {
        if (engine == null || context == null || bgScheme == null || orgUnit == null || tmpTreeMap == null || fieldIndexMap == null || CMPDataMap == null || srcFieldMap == null || checkResults == null) {
            return;
        }
        ArrayList<BizCalcObj> checkGroup = new ArrayList<BizCalcObj>();
        Map.Entry<String, IExpress> mEntry2 = null;
        Object result = null;
        BgExamineDataCheckResult checkResult = null;
        HashSet<String> bgProcessNumbers = new HashSet<String>();
        boolean check = false;
        int noPassType = this.mbgExamine.getNoPass().getValue();
        String field = null;
        String key = null;
        String offPeriodNum = null;
        BizCalcObj calcObj = null;
        IExpress expr = null;
        MdxMemberExpr mdxExpr = null;
        FunctionExpr functionExpr = null;
        String defBgPeriodNumber = null;
        String defCurrencyNumber = null;
        String _leftPeriodNumber = null;
        block4: for (Map.Entry<String, IExpress> mEntry2 : this.members.entrySet()) {
            Object memExpr2;
            key = mEntry2.getKey();
            expr = mEntry2.getValue();
            if (!(expr instanceof MdxMemberExpr)) continue;
            mdxExpr = (MdxMemberExpr)expr;
            for (Object memExpr2 : mdxExpr.params) {
                if (!(memExpr2 instanceof MemberExpr)) continue;
                if (DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(((MemberExpr)memExpr2).srcNumber)) {
                    defBgPeriodNumber = ((MemberExpr)memExpr2).number;
                    continue;
                }
                if (DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER.equals(((MemberExpr)memExpr2).srcNumber)) {
                    defCurrencyNumber = ((MemberExpr)memExpr2).number;
                    continue;
                }
                if (!DimensionBaseConstants.DEF_PROCESS_SRCNUMBER.equals(((MemberExpr)memExpr2).srcNumber)) continue;
                bgProcessNumbers.add(((MemberExpr)memExpr2).number);
            }
            if (_leftPeriodNumber != null) continue;
            MemberExpr _memberExpr = null;
            memExpr2 = mdxExpr.params.iterator();
            while (memExpr2.hasNext()) {
                IExpress _expr = (IExpress)memExpr2.next();
                if (!(_expr instanceof MemberExpr)) continue;
                _memberExpr = (MemberExpr)_expr;
                if (!DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(_memberExpr.srcNumber)) continue;
                _leftPeriodNumber = _memberExpr.number;
                continue block4;
            }
        }
        for (Map.Entry<String, IExpress> mEntry2 : this.members.entrySet()) {
            key = mEntry2.getKey();
            expr = mEntry2.getValue();
            if (expr instanceof MemberExpr) {
                MemberExpr memExpr = (MemberExpr)expr;
                calcObj = new BizCalcObj();
                if (tmpStrs != null) {
                    int jn = tmpStrs.length;
                    for (int j = 0; j < jn; ++j) {
                        calcObj.getDimNums().put(fieldIndexMap.get(j), tmpStrs[j]);
                    }
                }
                if (DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(memExpr.srcNumber)) {
                    calcObj.schemeNum = memExpr.number;
                } else if (DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER.equals(memExpr.srcNumber)) {
                    calcObj.orgUnitNum = memExpr.number;
                } else if (DimensionBaseConstants.DEF_PROCESS_SRCNUMBER.equals(memExpr.srcNumber)) {
                    calcObj.bgProceeType = memExpr.number;
                } else {
                    field = srcFieldMap.get(memExpr.srcNumber);
                    if (DimUtils.checkBaseDimensionByField(field)) {
                        calcObj.getDimNums().put(field, memExpr.number);
                    } else {
                        calcObj.getDimNums().put(field, DimUtils.getDimNumber(memExpr.srcNumber, memExpr.number));
                    }
                }
                if (StringUtils.isEmpty((String)calcObj.schemeNum)) {
                    calcObj.schemeNum = bgScheme.getNumber();
                }
                if (StringUtils.isEmpty((String)calcObj.orgUnitNum)) {
                    calcObj.orgUnitNum = orgUnit.getNumber();
                }
                if (StringUtils.isEmpty((String)calcObj.bgProceeType)) {
                    calcObj.bgProceeType = processType;
                }
                if (!processType.equals(calcObj.bgProceeType) && !bgProcessNumbers.contains(processType)) continue;
                String fieldKey2 = null;
                for (String fieldKey2 : tmpTreeMap.keySet()) {
                    if (calcObj.getDimNums().containsKey(fieldKey2) || !tmpTreeMap.containsKey(fieldKey2)) continue;
                    calcObj.getDimNums().put(fieldKey2, tmpTreeMap.get(fieldKey2));
                }
                calcObj.parse(tmpTreeMap);
                this.queryMbgData(calcObj, CMPDataMap);
                if (calcObj.value != null) {
                    context.setAttribute(key, calcObj.value, 100);
                } else {
                    context.setAttribute(key, BigDecimal.ZERO, 100);
                }
                checkGroup.add(calcObj);
                continue;
            }
            if (expr instanceof MdxMemberExpr) {
                mdxExpr = (MdxMemberExpr)expr;
                calcObj = new BizCalcObj();
                calcObj.fieldSet.putAll(this.query.fieldSet);
                if (tmpStrs != null) {
                    int jn = tmpStrs.length;
                    for (int j = 0; j < jn; ++j) {
                        calcObj.getDimNums().put(fieldIndexMap.get(j), tmpStrs[j]);
                    }
                }
                for (IExpress memExpr : mdxExpr.params) {
                    if (memExpr instanceof MemberExpr) {
                        if (DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)memExpr).srcNumber)) {
                            calcObj.schemeNum = ((MemberExpr)memExpr).number;
                            continue;
                        }
                        if (DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER.equals(((MemberExpr)memExpr).srcNumber)) {
                            calcObj.orgUnitNum = ((MemberExpr)memExpr).number;
                            continue;
                        }
                        if (DimensionBaseConstants.DEF_PROCESS_SRCNUMBER.equals(((MemberExpr)memExpr).srcNumber)) {
                            calcObj.bgProceeType = ((MemberExpr)memExpr).number;
                            continue;
                        }
                        field = srcFieldMap.get(((MemberExpr)memExpr).srcNumber);
                        if (DimUtils.checkBaseDimensionByField(field)) {
                            calcObj.getDimNums().put(field, ((MemberExpr)memExpr).number);
                            continue;
                        }
                        calcObj.getDimNums().put(field, DimUtils.getDimNumber(((MemberExpr)memExpr).srcNumber, ((MemberExpr)memExpr).number));
                        continue;
                    }
                    if (!(memExpr instanceof FunctionExpr)) continue;
                    functionExpr = (FunctionExpr)memExpr;
                    if (functionExpr.functionName.equalsIgnoreCase("lead")) {
                        if (functionExpr.params.size() == 1) {
                            OperandExpr _expr = (OperandExpr)functionExpr.params.get(0);
                            if (_expr.value == null || BigDecimal.ZERO.compareTo(_expr.value) == 0 || !calcObj.getDimNums().containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) continue;
                            offPeriodNum = _leftPeriodNumber == null ? BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)calcObj.getDimNums().get(DimensionBaseConstants.DEF_PERIOD_FIELD), (int)_expr.value.intValue()) : BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)_leftPeriodNumber, (int)_expr.value.intValue());
                            calcObj.getDimNums().put(DimensionBaseConstants.DEF_PERIOD_FIELD, offPeriodNum);
                            continue;
                        }
                        if (functionExpr.params.size() != 2) continue;
                        OperandExpr _expr1 = (OperandExpr)functionExpr.params.get(0);
                        MemberExpr _expr2 = (MemberExpr)functionExpr.params.get(1);
                        if (_expr1.value == null || BigDecimal.ZERO.compareTo(_expr1.value) == 0) continue;
                        if (_expr2 != null) {
                            offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)_expr2.number, (int)_expr1.value.intValue());
                            calcObj.getDimNums().put(DimensionBaseConstants.DEF_PERIOD_FIELD, offPeriodNum);
                            continue;
                        }
                        if (!calcObj.getDimNums().containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) continue;
                        offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)calcObj.getDimNums().get(DimensionBaseConstants.DEF_PERIOD_FIELD), (int)_expr1.value.intValue());
                        calcObj.getDimNums().put(DimensionBaseConstants.DEF_PERIOD_FIELD, offPeriodNum);
                        continue;
                    }
                    if (!functionExpr.functionName.equalsIgnoreCase("Parent")) continue;
                    if (StringUtils.isEmpty((String)calcObj.schemeNum)) {
                        calcObj.schemeNum = bgScheme.getNumber();
                    }
                    if (functionExpr.params.size() != 1) continue;
                    String tOrgNumber = (String)functionExpr.params.get(0);
                    if (StringUtils.isEmpty((String)tOrgNumber)) {
                        tOrgNumber = orgUnit.getNumber();
                    }
                    if (!orgParentMap.containsKey(calcObj.schemeNum) || !orgParentMap.get(calcObj.schemeNum).containsKey(tOrgNumber)) continue;
                    calcObj.orgUnitNum = orgParentMap.get(calcObj.schemeNum).get(tOrgNumber);
                }
                if (StringUtils.isEmpty((String)calcObj.schemeNum)) {
                    calcObj.schemeNum = bgScheme.getNumber();
                }
                if (StringUtils.isEmpty((String)calcObj.orgUnitNum)) {
                    calcObj.orgUnitNum = orgUnit.getNumber();
                }
                if (StringUtils.isEmpty((String)calcObj.bgProceeType)) {
                    calcObj.bgProceeType = processType;
                }
                if (!processType.equals(calcObj.bgProceeType) && !bgProcessNumbers.contains(processType) && (functionExpr == null || !functionExpr.functionName.equalsIgnoreCase("Parent"))) continue;
                if (fieldMap.containsKey(calcObj.schemeNum) && fieldMap.get(calcObj.schemeNum).containsKey(calcObj.orgUnitNum)) {
                    Set<String> fieldSet = fieldMap.get(calcObj.schemeNum).get(calcObj.orgUnitNum);
                    for (String fieldkey : fieldSet) {
                        if (calcObj.getDimNums().containsKey(fieldkey) || defultMap == null || defultMap.isEmpty()) continue;
                        calcObj.getDimNums().put(fieldkey, defultMap.get(fieldkey));
                    }
                }
                calcObj.parse(tmpTreeMap);
                this.queryMbgData(calcObj, CMPDataMap);
                if (calcObj.value != null) {
                    context.setAttribute(key, calcObj.value, 100);
                } else {
                    context.setAttribute(key, BigDecimal.ZERO, 100);
                }
                checkGroup.add(calcObj);
                continue;
            }
            if (expr instanceof FormulaExpr) {
                FormulaExpr formulaExpr = (FormulaExpr)expr;
                String itemParam = null;
                boolean checkItem = false;
                boolean isIndex = false;
                StringExpr acctItem = (StringExpr)formulaExpr.params.get(1);
                if (acctItem != null && (StringUtils.isEmpty((String)(itemParam = acctItem.value)) || "@".equals(itemParam) || "@|@".equals(itemParam) || itemParam.contains("@|") || itemParam.contains("|@"))) {
                    checkItem = true;
                }
                calcObj = new BizCalcObj();
                calcObj.fieldSet.putAll(this.query.fieldSet);
                if (StringUtils.isEmpty((String)calcObj.schemeNum)) {
                    calcObj.schemeNum = bgScheme.getNumber();
                }
                if (StringUtils.isEmpty((String)calcObj.orgUnitNum)) {
                    calcObj.orgUnitNum = orgUnit.getNumber();
                }
                String exprKey = formulaExpr.toString();
                if (this.query != null && this.query.calcObjs.containsKey(exprKey)) {
                    Map expreObjs = (Map)this.query.calcObjs.get(exprKey);
                    List calcObjs = null;
                    Object[] obj = null;
                    HashSet<String> dimNumSet = new HashSet<String>();
                    HashSet<String> compareSet = new HashSet<String>();
                    String bgIndexNum = null;
                    String bgPeriodNum = null;
                    String currencyNum = null;
                    String acctExpr = null;
                    if (tmpStrs != null) {
                        int in = tmpStrs.length;
                        for (int i = 0; i < in; ++i) {
                            field = fieldIndexMap.get(i);
                            if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                                dimNumSet.add(tmpStrs[i]);
                                bgIndexNum = tmpStrs[i];
                                continue;
                            }
                            if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                                bgPeriodNum = tmpStrs[i];
                                continue;
                            }
                            if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(field)) {
                                currencyNum = tmpStrs[i];
                                continue;
                            }
                            if (DimUtils.checkBaseDimensionByField(field)) continue;
                            dimNumSet.add(tmpStrs[i]);
                        }
                    }
                    if (bgIndexNum == null) {
                        if (!StringUtils.isEmpty((String)itemParam) && itemParam != null) {
                            if (!"@|@".equals(itemParam) && itemParam.contains("|@")) {
                                bgIndexNum = itemParam.split("\\|")[0];
                                dimNumSet.add(bgIndexNum);
                                isIndex = true;
                            } else if ("@".endsWith(itemParam)) {
                                bgIndexNum = tmpTreeMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                                dimNumSet.add(bgIndexNum);
                            }
                        } else {
                            bgIndexNum = tmpTreeMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                            dimNumSet.add(bgIndexNum);
                        }
                    }
                    if (bgPeriodNum == null) {
                        bgPeriodNum = tmpTreeMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                    }
                    if (currencyNum == null) {
                        currencyNum = tmpTreeMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD);
                    }
                    Map.Entry entry = null;
                    Iterator citer = expreObjs.entrySet().iterator();
                    while (citer.hasNext() && calcObj.value == null) {
                        entry = citer.next();
                        acctExpr = (String)entry.getKey();
                        calcObjs = (List)entry.getValue();
                        int xn = calcObjs.size();
                        for (int x = 0; x < xn && calcObj.value == null; ++x) {
                            obj = (Object[])calcObjs.get(x);
                            if (checkItem && (!isIndex ? !this.getBgDimIndex(obj).equals(bgIndexNum) : !this.getBgDimIndex(obj).endsWith(bgIndexNum))) continue;
                            if ((bgPeriodNum != null || !obj[2].equals(defBgPeriodNumber)) && !obj[2].equals(bgPeriodNum) || currencyNum != null && !obj[3].equals(defCurrencyNumber) && !obj[3].equals(currencyNum)) continue;
                            if ("@|@".equals(itemParam)) {
                                if (obj[1] == null || StringUtils.isEmpty((String)((String)obj[1]))) continue;
                                compareSet.clear();
                                String[] _tmpDims = ((String)obj[1]).split(",");
                                int yn = _tmpDims.length;
                                for (int y = 0; y < yn; ++y) {
                                    if (_tmpDims[y].indexOf(":") <= 0) continue;
                                    compareSet.add(_tmpDims[y]);
                                }
                                if (!dimNumSet.containsAll(compareSet)) continue;
                                calcObj.express = acctExpr;
                                calcObj.value = (BigDecimal)obj[4];
                                continue;
                            }
                            calcObj.express = acctExpr;
                            calcObj.value = (BigDecimal)obj[4];
                        }
                    }
                } else if (StringUtils.isEmpty((String)calcObj.express)) {
                    calcObj.express = exprKey;
                }
                if (calcObj.value == null) {
                    calcObj.value = BigDecimal.ZERO;
                }
                context.setAttribute(key, calcObj.value, 100);
                checkGroup.add(calcObj);
                continue;
            }
            context.setAttribute(key, null, 100);
        }
        if (this.checkBizCalcObjs(checkGroup)) {
            boolean isFilter = true;
            if (filterSet != null) {
                String checkKey = null;
                int in = checkGroup.size();
                for (int i = 0; i < in; ++i) {
                    calcObj = (BizCalcObj)checkGroup.get(i);
                    checkKey = i == 0 ? calcObj.dimKey : checkKey + "-" + calcObj.dimKey;
                }
                if (checkKey != null && filterSet.contains(checkKey)) {
                    isFilter = false;
                } else {
                    filterSet.add(checkKey);
                }
            }
            String ifScriptEval = null;
            String ifScriptError = null;
            if (this.checkIF(this.script)) {
                String rightScript = this.getRightScript(this.script);
                String rightIfScript = this.getIfScript(this.script);
                String ifValueScript = this.getIfValueScript(rightIfScript, context);
                try {
                    Object reVal = engine.eval(ifValueScript, context);
                    if (reVal != null) {
                        String tmpScript = this.script;
                        tmpScript = tmpScript.replace(rightScript, reVal.toString());
                        ifScriptEval = this.getEvalScript(tmpScript);
                        ifScriptError = this.getErrorScript(tmpScript);
                    }
                }
                catch (ScriptException e) {
                    logger.error((Object)"script eval error:", (Throwable)e);
                    logger.error((Object)("script:" + this.script));
                    throw new BgExamineException(BgExamineException.SCRIPTERROR);
                }
            }
            if (isFilter) {
                try {
                    String evalScript = StringUtils.isEmpty(ifScriptEval) ? this.scriptEval : ifScriptEval;
                    String evalErrorScript = StringUtils.isEmpty(ifScriptError) ? this.scriptError : ifScriptError;
                    result = engine.eval(evalScript, context);
                    if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                        check = false;
                        result = engine.eval(evalErrorScript, context);
                        if (result instanceof Double) {
                            Double _double = (Double)result;
                            BigDecimal defaultLow = new BigDecimal("0.000000001");
                            if (this.isExamineIgnorePrecision != null && this.currencyInfo != null) {
                                int precision = this.currencyInfo.getPrecision();
                                defaultLow = new BigDecimal(Math.pow(10.0, -precision)).setScale(precision, 5);
                            }
                            if (!_double.isInfinite() && !_double.isNaN()) {
                                if (this.hasEquals && (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(_double)) == 0 || defaultLow.compareTo(BigDecimal.valueOf(_double).abs()) >= 0)) {
                                    check = true;
                                }
                                if (BigDecimal.ZERO.compareTo(this.subSetInfo.getErrorData()) != 0 && this.subSetInfo.getErrorData().compareTo(BigDecimal.valueOf(_double).abs()) >= 0) {
                                    check = true;
                                }
                            }
                        }
                        if (!check) {
                            checkResult = new BgExamineDataCheckResult();
                            checkResult.orgUnit = new String[]{orgUnit.getId().toString(), orgUnit.getNumber(), orgUnit.getName()};
                            checkResult.script = this.transIfElse(this.script);
                            checkResult.calcResult = this.getCalcResult(engine, context);
                            checkResult.getResult().add(this.getBizCalcObjs(checkGroup));
                            if (noPassType == 3) {
                                checkResult.check = true;
                            }
                            checkResults.add(checkResult);
                        }
                    }
                }
                catch (ScriptException ex) {
                    logger.error((Object)"script eval error:", (Throwable)ex);
                    logger.error((Object)("script:" + this.script));
                    throw new BgExamineException(BgExamineException.SCRIPTERROR);
                }
            }
        }
    }

    private List<String[]> combineArray(List<String[]> combins, Set<String> dimNumberSet) {
        ArrayList<String[]> dimNums = new ArrayList<String[]>();
        if (combins == null || dimNumberSet == null) {
            return dimNums;
        }
        ArrayList<String> dimNumberLst = new ArrayList<String>(dimNumberSet);
        Collections.sort(dimNumberLst);
        String[] tmpStrs = null;
        String[] copyStrs = null;
        if (combins.isEmpty()) {
            for (String dimNumber : dimNumberLst) {
                tmpStrs = new String[]{dimNumber};
                dimNums.add(tmpStrs);
            }
        } else {
            int in = combins.size();
            for (int i = 0; i < in; ++i) {
                tmpStrs = combins.get(i);
                for (String dimNumber : dimNumberLst) {
                    copyStrs = new String[tmpStrs.length + 1];
                    System.arraycopy(tmpStrs, 0, copyStrs, 0, tmpStrs.length);
                    copyStrs[tmpStrs.length] = dimNumber;
                    dimNums.add(copyStrs);
                }
            }
        }
        return dimNums;
    }

    private void queryMbgData(BizCalcObj calcObj, Map[] CMPDataMap) {
        Map orgDataMap;
        if (calcObj == null || CMPDataMap == null) {
            return;
        }
        Map schemeDataMap = null;
        schemeDataMap = CMPDataMap[BgProcessEnum.getEnum(calcObj.getBgProceeType()).getValue() - 1];
        if (schemeDataMap == null) {
            return;
        }
        if (schemeDataMap.containsKey(calcObj.schemeNum) && (orgDataMap = (Map)schemeDataMap.get(calcObj.schemeNum)) != null && orgDataMap.containsKey(calcObj.orgUnitNum)) {
            ICalcData calcData;
            Map dataMap = (Map)orgDataMap.get(calcObj.orgUnitNum);
            String dimKey = calcObj.getDimDataKey();
            if (dataMap != null && dataMap.containsKey(dimKey) && (calcData = (ICalcData)dataMap.get(dimKey)) != null) {
                calcObj.value = calcData.getValue();
            }
        }
    }

    private boolean checkBizCalcObjs(List<BizCalcObj> calcObjs) {
        if (calcObjs == null || calcObjs.isEmpty()) {
            return false;
        }
        int in = calcObjs.size();
        for (int i = 0; i < in; ++i) {
            if (calcObjs.get((int)i).value == null) continue;
            return true;
        }
        return true;
    }

    private BizCalcObj[] getBizCalcObjs(List<BizCalcObj> checkGroup) {
        if (checkGroup == null || checkGroup.isEmpty()) {
            return null;
        }
        BizCalcObj[] objs = new BizCalcObj[checkGroup.size()];
        int in = checkGroup.size();
        for (int i = 0; i < in; ++i) {
            objs[i] = checkGroup.get(i);
        }
        return objs;
    }

    private String[] getLeftAndRightScript(String script, ScriptContext context) {
        String[] rlScripts = null;
        if (this.checkIF(script)) {
            rlScripts = new String[]{this.getLeftScript(script), this.getIfScript(script)};
            rlScripts[1] = this.getIfValueScript(rlScripts[1], context);
        } else if (script.indexOf(">=") > 0) {
            rlScripts = script.split(">=");
        } else if (script.indexOf("<=") > 0) {
            rlScripts = script.split("<=");
        } else if (script.indexOf("==") > 0) {
            rlScripts = script.split("==");
        } else if (script.indexOf("!=") > 0) {
            rlScripts = script.split("!=");
        } else if (script.indexOf(">") > 0) {
            rlScripts = script.split(">");
        } else if (script.indexOf("<") > 0) {
            rlScripts = script.split("<");
        }
        return rlScripts;
    }

    private boolean checkCalc() {
        if (this.script == null) {
            return false;
        }
        return this.script.indexOf("+") > 0 || this.script.indexOf("-") > 0 || this.script.indexOf("*") > 0 || this.script.indexOf("/") > 0;
    }

    private Object[] getCalcResult(ScriptEngine engine, ScriptContext context) throws ScriptException {
        Object[] calcStr = null;
        String[] scriptArr = this.getLeftAndRightScript(this.script, context);
        if (scriptArr != null) {
            calcStr = new Object[2];
            this.checkNashornScriptEngine(scriptArr[0], engine, context);
            calcStr[0] = engine.eval(scriptArr[0], context);
            this.checkNashornScriptEngine(scriptArr[1], engine, context);
            calcStr[1] = engine.eval(scriptArr[1], context);
        }
        return calcStr;
    }

    private void checkNashornScriptEngine(String calcStr, ScriptEngine engine, ScriptContext context) {
        if (!this.isNashornScriptEngine(engine)) {
            return;
        }
        calcStr = calcStr.indexOf("(") >= 0 ? calcStr.replaceAll("\\(", ",") : calcStr;
        calcStr = calcStr.indexOf(")") >= 0 ? calcStr.replaceAll("\\)", ",") : calcStr;
        calcStr = calcStr.indexOf("+") >= 0 ? calcStr.replaceAll("\\+", ",") : calcStr;
        calcStr = calcStr.indexOf("-") >= 0 ? calcStr.replaceAll("\\-", ",") : calcStr;
        calcStr = calcStr.indexOf("*") >= 0 ? calcStr.replaceAll("\\*", ",") : calcStr;
        String[] strArr = (calcStr = calcStr.indexOf("/") >= 0 ? calcStr.replaceAll("\\/", ",") : calcStr).trim().split(",");
        if (strArr != null && strArr.length > 0) {
            HashSet<String> calcSet = new HashSet<String>();
            int in = strArr.length;
            for (int i = 0; i < in; ++i) {
                if (StringUtils.isEmpty((String)strArr[i])) continue;
                calcSet.add(strArr[i].toString());
            }
            Bindings bindings = context.getBindings(100);
            String name2 = null;
            Object value = null;
            if (!bindings.isEmpty()) {
                boolean isAllNull = true;
                for (String name2 : bindings.keySet()) {
                    value = bindings.get(name2);
                    if (!calcSet.contains(name2) || value == null) continue;
                    isAllNull = false;
                    break;
                }
                if (!isAllNull) {
                    for (String name2 : bindings.keySet()) {
                        value = bindings.get(name2);
                        if (!calcSet.contains(name2) || value != null) continue;
                        context.setAttribute(name2, BigDecimal.ZERO, 100);
                    }
                }
            }
        }
    }

    private boolean isNashornScriptEngine(ScriptEngine engine) {
        return engine.getClass().getName().indexOf("NashornScriptEngine") >= 0;
    }

    public String getBgDimIndex(Object[] obj) {
        String acctNum = obj[0].toString();
        String[] acctStrs = acctNum.split(",");
        return acctStrs[0];
    }

    public String dealYearWeek(String acct) {
        String result = null;
        String[] temp = acct.split(",");
        StringBuffer sb = new StringBuffer();
        temp[4] = "0";
        temp[6] = "0";
        for (int i = 0; i < temp.length; ++i) {
            sb.append(temp[i] + ",");
        }
        result = sb.toString();
        return result.subSequence(0, result.length() - 1).toString();
    }

    private String transIfElse(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            if (!this.avgStrs.isEmpty()) {
                String key2 = null;
                String value = null;
                for (String key2 : this.avgStrs.keySet()) {
                    value = this.avgStrs.get(key2);
                    str = str.replace(key2, value);
                }
            }
            if ((str = str.replace("MBR:", "")).indexOf("IF") >= 0) {
                str = str.replaceAll("IF", "if");
            }
            if (str.indexOf("ELSE") >= 0) {
                str = str.replaceAll("ELSE", "else");
            }
            if (str.indexOf("[") >= 0) {
                str = str.replaceAll("\\[", "\\(");
            }
            if (str.indexOf("]") >= 0) {
                str = str.replaceAll("\\]", "\\)");
            }
            if (str.indexOf("((") >= 0 && str.indexOf("))") >= 0) {
                str = str.replaceAll("\\(\\(", "\\(");
                str = str.replaceAll("\\)\\)", "\\)");
            }
        }
        return str;
    }

    private int getIndex(String tmpStr) {
        int index = -1;
        if (tmpStr.indexOf(">=") > 0) {
            index = tmpStr.indexOf(">=");
        } else if (tmpStr.indexOf("<=") > 0) {
            index = tmpStr.indexOf("<=");
        } else if (tmpStr.indexOf(">") > 0) {
            index = tmpStr.indexOf(">");
        } else if (tmpStr.indexOf("<") > 0) {
            index = tmpStr.indexOf("<");
        } else if (tmpStr.indexOf("==") > 0) {
            index = tmpStr.indexOf("==");
        } else if (tmpStr.indexOf("!=") > 0) {
            index = tmpStr.indexOf("!=");
        }
        return index;
    }

    private int getIfIndex(String script) {
        String tmpStr;
        int index = 0;
        if (script.indexOf("if") > 0) {
            index = script.indexOf("if");
        } else if (script.indexOf("IF") > 0) {
            index = script.indexOf("IF");
        }
        if (index > 0 && this.getIndex(tmpStr = script.substring(0, index)) > 0) {
            index = this.getIndex(tmpStr);
        }
        return index;
    }

    private String getIfScript(String script) {
        if (script.indexOf("if") < 0 && script.indexOf("IF") < 0) {
            return null;
        }
        int index = -1;
        String rightScript = script;
        if (this.checkIF(script)) {
            index = this.getIfIndex(rightScript);
        } else if (this.getIndex(rightScript) > 0) {
            index = this.getIndex(rightScript);
        }
        rightScript = rightScript.substring(index + 2);
        rightScript = org.apache.commons.lang.StringUtils.deleteWhitespace((String)rightScript);
        rightScript = this.transIfElse(rightScript);
        rightScript = rightScript.replace("else(", "else if(");
        rightScript = rightScript.replace("OR", " || ");
        rightScript = rightScript.replace("AND", " && ");
        rightScript = rightScript.replace("NOT", " !");
        rightScript = rightScript.replace("MBR:", "");
        rightScript = rightScript.replace("@MAx", " Math.max");
        rightScript = rightScript.replace("@Max", " Math.max");
        rightScript = rightScript.replace("@MIn", " Math.min");
        rightScript = rightScript.replace("@Min", " Math.min");
        rightScript = rightScript.replace("@ABs", " Math.abs");
        rightScript = rightScript.replace("@Abs", " Math.abs");
        return rightScript;
    }

    private String getRightScript(String script) {
        int index = -1;
        String rightScript = script;
        if (this.checkIF(script)) {
            index = this.getIfIndex(rightScript);
        } else if (this.getIndex(rightScript) > 0) {
            index = this.getIndex(rightScript);
        }
        rightScript = rightScript.substring(index + 2);
        return rightScript;
    }

    private String getIfValueScript(String ifScript, ScriptContext context) {
        String valueScript = ifScript;
        Bindings bindings = context.getBindings(100);
        String name2 = null;
        Object value = null;
        if (!bindings.isEmpty()) {
            for (String name2 : bindings.keySet()) {
                value = bindings.get(name2);
                if (value != null) {
                    valueScript = valueScript.replace(name2, value.toString());
                    continue;
                }
                valueScript = valueScript.replace(name2, "0");
            }
        }
        return valueScript;
    }

    private String getLeftScript(String script) {
        int index = -1;
        String leftScript = script;
        if (this.checkIF(script)) {
            index = this.getIfIndex(leftScript);
        } else if (this.getIndex(leftScript) > 0) {
            index = this.getIndex(leftScript);
        }
        leftScript = leftScript.substring(0, index);
        return leftScript;
    }

    private boolean checkIF(String str) {
        boolean hasIF = false;
        if (!StringUtils.isEmpty((String)str)) {
            return str.indexOf("if") > 0 || str.indexOf("IF") > 0;
        }
        return hasIF;
    }

    private void testIfElse(ScriptEngine engine, ScriptContext context) throws BgExamineException {
        String ss = "if(A>B){re = true;} else{re = false;}";
        String s1 = "if(B<0){re = B*(C+10)+999;} else{re = 999;}";
        String s2 = "if(B>=C){B*(C+10)+999;} else{999;}";
        String s7 = " if (B >= C) {D}else {E}";
        String s9 = "if(B>=C){B*(C+1);}else{B*(C-1);}";
        String s10 = "A >= (B >= C ? D : E)";
        String s11 = "A -(B >= C ? D : E)";
        String s12 = "A -(B >= C ? (D > 0 ? D : 0) : (E < 0 ? E : 0))";
        String s13 = "if (B == C) {H}else if (D == E + 1) {I + 1}else if(F == G + 2) {J + 2}else {K}";
        String s14 = "if (B == C) {H}else (D == E + 1) {I + 1}else (F == G + 2) {J + 2}else {K}";
        try {
            Object oo = engine.eval(ss, context);
            Object o1 = engine.eval(s1, context);
            Object o2 = engine.eval(s2, context);
            Object o7 = engine.eval(s7, context);
            Object o9 = engine.eval(s9, context);
            Object o10 = engine.eval(s10, context);
            Object o11 = engine.eval(s11, context);
            Object o12 = engine.eval(s12, context);
            Object o13 = engine.eval(s13, context);
            System.out.print(oo + "   " + o1 + "   " + o2);
        }
        catch (ScriptException e) {
            logger.error((Object)"script eval error:", (Throwable)e);
            logger.error((Object)("script:" + this.script));
            throw new BgExamineException(BgExamineException.SCRIPTERROR);
        }
    }
}

