/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.calctrace;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParse;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2RPN;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BizCalcTraceUtils {
    public static final String RES = "com.kingdee.eas.ma.mbg.BgFormMsgResource";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final int INDEX_NUMBER = 0;
    public static final int INDEX_NAME = 1;
    public static final int INDEX_ID = 2;

    public static StringBuffer getSpaces(int length) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            s.append(" ");
        }
        return s;
    }

    public static Map<String, String> getMemberNumByFormula(Map<String, String> srcFieldMap, String formula, String bgVersionNumber, boolean hasSrc) {
        TreeMap<String, String> numMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        String bgItemNumber = params[0];
        if (bgItemNumber.indexOf(",") > 0) {
            String[] memArr;
            for (String mem : memArr = bgItemNumber.split(",")) {
                if (mem.indexOf(":") <= 0) continue;
                String[] arrs = mem.split(":");
                if (hasSrc) {
                    numMap.put(srcFieldMap.get(arrs[0]), mem);
                    continue;
                }
                numMap.put(srcFieldMap.get(arrs[0]), arrs[1]);
            }
        } else if (bgItemNumber.indexOf(":") > 0) {
            String[] arrs = bgItemNumber.split(":");
            if (hasSrc) {
                numMap.put(srcFieldMap.get(arrs[0]), bgItemNumber);
            } else {
                numMap.put(srcFieldMap.get(arrs[0]), arrs[1]);
            }
        }
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER), params[1]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_ELEMENT_SRCNUMBER), params[2]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_CURRENCY_SRCNUMBER), params[5]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER), params[3]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER), bgVersionNumber);
        return numMap;
    }

    public static Map<String, Map<String, Set<String>>> reverseMap(Map<String, Map<String, Set<String>>> bizCalcRelationR2L) {
        HashMap<String, Map<String, Set<String>>> bizCalcRelationL2R = new HashMap<String, Map<String, Set<String>>>();
        for (String field : bizCalcRelationR2L.keySet()) {
            Map<String, Set<String>> tMap = bizCalcRelationR2L.get(field);
            if (!bizCalcRelationL2R.containsKey(field)) {
                bizCalcRelationL2R.put(field, new HashMap());
            }
            for (String rNumber : tMap.keySet()) {
                Set<String> tSet = tMap.get(rNumber);
                for (String lNumber : tSet) {
                    if (!((Map)bizCalcRelationL2R.get(field)).containsKey(lNumber)) {
                        ((Map)bizCalcRelationL2R.get(field)).put(lNumber, new HashSet());
                    }
                    ((Set)((Map)bizCalcRelationL2R.get(field)).get(lNumber)).add(rNumber);
                }
            }
        }
        return bizCalcRelationL2R;
    }

    public static Map<String, Map<String, Set<String>>> bizCaclRelation(Map<String, String> srcFieldMap, Map<String, Map<String, Set<String>>> refNumLeftMap, Map<String, Map<String, Set<String>>> refNumRightMap, BinaryExpr expre) {
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        if (expre != null) {
            refNumLeftMap.clear();
            refNumRightMap.clear();
            BizCalcTraceUtils.putMbgMember(expre.left, refNumLeftMap, srcFieldMap);
            BizCalcTraceUtils.putMbgMember(expre.right, refNumRightMap, srcFieldMap);
        }
        return result;
    }

    public static void putMbgMember(IExpress expr, Map<String, Map<String, Set<String>>> refDimMap, Map<String, String> srcFieldMap) {
        if (expr == null || refDimMap == null || srcFieldMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            BizCalcTraceUtils.putMbgMember((BinaryExpr)expr, refDimMap, srcFieldMap, false);
        } else if (expr instanceof ConditionExpr) {
            BizCalcTraceUtils.putMbgMember((ConditionExpr)expr, refDimMap, srcFieldMap, false);
        } else if (expr instanceof MdxMemberExpr) {
            BizCalcTraceUtils.putMbgMember((MdxMemberExpr)expr, refDimMap, srcFieldMap, false);
        } else if (expr instanceof FunctionExpr) {
            BizCalcTraceUtils.putMbgMember((FunctionExpr)expr, refDimMap, srcFieldMap, false);
        } else if (expr instanceof MemberExpr) {
            BizCalcTraceUtils.putMbgMember((MemberExpr)expr, refDimMap, srcFieldMap);
        }
    }

    public static void putMbgMember(BinaryExpr expr, Map<String, Map<String, Set<String>>> refDimMap, Map<String, String> srcFieldMap, boolean isLeaf) {
        if (expr == null || refDimMap == null || srcFieldMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            BizCalcTraceUtils.putMbgMember((BinaryExpr)expr.left, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.left instanceof MdxMemberExpr) {
            if ("=".equals(expr.operType != null ? expr.operType.toString() : null)) {
                BizCalcTraceUtils.putMbgMember((MdxMemberExpr)expr.left, refDimMap, srcFieldMap, true);
            } else {
                BizCalcTraceUtils.putMbgMember((MdxMemberExpr)expr.left, refDimMap, srcFieldMap, false);
            }
        } else if (expr.left instanceof VariateExpr) {
            BizCalcTraceUtils.putMbgMember((VariateExpr)expr.left, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.left instanceof FunctionExpr) {
            BizCalcTraceUtils.putMbgMember((FunctionExpr)expr.left, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.left instanceof ConditionExpr) {
            BizCalcTraceUtils.putMbgMember((ConditionExpr)expr.left, refDimMap, srcFieldMap, isLeaf);
        }
        if (expr.right instanceof BinaryExpr) {
            BizCalcTraceUtils.putMbgMember((BinaryExpr)expr.right, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.right instanceof MdxMemberExpr) {
            BizCalcTraceUtils.putMbgMember((MdxMemberExpr)expr.right, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.right instanceof VariateExpr) {
            BizCalcTraceUtils.putMbgMember((VariateExpr)expr.right, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.right instanceof FunctionExpr) {
            BizCalcTraceUtils.putMbgMember((FunctionExpr)expr.right, refDimMap, srcFieldMap, isLeaf);
        } else if (expr.right instanceof ConditionExpr) {
            BizCalcTraceUtils.putMbgMember((ConditionExpr)expr.right, refDimMap, srcFieldMap, isLeaf);
        }
    }

    public static void putMbgMember(ConditionExpr expr, Map<String, Map<String, Set<String>>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeaf) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        for (IExpress _expr : expr.getAllExpresss()) {
            if (_expr instanceof BinaryExpr) {
                BizCalcTraceUtils.putMbgMember((BinaryExpr)_expr, dimMemberMap, srcFieldMap, isLeaf);
                continue;
            }
            if (_expr instanceof ConditionExpr) {
                BizCalcTraceUtils.putMbgMember((ConditionExpr)_expr, dimMemberMap, srcFieldMap, isLeaf);
                continue;
            }
            if (_expr instanceof MdxMemberExpr) {
                BizCalcTraceUtils.putMbgMember((MdxMemberExpr)_expr, dimMemberMap, srcFieldMap, isLeaf);
                continue;
            }
            if (!(_expr instanceof FunctionExpr)) continue;
            BizCalcTraceUtils.putMbgMember((FunctionExpr)_expr, dimMemberMap, srcFieldMap, isLeaf);
        }
    }

    public static void putMbgMember(FunctionExpr expr, Map<String, Map<String, Set<String>>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeaf) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        Object param = null;
        String[] params = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            param = expr.params.get(i);
            if (param instanceof FunctionExpr) {
                BizCalcTraceUtils.putMbgMember((FunctionExpr)param, dimMemberMap, srcFieldMap, isLeaf);
                continue;
            }
            if (param instanceof MdxMemberExpr) {
                BizCalcTraceUtils.putMbgMember((MdxMemberExpr)param, dimMemberMap, srcFieldMap, isLeaf);
                continue;
            }
            if (param instanceof MemberExpr) {
                BizCalcTraceUtils.putMbgMember((MemberExpr)param, dimMemberMap, srcFieldMap);
                continue;
            }
            if (param instanceof VariateExpr) {
                BizCalcTraceUtils.putMbgMember((NameExpr)((VariateExpr)param), dimMemberMap, srcFieldMap);
                continue;
            }
            if (param instanceof BinaryExpr) {
                BizCalcTraceUtils.putMbgMember((BinaryExpr)param, dimMemberMap, srcFieldMap, isLeaf);
                continue;
            }
            if ("ABS".equals(expr.functionName) && param.toString().indexOf("MBR") != -1) {
                try {
                    Parse2RPN parse = null;
                    IExpress expr1 = null;
                    parse = new Parse2RPN(param.toString());
                    parse.parse();
                    MbgExprParse p2 = new MbgExprParse(parse.getTokens());
                    expr1 = p2.parse();
                    BizCalcTraceUtils.putMbgMember(expr1, dimMemberMap, srcFieldMap);
                }
                catch (Exception parse) {}
                continue;
            }
            if ("MAX".equals(expr.functionName) || "MIN".equals(expr.functionName) || "AVG".equals(expr.functionName) || "IsMember".equals(expr.functionName)) {
                String memNum = param.toString();
                if (memNum.indexOf(":") == -1) continue;
                String srcNumber = memNum.substring(memNum.indexOf("[") + 1, memNum.indexOf("]"));
                String[] numbers = srcNumber.split(":");
                if (!dimMemberMap.containsKey(expr.toString())) {
                    dimMemberMap.put(expr.toString(), new HashMap());
                }
                BizCalcTraceUtils.putDimNumber(srcFieldMap.get(numbers[0]), srcNumber, dimMemberMap.get(expr.toString()));
                continue;
            }
            if (!dimMemberMap.containsKey(expr.toString())) {
                dimMemberMap.put(expr.toString(), new HashMap());
            }
            params = param.toString().replace("\"", "").split(":");
            BizCalcTraceUtils.putDimNumber(srcFieldMap.get(params[0]), param.toString().replace("\"", ""), dimMemberMap.get(expr.toString()));
        }
    }

    public static void putMbgMember(VariateExpr expr, Map<String, Map<String, Set<String>>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeaf) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        if (expr.expr != null) {
            BizCalcTraceUtils.putMbgMember(expr.expr, dimMemberMap, srcFieldMap, isLeaf);
        }
    }

    public static void putMbgMember(MdxMemberExpr expr, Map<String, Map<String, Set<String>>> refDimMap, Map<String, String> srcFieldMap, boolean isLeft) {
        int i;
        if (expr == null || refDimMap == null || srcFieldMap == null) {
            return;
        }
        IExpress param = null;
        String dimNumber = null;
        int in = expr.params.size();
        for (i = 0; i < in; ++i) {
            param = (IExpress)expr.params.get(i);
            if (!(param instanceof MemberExpr) || ((MemberExpr)param).field != null) continue;
            ((MemberExpr)param).field = srcFieldMap.get(((MemberExpr)param).srcNumber);
        }
        in = expr.params.size();
        for (i = 0; i < in; ++i) {
            param = (IExpress)expr.params.get(i);
            if (param instanceof MemberExpr) {
                if (((MemberExpr)param).field == null) {
                    ((MemberExpr)param).field = srcFieldMap.get(((MemberExpr)param).srcNumber);
                }
                dimNumber = ((MemberExpr)param).getDimNumber();
                if ((DimUtils.checkBaseDimensionByField(((MemberExpr)param).field) || DimensionConstants.DEF_CSL_FIELD.equals(((MemberExpr)param).field) || DimensionConstants.DEF_PROCESS_FIELD.equals(((MemberExpr)param).field)) && dimNumber.indexOf("@") == -1) {
                    dimNumber = DimUtils.getNumber(dimNumber);
                }
                if (!refDimMap.containsKey(expr.toString())) {
                    refDimMap.put(expr.toString(), new HashMap());
                }
                BizCalcTraceUtils.putDimNumber(((MemberExpr)param).field, ((MemberExpr)param).getDimNumber(), refDimMap.get(expr.toString()));
                continue;
            }
            if (!(expr.params.get(i) instanceof FunctionExpr)) continue;
            BizCalcTraceUtils.putMbgMember((FunctionExpr)param, refDimMap, srcFieldMap, isLeft);
        }
    }

    public static void putMbgMember(MemberExpr expr, Map<String, Map<String, Set<String>>> dimMemberMap, Map<String, String> srcFieldMap) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        MemberExpr param = expr;
        if (expr.field == null) {
            param.field = srcFieldMap.get(param.srcNumber);
        }
        if (!dimMemberMap.containsKey(expr.toString())) {
            dimMemberMap.put(expr.toString(), new HashMap());
        }
        BizCalcTraceUtils.putDimNumber(param.field, param.getDimNumber(), dimMemberMap.get(expr.toString()));
    }

    public static void putMbgMember(NameExpr expr, Map<String, Map<String, Set<String>>> dimMemberMap, Map<String, String> srcFieldMap) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        String dimNumber = BizExprUtils.getDimMemByScopeFunction((String)expr.toString());
        String srcNumber = DimUtils.getSrcNumber(dimNumber);
        String refField = srcFieldMap.get(srcNumber);
        if (!dimMemberMap.containsKey(expr.toString())) {
            dimMemberMap.put(expr.toString(), new HashMap());
        }
        BizCalcTraceUtils.putDimNumber(refField, dimNumber, dimMemberMap.get(expr.toString()));
    }

    public static void putDimNumber(String field, String dimNumber, Map<String, Set<String>> dimMemberMap) {
        if (field == null || dimNumber == null || dimMemberMap == null) {
            return;
        }
        String _dimNumber = dimNumber;
        if ((DimUtils.checkBaseDimensionByField(field) || DimensionConstants.DEF_CSL_FIELD.equals(field) || DimensionConstants.DEF_PROCESS_FIELD.equals(field)) && _dimNumber.indexOf("@") == -1) {
            _dimNumber = DimUtils.getNumber(_dimNumber);
        }
        Set<Object> dimNumSet = null;
        if (dimMemberMap.containsKey(field)) {
            dimNumSet = dimMemberMap.get(field);
        } else {
            dimNumSet = new HashSet();
            dimMemberMap.put(field, dimNumSet);
        }
        if (dimNumSet != null) {
            dimNumSet.add(_dimNumber);
        }
    }

    public static Map<String, Map<String, Set<String>>> parseFormDimData(Context ctx, BgSchemeInfo schemeInfo, List<IDimDataQuery> billValues, Map<String, String> srcFieldMap) throws Exception {
        HashMap<String, Map<String, Set<String>>> formDataMap = new HashMap<String, Map<String, Set<String>>>();
        if (ctx == null || schemeInfo == null || billValues == null || billValues.isEmpty()) {
            return formDataMap;
        }
        Map<String, Set<String>> formDimMap = null;
        Set<String> dimNumSet = null;
        HashMap<String, Map<String, String[]>> dimDataInfoMap = new HashMap<String, Map<String, String[]>>();
        Map<String, String[]> dataInfoMap = null;
        IMbgViewBase view = null;
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        String field = null;
        String billId = null;
        String[] tmpStrs = null;
        for (IDimDataQuery model : billValues) {
            Map<String, String[]> spMbgDimMap;
            view = model.getView(ctx, schemeInfo);
            billId = model.getId().toString();
            if (formDataMap.containsKey(billId)) {
                formDimMap = (Map)formDataMap.get(billId);
            } else {
                formDimMap = new HashMap();
                formDataMap.put(billId, formDimMap);
            }
            int periodType = model.getBizPeriod().getPeriodType().getValue();
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = view.getSheetManagers().get(i).getDimensionManager();
                    if (manager == null) continue;
                    if (manager instanceof MbgViewListDimensionManager) {
                        DimUtils.transMbgDimMember((MbgViewListDimensionManager)manager);
                    }
                    for (int j = 0; j < manager.getDimension().size(); ++j) {
                        int x;
                        int xn;
                        if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo) || DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j)).getNumber())) continue;
                        if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimInfo.getNumber())) {
                            if (dimInfo.getMember().isEmpty()) {
                                member = new BgDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, DimensionBaseConstants.DEF_VERSION_FIELD, model.getBizVersion().getName(), model.getBizVersion().getNumber());
                                dimInfo.getMember().add(member);
                            }
                        } else if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimInfo.getNumber())) {
                            if (dimInfo.getMember().isEmpty()) {
                                member = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD, model.getBizPeriod().getName(), model.getBizPeriod().getNumber());
                                dimInfo.getMember().add(member);
                            }
                        } else if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(dimInfo.getNumber()) && dimInfo.getMember().isEmpty()) {
                            member = new BgDimensionMember(DimensionConstants.DEF_CURRENCY_NUMBER, DimensionBaseConstants.DEF_CURRENCY_FIELD, model.getBizCurrency().getName(), model.getBizCurrency().getNumber());
                            dimInfo.getMember().add(member);
                        }
                        if (formDimMap.containsKey(field = DimUtils.getDimensionField(dimInfo))) {
                            dimNumSet = (Set)formDimMap.get(field);
                        } else {
                            dimNumSet = new HashSet();
                            formDimMap.put(field, dimNumSet);
                        }
                        if (dimDataInfoMap.containsKey(field)) {
                            dataInfoMap = (Map)dimDataInfoMap.get(field);
                        } else {
                            dataInfoMap = new HashMap();
                            dimDataInfoMap.put(field, dataInfoMap);
                        }
                        List memList = dimInfo.getMember();
                        if (memList == null || memList.isEmpty()) continue;
                        BgDimensionMember dimensionMember = null;
                        if (DimUtils.checkBaseDimension(dimInfo)) {
                            xn = memList.size();
                            for (x = 0; x < xn; ++x) {
                                dimensionMember = (BgDimensionMember)memList.get(x);
                                tmpStrs = new String[]{dimensionMember.getNumber(), dimensionMember.getName()};
                                if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimInfo.getNumber())) {
                                    tmpStrs[0] = BgPeriodNVariableHelper.getBgPeriodByN((String)model.getBizPeriod().getNumber(), (String)dimensionMember.getNumber(), (int)periodType);
                                }
                                dimNumSet.add(tmpStrs[0]);
                                dataInfoMap.put(tmpStrs[0], tmpStrs);
                            }
                            continue;
                        }
                        xn = memList.size();
                        for (x = 0; x < xn; ++x) {
                            dimensionMember = (BgDimensionMember)memList.get(x);
                            tmpStrs = new String[]{DimUtils.getDimNumber(dimensionMember.getSrcNumber(), dimensionMember.getNumber()), dimensionMember.getName()};
                            dimNumSet.add(tmpStrs[0]);
                            dataInfoMap.put(tmpStrs[0], tmpStrs);
                        }
                    }
                }
            }
            if ((spMbgDimMap = model.getSpItems(srcFieldMap)) != null && !spMbgDimMap.isEmpty()) {
                Map.Entry<String, String[]> entry2 = null;
                for (Map.Entry<String, String[]> entry2 : spMbgDimMap.entrySet()) {
                    field = entry2.getKey();
                    tmpStrs = entry2.getValue();
                    if (formDimMap.containsKey(field)) {
                        dimNumSet = (Set)formDimMap.get(field);
                    } else {
                        dimNumSet = new HashSet();
                        formDimMap.put(field, dimNumSet);
                    }
                    if (dimDataInfoMap.containsKey(field)) {
                        dataInfoMap = (Map)dimDataInfoMap.get(field);
                    } else {
                        dataInfoMap = new HashMap();
                        dimDataInfoMap.put(field, dataInfoMap);
                    }
                    if (DimUtils.checkBaseDimensionByField(field) && tmpStrs[0].indexOf(":") > 0) {
                        dimNumSet.add(DimensionFormulaHelper.getMemberNumber(tmpStrs[0]));
                        dataInfoMap.put(DimensionFormulaHelper.getMemberNumber(tmpStrs[0]), tmpStrs);
                        continue;
                    }
                    dimNumSet.add(tmpStrs[0]);
                    dataInfoMap.put(tmpStrs[0], tmpStrs);
                }
            }
            if ((dimNumSet = (HashSet<String>)formDimMap.get(DimensionBaseConstants.DEF_VERSION_FIELD)) == null) {
                dimNumSet = new HashSet<String>();
            }
            dimNumSet.clear();
            dimNumSet.add(model.getBizVersion().getNumber());
        }
        return formDataMap;
    }

    public static Map<String, Map<String, BgDimensionMember>> queryMembersName(Context ctx, Map<String, Set<String>> allDimNumbers, String orgUnitId, String bgSchemeId) throws EASBizException, BOSException {
        HashMap<String, Map<String, BgDimensionMember>> result = new HashMap<String, Map<String, BgDimensionMember>>();
        if (ctx == null || allDimNumbers == null || allDimNumbers.isEmpty() || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgSchemeId)) {
            return result;
        }
        IDimensionFormulaFacade iDimensionFormulaFacade = DimensionFormulaFacadeFactory.getLocalInstance(ctx);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        Map<String, BgDimensionInfo> dimsMap = schemeHelper.getDimensionByRefField();
        String dimNumber = null;
        String field2 = null;
        Set<String> memberNums = null;
        HashSet<String> querySet = null;
        Map membersMap = null;
        for (String field2 : allDimNumbers.keySet()) {
            if (!dimsMap.containsKey(field2)) continue;
            dimNumber = dimsMap.get(field2).getNumber();
            memberNums = allDimNumbers.get(field2);
            querySet = new HashSet<String>();
            if (DimUtils.checkBaseDimension(dimNumber)) {
                querySet.addAll(memberNums);
            } else {
                for (String memberNum : memberNums) {
                    if (memberNum.indexOf(":") != 3) continue;
                    querySet.add(memberNum.substring(4, memberNum.length()));
                }
            }
            membersMap = iDimensionFormulaFacade.queryMembers(orgUnitId, bgSchemeId, dimNumber, querySet);
            result.put(field2, membersMap);
        }
        return result;
    }
}

