/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.control.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.control.client.MbgAvlBalDetailUI;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.client.AbstractBgAdjustCheckReportUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgAdjustCheckReportUI
extends AbstractBgAdjustCheckReportUI {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_STR = "com.kingdee.eas.ma.mbg.client.BgAdjustCheckResource";
    private static final Logger logger = Logger.getLogger(BgAdjustCheckReportUI.class);
    protected static final String COL_seq = "seq";
    protected static final String COL_org = "org";
    protected static final String COL_bgSubjectMember = "bgSubjectMember";
    protected static final String COL_dimMemberHelper = "dimMemberHelper";
    protected static final String COL_currency = "currency";
    protected static final String COL_bgScene = "bgScene";
    protected static final String COL_actScena = "actScena";
    protected static final String COL_bgElement = "bgElement";
    protected static final String COL_periodClassification = "periodClassification";
    protected static final String COL_period = "period";
    protected static final String COL_balance = "balance";
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    Map<String, Integer> colWidth = new LinkedHashMap<String, Integer>();

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    @Override
    public void onLoad() throws Exception {
        this.getCellHelper().init();
        super.onLoad();
    }

    protected Map<String, Integer> getColWidth() {
        if (this.colWidth.isEmpty()) {
            this.colWidth.put(COL_seq, 35);
            this.colWidth.put(COL_org, 120);
            this.colWidth.put(COL_bgSubjectMember, 90);
            this.colWidth.put(COL_dimMemberHelper, 120);
            this.colWidth.put(COL_currency, 70);
            this.colWidth.put(COL_bgScene, 70);
            this.colWidth.put(COL_actScena, 70);
            this.colWidth.put(COL_bgElement, 70);
            this.colWidth.put(COL_periodClassification, 120);
            this.colWidth.put(COL_period, 120);
            this.colWidth.put(COL_balance, 120);
        }
        return this.colWidth;
    }

    @Override
    protected void initTable() {
        int rowCount = 6;
        int colCount = this.getColWidth().size();
        this.tblMain.checkParsed(true);
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.setRefresh(false);
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.addRows(rowCount);
        this.tblMain.addColumns(colCount);
        this.tblMain.addHeadRow();
        int index = 0;
        for (String colKey : this.getColWidth().keySet()) {
            this.tblMain.getColumn(index).setKey(colKey);
            this.tblMain.getColumn(index).setWidth(this.getColWidth().get(colKey).intValue());
            ++index;
        }
        this.tblMain.setRefresh(true);
        this.tblMain.checkParsed(true);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    @Override
    protected void btnBudgetMsg_actionPerformed(ActionEvent e) throws Exception {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null || row.getUserObject() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        BgControlParam controlParam = (BgControlParam)row.getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put(BgControlParam.class, (Object)controlParam);
        uiContext.put((Object)"isLoadTransitBudget", (Object)false);
        uiContext.put((Object)"isCtrl", (Object)Boolean.TRUE);
        uiContext.put((Object)"balTypeEnum", (Object)BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgAvlBalDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void loadBgExamineCheckData() {
        this.tblMain.getCell(0, 1).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"title"));
        this.tblMain.getCell(1, 1).setValue((Object)(EASResource.getString((String)DEFAULT_STR, (String)"user") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        this.tblMain.getCell(2, 1).setValue((Object)(EASResource.getString((String)DEFAULT_STR, (String)"time") + BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date())));
        this.tblMain.getMergeManager().mergeBlock(0, 0, 0, 1);
        this.tblMain.getMergeManager().mergeBlock(1, 0, 1, 2);
        this.tblMain.getMergeManager().mergeBlock(2, 0, 2, 2);
        this.tblMain.getMergeManager().mergeBlock(3, 0, 3, 1);
        this.tblMain.getCell(4, 0).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"budgetAdjustCheckCantPassIsThisReason"));
        this.tblMain.getMergeManager().mergeBlock(4, 0, 4, 6);
        for (String colKey : this.getColWidth().keySet()) {
            this.tblMain.getCell(5, colKey).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)colKey));
        }
        if (this.getUIContext().get("adjustData") != null && this.getUIContext().get("adjustData") instanceof List) {
            List adjustData = (List)this.getUIContext().get("adjustData");
            Map<String, Map<String, String>> combinNames = null;
            try {
                combinNames = DimensionFormulaHelper.queryCombinNames(null, adjustData, true);
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            String indexName = null;
            String orgUnitId = null;
            String companyId = null;
            String bgSchemeId = null;
            IRow row = null;
            for (int i = 0; i < adjustData.size(); ++i) {
                BgControlParam data = (BgControlParam)adjustData.get(i);
                row = this.tblMain.addRow();
                row.getCell(COL_seq).setValue((Object)(i + 1 + ""));
                row.getCell(COL_org).setValue((Object)data.getOrgUnit());
                bgSchemeId = data.getBgSchemeInfo().getId().toString();
                indexName = BgControlParam.getName((String)bgSchemeId, combinNames, (String)data.getBgIndexNumber(), (BgControlParam)data);
                orgUnitId = data.getOrgUnit().getId().toString();
                String accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme(data.getBgSchemeInfo());
                if (accountViewId != null) {
                    row.getCell(COL_bgSubjectMember).setValue((Object)this.getCellHelper().getIndexDisplayName(accountViewId, data.getBgIndexNumber(), indexName));
                } else {
                    row.getCell(COL_bgSubjectMember).setValue((Object)(data.getBgIndexNumber() + "(" + indexName + ")"));
                }
                String[] dimNums = data.getDimItemNumber().split(",");
                StringBuffer dimItemNames = new StringBuffer();
                int jn = dimNums.length;
                for (int j = 0; j < jn; ++j) {
                    String dimItemName = BgControlParam.getName((String)bgSchemeId, combinNames, (String)dimNums[j], (BgControlParam)data);
                    dimItemNames.append(dimItemName).append(",");
                }
                dimItemNames.delete(dimItemNames.lastIndexOf(","), dimItemNames.length());
                data.setDimItemName(dimItemNames.toString());
                String extName = BgControlParam.getExtName((String)bgSchemeId, combinNames, (BgControlParam)data);
                String extRefField = BgControlParam.getExtRefField((BgControlParam)data);
                String extNumber = BgControlParam.getExtNumber((BgControlParam)data);
                if (!StringUtils.isEmpty((String)extNumber)) {
                    String[] numbers = extNumber.split(",");
                    StringBuilder srcnumbers = new StringBuilder();
                    StringBuilder elementNumbers = new StringBuilder();
                    for (int j = 0; j < numbers.length; ++j) {
                        String[] split = numbers[j].split(":");
                        if (split.length != 2) {
                            return;
                        }
                        srcnumbers.append(split[0]).append(",");
                        elementNumbers.append(split[1]).append(",");
                    }
                    String memberSrcNumber = srcnumbers.deleteCharAt(srcnumbers.lastIndexOf(",")).toString();
                    String memberNumbers = elementNumbers.deleteCharAt(elementNumbers.lastIndexOf(",")).toString();
                    BgDimensionMember combinNumbers = new BgDimensionMember(null, extRefField, extName, memberNumbers);
                    combinNumbers.setSrcNumber(memberSrcNumber);
                    row.getCell(COL_dimMemberHelper).setValue((Object)this.getCellHelper().getIndexDisplayName(companyId, extNumber, extName));
                    row.getCell(COL_dimMemberHelper).setUserObject((Object)combinNumbers);
                }
                row.getCell(COL_currency).setValue((Object)data.getCurrency());
                row.getCell(COL_bgElement).setValue((Object)data.getBgElement());
                row.getCell(COL_bgScene).setValue((Object)data.getBgScenario().getName());
                row.getCell(COL_actScena).setValue((Object)data.getAcScenario().getName());
                row.getCell(COL_periodClassification).setValue((Object)data.getBgPeriodGroup().getName());
                row.getCell(COL_period).setValue((Object)data.getBgPeriodName());
                row.getCell(COL_balance).setValue((Object)(data.getExtBalance() != null ? data.getExtBalance() : data.getOrignBalance()));
                int precision = 2;
                if (data.getCurrency() != null) {
                    precision = data.getCurrency().getPrecision();
                }
                String numberFormat = "###,###." + BgNFSHelper.getNumberFormat("0", precision);
                row.getCell(COL_balance).getStyleAttributes().setNumberFormat(numberFormat);
                row.setUserObject((Object)data);
            }
            this.tblMain.getColumn(COL_balance).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    protected void initUserConfig() {
        super.initUserConfig();
        PopupMenuManager tm = this.getPopupMenuManager((JComponent)this.tblMain);
        tm.removeMenuSection("edit");
        tm.removeMenuSection("addition");
        tm.removeMenuSection("export");
        tm.removeMenuSection("send");
        tm.removeMenuSection("table");
    }
}

