/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgAdjustRuleEntryInfo;
import com.kingdee.eas.ma.mbg.BgAdjustRuleFactory;
import com.kingdee.eas.ma.mbg.BgAdjustRuleInfo;
import com.kingdee.eas.ma.mbg.BgAdjustRuleStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgAdjustRule;
import com.kingdee.eas.ma.mbg.client.AbstractBgAdjustRuleEditUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustRuleListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustRuleEditUI
extends AbstractBgAdjustRuleEditUI {
    private static final long serialVersionUID = -8787861100533870810L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustRuleEditUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgAdjustRuleResource";
    protected static final String COL_BGORGUNIT = "bgOrgUnit";
    protected static final String COL_BGACCOUNT = "bgAccount";
    private BgSchemeInfo bgSchemeInfo = null;
    protected BgSchemeDimensionHelper schemeHelper = null;

    public BgSchemeInfo getBgSchemeInfo() {
        if (this.bgSchemeInfo == null && this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            this.bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        }
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null && this.getBgSchemeInfo() != null) {
            try {
                this.schemeHelper = new BgSchemeDimensionHelper(this.getBgSchemeInfo().getId().toString());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.beforeOnLoad();
        super.onLoad();
        this.txtNumber.requestFocus();
    }

    public void afterShow() {
        this.txtNumber.requestFocus();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.afterShow();
    }

    protected void beforeOnLoad() {
        if (this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO) instanceof BgSchemeInfo) {
            this.setBgSchemeInfo((BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO));
            this.prmtBgScheme.setData((Object)this.getBgSchemeInfo());
        }
        this.textAreaNode.setText(this.getString("node1"));
        this.textAreaNode.setToolTipText(this.getString("node1"));
        this.initF7();
        this.initEntryTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddOneLine.setEnabled(false);
            this.btnCopyOneLine.setEnabled(false);
            this.btnDelSelectLine.setEnabled(false);
        }
    }

    protected void initF7() {
        this.prmtBgScenario.setEditable(false);
        this.prmtBgElement.setEditable(false);
        this.prmtBgVersion.setEditable(false);
        this.prmtCurrency.setEditable(false);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgScenario.setSelector((KDPromptSelector)this.getDimensionMemberSelectDialog(DimensionConstants.DEF_SCENARIO_NUMBER));
        this.prmtBgElement.setSelector((KDPromptSelector)this.getDimensionMemberSelectDialog(DimensionConstants.DEF_ELEMENT_NUMBER));
        this.prmtBgVersion.setSelector((KDPromptSelector)this.getDimensionMemberSelectDialog(DimensionConstants.DEF_VERSION_NUMBER));
        this.prmtCurrency.setSelector((KDPromptSelector)this.getDimensionMemberSelectDialog(DimensionConstants.DEF_CURRENCY_NUMBER));
        this.prmtBgPeriod.setSelector((KDPromptSelector)this.getDimensionMemberSelectDialog(DimensionConstants.DEF_PERIOD_NUMBER));
    }

    protected DimensionMemberSelectDialog getDimensionMemberSelectDialog(String dimNumber) {
        DimensionMemberSelectDialog dialog = new DimensionMemberSelectDialog();
        dialog.setDimension(this.getSchemeHelper().getDimension(dimNumber));
        dialog.setOwner((Component)((Object)this));
        dialog.setMulti(true);
        dialog.setOnlySelectItem(true);
        dialog.setSelectCombinItem(false);
        dialog.setOnlyRefDim(false);
        dialog.setQingAnalyse(false);
        dialog.setCanSelectType(false);
        dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        dialog.setOrgUnit(this.getBgSchemeInfo().getOrgUnit());
        dialog.setOrgId(this.getBgSchemeInfo().getOrgUnit().getId().toString());
        dialog.setBgPeriodBeginDate(this.getBgSchemeInfo().getDateFrom());
        dialog.setBgPeriodEndDate(this.getBgSchemeInfo().getDateTo());
        dialog.setFilterRollVersion(true);
        dialog.setShowOuSealup(false);
        return dialog;
    }

    protected void initEntryTable() {
        List<String> dimNumbers;
        if (this.getSchemeHelper() != null && !(dimNumbers = this.getSchemeHelper().getAccAndOtherDim(true)).isEmpty()) {
            LinkedHashMap<String, BgDimensionInfo> dimensions = this.getSchemeHelper().getDimensions();
            String dimNumber = null;
            BgDimensionInfo dimension = null;
            IColumn column = null;
            for (int i = 0; i < dimNumbers.size(); ++i) {
                dimNumber = dimNumbers.get(i);
                dimension = dimensions.get(dimNumber);
                column = this.getDetailTable().addColumn();
                column.setKey(dimNumber);
                column.setWidth(200);
                this.getDetailTable().getHeadRow(0).getCell(dimNumber).setValue((Object)dimension.getName());
            }
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (this.editData != null) {
            List members = null;
            MbgViewListResultData data = null;
            if (this.editData.getBgScenarios() != null && (members = (List)BgAnalyseHelper.getObject(this.editData.getBgScenarios())) != null && !members.isEmpty()) {
                data = new MbgViewListResultData();
                data.setMembers(members);
                this.prmtBgScenario.setData((Object)data);
            }
            if (this.editData.getBgElements() != null && (members = (List)BgAnalyseHelper.getObject(this.editData.getBgElements())) != null && !members.isEmpty()) {
                data = new MbgViewListResultData();
                data.setMembers(members);
                this.prmtBgElement.setData((Object)data);
            }
            if (this.editData.getCurrencys() != null && (members = (List)BgAnalyseHelper.getObject(this.editData.getCurrencys())) != null && !members.isEmpty()) {
                data = new MbgViewListResultData();
                data.setMembers(members);
                this.prmtCurrency.setData((Object)data);
            }
            if (this.editData.getBgVersions() != null && (members = (List)BgAnalyseHelper.getObject(this.editData.getBgVersions())) != null && !members.isEmpty()) {
                data = new MbgViewListResultData();
                data.setMembers(members);
                this.prmtBgVersion.setData((Object)data);
            }
            if (this.editData.getBgPeriods() != null && (members = (List)BgAnalyseHelper.getObject(this.editData.getBgPeriods())) != null && !members.isEmpty()) {
                data = new MbgViewListResultData();
                data.setMembers(members);
                this.prmtBgPeriod.setData((Object)data);
            }
            if (this.editData.getEntry() != null && !this.editData.getEntry().isEmpty()) {
                int count = this.editData.getEntry().size();
                BgAdjustRuleEntryInfo entryInfo = null;
                IRow row = null;
                String columnKey = null;
                for (int i = 0; i < count; ++i) {
                    Object obj;
                    entryInfo = this.editData.getEntry().get(i);
                    if (entryInfo.getMembers() == null || !((obj = BgAnalyseHelper.getObject(entryInfo.getMembers())) instanceof Map)) continue;
                    Map membersMap = (Map)obj;
                    row = this.getDetailTable().addRow();
                    this.initRowDialog(row);
                    for (int colIndex = 0; colIndex < this.getDetailTable().getColumnCount(); ++colIndex) {
                        columnKey = this.getDetailTable().getColumnKey(colIndex);
                        members = null;
                        if (COL_BGORGUNIT.equals(columnKey) && membersMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER) != null) {
                            members = (List)membersMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER);
                        } else if (COL_BGACCOUNT.equals(columnKey) && membersMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER) != null) {
                            members = (List)membersMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER);
                        } else if (this.getSchemeHelper().getDimensions().containsKey(columnKey)) {
                            members = (List)membersMap.get(columnKey);
                        }
                        if (members == null) continue;
                        data = new MbgViewListResultData();
                        data.setMembers(members);
                        row.getCell(colIndex).setValue((Object)data);
                    }
                }
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("numberNotNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("nameNotNull"));
            SysUtil.abort();
        }
    }

    public void verifyData() throws Exception {
        super.verifyData();
    }

    @Override
    protected void btnAddOneLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getDetailTable().addRow();
        this.initRowDialog(row);
    }

    @Override
    protected void btnDelSelectLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BgCommCHelper.removeRows((KDTable)this.getDetailTable());
    }

    @Override
    protected void btnCopyOneLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = this.getDetailTable().getSelectManager().getActiveRowIndex();
        IRow sourceRow = this.getDetailTable().getRow(index);
        IRow row = this.getDetailTable().addRow();
        this.initRowDialog(row);
        for (int c = 0; c < this.getDetailTable().getColumnCount(); ++c) {
            row.getCell(c).setValue(sourceRow.getCell(c).getValue());
        }
    }

    protected void initRowDialog(IRow row) throws EASBizException, BOSException {
        if (row == null) {
            return;
        }
        KDBizPromptBox prmtMember = null;
        int count = this.getDetailTable().getColumnCount();
        IColumn column = null;
        String columnKey = null;
        for (int colIndex = 0; colIndex < count; ++colIndex) {
            column = this.getDetailTable().getColumn(colIndex);
            columnKey = column.getKey();
            if (StringUtils.isEmpty((String)columnKey)) continue;
            prmtMember = COL_BGORGUNIT.equals(columnKey) ? this.getMemberPrmt(DimensionConstants.DEF_ORGUNIT_NUMBER) : (COL_BGACCOUNT.equals(columnKey) ? this.getMemberPrmt(DimensionConstants.DEF_ACCOUNT_NUMBER) : this.getMemberPrmt(columnKey));
            row.getCell(colIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMember));
            prmtMember.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof KDBizPromptBox && ((KDBizPromptBox)obj).getSelector() instanceof DimensionMemberSelectDialog) {
                        ((DimensionMemberSelectDialog)((KDBizPromptBox)obj).getSelector()).reSetF7UI();
                        ((DimensionMemberSelectDialog)((KDBizPromptBox)obj).getSelector()).setCurSelectFunction(null);
                        if (((KDBizPromptBox)obj).getData() instanceof MbgViewListResultData) {
                            ((DimensionMemberSelectDialog)((KDBizPromptBox)obj).getSelector()).setCurSelectFunction((MbgViewListResultData)((KDBizPromptBox)obj).getData());
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void prmtBgScenario_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScenario_willShow(e);
        List allScenarios = BgScenarioHelper.getBgScenario();
        if (allScenarios != null && !allScenarios.isEmpty()) {
            HashMap<String, Set<String>> memberFilter = new HashMap<String, Set<String>>();
            memberFilter.put(DimensionConstants.DEF_SCENARIO_NUMBER, new HashSet());
            for (BgScenarioInfo info : allScenarios) {
                ((Set)memberFilter.get(DimensionConstants.DEF_SCENARIO_NUMBER)).add(info.getNumber());
            }
            ((DimensionMemberSelectDialog)((KDBizPromptBox)e.getSource()).getSelector()).setMemberFilter(memberFilter);
        }
        this.doWillShow(e);
    }

    @Override
    protected void prmtBgElement_willShow(SelectorEvent e) throws Exception {
        super.prmtBgElement_willShow(e);
        this.doWillShow(e);
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtBgVersion_willShow(e);
        this.doWillShow(e);
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtBgPeriod_willShow(e);
        this.doWillShow(e);
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        super.prmtCurrency_willShow(e);
        this.doWillShow(e);
    }

    protected void doWillShow(SelectorEvent e) {
        if (((KDBizPromptBox)e.getSource()).getSelector() instanceof DimensionMemberSelectDialog) {
            ((DimensionMemberSelectDialog)((KDBizPromptBox)e.getSource()).getSelector()).reSetF7UI();
            ((DimensionMemberSelectDialog)((KDBizPromptBox)e.getSource()).getSelector()).setCurSelectFunction(null);
            if (((KDBizPromptBox)e.getSource()).getData() instanceof MbgViewListResultData) {
                ((DimensionMemberSelectDialog)((KDBizPromptBox)e.getSource()).getSelector()).setCurSelectFunction((MbgViewListResultData)((KDBizPromptBox)e.getSource()).getData());
            }
        }
    }

    protected KDBizPromptBox getMemberPrmt(String dimNumber) throws EASBizException, BOSException {
        DimensionMemberSelectDialog dimDialog = this.getDimensionMemberSelectDialog(dimNumber);
        KDBizPromptBox prmtDim = new KDBizPromptBox();
        prmtDim.setEditable(false);
        prmtDim.setSelector((KDPromptSelector)dimDialog);
        return prmtDim;
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public IObjectPK runSave() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData != null && this.editData.getId() != null && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.editData.getId())) && BgAdjustRuleStateEnum.SAVED.equals((Object)((IBgAdjustRule)this.getBizInterface()).getBgAdjustRuleInfo((IObjectPK)new ObjectUuidPK(this.editData.getId())).getState())) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("invalidStateSave"));
            SysUtil.abort();
        }
        this.afterStoreFields();
        IObjectPK pk = super.runSave();
        this.refreshList();
        return pk;
    }

    protected void refreshList() throws Exception {
        Object listUI = this.getUIContext().get("Owner");
        if (listUI instanceof BgAdjustRuleListUI) {
            ((BgAdjustRuleListUI)((Object)listUI)).refreshList();
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re && !OprtState.VIEW.equals(this.getOprtState())) {
            BgNFCHelper.refreshListUI((CoreUI)this);
        }
        return re;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
    }

    public boolean isModify() {
        return super.isModify();
    }

    public void afterStoreFields() {
        if (this.editData != null) {
            this.editData.setBgScenarios(BgAnalyseHelper.getBytes(this.getMembersfromPrmt(this.prmtBgScenario)));
            this.editData.setBgElements(BgAnalyseHelper.getBytes(this.getMembersfromPrmt(this.prmtBgElement)));
            this.editData.setCurrencys(BgAnalyseHelper.getBytes(this.getMembersfromPrmt(this.prmtCurrency)));
            this.editData.setBgVersions(BgAnalyseHelper.getBytes(this.getMembersfromPrmt(this.prmtBgVersion)));
            this.editData.setBgPeriods(BgAnalyseHelper.getBytes(this.getMembersfromPrmt(this.prmtBgPeriod)));
            this.editData.getEntry().clear();
            int rowCount = this.getDetailTable().getRowCount();
            int columnCount = this.getDetailTable().getColumnCount();
            if (rowCount > 0) {
                BgAdjustRuleEntryInfo entryInfo = null;
                HashMap<String, List> membersMap = null;
                IRow row = null;
                IColumn column = null;
                String columnKey = null;
                MbgViewListResultData data = null;
                int seq = 1;
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    row = this.getDetailTable().getRow(rowIndex);
                    membersMap = new HashMap<String, List>();
                    entryInfo = new BgAdjustRuleEntryInfo();
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                        column = this.getDetailTable().getColumn(colIndex);
                        columnKey = column.getKey();
                        if (!(row.getCell(colIndex).getValue() instanceof MbgViewListResultData) || ((MbgViewListResultData)row.getCell(colIndex).getValue()).getMembers().isEmpty()) continue;
                        data = (MbgViewListResultData)row.getCell(colIndex).getValue();
                        if (COL_BGORGUNIT.equals(columnKey)) {
                            membersMap.put(DimensionConstants.DEF_ORGUNIT_NUMBER, data.getMembers());
                            continue;
                        }
                        if (COL_BGACCOUNT.equals(columnKey)) {
                            membersMap.put(DimensionConstants.DEF_ACCOUNT_NUMBER, data.getMembers());
                            continue;
                        }
                        if (!this.getSchemeHelper().getDimensions().containsKey(columnKey)) continue;
                        membersMap.put(columnKey, data.getMembers());
                    }
                    if (membersMap.isEmpty()) continue;
                    entryInfo.setMembers(BgAnalyseHelper.getBytes(membersMap));
                    entryInfo.setBgAdjustRule(this.editData);
                    entryInfo.setSeq(seq);
                    ++seq;
                    this.editData.getEntry().add(entryInfo);
                }
            }
        }
    }

    protected List getMembersfromPrmt(KDBizPromptBox prmtDim) {
        if (prmtDim != null && prmtDim.getData() instanceof MbgViewListResultData) {
            return ((MbgViewListResultData)prmtDim.getData()).getMembers();
        }
        return null;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected IObjectValue createNewData() {
        BgAdjustRuleInfo info = new BgAdjustRuleInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(info.getCreator());
        info.setLastUpdateTime(info.getCreateTime());
        info.setState(BgAdjustRuleStateEnum.TMPSAVED);
        info.setAdjustHisPeriod(true);
        if (this.getBgSchemeInfo() != null) {
            info.setBgScheme(this.getBgSchemeInfo());
            if (this.getBgSchemeInfo().getOrgUnit() != null) {
                info.setOrgUnit(this.getBgSchemeInfo().getOrgUnit());
            }
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAdjustRuleFactory.getRemoteInstance();
    }

    protected String getString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("bgScenarios");
        sic.add("bgElements");
        sic.add("currencys");
        sic.add("bgVersions");
        sic.add("bgPeriods");
        sic.add("orgUnit.id");
        sic.add("entry.*");
        return sic;
    }
}

