/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.ProgressDialogUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgBatchExcuteAnalysisSetUI;
import com.kingdee.eas.ma.mbg.client.BgExcuteAnalysisSelectScenUI;
import com.kingdee.eas.ma.mbg.client.BgNBatchEditAddOrgUnit;
import com.kingdee.eas.ma.mbg.client.BgTemplateDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgExcuteAnalysisHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.BgTemplateObject;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgBatchExcuteAnalysisSetUI
extends AbstractBgBatchExcuteAnalysisSetUI {
    private static final long serialVersionUID = 8342800882115694747L;
    private static final Logger logger = CoreUIObject.getLogger(BgBatchExcuteAnalysisSetUI.class);
    protected static final String res = "com.kingdee.eas.ma.mbg.MBgAnalyseResource";
    private BgSchemeInfo schemeInfo = null;
    private String createPermissionNum = null;
    protected BgSchemeDimensionHelper schemeHelper = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.schemeInfo = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("schemeHelper");
        this.createPermissionNum = (String)this.getUIContext().get("permissionItem");
        this.btnOk.setEnabled(true);
        this.init();
        this.prmtOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BgNBatchEditAddOrgUnit orgView = (BgNBatchEditAddOrgUnit)BgBatchExcuteAnalysisSetUI.this.prmtOrgUnit.getSelector();
                    if (BgBatchExcuteAnalysisSetUI.this.prmtOrgUnit.getData() != null) {
                        orgView.setPermissionItem(BgBatchExcuteAnalysisSetUI.this.createPermissionNum);
                        orgView.setShowVirtualOrg(false);
                    }
                    orgView.setSelectedOrgUnit(BgBatchExcuteAnalysisSetUI.this.prmtOrgUnit.getData());
                }
                catch (Exception exc) {
                    BgBatchExcuteAnalysisSetUI.this.handUIException(exc);
                }
            }
        });
        BgSchemeUtils.setDefualtMembers(this.schemeHelper, null, (JComponent)this.prmtBgPeriod, (JComponent)this.prmtCurrency, false, false);
        super.onLoad();
    }

    protected void init() throws Exception {
        this.initOrgUnit();
        this.initTemplate();
        this.initPeriod();
        this.initCurrency();
    }

    private void initTemplate() throws Exception {
        BgTemplateCollection bgTemplateColl = TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(this.schemeInfo.getId(), null);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (bgTemplateColl != null && !bgTemplateColl.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < bgTemplateColl.size(); ++i) {
                ids.add(bgTemplateColl.get(i).getId().toString());
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
        }
        this.prmtTemplate.setEntityViewInfo(evi);
        BgTemplateDialog templateDialog = new BgTemplateDialog();
        templateDialog.setSchemeId(this.schemeInfo.getId().toString());
        templateDialog.setFilterInfo(this.prmtTemplate.getEntityViewInfo().getFilter());
        templateDialog.setCreateExcute(true);
        BgOrgUnitInfo obj = (BgOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS);
        if (obj != null) {
            FullOrgUnitInfo orginfo = new FullOrgUnitInfo();
            orginfo.setId(BOSUuid.read((String)obj.getOrgUnitID()));
            templateDialog.setOrgInfo(orginfo);
        }
        this.prmtTemplate.setSelector((KDPromptSelector)templateDialog);
    }

    private void initPeriod() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, true);
        bgPeriodDialog.setBgPeriodBeginDate(this.schemeInfo.getDateFrom());
        bgPeriodDialog.setBgPeriodEndDate(this.schemeInfo.getDateTo());
        bgPeriodDialog.setBgPeriodTypeNumbers(this.schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        bgPeriodDialog.setBgSchemeID(this.schemeHelper.getBgSchemeId());
        bgPeriodDialog.setAllowSort(false);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
        this.prmtBgPeriod.setHistoryRecordEnabled(false);
        BgPeriodInfo periodInfo = null;
        Object objPeriod = this.prmtBgPeriod.getData();
        if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
            periodInfo = (BgPeriodInfo)objPeriod;
            BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
            bgPeriodDialog.setBgPeriods(periodArray);
        } else {
            bgPeriodDialog.setBgPeriods(null);
        }
    }

    private void initCurrency() throws Exception {
        Set currencyID = MbgAnalyseExeHelper.getCurrencyID((BgSchemeInfo)this.schemeInfo);
        EntityViewInfo view = this.prmtCurrency.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCurrency.setEnabledMultiSelection(true);
        this.prmtCurrency.setEntityViewInfo(view);
    }

    private void initOrgUnit() throws EASBizException, BOSException, UuidException {
        BgOrgUnitInfo obj = (BgOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS);
        String bgOrgViewId = (String)this.getUIContext().get("orgViewId");
        BgNBatchEditAddOrgUnit orgView = new BgNBatchEditAddOrgUnit((IUIObject)this);
        orgView.setBgOrgViewId(bgOrgViewId);
        orgView.setOrgUnitId(BgOrgUnitFactory.getRemoteInstance().getBuildTreeOrgUnitId(BOSUuid.read((String)obj.getOrgUnitID()), BOSUuid.read((String)orgView.getBgOrgViewId())).toString());
        orgView.setMultipleSelect(true);
        orgView.setPermissionItem(this.createPermissionNum);
        orgView.setShowVirtualOrg(false);
        this.prmtOrgUnit.setData((Object)obj);
        if (obj != null && !PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(obj.getOrgUnitID()), this.createPermissionNum)) {
            this.prmtOrgUnit.setData(null);
        }
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setCommitFormat("$number$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
            BgPeriodInfo periodInfo = null;
            Object objPeriod = this.prmtBgPeriod.getData();
            if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                periodInfo = (BgPeriodInfo)objPeriod;
                BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                bgPeriodDialog.setBgPeriods(periodArray);
            } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
                bgPeriodDialog.setBgPeriods((BgPeriodInfo[])objPeriod);
            } else {
                bgPeriodDialog.setBgPeriods(null);
            }
        }
        super.prmtBgPeriod_willShow(e);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.verify()) {
            this.queryFormAndDealScen();
        }
    }

    private boolean verify() {
        String msg = null;
        boolean isVerify = true;
        Object obj1 = this.prmtOrgUnit.getData();
        Object obj2 = this.prmtTemplate.getData();
        Object obj3 = this.prmtBgPeriod.getData();
        Object obj4 = this.prmtCurrency.getData();
        if (obj1 == null) {
            msg = EASResource.getString((String)res, (String)"selectBgOrg", (Object[])new Object[0]);
            isVerify = false;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return isVerify;
        }
        if (obj2 == null) {
            msg = EASResource.getString((String)res, (String)"selectBgTemplate", (Object[])new Object[0]);
            isVerify = false;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return isVerify;
        }
        if (obj2 instanceof BgTemplateObject) {
            if (((BgTemplateObject)obj2).getResult().isEmpty()) {
                msg = EASResource.getString((String)res, (String)"selectBgTemplate", (Object[])new Object[0]);
                isVerify = false;
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                return isVerify;
            }
        } else if (obj2 instanceof Object[]) {
            msg = EASResource.getString((String)res, (String)"selectBgTemplate", (Object[])new Object[0]);
            isVerify = false;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return isVerify;
        }
        if (obj3 == null) {
            msg = EASResource.getString((String)res, (String)"selectBgPeriod", (Object[])new Object[0]);
            isVerify = false;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return isVerify;
        }
        if (obj4 == null) {
            msg = EASResource.getString((String)res, (String)"selectCurrency", (Object[])new Object[0]);
            isVerify = false;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
        }
        return isVerify;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void queryFormAndDealScen() throws Exception {
        Object[] objs = DimensionCommonHelper.getValues((Object)((BgTemplateObject)this.prmtTemplate.getData()).getResult());
        HashSet<String> templateIds = new HashSet<String>();
        if (objs != null) {
            BgTemplateInfo bgTemplateInfo = null;
            for (Object obj : objs) {
                bgTemplateInfo = (BgTemplateInfo)obj;
                templateIds.add(bgTemplateInfo.getId().toString());
            }
        }
        if (!templateIds.isEmpty()) {
            Map<String, BgScenarioInfo> scenarioMap = BgExcuteAnalysisHelper.getScenariooObjMap();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("template.id");
            sic.add("template.formType");
            sic.add("template.number");
            sic.add("template.name");
            sic.add("data");
            viewInfo.setSelector(sic);
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("template.id", templateIds, CompareType.INCLUDE));
            viewInfo.setSorter(new SorterItemCollection());
            viewInfo.getSorter().add(new SorterItemInfo("template.number"));
            CoreBaseCollection coll = BgViewDimensionFactory.getRemoteInstance().getCollection(viewInfo);
            BgViewDimensionInfo info = null;
            BgTemFormTypeEnum formType = null;
            byte[] bytes = null;
            IMbgViewBase view = null;
            List list = null;
            HashSet<String> senarioNum = null;
            BgDimensionBaseInfo dimInfo = null;
            BgDimensionMember member = null;
            LinkedHashMap<String, Set<String>> temScen = new LinkedHashMap<String, Set<String>>();
            HashSet allSenarioNum = new HashSet();
            for (int i = 0; i < coll.size(); ++i) {
                info = (BgViewDimensionInfo)coll.get(i);
                formType = info.getTemplate().getFormType();
                bytes = info.getData();
                view = BgTemFormTypeEnum.VIEWFORM.equals((Object)formType) || BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType) ? new MbgXMLParser().parse(bytes) : new MbgViewListXMLParser().parse(bytes);
                MbgViewListDimensionManager managerInfo = null;
                senarioNum = new HashSet<String>();
                for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                    list = view.getSheetManagers().get(s).getDimensionManager().getDimension();
                    dimInfo = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_SCENARIO_NUMBER, list);
                    for (int j = 0; j < dimInfo.getMember().size(); ++j) {
                        member = (BgDimensionMember)dimInfo.getMember().get(j);
                        if (!scenarioMap.containsKey(member.getNumber()) || !scenarioMap.get(member.getNumber()).getType().equals((Object)BgScenarioType.BudgetData)) continue;
                        senarioNum.add(member.getNumber());
                    }
                    if (!(view.getSheetManagers().get(s).getDimensionManager() instanceof MbgViewListDimensionManager)) continue;
                    managerInfo = (MbgViewListDimensionManager)view.getSheetManagers().get(s).getDimensionManager();
                    MbgViewListDimensionInfo dim = null;
                    List<IMbgViewListObject> rowCols = managerInfo.getRowCols();
                    for (int r = 0; r < rowCols.size(); ++r) {
                        if (!(rowCols.get(r) instanceof MbgViewListRowCol)) continue;
                        MbgViewListRowCol object = (MbgViewListRowCol)rowCols.get(r);
                        List<MbgViewListDimensionInfo> dimens = object.getDimensions();
                        for (int d = 0; d < dimens.size(); ++d) {
                            if (!(dimens.get(d) instanceof MbgViewListDimensionInfo) || (dim = dimens.get(d)) == null || !dim.getNumber().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) continue;
                            for (Object obj : dim.getMember()) {
                                if (obj instanceof MbgViewListDimensionMember) {
                                    if (!scenarioMap.containsKey(((MbgViewListDimensionMember)obj).getNumber()) || !scenarioMap.get(((MbgViewListDimensionMember)obj).getNumber()).getType().equals((Object)BgScenarioType.BudgetData)) continue;
                                    senarioNum.add(((MbgViewListDimensionMember)obj).getNumber());
                                    continue;
                                }
                                if (!(obj instanceof BgDimensionMember) || !scenarioMap.containsKey(((BgDimensionMember)obj).getNumber()) || !scenarioMap.get(((BgDimensionMember)obj).getNumber()).getType().equals((Object)BgScenarioType.BudgetData)) continue;
                                senarioNum.add(((BgDimensionMember)obj).getNumber());
                            }
                        }
                    }
                }
                temScen.put(info.getTemplate().getId().toString(), senarioNum);
                allSenarioNum.addAll(senarioNum);
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)this.schemeInfo);
            uiContext.put((Object)BgBaseConstants.BGSCENARIO_INFO, allSenarioNum);
            uiContext.put((Object)BgBaseConstants.BGTEMPLATE_INFO, scenarioMap);
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.schemeHelper);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExcuteAnalysisSelectScenUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            BgExcuteAnalysisSelectScenUI f7UI = (BgExcuteAnalysisSelectScenUI)uiWindow.getUIObject();
            if (f7UI.isCancel() || f7UI.getReturnMap().isEmpty()) {
                return;
            }
            this.getUIWindow().close();
            Map<String, Set<String>> returnMap = f7UI.getReturnMap();
            SimpleTimer time = new SimpleTimer();
            UIContext map = new UIContext((Object)this);
            map.put((Object)"MainUI", this.getUIContext().get("MainUI"));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)map, null, null, 16);
            if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
                ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
                ui.setSplitName(false);
                ui.setShowTableMessage(true);
                ui.setUiFactoryName("com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                logger.debug((Object)("begin initParameterValue" + time.getTime() + ""));
                this.initParameterValue(ui, temScen, returnMap);
                logger.debug((Object)("begin init" + time.getTime() + ""));
                ui.init();
                logger.debug((Object)("begin show" + time.getTime() + ""));
                window.show();
            }
        }
    }

    private void initParameterValue(ProgressDialogUI ui, Map<String, Set<String>> temScen, Map<String, Set<String>> returnMap) throws BOSException {
        ui.setUITitle(BgBatchExcuteAnalysisSetUI.getString("createAnalysisTitle"));
        ui.setAllSuccessMsg(MessageFormat.format(BgBatchExcuteAnalysisSetUI.getString("allSuccessMsg"), ui.getUITitle()));
        ui.setInvokeClass(BgBatchExcuteAnalysisSetUI.class.getName());
        ui.setInvokeMethod("runCreateAnalysis");
        Class[] cls = new Class[]{BgOrgUnitInfo.class, BgOrgUnitInfo.class, Map.class, Map.class, List.class, List.class, Boolean.TYPE, Map.class, Set.class};
        ui.setInvokeMethodParmeterType(cls);
        ArrayList<Object[]> paramValues = new ArrayList<Object[]>();
        BgOrgUnitInfo[] values = null;
        Object objOrg = this.prmtOrgUnit.getData();
        if (objOrg != null && objOrg instanceof BgOrgUnitInfo) {
            values = new BgOrgUnitInfo[]{(BgOrgUnitInfo)objOrg};
        } else if (objOrg != null && objOrg instanceof BgOrgUnitInfo[]) {
            values = (BgOrgUnitInfo[])objOrg;
        }
        List orgValues = Arrays.asList(values);
        Collections.sort(orgValues, new Comparator<BgOrgUnitInfo>(){

            @Override
            public int compare(BgOrgUnitInfo o1, BgOrgUnitInfo o2) {
                return o1.getLongNumber().compareTo(o2.getLongNumber());
            }
        });
        Object objPeriod = this.prmtBgPeriod.getData();
        BgPeriodInfo[] periodArray = null;
        if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
            periodArray = new BgPeriodInfo[]{(BgPeriodInfo)objPeriod};
        } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
            periodArray = (BgPeriodInfo[])objPeriod;
        }
        List listPeriods = Arrays.asList(periodArray);
        Object objCurrency = this.prmtCurrency.getData();
        CurrencyInfo[] currencyArray = null;
        if (objCurrency != null && objCurrency instanceof CurrencyInfo) {
            currencyArray = new CurrencyInfo[]{(CurrencyInfo)objCurrency};
        } else if (objCurrency != null && objCurrency instanceof CurrencyInfo[]) {
            currencyArray = (CurrencyInfo[])objCurrency;
        } else if (objCurrency != null && objCurrency instanceof Object[]) {
            Object[] objc = (Object[])objCurrency;
            currencyArray = new CurrencyInfo[objc.length];
            for (int i = 0; i < objc.length; ++i) {
                currencyArray[i] = (CurrencyInfo)objc[i];
            }
        }
        List listCurrencys = Arrays.asList(currencyArray);
        HashMap<String, BgTemplateInfo> tempInfoMap = new HashMap<String, BgTemplateInfo>();
        HashSet<String> tempIdSet = new HashSet<String>();
        tempIdSet.addAll(temScen.keySet());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("number"));
        BgTemplateCollection coll = BgTemplateFactory.getRemoteInstance().getBgTemplateCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            tempInfoMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        LinkedHashSet<String> filterTemp = new LinkedHashSet<String>();
        for (String key : temScen.keySet()) {
            boolean isExist = false;
            for (String bgDataNum : returnMap.keySet()) {
                if (!temScen.get(key).contains(bgDataNum)) continue;
                isExist = true;
                break;
            }
            if (!isExist) continue;
            filterTemp.add(key);
        }
        BgOrgUnitInfo orgInfo = null;
        Object[] params = null;
        for (int i = 0; i < orgValues.size(); ++i) {
            orgInfo = (BgOrgUnitInfo)orgValues.get(i);
            if (i == 0) {
                params = new Object[9];
                params[6] = true;
                paramValues.add(params);
            }
            if (params != null) {
                params[0] = orgInfo;
            }
            params = new Object[9];
            params[1] = orgInfo;
            params[2] = temScen;
            params[3] = returnMap;
            params[4] = listPeriods;
            params[5] = listCurrencys;
            params[6] = false;
            if (i == 0) {
                params[6] = true;
            }
            params[7] = tempInfoMap;
            params[8] = filterTemp;
            paramValues.add(params);
        }
        ui.setInvokeMethodParmeterValue((Object[][])paramValues.toArray((T[])new Object[0][0]));
        ui.setCountSum(paramValues.size() - 1);
    }

    public Object[] runCreateAnalysis(BgOrgUnitInfo nextOrg, BgOrgUnitInfo thisOrg, Map<String, Set<String>> temScen, Map<String, Set<String>> returnMap, List<BgPeriodInfo> listPeriods, List<CurrencyInfo> listCurrencys, boolean isFirst, Map<String, BgTemplateInfo> tempInfoMap, Set<String> filterTemp) {
        Object[] obj = new Object[3];
        try {
            if (nextOrg != null) {
                obj[0] = MessageFormat.format(BgBatchExcuteAnalysisSetUI.getString("createAnalysisProcess"), nextOrg.getName());
            }
            if (thisOrg == null) {
                return obj;
            }
            obj[1] = BgFormExcuteAnalysisFactory.getRemoteInstance().batchCreateAnalysis((IObjectValue)thisOrg, temScen, returnMap, listPeriods, listCurrencys, isFirst, tempInfoMap, filterTemp);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            obj[2] = e;
        }
        return obj;
    }

    public static String getString(String key) {
        return EASResource.getString((String)res, (String)key);
    }
}

