/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.client.utils.BizCalcClientHelper;
import com.kingdee.eas.ma.mbg.BgDetailMemberEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.MbgFunctionProcess;
import com.kingdee.eas.ma.mbg.client.AbstractBgBizPeriodF7UI;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunction;
import com.kingdee.eas.ma.mbg.function.define.MbgFunctionSourceFactory;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgBizPeriodF7UI
extends AbstractBgBizPeriodF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgBizPeriodF7UI.class);
    public static final String CAN_SELECT_ALL_DIM = "canSelectAllDim";
    public static final String CAN_SELECT_TYPE = "canSelectType";
    public static final String SELECT_TYPE = "SelectType";
    private String orgId = null;
    private NumberExpandHelper numberHelper = null;
    private Map dataTypeMap = null;
    private Map<String, BgDimensionMember> curSelectedFunction = new HashMap<String, BgDimensionMember>();
    private MbgViewListResultData backFillMember = null;
    protected boolean canSelectAllDim = false;
    protected BgMemberSelectTypeEnum selectType = null;
    protected boolean canSelectType = true;
    private BgDimensionBaseInfo dimension = null;
    private Boolean isMultiSelect = false;
    private boolean isLoadTblVaLeft = false;
    private String bgSchemeID = null;
    private DimensionMemberSelectHelper selectHelper = null;
    BgPeriodTypeInfo bgPeriodTypeInfo = null;
    BgPeriodDispInfo bgPeriodDispInfo = null;

    public boolean isCanSelectType() {
        return this.canSelectType;
    }

    public void setCanSelectType(boolean canSelectType) {
        this.canSelectType = canSelectType;
    }

    public BgDimensionBaseInfo getDimension() {
        return this.dimension;
    }

    public void setDimension(BgDimensionBaseInfo dimension) {
        this.dimension = dimension;
    }

    public String getBgSchemeID() {
        return this.bgSchemeID;
    }

    public void setBgSchemeID(String bgSchemeID) {
        this.bgSchemeID = bgSchemeID;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public Map<String, BgDimensionMember> getCurSelectedFunction() {
        return this.curSelectedFunction;
    }

    public void setCurSelectedFunction(Map<String, BgDimensionMember> curSelectedFunction) {
        this.curSelectedFunction = curSelectedFunction;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initCbBox();
        this.dimension = (BgDimensionInfo)this.getUIContext().get("dimension");
        this.bgSchemeID = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        if (this.orgId == null) {
            this.orgId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        this.dataTypeMap = this.getUIContext().get("dataTypeMap") != null ? (Map)this.getUIContext().get("dataTypeMap") : new HashMap();
        this.isMultiSelect = this.getUIContext().get("isMulSelect") instanceof Boolean ? (Boolean)this.getUIContext().get("isMulSelect") : false;
        this.setMultiSelect(this.isMultiSelect);
        this.fillBackValue();
    }

    protected final DimensionMemberSelectHelper getSelectHelper() throws EASBizException, BOSException {
        if (this.selectHelper == null) {
            BgSchemeDimensionHelper schemeHelper = null;
            schemeHelper = this.getUIContext().get("BGSCHEME_HELPER") != null ? (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER") : new BgSchemeDimensionHelper(null, (String)this.getUIContext().get("BGSCHEME_ID"));
            this.selectHelper = this.createSelectHelper(schemeHelper);
        }
        return this.selectHelper;
    }

    protected DimensionMemberSelectHelper createSelectHelper(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        return new DimensionMemberSelectHelper(schemeHelper);
    }

    private void fillBackValue() {
        if (this.getUIContext().get("backfillMember") != null && this.getUIContext().get("backfillMember") instanceof MbgViewListResultData) {
            this.backFillMember = (MbgViewListResultData)this.getUIContext().get("backfillMember");
            this.refreshSelectedDimMemberList(this.backFillMember);
        }
    }

    private void initCbBox() {
        this.cbxBgPeriodType.setEditable(false);
        this.cbxYear.setEditable(false);
        this.cbxSelectType.addItem((Object)BgMemberSelectTypeEnum.Function);
        this.selectType = (BgMemberSelectTypeEnum)((Object)this.getUIContext().get(SELECT_TYPE));
        if (this.selectType != null) {
            this.cbxSelectType.setSelectedItem((Object)this.selectType);
            this.cbxSelectType.setUserObject((Object)this.getMemberSelectType());
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnTop.setVisible(false);
        this.btnUp.setVisible(false);
        this.btnDown.setVisible(false);
        this.btnBottom.setVisible(false);
    }

    public BgMemberSelectTypeEnum getSelectType() {
        if (this.selectType == null) {
            this.selectType = (BgMemberSelectTypeEnum)((Object)this.cbxSelectType.getSelectedItem());
        }
        return this.selectType;
    }

    public void setSelectType(BgMemberSelectTypeEnum selectType) {
        this.selectType = selectType;
    }

    @Override
    protected void cbxSelectType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.getMemberSelectType().equals(this.cbxSelectType.getUserObject())) {
            return;
        }
        if (this.isNeedCheckSwitch.booleanValue()) {
            this.checkCanSwitch(this.cbxSelectType.getUserObject() instanceof BgMemberSelectTypeEnum ? (BgMemberSelectTypeEnum)((Object)this.cbxSelectType.getUserObject()) : this.getMemberSelectType());
        }
        if (BgMemberSelectTypeEnum.Function == this.getMemberSelectType()) {
            this.initFunctionType();
            this.hideTableExceptFun();
            this.cbxSelectType.setUserObject((Object)this.getMemberSelectType());
        } else {
            if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
                this.initMemberType();
            } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
                this.initVariateType();
            } else {
                this.initFunctionType();
                this.hideTableExceptFun();
            }
            this.cbxSelectType.setUserObject((Object)this.getMemberSelectType());
        }
    }

    @Override
    protected void checkCanSwitch(BgMemberSelectTypeEnum oldSelectType) {
        boolean canSwitch = true;
        if (BgMemberSelectTypeEnum.Function == oldSelectType) {
            boolean bl = canSwitch = this.tblFuncRight.getRowCount() <= 0;
        }
        if (!canSwitch) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"only_one_source"));
            this.cbxSelectType.setSelectedItem(this.cbxSelectType.getUserObject(), false);
            return;
        }
        super.checkCanSwitch(oldSelectType);
    }

    public void addFunction(Map<String, BgDimensionMember> addFunctionMap) {
        MbgViewListResultData rstData = new MbgViewListResultData();
        rstData.setMemberType(BgMemberSelectTypeEnum.Function);
        BgDimensionMember member = null;
        if (addFunctionMap != null && !addFunctionMap.isEmpty()) {
            this.getCurSelectedFunction().putAll(addFunctionMap);
            for (String funStr : this.getCurSelectedFunction().keySet()) {
                member = new BgDimensionMember(null, null, funStr, funStr);
                rstData.getMembers().add(member);
            }
            this.refreshSelectedDimMemberList(rstData);
        }
    }

    public boolean checkFunctionRepeat(String memberKey) {
        boolean isExistSameParam = false;
        if (StringUtils.isEmpty((String)memberKey)) {
            return isExistSameParam;
        }
        Map<String, BgDimensionMember> curSelectedFunction = this.getCurSelectedFunction();
        if (curSelectedFunction.containsKey(memberKey)) {
            isExistSameParam = true;
        }
        return isExistSameParam;
    }

    private void initVariateType() throws BOSException {
        this.switchSelectTypeToMember(false);
        this.cbxBgPeriodType.setSelectedItem(null);
        this.cbxYear.setSelectedItem(null);
        if (!this.isLoadTblVaLeft) {
            BgViewMemberSelectHelper.loadBgVariate(this.bgSchemeID, DimensionConstants.DEF_PERIOD_NUMBER, this.tblVaLeft, null);
            this.isLoadTblVaLeft = true;
        }
    }

    private void initMemberType() {
        if (this.cbxBgPeriodType.getSelectedItem() instanceof BgPeriodTypeInfo) {
            this.bgPeriodTypeInfo = (BgPeriodTypeInfo)this.cbxBgPeriodType.getSelectedItem();
        } else if (this.cbxBgPeriodType.getSelectedItem() == null && this.bgPeriodTypeInfo instanceof BgPeriodTypeInfo) {
            this.cbxBgPeriodType.removeItem(null);
            this.cbxBgPeriodType.setSelectedItem((Object)this.bgPeriodTypeInfo, false);
        }
        if (this.cbxYear.getSelectedItem() instanceof BgPeriodDispInfo) {
            this.bgPeriodDispInfo = (BgPeriodDispInfo)this.cbxYear.getSelectedItem();
        } else if (this.cbxYear.getSelectedItem() == null && this.bgPeriodDispInfo instanceof BgPeriodDispInfo) {
            this.cbxYear.removeItem(null);
            this.cbxYear.setSelectedItem((Object)this.bgPeriodDispInfo, false);
        }
        this.switchSelectTypeToMember(true);
    }

    private void switchSelectTypeToMember(boolean isSelectMember) {
        this.tblMain.setVisible(isSelectMember);
        this.tblRight.setVisible(isSelectMember);
        this.tblVaLeft.setVisible(!isSelectMember);
        this.tblVaRight.setVisible(!isSelectMember);
        this.cbxBgPeriodType.setEnabled(isSelectMember);
        this.cbxYear.setEnabled(isSelectMember);
        this.chkYear.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkHalfYear.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkQuarter.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkMonth.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkMWeek.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkYWeek.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.btnExpand.setEnabled(isSelectMember);
        this.btnConstriction.setEnabled(isSelectMember);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function == this.getMemberSelectType()) {
            int selectRowIndex = this.tblFuncLeft.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncLeft.getRow(selectRowIndex);
            String functionName = row.getCell("name").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgId());
            uiContext.put((Object)DimensionConstants.DIMENSION, (Object)this.getDimension());
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeID());
            uiContext.put((Object)"beginDate", this.getUIContext().get("beginDate"));
            uiContext.put((Object)"endDate", this.getUIContext().get("endDate"));
            MbgFunctionProcess process = new MbgFunctionProcess(functionName, (CoreUI)this, uiContext);
            process.process();
        }
        super.btnAdd_actionPerformed(e);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function == this.getMemberSelectType()) {
            int selectRowIndex = this.tblFuncRight.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncRight.getRow(selectRowIndex);
            String functionName = row.getCell("name").getValue().toString();
            this.tblFuncRight.removeRow(selectRowIndex);
            this.getCurSelectedFunction().remove(functionName);
            this.refreshSelectedFunctionList(this.getCurSelectedFunction().keySet());
        }
        super.btnDelete_actionPerformed(e);
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function == this.getMemberSelectType()) {
            this.getCurSelectedFunction().clear();
            this.tblFuncRight.removeRows();
            this.refreshSelectedFunctionList(this.getCurSelectedFunction().keySet());
        }
        super.btnDeleteAll_actionPerformed(e);
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.dataTypeMap.put(this.dimension.getType(), this.getMemberSelectType());
        super.btnOk_actionPerformed(e);
    }

    @Override
    public Object getData() {
        MbgViewListResultData data;
        block10: {
            data = null;
            ArrayList<BgDimensionMember> members = null;
            BgDimensionMember member = null;
            try {
                if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
                    BgPeriodCollection obj = this.getBgPeriodCollection();
                    if (!(obj instanceof BgPeriodCollection)) break block10;
                    data = new MbgViewListResultData();
                    members = data.getMembers();
                    BgPeriodCollection colls = obj;
                    int in = colls.size();
                    for (int i = 0; i < in; ++i) {
                        String name = colls.get(i).getName();
                        String number = colls.get(i).getNumber();
                        member = new BgDimensionMember(null, DimensionBaseConstants.DEF_PERIOD_FIELD, name, number);
                        try {
                            member.setSrcNumber(this.getSelectHelper().getSrcNumber(DimensionBaseConstants.DEF_PERIOD_NUMBER));
                        }
                        catch (EASBizException e) {
                            logger.error((Object)"set srcNumer error", (Throwable)e);
                        }
                        members.add(member);
                    }
                    data.setMemberType(BgMemberSelectTypeEnum.Member);
                    return data;
                }
                if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
                    data = new MbgViewListResultData();
                    data.setMembers(this.getBgVariateLst(this.tblVaRight));
                    data.setMemberType(BgMemberSelectTypeEnum.Variate);
                    return data;
                }
                if (BgMemberSelectTypeEnum.Function != this.getMemberSelectType()) break block10;
                data = new MbgViewListResultData();
                data.setMemberType(BgMemberSelectTypeEnum.Function);
                members = new ArrayList<BgDimensionMember>();
                String funName2 = null;
                BgDimensionMember dimMem = null;
                for (String funName2 : this.curSelectedFunction.keySet()) {
                    dimMem = new BgDimensionMember(null, DimensionBaseConstants.DEF_PERIOD_FIELD, funName2, funName2);
                    try {
                        dimMem.setSrcNumber(this.getSelectHelper().getSrcNumber(DimensionBaseConstants.DEF_PERIOD_NUMBER));
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"set srcNumer error", (Throwable)e);
                    }
                    members.add(dimMem);
                }
                data.setMembers(members);
                return data;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                this.handUIException(e);
            }
        }
        this.returnData = data;
        return this.returnData instanceof MbgViewListResultData ? (MbgViewListResultData)this.returnData : null;
    }

    private void refreshSelectedFunctionList(Set<String> functionStr) {
        if (functionStr == null || functionStr.isEmpty()) {
            return;
        }
        this.tblFuncRight.checkParsed();
        this.tblFuncRight.removeRows();
        this.tblFuncRight.setEditable(false);
        IRow row = null;
        String selectedFun2 = null;
        for (String selectedFun2 : functionStr) {
            row = this.tblFuncRight.addRow();
            this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() + 1);
            row.getCell("name").setValue((Object)selectedFun2);
        }
    }

    private void refreshSelectedDimMemberList(MbgViewListResultData functionStr) {
        block5: {
            List members;
            block6: {
                block4: {
                    if (functionStr == null || functionStr.isEmpty()) {
                        return;
                    }
                    BgDimensionMember selectedFun2 = null;
                    members = null;
                    Object member = null;
                    this.selectType = functionStr.getMemberType();
                    members = functionStr.getMembers();
                    this.cbxSelectType.setSelectedItem((Object)functionStr.getMemberType());
                    if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Function)) break block4;
                    this.tblFuncRight.checkParsed();
                    this.tblFuncRight.removeRows();
                    this.tblFuncRight.setEditable(false);
                    IRow row = null;
                    for (BgDimensionMember selectedFun2 : members) {
                        this.curSelectedFunction.put(selectedFun2.getNumber(), selectedFun2);
                        row = this.tblFuncRight.addRow();
                        this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() + 1);
                        row.getCell("name").setValue((Object)selectedFun2.getNumber());
                    }
                    break block5;
                }
                if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Member)) break block6;
                this.tblRight.checkParsed();
                this.tblRight.removeRows();
                this.tblRight.setEditable(false);
                IRow row = null;
                for (BgDimensionMember selectedFun2 : members) {
                    row = this.tblRight.addRow();
                    this.tblRight.setRowCount(this.tblRight.getRowCount() + 1);
                    row.setUserObject((Object)selectedFun2);
                    row.getCell("number").setValue((Object)selectedFun2.getNumber());
                    row.getCell("name").setValue((Object)selectedFun2.getName());
                    row.getCell("alias").setValue((Object)selectedFun2.getName());
                }
                break block5;
            }
            if (!this.selectType.equals((Object)BgMemberSelectTypeEnum.Variate)) break block5;
            this.tblVaRight.checkParsed();
            this.tblVaRight.removeRows();
            this.tblVaRight.setEditable(false);
            IRow row = null;
            for (BgDimensionMember selectedFun2 : members) {
                row = this.tblVaRight.addRow();
                this.tblVaRight.setRowCount(this.tblVaRight.getRowCount() + 1);
                row.setUserObject((Object)selectedFun2);
                row.getCell("number").setValue((Object)selectedFun2.getName());
                row.getCell("name").setValue((Object)selectedFun2.getName());
            }
        }
    }

    private void initFunctionType() {
        MbgFunctionSourceFactory factory = null;
        ArrayList<String> functionsName = null;
        this.tblFuncLeft.checkParsed();
        this.tblFuncLeft.removeRows();
        this.tblFuncRight.setVisible(true);
        try {
            factory = MbgFunctionSourceFactory.getInstance();
        }
        catch (Exception e) {
            logger.error((Object)"load function error", (Throwable)e);
        }
        logger.debug((Object)"---------start--------------");
        logger.debug((Object)("factory == null ?" + factory == null ? 1 : 0));
        logger.debug("factory functionname ?" + factory == null ? null : factory.getAllFunctionsName());
        logger.debug((Object)"----------end---------------");
        if (factory != null) {
            functionsName = new ArrayList<String>();
            List<MbgFunction> fnList = factory.getFunctionTypeMap().get("MEMBER");
            for (MbgFunction fn : fnList) {
                functionsName.add(fn.getName() + "  (" + fn.getFunctionTitle().get("zh_CN") + ")");
            }
        }
        if (functionsName != null) {
            IRow row = null;
            for (int i = 0; i < functionsName.size(); ++i) {
                row = this.tblFuncLeft.addRow();
                this.tblFuncLeft.setRowCount(this.tblFuncLeft.getRowCount() + 1);
                row.getCell("name").setValue(functionsName.get(i));
            }
        }
        this.switchSelectTypeToMember(false);
    }

    private void hideTableExceptFun() {
        this.tblFuncLeft.setEditable(false);
        this.tblFuncLeft.setVisible(true);
        this.tblVaLeft.setVisible(false);
        this.tblVaRight.setVisible(false);
        this.tblMain.setVisible(false);
        this.tblRight.setVisible(false);
        this.btnAddAll.setVisible(false);
        this.btnAddAll.setEnabled(false);
    }

    public List<BgDimensionMember> getBgVariateLst(KDTable tblVaRight) throws BOSException {
        if (tblVaRight.getRowCount() == 0) {
            return null;
        }
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        BgDimensionMember bgVariateInfo = null;
        IRow row = null;
        int count = tblVaRight.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = tblVaRight.getRow(index);
            String name = row.getCell("name").getValue().toString();
            String number = row.getCell("number").getValue().toString();
            bgVariateInfo = new BgDimensionMember(null, DimensionBaseConstants.DEF_PERIOD_FIELD, name, number);
            result.add(bgVariateInfo);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    @Override
    protected void tblFuncLeft_tableClicked(KDTMouseEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Function == this.getMemberSelectType() && e.getClickCount() == 2) {
            int selectRowIndex = this.tblFuncLeft.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncLeft.getRow(selectRowIndex);
            String functionName = row.getCell("name").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgId());
            uiContext.put((Object)DimensionConstants.DIMENSION, (Object)this.getDimension());
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeID());
            uiContext.put((Object)"beginDate", this.getUIContext().get("beginDate"));
            uiContext.put((Object)"endDate", this.getUIContext().get("endDate"));
            MbgFunctionProcess process = new MbgFunctionProcess(functionName, (CoreUI)this, uiContext);
            process.process();
        }
        super.tblFuncLeft_tableClicked(e);
    }

    @Override
    protected void tblFuncRight_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int selectRowIndex = this.tblFuncRight.getSelectManager().getActiveRowIndex();
            if (selectRowIndex < 0) {
                return;
            }
            IRow row = this.tblFuncRight.getRow(selectRowIndex);
            String functionStr = row.getCell("name").getValue().toString();
            String functionName = MbgFunctionHelper.getFunctionNameByFunParam(functionStr);
            BgDimensionMember member = BizCalcClientHelper.parseFXMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)functionStr);
            BgDetailMemberEnum detailMem = MbgFunctionHelper.getDetailMemberByFuncParam(functionStr);
            MbgViewListResultData resultListOne = null;
            MbgViewListResultData resultListTwo = null;
            if (functionName.indexOf("@Remove") != -1) {
                String param = functionStr.substring(functionStr.indexOf("("), functionStr.lastIndexOf(")"));
                String listOne = param.substring(param.indexOf("[") + 1, param.indexOf("L2") - 2);
                String listTwoTmp = param.substring(param.indexOf("L2"), param.lastIndexOf("]"));
                String listTwo = listTwoTmp.substring(listTwoTmp.indexOf("[") + 1);
                MbgFunctionHelper.getMemNumByScopeMemFunction(functionStr);
                resultListOne = BizCalcClientHelper.parseAllFXMultiMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)listOne);
                resultListTwo = BizCalcClientHelper.parseAllFXMultiMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)listTwo);
            } else {
                member = BizCalcClientHelper.parseFXMember((BgSchemeDimensionHelper)this.getSelectHelper().getSchemeHelper(), (String)"FX", (String)functionStr);
                detailMem = MbgFunctionHelper.getDetailMemberByFuncParam(functionStr);
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgId());
            uiContext.put((Object)DimensionConstants.DIMENSION, (Object)this.getDimension());
            uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeID());
            uiContext.put((Object)"MEMBER", (Object)member);
            uiContext.put((Object)"bgDetailMember", (Object)detailMem);
            uiContext.put((Object)"isOpenByExist", (Object)true);
            uiContext.put((Object)"existMember", (Object)functionStr);
            uiContext.put((Object)"ExistListOne", (Object)resultListOne);
            uiContext.put((Object)"ExistListTwo", (Object)resultListTwo);
            MbgFunctionProcess openFun = new MbgFunctionProcess(functionName, (CoreUI)this, uiContext);
            openFun.process();
        }
        super.tblFuncRight_tableClicked(e);
    }

    public void removeFunction(String oldFunction) {
        this.curSelectedFunction.remove(oldFunction);
        int deleteRowIndex = -1;
        for (int i = 0; i < this.tblFuncRight.getRowCount(); ++i) {
            String rowFunction = this.tblFuncRight.getRow(i).getCell("name").getValue().toString();
            if (!oldFunction.equals(rowFunction)) continue;
            deleteRowIndex = i;
            break;
        }
        this.tblFuncRight.removeRow(deleteRowIndex);
        this.tblFuncRight.setRowCount(this.tblFuncRight.getRowCount() - 1);
    }

    protected void btnEnd_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("Owner") instanceof BizCalcMainUI) {
            ((BizCalcMainUI)this.getUIContext().get("Owner")).setTableLostFocus();
        }
        super.btnEnd_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        boolean bl = this.canSelectType = this.getUIContext().get(CAN_SELECT_TYPE) != null ? (Boolean)this.getUIContext().get(CAN_SELECT_TYPE) : true;
        if (!this.canSelectType) {
            this.cbxSelectType.setEnabled(false);
        }
    }
}

