/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.AbstractBgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeReportFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgCalcSchemeReportListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgCalcSchemeReportListUI
extends AbstractBgCalcSchemeReportListUI {
    private static final long serialVersionUID = -8327759791583879250L;
    private static final Logger logger = CoreUIObject.getLogger(BgCalcSchemeReportListUI.class);
    private static final String COL_ORGUNIT_NAME = "orgUnit.name";
    private static final String COL_ORGUNIT_NUMBER = "orgUnit.number";
    private static final String COL_BGTEMPLATE_NAME = "bgTemplate.name";
    private static final String COL_BGTEMPLATE_NUMBER = "bgTemplate.number";
    private static final String COL_BGPERIOD_NAME = "bgPeriod.name";
    private static final String COL_BGPERIOD_NUMBER = "bgPeriod.number";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BgCalcSchemeReportListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    protected void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.afterDataFill(e);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        String bgCalcSchemeId = null;
        AbstractBgCalculateSchemeInfo bgCalculateSchemeInfo = null;
        BgSchemeDimensionHelper schemeHelper = null;
        HashSet<String> orgIds = new HashSet<String>();
        if (this.getUIContext().containsKey("ID")) {
            bgCalcSchemeId = (String)this.getUIContext().get("ID");
            schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
            try {
                bgCalculateSchemeInfo = BgCalculateSchemeFactory.getRemoteInstance().getBgCalculateSchemeInfo("select name,number,id,rootid, orgUnit.id where id = '" + bgCalcSchemeId + "'");
                BgOrgUnitInfo bgOrgUnit = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId, number, name, longNumber where viewId = '" + schemeHelper.getBgOrgViewId() + "' and orgUnitId = '" + bgCalculateSchemeInfo.getOrgUnit().getId() + "' and isVirtual = 0");
                BgOrgUnitCollection orgCol = MbgDataHelper.getBgOrgUnitChildren(bgOrgUnit, schemeHelper.getBgOrgViewId());
                if (orgCol != null && !orgCol.isEmpty()) {
                    for (int i = 0; i < orgCol.size(); ++i) {
                        orgIds.add(orgCol.get(i).getOrgUnitID());
                    }
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        FilterItemInfo filterItem = new FilterItemInfo("bgCalcScheme.rootId", (Object)(bgCalcSchemeId != null ? bgCalculateSchemeInfo.getRootId().toString() : "000000000000000000000000000="), CompareType.EQUALS);
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null || filter.getFilterItems().size() == 0) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(filterItem);
            if (!orgIds.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
            }
        } else {
            viewInfo.setFilter(filter);
            if (BgNFCHelper.findFilterItem(filter, "bgCalcScheme.rootId") == null) {
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("(" + filter.getMaskString() + ")AND #" + (filter.getFilterItems().size() - 1));
            }
            if (BgNFCHelper.findFilterItem(filter, "orgUnit.id") == null && !orgIds.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
                filter.setMaskString("(" + filter.getMaskString() + ")AND #" + (filter.getFilterItems().size() - 1));
            }
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void afterDataFill(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        String orgNumber = null;
        String orgName = null;
        String bgTemplateNumber = null;
        String bgTemplateName = null;
        String bgPeriodNumber = null;
        String bgPeriodName = null;
        int in = lastRow;
        for (int i = firstRow; i <= in; ++i) {
            orgNumber = (String)this.tblMain.getCell(i, COL_ORGUNIT_NUMBER).getValue();
            orgName = (String)this.tblMain.getCell(i, COL_ORGUNIT_NAME).getValue();
            this.tblMain.getCell(i, COL_ORGUNIT_NAME).setValue((Object)(orgNumber + "(" + orgName + ")"));
            bgTemplateNumber = (String)this.tblMain.getCell(i, COL_BGTEMPLATE_NUMBER).getValue();
            bgTemplateName = (String)this.tblMain.getCell(i, COL_BGTEMPLATE_NAME).getValue();
            this.tblMain.getCell(i, COL_BGTEMPLATE_NAME).setValue((Object)(bgTemplateNumber + "(" + bgTemplateName + ")"));
            bgPeriodNumber = (String)this.tblMain.getCell(i, COL_BGPERIOD_NUMBER).getValue();
            bgPeriodName = (String)this.tblMain.getCell(i, COL_BGPERIOD_NAME).getValue();
            this.tblMain.getCell(i, COL_BGPERIOD_NAME).setValue((Object)(bgPeriodNumber + "(" + bgPeriodName + ")"));
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{COL_ORGUNIT_NAME, COL_BGTEMPLATE_NAME};
        return locateNames;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void initListener() {
        super.initListener();
        AbstractAction actionClearException = new AbstractAction(){
            private static final long serialVersionUID = 7399674953197137838L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgCalcSchemeReportListUI.this.actionClearException_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgCalcSchemeReportListUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_SHIFT_F6";
        KeyStroke ks = KeyStroke.getKeyStroke(117, 192, false);
        this.getActionMap().put(strKey, actionClearException);
        this.getInputMap(2).put(ks, strKey);
    }

    public void actionClearException_actionPerformed(ActionEvent e) {
        int re = MsgBox.showConfirm2((String)BgNFSHelper.getHardCodeRes("clearException"));
        if (re == 0) {
            try {
                BgCalculateSchemeReportFactory.getRemoteInstance().updateResultException();
            }
            catch (EASBizException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
        }
    }
}

