/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.AssignSolutionCollection;
import com.kingdee.eas.ma.mbg.AssignSolutionFactory;
import com.kingdee.eas.ma.mbg.AssignSolutionInfo;
import com.kingdee.eas.ma.mbg.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeCollection;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgCalculateSchemeFacade;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.client.AbstractBgCalculateSchemeAssignUI;
import com.kingdee.eas.ma.mbg.client.BgCalcSchemeSearchKeyEnum;
import com.kingdee.eas.ma.mbg.client.BgCalculateSchemeAssignReportUI;
import com.kingdee.eas.ma.mbg.client.BgPropertyChooseUI;
import com.kingdee.eas.ma.mbg.client.utils.AssignSolutionInterface;
import com.kingdee.eas.ma.mbg.designer.IAction;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgUnitBaseUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgCalculateSchemeAssignUI
extends AbstractBgCalculateSchemeAssignUI
implements PropertyChangeListener,
AssignSolutionInterface,
KeyListener {
    private static final long serialVersionUID = -8439174361976363170L;
    private static final Logger logger = CoreUIObject.getLogger(BgCalculateSchemeAssignUI.class);
    public static final String COL_ID = "id";
    public static final String COL_select = "select";
    public static final String COL_number = "number";
    public static final String COL_name = "name";
    public static final String COL_creator = "creator";
    public static final String COL_createtime = "createtime";
    public static final String COL_temType = "temType";
    private static final Color NO_DISPATCHED = Color.BLACK;
    private static final Color DISPATCHED_BY_CURRSCHEME = Color.RED;
    private static final Color NOFINANCE = Color.GRAY;
    protected Set<String> selectIds = null;
    private Set<BOSUuid> companyIds = new HashSet<BOSUuid>();
    private Map<BOSUuid, Set<BOSUuid>> dispatchMap = new HashMap<BOSUuid, Set<BOSUuid>>();
    private TreeModel oldTree = null;
    private TreeWillExpandListener listener = null;
    private BgCalculateSchemeCollection temColls = new BgCalculateSchemeCollection();
    private KDPopupMenu popMenu = new KDPopupMenu();
    private LongTimeDialog dialog = null;
    private boolean isRefeshOrgUnitTree = false;
    private BgCalcSchemeSearchKeyEnum lastSearchKey = BgCalcSchemeSearchKeyEnum.orgName;
    private String lastSearchValue = "";

    public Set<String> getSelectIds() {
        return this.selectIds;
    }

    public void setSelectIds(Set<String> selectIds) {
        this.selectIds = selectIds;
    }

    public Set<BOSUuid> getCompanyIds() {
        return this.companyIds;
    }

    public Map<BOSUuid, Set<BOSUuid>> getDispatchMap() {
        return this.dispatchMap;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public BgCalculateSchemeCollection getTemColls() {
        return this.temColls;
    }

    protected String getBgSchemeId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
    }

    protected BgSchemeInfo getBgScheme() {
        return (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
    }

    protected String getBgOrgViewId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGORGVIEW_ID);
    }

    protected String getOrgUnitId() {
        return this.getOrgId();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void onLoad() throws Exception {
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        super.onLoad();
        if (this.getUIContext().get("selectTemplates") != null) {
            this.setSelectIds((Set)this.getUIContext().get("selectTemplates"));
        } else {
            this.setSelectIds(new HashSet<String>());
        }
        this.init();
        this.initQuickSearch();
    }

    protected void initQuickSearch() {
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtKey, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtKey.addKeyListener((KeyListener)this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.doSearch();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnClearAllTem.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectAllTem.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void initListener() {
        super.initListener();
        this.treeOrgUnit.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                BgCalculateSchemeAssignUI.this.treeOrgUnit_nodeStateChange(event);
            }
        });
        this.iniPoppMenu();
    }

    protected String getSelectOrgViewId() {
        return this.getBgOrgViewId();
    }

    protected void init() throws Exception {
        BgOrgTreeHelper.resetAction(this.treeViewOrgUnit, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgCalculateSchemeAssignUI.this.loadOrgUnitTree();
                TreeNode root = (TreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getModel().getRoot();
                BgCalculateSchemeAssignUI.this.treeOrgUnit.expandAllNodes(true, root);
            }
        });
        this.initData();
        this.initBgOrgUnit();
        this.initBgTemplate();
    }

    protected void initData() throws Exception {
        this.initCompanyIds();
        this.initDispatchData();
    }

    protected void initBgOrgUnit() throws Exception {
        String schemeOrgId = this.getBgScheme().getOrgUnit().getId().toString();
        if (!schemeOrgId.equals(this.getOrgUnitId())) {
            String bgOrgId = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(this.getOrgUnitId(), this.getSelectOrgViewId(), false);
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, bgOrgId, this.getListener(), this.getSelectOrgViewId(), true, null, false));
        } else {
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, null, this.getListener(), this.getSelectOrgViewId(), true, null, false));
        }
        this.setRefeshOrgUnitTree(false);
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.setModel(this.getOldTree());
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitId(), null);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        this.afterReloadOrgTree(root);
    }

    protected void afterReloadOrgTree(DefaultKingdeeTreeNode root) {
        if (root != null && root.getChildCount() > 0) {
            int in = root.getChildCount();
            for (int i = 0; i < in; ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OrgUnitBaseUtils.expandNode(this.treeOrgUnit, child);
            }
        }
    }

    protected void initBgTemplate() throws Exception {
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.temTable.getColumn(COL_createtime).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getTemColls().clear();
        BgCalculateSchemeCollection colls = this.getBgTemplateColls(this.getBgSchemeId(), this.getOrgUnitId());
        if (colls != null) {
            int i;
            BgCalculateSchemeInfo template = null;
            int in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (!this.selectIds.contains(template.getId().toString())) continue;
                this.getTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, true);
            }
            in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (this.selectIds.contains(template.getId().toString())) continue;
                this.getTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, false);
            }
            this.temTable.getSelectManager().select(0, 0);
        }
    }

    protected void addRowByTemplate(KDTable table, BgCalculateSchemeInfo template, boolean isChoose) {
        if (table == null || template == null) {
            return;
        }
        IRow row = this.temTable.addRow();
        row.setUserObject((Object)template);
        row.getCell(COL_ID).setValue((Object)template.getId());
        row.getCell(COL_select).setValue((Object)isChoose);
        row.getCell(COL_number).setValue((Object)template.getNumber());
        row.getCell(COL_name).setValue((Object)template.getName());
        row.getCell(COL_creator).setValue((Object)template.getCreator().getName());
        row.getCell(COL_createtime).setValue((Object)template.getCreateTime());
    }

    protected BgCalculateSchemeCollection getBgTemplateColls(String bgSchemeId, String orgUnitId) throws Exception {
        return (BgCalculateSchemeCollection)((Object)this.getUIContext().get("InitDataObject"));
    }

    protected void buildBgOrgTree(List<BgOrgUnitInfo> orgUnitColl, String bgOrgViewId, List<String> nodeOrgIDList) throws BOSException, Exception {
        this.treeViewOrgUnit.setShowButton(true);
        this.treeViewOrgUnit.updateUI();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(false);
        TreeModel bgOrgTreeModel = null;
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            return;
        }
        TreePath path = null;
        List<DefaultKingdeeTreeNode> nodeList = null;
        bgOrgTreeModel = BgOrgTreeHelper.buildMultiTreeModel(orgUnitColl);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)bgOrgTreeModel.getRoot();
        root.setCheckBoxVisible(false);
        this.treeOrgUnit.setModel(bgOrgTreeModel);
        this.setOldTree(bgOrgTreeModel);
        this.treeOrgUnit.getSelectionModel().setSelectionMode(4);
        if (EmptyUtil.isEmpty(nodeOrgIDList)) {
            this.treeOrgUnit.expandOnLevel(3);
        } else {
            nodeList = BgOrgTreeHelper.findForAllExtendNode(root, nodeOrgIDList);
            for (DefaultKingdeeTreeNode node : nodeList) {
                if (node == null) continue;
                path = new TreePath(node.getPath());
                this.treeOrgUnit.expandPath(path);
            }
        }
        this.treeOrgUnit.setShowCheckBox(true);
        Set userSet = BgOrgViewFactory.getRemoteInstance().getOrgUnitCollByViewId(BOSUuid.read((String)this.getBgOrgViewId()), true);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable(root, true, true, this.getOrgUnitId(), userSet);
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowsRootHandles(true);
        this.treeOrgUnit.repaint();
    }

    protected void initCompanyIds() throws Exception {
        this.getCompanyIds().addAll(this.queryCompanyIds());
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance().queryCompanyIds();
    }

    protected void initDispatchData() throws Exception {
        this.getDispatchMap().clear();
        Map tmpMap = this.getDispatchInterface().queryDispatchInfo(BOSUuid.read((String)this.getBgSchemeId()));
        if (tmpMap != null && !tmpMap.isEmpty()) {
            Map disMap = (Map)tmpMap.get(BgSchemeDispatchConstants.SCHEME_DISPATCH);
            this.getDispatchMap().putAll(disMap);
        }
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"allLeafOrg"));
        menuItem.addActionListener((ActionListener)new AllLeafOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new AllSubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectDispatch"));
        menuItem.addActionListener((ActionListener)new DispatchOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectCompany"));
        menuItem.addActionListener((ActionListener)new CompanyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"propertyChoose"));
        menuItem.addActionListener((ActionListener)new PropertyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
    }

    private Set<String> getOrgIdByFid(Set ids) {
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitCollection unitCol = null;
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add("orgUnitID");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("ViewId", (Object)this.getBgOrgViewId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        try {
            iBgOrgUnit = BgOrgUnitFactory.getRemoteInstance();
            unitCol = iBgOrgUnit.getBgOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (unitCol == null || unitCol.isEmpty()) {
            return null;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            set.add(unitCol.get(i).getOrgUnitID());
        }
        return set;
    }

    protected void treeOrgUnit_nodeStateChange(TreeNodeStateChangeEvent event) {
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.fillOrgUnitColor();
    }

    protected BgCalculateSchemeInfo getSelectedTemplate() {
        int rowIndex = this.temTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        IRow row = this.temTable.getRow(rowIndex);
        BgCalculateSchemeInfo template = (BgCalculateSchemeInfo)row.getUserObject();
        return template;
    }

    protected List<String> getSelectedTemplateIds() {
        ArrayList<String> selBgTemplateIds = new ArrayList<String>();
        Object obj = null;
        IRow row = null;
        BgCalculateSchemeInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgCalculateSchemeInfo)row.getUserObject();
            obj = row.getCell(COL_select).getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            selBgTemplateIds.add(template.getId().toString());
        }
        return selBgTemplateIds;
    }

    protected void selectedTemplateIds(Collection<String> selBgTemplateIds) {
        IRow row = null;
        BgCalculateSchemeInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgCalculateSchemeInfo)row.getUserObject();
            if (selBgTemplateIds != null && selBgTemplateIds.contains(template.getId().toString())) {
                row.getCell(COL_select).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(COL_select).setValue((Object)Boolean.FALSE);
        }
    }

    protected List<String> getSelectedOrgUnitIds() {
        return BgOrgUnitUtils.getSelectOrgUnitIds(this.treeOrgUnit);
    }

    @Override
    public void clear() throws Exception {
        BgOrgViewInfo orgView = new BgOrgViewInfo();
        orgView.setId(BOSUuid.read((String)this.getBgOrgViewId()));
        this.selectedTemplateIds(this.getSelectIds());
        this.txtKey.setUserObject(null);
        this.txtKey.setText("");
        this.lastSearchValue = "";
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
        this.treeOrgUnit.repaint();
    }

    @Override
    public Object saveSolution() throws Exception {
        HashMap<String, String> solution = new HashMap<String, String>();
        solution.put("BGORGVIEW_ID", this.getSelectOrgViewId());
        solution.put(BgBaseConstants.BGTEMPLATE_ID, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(this.getSelectedTemplateIds())));
        solution.put(BgBaseConstants.ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(this.getSelectedOrgUnitIds())));
        return solution;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        if (o instanceof Map) {
            Map solution = (Map)o;
            BgOrgViewInfo orgView = new BgOrgViewInfo();
            if (solution.get("BGORGVIEW_ID") instanceof String) {
                orgView.setId(BOSUuid.read((String)((String)solution.get("BGORGVIEW_ID"))));
            } else {
                orgView.setId(BOSUuid.read((String)this.getBgOrgViewId()));
            }
            if (solution.containsKey(BgBaseConstants.BGTEMPLATE_ID)) {
                Collection selBgTemplateIds = (Collection)BgAnalyseHelper.getObject(BgAnalyseHelper.decode((String)solution.get(BgBaseConstants.BGTEMPLATE_ID)));
                this.selectedTemplateIds(selBgTemplateIds);
            }
            if (solution.containsKey(BgBaseConstants.ORGUNIT_IDS)) {
                Collection selOrgUnitIds = (Collection)BgAnalyseHelper.getObject(BgAnalyseHelper.decode((String)solution.get(BgBaseConstants.ORGUNIT_IDS)));
                HashSet ids = null;
                if (selOrgUnitIds instanceof Set) {
                    ids = (HashSet)selOrgUnitIds;
                } else if (selOrgUnitIds != null) {
                    ids = new HashSet(selOrgUnitIds);
                }
                final HashSet copy = ids;
                IAction after = new IAction(){

                    @Override
                    public String getID() {
                        return null;
                    }

                    @Override
                    public void doAction() throws Exception {
                        BgOrgUnitUtils.selectOrgUnit(BgCalculateSchemeAssignUI.this.treeOrgUnit, (Set<String>)copy);
                    }
                };
                this.loadOrgUnitTree(after);
            }
        }
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = this.getBgSchemeId();
        String operateType = null;
        if (this.getUIContext().get("operateType") != null) {
            operateType = (String)this.getUIContext().get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String CUID = this.getCuId();
            oql.append(" and cuid='" + CUID + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = this.getOrgId();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + this.getClass().getName() + "'");
        oql.append(" order by isSystemSolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (asSolutionCol != null && !asSolutionCol.isEmpty()) {
            Object[] arrays = asSolutionCol.toArray();
            Arrays.sort(arrays, new Comparator(){

                public int compare(Object o1, Object o2) {
                    AssignSolutionInfo as1 = (AssignSolutionInfo)o1;
                    AssignSolutionInfo as2 = (AssignSolutionInfo)o2;
                    int result = Boolean.valueOf(as2.isIsSystemSolution()).compareTo(as1.isIsSystemSolution());
                    if (result == 0) {
                        result = as1.getSolutionName().compareTo(as2.getSolutionName());
                    }
                    return result;
                }
            });
            asSolutionCol = new AssignSolutionCollection();
            for (int i = 0; i < arrays.length; ++i) {
                asSolutionCol.add((AssignSolutionInfo)arrays[i]);
            }
        }
        return asSolutionCol;
    }

    public String getCuId() {
        return (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_CU);
    }

    public String getOrgId() {
        return (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = this.getBgSchemeId();
        String operateType = null;
        if (this.getUIContext().get("operateType") != null) {
            operateType = (String)this.getUIContext().get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution = 1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + this.getClass().getName() + "'");
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    @Override
    public void verifyData() throws Exception {
        List<String> bgOrgUnitIds;
        super.verifyData();
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)("selectCalcSchemeOrOrg" + this.getMessageFlag())));
            SysUtil.abort();
        }
        if ((bgOrgUnitIds = this.getSelectedOrgUnitIds()) == null || bgOrgUnitIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)("selectCalcSchemeOrOrg" + this.getMessageFlag())));
            SysUtil.abort();
        }
    }

    protected String getMessageFlag() {
        return "";
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.verifyData();
        this.assign();
        return false;
    }

    protected void assign() throws Exception {
        final String bgSchemeId = this.getBgSchemeId();
        final List<String> calcSchemeIds = this.getSelectedTemplateIds();
        final List<String> orgUnitIds = this.getSelectedOrgUnitIds();
        if (StringUtils.isEmpty((String)bgSchemeId) || calcSchemeIds == null || calcSchemeIds.isEmpty() || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return;
        }
        HashSet<String> rootIds = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("rootId");
        evi.getSelector().add(COL_ID);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, new HashSet<String>(calcSchemeIds), CompareType.INCLUDE));
        BgCalculateSchemeCollection col = BgCalculateSchemeFactory.getRemoteInstance().getBgCalculateSchemeCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            rootIds.add(col.get(i).getRootId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rootId", rootIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", new HashSet<String>(orgUnitIds), CompareType.INCLUDE));
        boolean _isReplace = false;
        if (BgCalculateSchemeFactory.getRemoteInstance().exists(filter)) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"hasassigned"));
            if (MsgBox.isCancel((int)result)) {
                return;
            }
            _isReplace = MsgBox.isYes((int)result);
        }
        final boolean isReplace = _isReplace;
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                return BgCalculateSchemeAssignUI.this.getDispatchInterface().assign(bgSchemeId, calcSchemeIds, orgUnitIds, isReplace);
            }

            public void afterExec(Object result) throws Exception {
                List _result = (List)result;
                if (_result != null) {
                    BgOrgTreeHelper.selectAllSubNode((DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getModel().getRoot(), false);
                    BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH, (Object)Boolean.TRUE);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)_result);
                    uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)BgCalculateSchemeAssignUI.this.getBgScheme());
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCalculateSchemeAssignUI.this.getDispatchReportUIName(), (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
            }
        });
        this.dialog.show();
        this.setRefeshOrgUnitTree(false);
        this.initDispatchData();
        this.refeshOrgUnitTree();
    }

    protected String getDispatchReportUIName() {
        return BgCalculateSchemeAssignReportUI.class.getName();
    }

    protected String getPropertyChooseUIName() {
        return BgPropertyChooseUI.class.getName();
    }

    @Override
    public boolean cancel() throws Exception {
        this.destroyWindow();
        return true;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    public LongTimeDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    protected void loadOrgUnit() {
        if (!this.isRefeshOrgUnitTree()) {
            this.loadOrgUnitTree(null);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void loadOrgUnitTree() {
        this.loadOrgUnitTree(null);
    }

    private void loadOrgUnitTree(final IAction afterAction) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgCalculateSchemeAssignUI.this.refeshOrgUnitTree();
                if (afterAction != null) {
                    afterAction.doAction();
                }
                BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void refeshOrgUnitTree() throws Exception {
        if (!this.isRefeshOrgUnitTree() && this.getOldTree() != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            this.refeshOrgUnitTree(root);
            this.fillOrgUnitColor();
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1) {
            try {
                BgOrgUnitUtils.addChildNode(root, this.getSelectOrgViewId(), false);
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    protected void fillOrgUnitColor() throws Exception {
        BgCalculateSchemeInfo template = this.getSelectedTemplate();
        if (template != null) {
            this.fillOrgUnitColor(template);
            this.treeOrgUnit.repaint();
        }
    }

    protected void fillOrgUnitColor(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        BgCalculateSchemeInfo template = this.getSelectedTemplate();
        if (template != null) {
            this.fillOrgUnitColor(template, root);
            this.treeOrgUnit.repaint();
        }
    }

    protected void fillOrgUnitColor(BgCalculateSchemeInfo template) throws Exception {
        if (template == null || this.treeOrgUnit.getModel() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.fillOrgUnitColor(template, root);
    }

    protected void fillOrgUnitColor(BgCalculateSchemeInfo template, DefaultKingdeeTreeNode root) throws Exception {
        if (template == null || root == null) {
            return;
        }
        Set<BOSUuid> orgUnitIds = this.getDispatchMap().get(template.getId());
        if (orgUnitIds == null) {
            orgUnitIds = new HashSet<BOSUuid>();
        }
        this.fillOrgUnitColor(root, orgUnitIds);
    }

    protected void fillOrgUnitColor(DefaultKingdeeTreeNode root, Set<BOSUuid> orgUnitIds) {
        if (root == null || orgUnitIds == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        BOSUuid uuid = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                bgOrgUnit = (BgOrgUnitInfo)node.getUserObject();
                uuid = BOSUuid.read((String)bgOrgUnit.getOrgUnitID());
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    uuid = oui.getUnit().getId();
                }
            } else if (node.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)node.getUserObject();
                uuid = tmpUnit.getId();
            }
            if (uuid != null && !uuid.toString().equals(this.getOrgUnitId()) && orgUnitIds.contains(uuid)) {
                node.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                node.setTextColor(NO_DISPATCHED);
            }
            if (node.isLeaf()) continue;
            this.fillOrgUnitColor(node, orgUnitIds);
        }
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_select).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_select).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), true);
        this.treeOrgUnit.expandOnLevel(7);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        }
        BgOrgUnitUtils.selectOrgUnit(node, false);
        this.treeOrgUnit.repaint();
    }

    @Override
    public void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.doSearch();
    }

    protected void doSearch() {
        boolean lastIsOrg;
        String value = this.txtKey.getText();
        BgCalcSchemeSearchKeyEnum keyEnum = (BgCalcSchemeSearchKeyEnum)((Object)this.comboSearchKey.getSelectedItem());
        if (this.lastSearchKey.equals((Object)keyEnum) && StringUtils.equals((String)value, (String)this.lastSearchValue)) {
            return;
        }
        boolean thisIsOrg = BgCalcSchemeSearchKeyEnum.orgName.equals((Object)keyEnum) || BgCalcSchemeSearchKeyEnum.orgNumber.equals((Object)keyEnum);
        boolean bl = lastIsOrg = BgCalcSchemeSearchKeyEnum.orgName.equals((Object)this.lastSearchKey) || BgCalcSchemeSearchKeyEnum.orgNumber.equals((Object)this.lastSearchKey);
        if (StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)this.lastSearchValue) && thisIsOrg == lastIsOrg) {
            return;
        }
        this.lastSearchKey = keyEnum;
        this.lastSearchValue = value;
        if (StringUtils.isEmpty((String)value)) {
            this.restartTemplateColls(this.getTemColls());
            this.treeOrgUnit.setModel(this.getOldTree());
            this.afterReloadOrgTree((DefaultKingdeeTreeNode)this.getOldTree().getRoot());
            this.treeOrgUnit.updateUI();
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            return;
        }
        BgCalculateSchemeInfo template = this.getSelectedTemplate();
        Set<Object> orgUnitIds = null;
        orgUnitIds = template != null ? this.getDispatchMap().get(template.getId()) : new HashSet();
        TreeModel model = null;
        if (keyEnum.getValue() == 0 || keyEnum.getValue() == 10) {
            if (keyEnum.getValue() == 0) {
                model = BgOrgUnitUtils.clipAndCloneTreeModel(this.getOldTree(), new String[]{COL_name}, value, true, orgUnitIds);
            } else if (keyEnum.getValue() == 10) {
                model = BgOrgUnitUtils.clipAndCloneTreeModel(this.getOldTree(), new String[]{COL_number}, value, true, orgUnitIds);
            }
            this.treeOrgUnit.setModel(model);
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitId(), null);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            if (root != null) {
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
                root.setChecked(false);
            }
            this.treeOrgUnit.expandOnLevel(7);
        } else if (keyEnum.getValue() == 30) {
            this.filterTemplateColls(this.getTemColls(), COL_number, value, true);
        } else if (keyEnum.getValue() == 20) {
            this.filterTemplateColls(this.getTemColls(), COL_name, value, true);
        }
    }

    protected void restartTemplateColls(BgCalculateSchemeCollection colls) {
        List<String> selectIds = this.getSelectedTemplateIds();
        this.temTable.removeRows();
        if (colls == null) {
            return;
        }
        BgCalculateSchemeInfo template = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            this.addRowByTemplate(this.temTable, template, selectIds != null && selectIds.contains(template.getId().toString()));
        }
        this.temTable.repaint();
    }

    protected void filterTemplateColls(BgCalculateSchemeCollection colls, String fields, String value, boolean isBlured) {
        this.temTable.removeRows();
        if (colls == null || fields == null || value == null) {
            return;
        }
        BgCalculateSchemeInfo template = null;
        Object obj = null;
        String tmpValue = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            obj = template.get(fields);
            if (obj == null) continue;
            tmpValue = obj.toString();
            if (isBlured) {
                if (tmpValue.indexOf(value) < 0) continue;
                this.addRowByTemplate(this.temTable, template, false);
                continue;
            }
            if (!tmpValue.equals(value)) continue;
            this.addRowByTemplate(this.temTable, template, false);
        }
        this.temTable.repaint();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeId());
            request.put(BgBaseConstants.BGORGVIEW_ID, (Object)this.getBgOrgViewId());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitId());
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserPk().toString());
        }
        return handler;
    }

    protected IBgOrgView getBgOrgViewInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    protected IBgCalculateSchemeFacade getDispatchInterface() throws BOSException {
        return BgCalculateSchemeFacadeFactory.getRemoteInstance();
    }

    class PropertyListener
    implements ActionListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set<String> set = new HashSet<String>();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCalculateSchemeAssignUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getModel().getRoot();
            if (set != null) {
                set = BgCalculateSchemeAssignUI.this.getOrgIdByFid(set);
            }
            BgOrgUnitUtils.selectOrgUnitIds(node, set);
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class CompanyListener
    implements ActionListener {
        CompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgCalculateSchemeAssignUI.this.getCompanyIds());
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class AllSubOrgUnitListener
    implements ActionListener {
        AllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgUnitListener
    implements ActionListener {
        AllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgUnitUtils.selectOrgUnit(BgCalculateSchemeAssignUI.this.treeOrgUnit.getModel(), true);
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class DispatchOrgUnitListener
    implements ActionListener {
        DispatchOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgCalculateSchemeInfo template = BgCalculateSchemeAssignUI.this.getSelectedTemplate();
            if (template != null) {
                BgOrgUnitUtils.selectOrgUnitByIds(node, BgCalculateSchemeAssignUI.this.getDispatchMap().get(template.getRootId()));
            }
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class AllLeafOrgUnitListener
    implements ActionListener {
        AllLeafOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectLeafOrgUnit(node, true);
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class SubOrgUnitListener
    implements ActionListener {
        SubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCalculateSchemeAssignUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgCalculateSchemeAssignUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgCalculateSchemeAssignUI.this.getPopMenu().show((Component)BgCalculateSchemeAssignUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

