/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryTemplateInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemePeriodInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgReCalcSchemeHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgCalculateScheme;
import com.kingdee.eas.ma.mbg.IBgFinalizedFacade;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgCalculateSchemeGuideUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.common.BgProcessSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgCalculateSchemeGuideUI
extends AbstractBgCalculateSchemeGuideUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = 8775673430513103592L;
    private static final Logger logger = CoreUIObject.getLogger(BgCalculateSchemeGuideUI.class);
    protected static final String OBJECTDISPLAYSPLITTER = "; ";
    public static final String COL_number = "number";
    public static final String COL_name = "name";
    public static final String COL_formType = "formType";
    protected OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
    private BgSchemeDimensionHelper schemeHelper = null;
    private SimpleQuickQueryHandler leftQuickQuery = null;
    private SimpleQuickQueryHandler rightQuickQuery = null;
    private Map<String, BgCalculateSchemeEntryInfo> entryTemplateMap = new HashMap<String, BgCalculateSchemeEntryInfo>();
    private Map<String, BgCalculateSchemePeriodInfo> entryPeriodMap = new HashMap<String, BgCalculateSchemePeriodInfo>();
    private List<BgTemplateInfo> initTemplate = new ArrayList<BgTemplateInfo>();

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.editData != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.editData.getBgScheme().getId().toString());
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPeriodF7();
        this.initCurrencyF7();
        this.initBgVersionF7();
        this.initProcessTypeF7();
        this.leftQuickQuery = new SimpleQuickQueryHandler(this.txtLeftSearch, (ISimpleQuickQueryHandler)new SimpleQuick(this.txtLeftSearch, this.tblLeft), "");
        this.rightQuickQuery = new SimpleQuickQueryHandler(this.txtRightSearch, (ISimpleQuickQueryHandler)new SimpleQuick(this.txtRightSearch, this.tblRight), "");
        this.tblLeft.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgCalculateSchemeGuideUI.this.tblLeft_tableClicked(e);
                }
                catch (Exception e1) {
                    BgCalculateSchemeGuideUI.this.handUIExceptionAndAbort(e1);
                }
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initCBFinalized();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadProcessType();
            this.loadLeftTemplate();
            this.loadRightTemplate();
            this.txtNumber.setEnabled(OprtState.ADDNEW.equals(this.getOprtState()));
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                BgSchemeUtils.setDefualtMembers(this.getSchemeHelper(), (JComponent)this.prmtVersion, (JComponent)this.prmtPeriod, (JComponent)this.prmtCurrency, false, false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void loadProcessType() {
        if (StringUtils.isEmpty((String)this.editData.getProcessTypeNumber())) {
            this.prmtProcessType.setData(null);
        } else {
            String[] pnumbers = this.editData.getProcessTypeNumber().split(OBJECTDISPLAYSPLITTER);
            BgProcessEnum[] processTypes = new BgProcessEnum[pnumbers.length];
            for (int i = 0; i < pnumbers.length; ++i) {
                processTypes[i] = BgProcessEnum.getEnum(pnumbers[i]);
            }
            this.prmtProcessType.setData((Object)processTypes);
        }
    }

    protected void loadRightTemplate() {
        this.entryTemplateMap.clear();
        this.entryPeriodMap.clear();
        this.tblRight.removeRows();
        HashMap<String, Integer> templateRowIndex = new HashMap<String, Integer>();
        for (int r = 0; r < this.initTemplate.size(); ++r) {
            templateRowIndex.put(this.initTemplate.get(r).getId().toString(), r);
        }
        ArrayList<Integer> selectRowIndexes = new ArrayList<Integer>();
        LinkedHashMap<String, BgPeriodInfo> periodMap = new LinkedHashMap<String, BgPeriodInfo>();
        BgCalculateSchemeEntryInfo entryInfo = null;
        String bgTemplateId = null;
        String bgPeriodId = null;
        String key = null;
        for (int e = 0; e < this.editData.getEntry().size(); ++e) {
            entryInfo = this.editData.getEntry().get(e);
            bgTemplateId = entryInfo.getTemplate().getTemplate().getId().toString();
            this.entryTemplateMap.put(bgTemplateId, entryInfo);
            if (!templateRowIndex.containsKey(bgTemplateId)) continue;
            selectRowIndexes.add((Integer)templateRowIndex.get(bgTemplateId));
            for (int p = 0; p < entryInfo.getTemplate().getPeriod().size(); ++p) {
                bgPeriodId = entryInfo.getTemplate().getPeriod().get(p).getPeriod().getId().toString();
                key = this.getKey(bgTemplateId, bgPeriodId);
                this.entryPeriodMap.put(key, entryInfo.getTemplate().getPeriod().get(p));
                if (periodMap.containsKey(bgPeriodId)) continue;
                periodMap.put(bgPeriodId, entryInfo.getTemplate().getPeriod().get(p).getPeriod());
            }
        }
        BgPeriodCollection periodCol = new BgPeriodCollection();
        Iterator itP = periodMap.values().iterator();
        while (itP.hasNext()) {
            periodCol.add((BgPeriodInfo)itP.next());
        }
        if (periodCol.isEmpty()) {
            this.prmtPeriod.setData(null);
        } else {
            this.prmtPeriod.setData((Object)periodCol);
        }
        this.addToRight(selectRowIndexes, true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.storeProcessType();
            this.storeRightTemplate();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void storeProcessType() {
        StringBuffer processNumbers = new StringBuffer();
        StringBuffer processNames = new StringBuffer();
        Object[] processTypes = DimensionCommonHelper.getValues(this.prmtProcessType.getValue());
        if (processTypes == null || processTypes.length == 0) {
            this.editData.setProcessTypeName(null);
            this.editData.setProcessTypeNumber(null);
        } else {
            for (int i = 0; i < processTypes.length; ++i) {
                if (i > 0) {
                    processNames.append(OBJECTDISPLAYSPLITTER);
                    processNumbers.append(OBJECTDISPLAYSPLITTER);
                }
                processNames.append(((BgProcessEnum)((Object)processTypes[i])).getAlias());
                processNumbers.append(((BgProcessEnum)((Object)processTypes[i])).getName());
            }
            this.editData.setProcessTypeName(processNames.toString());
            this.editData.setProcessTypeNumber(processNumbers.toString());
        }
    }

    protected void storeRightTemplate() {
        int p;
        this.editData.getEntry().clear();
        if (DimensionCommonHelper.isEmpty(this.prmtPeriod.getData()) || this.tblRight.getRowCount() <= 0) {
            return;
        }
        Object[] periodInfos = DimensionCommonHelper.getValues(this.prmtPeriod.getData());
        BgTemplateInfo templateInfo = null;
        BgPeriodInfo periodInfo = null;
        String key = null;
        String bgTemplateId = null;
        BgCalculateSchemeEntryInfo entryInfo = null;
        BgCalculateSchemePeriodInfo calPeriodInfo = null;
        for (int r = 0; r < this.tblRight.getRowCount(); ++r) {
            templateInfo = (BgTemplateInfo)this.tblRight.getRow(r).getUserObject();
            bgTemplateId = templateInfo.getId().toString();
            if (this.entryTemplateMap.containsKey(bgTemplateId)) {
                entryInfo = this.entryTemplateMap.get(bgTemplateId);
            } else {
                entryInfo = new BgCalculateSchemeEntryInfo();
                entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                entryInfo.setBgCalculateScheme(this.editData);
                entryInfo.setTemplate(new BgCalculateSchemeEntryTemplateInfo());
                entryInfo.getTemplate().setId(BOSUuid.create((BOSObjectType)entryInfo.getTemplate().getBOSType()));
                entryInfo.getTemplate().setEntry(entryInfo);
                entryInfo.getTemplate().setTemplate(templateInfo);
                this.entryTemplateMap.put(bgTemplateId, entryInfo);
            }
            this.editData.getEntry().add(entryInfo);
            entryInfo.setSeq(r);
            entryInfo.getTemplate().getPeriod().clear();
            for (p = 0; p < periodInfos.length; ++p) {
                periodInfo = (BgPeriodInfo)periodInfos[p];
                key = this.getKey(templateInfo.getId(), periodInfo.getId());
                if (this.entryPeriodMap.containsKey(key)) {
                    calPeriodInfo = this.entryPeriodMap.get(key);
                } else {
                    calPeriodInfo = new BgCalculateSchemePeriodInfo();
                    calPeriodInfo.setId(BOSUuid.create((BOSObjectType)calPeriodInfo.getBOSType()));
                    calPeriodInfo.setPeriod(periodInfo);
                    calPeriodInfo.setTemplate(entryInfo.getTemplate());
                }
                entryInfo.getTemplate().getPeriod().add(calPeriodInfo);
                calPeriodInfo.setSeq(p);
            }
        }
        StringBuffer periodAlias = new StringBuffer();
        for (p = 0; p < periodInfos.length; ++p) {
            periodInfo = (BgPeriodInfo)periodInfos[p];
            if (periodAlias.length() > 0) {
                periodAlias.append(OBJECTDISPLAYSPLITTER);
            }
            periodAlias.append(periodInfo.getName()).append("(").append(periodInfo.getNumber().split("\\.")[0]).append(")");
        }
        this.editData.setPeriodNums(periodAlias.toString());
    }

    protected String getKey(Object bgTemplatId, Object bgPeriodId) {
        return bgTemplatId + "_" + bgPeriodId;
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblLeft.checkParsed();
        this.tblLeft.getSelectManager().setSelectMode(10);
        this.tblLeft.setEditable(false);
        this.tblRight.checkParsed();
        this.tblRight.getSelectManager().setSelectMode(10);
        this.tblRight.setEditable(false);
    }

    protected void loadLeftTemplate() throws Exception {
        this.tblLeft.removeRows();
        if (this.editData == null) {
            return;
        }
        BgTemplateCollection bgTemplateColl = this.getBgTemplateOfBgScheme(this.editData.getBgScheme().getId());
        for (int i = bgTemplateColl.size() - 1; i >= 0; --i) {
            if (!this.isRemoveTemplate(bgTemplateColl.get(i))) continue;
            bgTemplateColl.removeObject(i);
        }
        if (bgTemplateColl == null || bgTemplateColl.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < bgTemplateColl.size(); ++i) {
            ids.add(bgTemplateColl.get(i).getId().toString());
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        FilterInfo filter = MbgPermissionHelper.addBgTemplatePermission(this.editData.getBgScheme().getBgSchemeType().getSchemeType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), evi.getFilter(), this.editData.getBgScheme().getId().toString(), true);
        evi.setFilter(filter);
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add(COL_number);
        evi.getSelector().add(COL_name);
        evi.getSelector().add(COL_formType);
        evi.getSelector().add("templateStatus");
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo(COL_number));
        bgTemplateColl = BgTemplateFactory.getRemoteInstance().getBgTemplateCollection(evi);
        IRow row = null;
        this.initTemplate.clear();
        for (int i = 0; i < bgTemplateColl.size(); ++i) {
            this.initTemplate.add(bgTemplateColl.get(i));
            if (bgTemplateColl.get(i).getTemplateStatus().getValue() == 10) continue;
            row = this.tblLeft.addRow();
            this.loadToRow(row, bgTemplateColl.get(i));
        }
    }

    private void loadToRow(IRow row, BgTemplateInfo bgTemplateInfo) {
        row.setUserObject((Object)bgTemplateInfo);
        row.getCell(COL_number).setValue((Object)bgTemplateInfo.getNumber());
        row.getCell(COL_name).setValue((Object)bgTemplateInfo.getName());
        row.getCell(COL_formType).setValue((Object)bgTemplateInfo.getFormType());
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId) throws Exception {
        FullOrgUnitInfo org = this.editData.getOrgUnit();
        if (org == null) {
            org = SysContext.getSysContext().getCurrentCostUnit();
        }
        BgTemplateCollection selfCol = TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, org.getId().toString(), true);
        BgTemplateCollection normalCol = TemplateFacadeFactory.getRemoteInstance().getBgTemplateColls(bgSchemeId, org.getId().toString(), true, true);
        if (selfCol == null) {
            return normalCol;
        }
        if (normalCol == null) {
            return selfCol;
        }
        normalCol.addCollection(selfCol);
        normalCol.sort(COL_number);
        return normalCol;
    }

    protected boolean isRemoveTemplate(BgTemplateInfo info) {
        return false;
    }

    protected IObjectValue createNewData() {
        BgCalculateSchemeInfo info = new BgCalculateSchemeInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setRootId(info.getId());
        info.setBgScheme((BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO"));
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        info.setOrgUnit(orgUnit);
        info.setCreateOrgUnit(orgUnit);
        info.setProcessTypeNumber(BgProcessEnum.C01.getName());
        info.setProcessTypeName(BgProcessEnum.C01.getAlias());
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getEditSelectors();
    }

    public SelectorItemCollection getEditSelectors() {
        return BgReCalcSchemeHelper.getSelectors();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        BgCalculateSchemeInfo info = (BgCalculateSchemeInfo)this.getBizInterface().getValue(pk, this.getMergedSelector());
        if (info != null) {
            info.getEntry().sort("seq");
            for (int e = 0; e < info.getEntry().size(); ++e) {
                info.getEntry().get(e).getTemplate().getPeriod().sort("seq");
            }
        }
        return info;
    }

    protected IBgCalculateScheme getBizInterface() throws Exception {
        return BgCalculateSchemeFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLeftSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
        this.btnRightSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
    }

    private void initPeriodF7() throws Exception {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this, true);
        dialog.setBgSchemeID(this.editData.getBgScheme().getId().toString());
        this.prmtPeriod.setSelector((KDPromptSelector)dialog);
        dialog.dataChanged(new DataChangeEvent((Object)this.prmtPeriod, this.prmtPeriod.getData(), null));
        this.prmtPeriod.setRequired(true);
        this.prmtCurrency.setRequired(true);
        this.prmtPeriod.setEnabledMultiSelection(true);
        this.prmtPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    BgCalculateSchemeGuideUI.this.prmtPeriod_dataChanged(eventObj);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                    BgCalculateSchemeGuideUI.this.handUIException(e);
                }
            }
        });
        this.prmtPeriod.addDataChangeListener((DataChangeListener)dialog);
        if (this.prmtPeriod != null && this.prmtPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
            BgPeriodInfo periodInfo = null;
            Object objPeriod = this.prmtPeriod.getData();
            if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                periodInfo = (BgPeriodInfo)objPeriod;
                BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                bgPeriodDialog.setBgPeriods(periodArray);
            } else {
                bgPeriodDialog.setBgPeriods(null);
            }
        }
    }

    private void initBgVersionF7() throws Exception {
        DimensionMemberSelectHelper.addIdFilter(this.prmtVersion, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
    }

    private void initCurrencyF7() throws Exception {
        DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
    }

    private void initProcessTypeF7() throws Exception {
        BgProcessSelectDialog dialog = this.getBgProcessTypeDialog();
        this.prmtProcessType.setSelector((KDPromptSelector)dialog);
        this.prmtProcessType.addDataChangeListener((DataChangeListener)dialog);
        dialog.dataChanged(new DataChangeEvent((Object)this.prmtProcessType, this.prmtProcessType.getValue(), null));
    }

    protected BgProcessSelectDialog getBgProcessTypeDialog() {
        BgProcessSelectDialog dialog = new BgProcessSelectDialog((IUIObject)this, true);
        return dialog;
    }

    protected void prmtPeriod_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && e.getNewValue() instanceof Object[]) {
            Object[] obj = (Object[])e.getNewValue();
            if (obj.length == 0 || obj[0] == null) {
                return;
            }
            BgPeriodInfo[] periods = (BgPeriodInfo[])e.getNewValue();
            List<BgPeriodInfo> list = Arrays.asList(periods);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                periods[i] = list.get(i);
            }
            e.setNewValue((Object)periods);
        }
    }

    @Override
    protected void btnLeftSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnLeftSearch_actionPerformed(e);
        this.doQuickQuery(this.txtLeftSearch, this.tblLeft);
    }

    @Override
    protected void btnRightSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnRightSearch_actionPerformed(e);
        this.doQuickQuery(this.txtRightSearch, this.tblRight);
    }

    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.btnLToR_actionPerformed(null);
        }
    }

    @Override
    public void btnLToR_actionPerformed(ActionEvent e) throws Exception {
        List rowIndexs = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft);
        this.addToRight(rowIndexs, false);
    }

    @Override
    public void btnALToR_actionPerformed(ActionEvent e) throws Exception {
        List rowIndexs = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblLeft);
        this.addToRight(rowIndexs, false);
    }

    private void addToRight(List<Integer> rowIndexs, boolean isLoadField) {
        if (rowIndexs == null || rowIndexs.isEmpty()) {
            return;
        }
        Map<String, BgTemplateInfo> selectedMap = this.getSelectBgTemplateMap();
        IRow row = null;
        BgTemplateInfo info = null;
        ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
        if (!isLoadField) {
            Collections.sort(rowIndexs);
            for (int rowIndex : rowIndexs) {
                row = this.tblLeft.getRow(rowIndex);
                if (this.tblLeft.getRow(rowIndex).getStyleAttributes().isHided()) continue;
                removeIndexes.add(rowIndex);
                info = (BgTemplateInfo)row.getUserObject();
                if (selectedMap.containsKey(info.getNumber())) continue;
                this.loadToRow(this.tblRight.addRow(), info);
            }
        } else {
            Map<String, Integer> indexMap = this.getLeftBgTemplateIndexMap();
            for (int rowIndex : rowIndexs) {
                info = this.initTemplate.get(rowIndex);
                if (indexMap.containsKey(info.getNumber())) {
                    removeIndexes.add(indexMap.get(info.getNumber()));
                }
                if (selectedMap.containsKey(info.getNumber())) continue;
                this.loadToRow(this.tblRight.addRow(), info);
            }
        }
        Collections.sort(removeIndexes);
        Collections.reverse(removeIndexes);
        for (int rowIndex : removeIndexes) {
            this.tblLeft.removeRow(rowIndex);
        }
    }

    private Map<String, Integer> getLeftBgTemplateIndexMap() {
        LinkedHashMap<String, Integer> bgTemplateMap = new LinkedHashMap<String, Integer>();
        BgTemplateInfo info = null;
        for (int r = 0; r < this.tblLeft.getRowCount(); ++r) {
            info = (BgTemplateInfo)this.tblLeft.getRow(r).getUserObject();
            bgTemplateMap.put(info.getNumber(), r);
        }
        return bgTemplateMap;
    }

    private Map<String, BgTemplateInfo> getSelectBgTemplateMap() {
        LinkedHashMap<String, BgTemplateInfo> bgTemplateMap = new LinkedHashMap<String, BgTemplateInfo>();
        BgTemplateInfo info = null;
        for (int r = 0; r < this.tblRight.getRowCount(); ++r) {
            info = (BgTemplateInfo)this.tblRight.getRow(r).getUserObject();
            bgTemplateMap.put(info.getNumber(), info);
        }
        return bgTemplateMap;
    }

    @Override
    public void btnARToL_actionPerformed(ActionEvent e) throws Exception {
        this.removeFromRight(BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblRight));
    }

    @Override
    public void btnRToL_actionPerformed(ActionEvent e) throws Exception {
        this.removeFromRight(BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight));
    }

    protected void removeFromRight(List<Integer> rowIndexs) {
        if (rowIndexs == null || rowIndexs.isEmpty()) {
            return;
        }
        Collections.reverse(rowIndexs);
        HashMap<String, BgTemplateInfo> selectBgTemplateMap = new HashMap<String, BgTemplateInfo>();
        IRow row = null;
        BgTemplateInfo info = null;
        for (int rowIndex : rowIndexs) {
            row = this.tblRight.getRow(rowIndex);
            if (row.getStyleAttributes().isHided()) continue;
            info = (BgTemplateInfo)row.getUserObject();
            selectBgTemplateMap.put(info.getNumber().toLowerCase(), info);
            this.tblRight.removeRow(rowIndex);
        }
        if (selectBgTemplateMap.isEmpty()) {
            return;
        }
        ArrayList addNumbers = new ArrayList(selectBgTemplateMap.keySet());
        Collections.sort(addNumbers);
        Collections.reverse(addNumbers);
        for (int rowIndex = this.tblLeft.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
            row = this.tblLeft.getRow(rowIndex);
            info = (BgTemplateInfo)row.getUserObject();
            while (addNumbers.size() > 0 && info.getNumber().toLowerCase().compareTo((String)addNumbers.get(0)) <= 0) {
                if (this.tblLeft.getRowCount() == rowIndex + 1) {
                    this.loadToRow(this.tblLeft.addRow(), (BgTemplateInfo)selectBgTemplateMap.get(addNumbers.remove(0)));
                    continue;
                }
                this.loadToRow(this.tblLeft.addRow(rowIndex + 1), (BgTemplateInfo)selectBgTemplateMap.get(addNumbers.remove(0)));
            }
        }
        for (int i = 0; i < addNumbers.size(); ++i) {
            this.loadToRow(this.tblLeft.addRow(0), (BgTemplateInfo)selectBgTemplateMap.get(addNumbers.get(i)));
        }
    }

    @Override
    protected void btnTemTop_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveTop((KDTable)this.tblRight);
    }

    @Override
    protected void btnTemBottom_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveBottom((KDTable)this.tblRight);
    }

    @Override
    public void btnTemDown_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveDown((KDTable)this.tblRight);
    }

    @Override
    public void btnTemUp_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveUp((KDTable)this.tblRight);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"isClose")) == 0) {
            this.getUIWindow().close();
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BgCommCHelper.verifyEmpty((JComponent)this.txtNumber, (Object)this.txtNumber.getText(), (String)this.contNumber.getBoundLabelText());
        BgCommCHelper.verifyEmpty((JComponent)this.txtName, (Object)this.txtName.getDefaultLangItemData(), (String)this.contName.getBoundLabelText());
        BgCommCHelper.verifyEmpty((JComponent)this.prmtPeriod, (Object)this.prmtPeriod.getData(), (String)this.contPeriod.getBoundLabelText());
        BgCommCHelper.verifyEmpty((JComponent)this.prmtCurrency, (Object)this.prmtCurrency.getData(), (String)this.contCurrency.getBoundLabelText());
        BgCommCHelper.verifyEmpty((JComponent)this.prmtVersion, (Object)this.prmtVersion.getData(), (String)this.contVersion.getBoundLabelText());
        if (this.tblRight.getRowCount() <= 0) {
            this.tblRight.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"templateHasNull"));
            SysUtil.abort();
        }
    }

    protected void doQuickQuery(KDTextField txtSearch, KDTable table) {
        String searchText = txtSearch.getText().trim();
        if (table == this.tblRight) {
            boolean isEnable = StringUtils.isEmpty((String)searchText);
            this.btnTemBottom.setEnabled(isEnable);
            this.btnTemDown.setEnabled(isEnable);
            this.btnTemTop.setEnabled(isEnable);
            this.btnTemUp.setEnabled(isEnable);
        }
        boolean isMarch = false;
        IRow row = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow(r);
            isMarch = false;
            if (StringUtils.isEmpty((String)searchText)) {
                isMarch = true;
            } else {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    if (table.getColumn(c).getStyleAttributes().isHided() || String.valueOf(row.getCell(c).getValue()).indexOf(searchText) < 0) continue;
                    isMarch = true;
                    break;
                }
            }
            row.getStyleAttributes().setHided(!isMarch);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeCBFinalized();
    }

    protected void initCBFinalized() throws Exception {
        Boolean isFinalized = BgParamUtils.checkFinalized(null);
        BgOrgUnitInfo bgOrgUnitInfo = this.getBgOrgUnitInfo();
        if (bgOrgUnitInfo != null && bgOrgUnitInfo.getLevel() == 1 && isFinalized.booleanValue()) {
            this.cbFinalized.setEditable(true);
            this.cbFinalized.setEnabled(true);
            this.cbFinalized.setVisible(true);
            this.loadCBFinalized();
        }
    }

    protected BgOrgUnitInfo getBgOrgUnitInfo() throws EASBizException, BOSException {
        BgOrgUnitInfo bgOrgUnitInfo = null;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.getUIContext().get("BGORGUNIT_INFO") instanceof BgOrgUnitInfo) {
                bgOrgUnitInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
            }
        } else {
            bgOrgUnitInfo = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId, number, name, longNumber, level where viewId = '" + this.getSchemeHelper().getBgOrgViewId() + "' and orgUnitId = '" + this.editData.getOrgUnit().getId() + "' and isVirtual = 0");
        }
        return bgOrgUnitInfo;
    }

    protected void storeCBFinalized() throws EASBizException, BOSException {
        BgSchemeInfo bgSchemeInfo;
        if (this.cbFinalized.isVisible() && (bgSchemeInfo = this.editData.getBgScheme()) != null && this.editData.getOrgUnit() != null && this.editData.getId() != null) {
            IBgFinalizedFacade iBgFinalizedFacade = BgFinalizedFacadeFactory.getRemoteInstance();
            Boolean checkExist = iBgFinalizedFacade.checkFinalizedCalcScheme(bgSchemeInfo.getId().toString(), this.editData.getOrgUnit().getId().toString());
            if (!checkExist.booleanValue() && this.cbFinalized.isSelected()) {
                iBgFinalizedFacade.saveFinalizedCalcScheme(bgSchemeInfo.getId().toString(), this.editData.getId().toString(), this.editData.getOrgUnit().getId().toString(), false);
            } else if (checkExist.booleanValue() && !this.cbFinalized.isSelected() && iBgFinalizedFacade.checkThisCalcScheme(this.editData.getId().toString())) {
                iBgFinalizedFacade.saveFinalizedCalcScheme(bgSchemeInfo.getId().toString(), this.editData.getId().toString(), this.editData.getOrgUnit().getId().toString(), true);
            }
        }
    }

    protected void loadCBFinalized() throws EASBizException, BOSException {
        IBgFinalizedFacade iBgFinalizedFacade;
        Boolean checkExist;
        if (this.cbFinalized.isVisible() && this.editData.getId() != null && (checkExist = Boolean.valueOf((iBgFinalizedFacade = BgFinalizedFacadeFactory.getRemoteInstance()).checkThisCalcScheme(this.editData.getId().toString()))).booleanValue()) {
            this.cbFinalized.setSelected(true);
        }
    }

    @Override
    protected void cbFinalized_actionPerformed(ActionEvent e) throws Exception {
        BgSchemeInfo bgSchemeInfo;
        super.cbFinalized_actionPerformed(e);
        if (this.cbFinalized.isVisible() && (bgSchemeInfo = this.editData.getBgScheme()) != null && this.editData.getOrgUnit() != null && this.editData.getId() != null) {
            IBgFinalizedFacade iBgFinalizedFacade = BgFinalizedFacadeFactory.getRemoteInstance();
            Boolean checkExist = iBgFinalizedFacade.checkFinalizedCalcScheme(bgSchemeInfo.getId().toString(), this.editData.getOrgUnit().getId().toString());
            Boolean checkThis = iBgFinalizedFacade.checkThisCalcScheme(this.editData.getId().toString());
            if (checkExist.booleanValue() && this.cbFinalized.isSelected() && !checkThis.booleanValue()) {
                this.cbFinalized.setSelected(false, false);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFinalizedResource", (String)"checkFinalizedCalcScheme"));
            }
        }
    }

    @Override
    protected void cbFinalized_stateChanged(ChangeEvent e) throws Exception {
        super.cbFinalized_stateChanged(e);
    }

    @Override
    protected void prmtVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtVersion_willShow(e);
        BgNFormListUI.addRollVersionFilter(this.prmtVersion);
    }

    private class SimpleQuick
    implements ISimpleQuickQueryHandler {
        private KDTable table = null;
        private KDTextField txtSearch = null;

        public SimpleQuick(KDTextField txtSearch, KDTable table) {
            this.txtSearch = txtSearch;
            this.table = table;
        }

        public void doQuickQuery() {
            BgCalculateSchemeGuideUI.this.doQuickQuery(this.txtSearch, this.table);
        }
    }
}

