/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgRelationDataFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgCheckDimRelationOrgF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;

public class BgCheckDimRelationOrgF7UI
extends AbstractBgCheckDimRelationOrgF7UI {
    private static final long serialVersionUID = 1L;
    boolean isCancel = true;
    private Object data;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void init() throws EASBizException, BOSException {
        if (!(this.getUIContext().get("formId") instanceof String)) {
            return;
        }
        String formId = (String)this.getUIContext().get("formId");
        CostCenterOrgUnitCollection colls = this.getOrgColls(formId);
        if (colls == null || colls.isEmpty()) {
            return;
        }
        this.initTable();
        this.tblMain.removeRows();
        for (int i = 0; i < colls.size(); ++i) {
            CostCenterOrgUnitInfo info = colls.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("select").setValue((Object)false);
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("level").setValue((Object)info.getLevel());
            row.getCell("isSeaf").setValue((Object)info.isIsLeaf());
            row.setUserObject((Object)info);
        }
    }

    protected void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(true);
        KDCheckBox box = new KDCheckBox();
        KDTDefaultCellEditor edit = new KDTDefaultCellEditor((JCheckBox)box);
        this.tblMain.getColumn("select").setEditor((ICellEditor)edit);
        edit = new KDTDefaultCellEditor((JCheckBox)box);
        this.tblMain.getColumn("isSeaf").setEditor((ICellEditor)edit);
        this.tblMain.getColumn("id").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("level").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("isSeaf").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").setWidth(80);
    }

    private CostCenterOrgUnitCollection getOrgColls(String formId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)formId)) {
            return null;
        }
        Object ob = BgRelationDataFacadeFactory.getRemoteInstance().queryOrgColls(formId);
        if (ob instanceof CostCenterOrgUnitCollection) {
            return (CostCenterOrgUnitCollection)ob;
        }
        return null;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        CostCenterOrgUnitCollection colls = new CostCenterOrgUnitCollection();
        for (int index = 0; index < this.tblMain.getRowCount(); ++index) {
            if (!Boolean.valueOf(this.tblMain.getRow(index).getCell("select").getValue().toString()).booleanValue()) continue;
            colls.add((CostCenterOrgUnitInfo)this.tblMain.getRow(index).getUserObject());
        }
        if (!colls.isEmpty()) {
            this.data = colls;
        }
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() < 1) {
            return;
        }
        for (int index = 0; index < this.tblMain.getRowCount(); ++index) {
            this.tblMain.getRow(index).getCell("select").setValue((Object)true);
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() < 1) {
            return;
        }
        for (int index = 0; index < this.tblMain.getRowCount(); ++index) {
            this.tblMain.getRow(index).getCell("select").setValue((Object)false);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

