/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgCourseOperateEnum;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.IBgCourseComment;
import com.kingdee.eas.ma.mbg.client.AbstractBgCourseCommentEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgCourseCommentEditUI
extends AbstractBgCourseCommentEditUI {
    private static final long serialVersionUID = -1588525799939111136L;
    private static final Logger logger = CoreUIObject.getLogger(BgCourseCommentEditUI.class);
    private boolean hasQuit = false;
    private UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
    private List bgFormIds = null;
    public static final String OPERATE = "OPERATE";
    private BgCourseOperateEnum courseOperateEnum = BgCourseOperateEnum.Back;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed(true);
        Object operate = this.getUIContext().get(OPERATE);
        if (operate != null && operate instanceof BgCourseOperateEnum) {
            this.courseOperateEnum = (BgCourseOperateEnum)((Object)operate);
        }
        super.onLoad();
        Object obj = this.getUIContext().get("BGFORM_ID");
        if (obj != null) {
            this.bgFormIds = (List)obj;
        }
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.toolBar.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionSubmitOption.setEnabled(false);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionFirst.setEnabled(false);
        this.actionPre.setEnabled(false);
        this.actionNext.setEnabled(false);
        this.actionLast.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        BgCourseCommentInfo info = new BgCourseCommentInfo();
        info.setCreator(this.userInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(this.userInfo);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCourseCommentFactory.getRemoteInstance();
    }

    protected IBgCourseComment getInterface() throws Exception {
        return BgCourseCommentFactory.getRemoteInstance();
    }

    protected void init() throws Exception {
        if (this.bgFormIds != null) {
            HashSet bgFormIdSet = new HashSet();
            bgFormIdSet.addAll(this.bgFormIds);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", bgFormIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("state");
            sic.add("orgUnit.id");
            sic.add("orgUnit.name");
            sic.add("bgScheme.id");
            sic.add("bgScheme.name");
            sic.add("bgTemplate.id");
            sic.add("bgTemplate.name");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.getSorter().add(new SorterItemInfo("orgUnit.name"));
            IRow row = null;
            BgFormInfo info = null;
            BgFormCollection collection = null;
            BgCourseCommentInfo commentInfo = null;
            this.tblMain.setRefresh(false);
            collection = BgFormFactory.getRemoteInstance().getBgFormCollection(view);
            if (collection != null) {
                int in = collection.size();
                for (int i = 0; i < in; ++i) {
                    info = collection.get(i);
                    row = this.tblMain.addRow();
                    row.getCell("orgUnit.name").setValue((Object)info.getOrgUnit());
                    row.getCell("number").setValue((Object)info.getNumber());
                    row.getCell("name").setValue((Object)info.getName());
                    row.getCell("bgScheme.name").setValue((Object)info.getBgScheme());
                    row.getCell("bgTemplate.name").setValue((Object)info.getBgTemplate());
                    row.getCell("state").setValue((Object)info.getState());
                    commentInfo = (BgCourseCommentInfo)this.createNewData();
                    commentInfo.setBgFormId(info.getId().toString());
                    row.setUserObject((Object)commentInfo);
                }
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
            this.tblMain.getSelectManager().setSelectMode(2);
            this.tblMain.getStyleAttributes().setLocked(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.kdText.isEnabled() && StringUtils.isEmpty((String)this.kdText.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "imputIdea"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setComment(this.kdText.getText());
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.verifyData();
        if (this.getInterface() != null) {
            List comments = this.getComments();
            this.getInterface().batchAddnew(comments);
            if (BgCourseOperateEnum.UnConfirm.equals((Object)this.courseOperateEnum) || BgCourseOperateEnum.Confirm.equals((Object)this.courseOperateEnum)) {
                BgAuditIdeaFactory.getRemoteInstance().addnewBatchData(this.convertToSubmitIdea(comments));
            }
            this.hasQuit = true;
            this.initOldData((IObjectValue)this.editData);
            this.getUIWindow().close();
        }
    }

    private CoreBaseCollection convertToSubmitIdea(List comments) {
        CoreBaseCollection ideas = new CoreBaseCollection();
        if (comments.isEmpty()) {
            return ideas;
        }
        for (BgCourseCommentInfo next : comments) {
            BgAuditIdeaInfo ideaInfo = new BgAuditIdeaInfo();
            ideaInfo.setId(BOSUuid.create((BOSObjectType)ideaInfo.getBOSType()));
            ideaInfo.setIdea(next.getComment());
            ideaInfo.setFormId(BOSUuid.read((String)next.getBgFormId()));
            ideaInfo.setCreateTime(next.getCreateTime());
            ideaInfo.setCreator(next.getCreator());
            ideaInfo.setCU(next.getCU());
            ideaInfo.setLastUpdateTime(next.getLastUpdateTime());
            ideaInfo.setLastUpdateUser(next.getLastUpdateUser());
            if (BgCourseOperateEnum.UnConfirm.equals((Object)next.getState())) {
                ideaInfo.setState(BgAuditIdeaEnum.UNAUDIT);
            } else if (BgCourseOperateEnum.Confirm.equals((Object)next.getState())) {
                ideaInfo.setState(BgAuditIdeaEnum.AUDITPASS);
            }
            ideas.add((CoreBaseInfo)ideaInfo);
        }
        return ideas;
    }

    protected List getComments() {
        IRow row = null;
        BgCourseCommentInfo info = null;
        ArrayList<BgCourseCommentInfo> tmpList = new ArrayList<BgCourseCommentInfo>();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            info = (BgCourseCommentInfo)row.getUserObject();
            info.setComment(this.kdText.getText());
        }
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            info = (BgCourseCommentInfo)row.getUserObject();
            info.setState(this.courseOperateEnum);
            tmpList.add(info);
        }
        return tmpList;
    }

    public boolean isHasQuit() {
        return this.hasQuit;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int nRow;
        int pRow;
        KDTSelectBlock selectBlock;
        super.tblMain_tableSelectChanged(e);
        KDTSelectBlock prevSelectBlock = e.getPrevSelectBlock();
        if (null != prevSelectBlock) {
            this.disableKDText(prevSelectBlock);
        }
        if (null != (selectBlock = e.getSelectBlock())) {
            this.disableKDText(selectBlock);
        }
        IRow row = null;
        KDTSelectBlock pblock = null;
        KDTSelectBlock nblock = null;
        BgCourseCommentInfo info = null;
        pblock = e.getPrevSelectBlock();
        nblock = e.getSelectBlock();
        if (pblock != null && (row = this.tblMain.getRow(pRow = pblock.getBeginRow())) != null) {
            info = (BgCourseCommentInfo)row.getUserObject();
            info.setComment(this.kdText.getText());
        }
        if (nblock != null && (row = this.tblMain.getRow(nRow = nblock.getBeginRow())) != null) {
            info = (BgCourseCommentInfo)row.getUserObject();
            this.kdText.setText(info.getComment());
        }
    }

    private void disableKDText(KDTSelectBlock prevSelectBlock) {
        int row = prevSelectBlock.getBeginRow();
        Object value = this.tblMain.getRow(row).getCell("state").getValue();
        if (value != null && value instanceof BgFormStateEnum) {
            BgFormStateEnum state = (BgFormStateEnum)((Object)value);
            if (BgCourseOperateEnum.UnConfirm.equals((Object)this.courseOperateEnum)) {
                if (BgFormStateEnum.Approved.equals((Object)state)) {
                    this.kdText.setEnabled(true);
                } else {
                    this.kdText.setEnabled(false);
                }
                return;
            }
            if (BgCourseOperateEnum.Back.equals((Object)this.courseOperateEnum) || BgCourseOperateEnum.Certificate.equals((Object)this.courseOperateEnum)) {
                if (BgFormStateEnum.Report.equals((Object)state)) {
                    this.kdText.setEnabled(true);
                } else {
                    this.kdText.setEnabled(false);
                }
                return;
            }
            if (BgCourseOperateEnum.AntiCertificate.equals((Object)this.courseOperateEnum)) {
                if (BgFormStateEnum.Certificate.equals((Object)state)) {
                    this.kdText.setEnabled(true);
                } else {
                    this.kdText.setEnabled(false);
                }
                return;
            }
            if (BgCourseOperateEnum.Confirm.equals((Object)this.courseOperateEnum)) {
                boolean needCertificate = BgParamCHelper.isNeedCertificate();
                if (needCertificate) {
                    if (BgFormStateEnum.Certificate.equals((Object)state) || BgFormStateEnum.Edited.equals((Object)state)) {
                        this.kdText.setEnabled(true);
                    } else {
                        this.kdText.setEnabled(false);
                    }
                } else if (BgFormStateEnum.Certificate.equals((Object)state) || BgFormStateEnum.Report.equals((Object)state) || BgFormStateEnum.Edited.equals((Object)state)) {
                    this.kdText.setEnabled(true);
                } else {
                    this.kdText.setEnabled(false);
                }
                return;
            }
        }
    }
}

