/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgDecomposeFormFactory;
import com.kingdee.eas.ma.mbg.BgDecomposeFormInfo;
import com.kingdee.eas.ma.mbg.BgDecomposeRefOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgOrgunitViewFoldEnum;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgSchemeDispatchFacade;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgDecomposeFormEditUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.BgPropertyChooseUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.designer.IAction;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgDecomposeFormEditUI
extends AbstractBgDecomposeFormEditUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = -4296309301890432973L;
    private static final Logger logger = CoreUIObject.getLogger(BgDecomposeFormEditUI.class);
    private Map<BOSUuid, Set<BOSUuid>> dispatchMap = new HashMap<BOSUuid, Set<BOSUuid>>();
    private Map<BOSUuid, Set<String>> dispatchNumberMap = new HashMap<BOSUuid, Set<String>>();
    private boolean isRefeshOrgUnitTree = false;
    private TreeModel oldTree = null;
    private LongTimeDialog dialog = null;
    private KDPopupMenu popMenu = new KDPopupMenu();
    private Set<BOSUuid> companyIds = new HashSet<BOSUuid>();
    private BgSchemeDimensionHelper schemeHelper = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTemplateFormBgScheme();
        this.initDispatchData();
        this.initBgPeriodInfo();
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgVersion, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
        this.setBgFormFilter();
        this.initOrgUnit();
        this.initCompanyIds();
        this.afterBgFormChange(null, this.prmtBgForm.getData());
    }

    public Map<BOSUuid, Set<BOSUuid>> getDispatchMap() {
        return this.dispatchMap;
    }

    public Map<BOSUuid, Set<String>> getDispatchNumberMap() {
        return this.dispatchNumberMap;
    }

    protected void initDispatchData() throws Exception {
        this.getDispatchMap().clear();
        Map tmpMap = this.getDispatchInterface().queryDispatchInfo(this.getBgSchemeInfo().getId());
        if (tmpMap != null) {
            Map disMap = (Map)tmpMap.get(BgSchemeDispatchConstants.SCHEME_DISPATCH);
            this.getDispatchMap().putAll(disMap);
        }
        BgOrgUnitCollection col = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select id, orgUnitId, longNumber where isVirtual = 0 and viewId = '" + this.getSchemeHelper().getBgOrgViewId() + "'");
        HashMap<String, HashSet<String>> orgUnitNumbers = new HashMap<String, HashSet<String>>();
        for (int i = 0; i < col.size(); ++i) {
            if (orgUnitNumbers.containsKey(col.get(i).getOrgUnitID())) {
                ((Set)orgUnitNumbers.get(col.get(i).getOrgUnitID())).addAll(Arrays.asList(col.get(i).getLongNumber().split("!")));
                continue;
            }
            orgUnitNumbers.put(col.get(i).getOrgUnitID(), new HashSet<String>(Arrays.asList(col.get(i).getLongNumber().split("!"))));
        }
        for (BOSUuid bgTemplateId : this.getDispatchMap().keySet()) {
            HashSet subSet = new HashSet();
            this.getDispatchNumberMap().put(bgTemplateId, subSet);
            for (BOSUuid orgId : this.getDispatchMap().get(bgTemplateId)) {
                if (orgUnitNumbers.get(orgId.toString()) == null) continue;
                subSet.addAll((Collection)orgUnitNumbers.get(orgId.toString()));
            }
        }
    }

    protected void initCompanyIds() throws Exception {
        this.getCompanyIds().addAll(this.queryCompanyIds());
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return this.getDispatchInterface().queryCompanyIds();
    }

    protected IBgSchemeDispatchFacade getDispatchInterface() throws BOSException {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance();
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    protected void initOrgUnit() throws EASBizException, BOSException, Exception {
        String schemeOrgId = this.getBgSchemeInfo().getOrgUnit().getId().toString();
        if (schemeOrgId.equals(this.getOrgUnitInfo().getId().toString())) {
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, null, null, this.getSchemeHelper().getBgOrgViewId(), true, null, false));
        } else if (this.getUIContext().get("BGORGUNIT_INFO") instanceof BgOrgUnitInfo) {
            String bgOrgId = ((BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO")).getId().toString();
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, bgOrgId, null, this.getSchemeHelper().getBgOrgViewId(), true, null, false));
        }
        this.setRefeshOrgUnitTree(false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
                    BgDecomposeFormEditUI.this.setTreeCanSelect((DefaultKingdeeTreeNode)event.getPath().getLastPathComponent());
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                logger.error((Object)("treeCollapsed" + event.getPath()));
            }
        });
        this.treeOrgUnit.setModel(BgOrgTreeHelper.clipAndCloneTreeModel(this.getOldTree(), null, true));
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitInfo().getId().toString(), null);
        root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.setTreeCanSelect(root);
        BgOrgViewInfo bgOrgView = BgOrgViewFactory.getRemoteInstance().getBgOrgViewInfo("Select id, bgOrguniteDirectFold where id = '" + this.getSchemeHelper().getBgOrgViewId() + "'");
        if (bgOrgView.getBgOrguniteDirectFold() != BgOrgunitViewFoldEnum.unfold) {
            this.treeOrgUnit.expandOnLevel(2);
        } else {
            this.treeOrgUnit.expandOnLevel(3);
        }
        BgOrgTreeHelper.resetAction(this.treeViewOrgUnit, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgDecomposeFormEditUI.this.loadOrgUnitTree();
                TreeNode root = (TreeNode)BgDecomposeFormEditUI.this.treeOrgUnit.getModel().getRoot();
                BgDecomposeFormEditUI.this.treeOrgUnit.expandAllNodes(true, root);
            }
        });
        this.treeOrgUnit.updateUI();
    }

    protected void treeModel_treeNodesInserted(TreeModelEvent e) {
        logger.error((Object)("treeModel_treeNodesInserted " + e.getSource()));
    }

    protected void setTreeCanSelect(DefaultKingdeeTreeNode node) {
        String orgUnitId = BgOrgTreeHelper.getBgOrgIDFromTreeNode(node);
        String orgNumber = ((BgOrgUnitInfo)node.getUserObject()).getNumber();
        BOSUuid bgTemplateId = null;
        if (this.prmtBgForm.getData() != null) {
            bgTemplateId = ((BgFormInfo)this.prmtBgForm.getData()).getBizTemplateId();
        }
        if (!(bgTemplateId == null || this.getDispatchNumberMap().containsKey(bgTemplateId) && this.getDispatchNumberMap().get(bgTemplateId).contains(orgNumber) || node.getParent() == null)) {
            ((DefaultKingdeeTreeNode)node.getParent()).remove((MutableTreeNode)node);
            return;
        }
        if (orgUnitId == null || this.getOrgUnitInfo().getId().toString().equals(orgUnitId) || bgTemplateId == null || !this.getDispatchMap().containsKey(bgTemplateId) || !this.getDispatchMap().get(bgTemplateId).contains(BOSUuid.read((String)orgUnitId))) {
            node.setCheckBoxEnabled(false);
            node.setCheckBoxVisible(false);
            node.setChecked(false);
            BgOrgTreeHelper.disableTreeNode(node);
        } else {
            node.setCheckBoxEnabled(true);
            node.setCheckBoxVisible(true);
            node.setTextColor(Color.black);
        }
        if (node.getChildCount() > 0) {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                this.setTreeCanSelect((DefaultKingdeeTreeNode)node.getChildAt(i));
            }
        }
    }

    private void loadOrgUnitTree() {
        this.loadOrgUnitTree(null);
    }

    public LongTimeDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    private void loadOrgUnitTree(final IAction afterAction) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgDecomposeFormEditUI.this.refeshOrgUnitTree();
                if (afterAction != null) {
                    afterAction.doAction();
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    public void refeshOrgUnitTree() throws Exception {
        if (!this.isRefeshOrgUnitTree() && this.getOldTree() != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            this.refeshOrgUnitTree(root);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1) {
            try {
                BgOrgUnitUtils.addChildNode(root, this.getSchemeHelper().getBgOrgViewId(), false);
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    protected void initListener() {
        super.initListener();
        this.iniPoppMenu();
    }

    protected void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new AllSubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectCompany"));
        menuItem.addActionListener((ActionListener)new CompanyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"propertyChoose"));
        menuItem.addActionListener((ActionListener)new PropertyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    public Set<BOSUuid> getCompanyIds() {
        return this.companyIds;
    }

    private Set<String> getOrgIdByFid(Set ids) {
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitCollection unitCol = null;
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("orgUnitID");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        try {
            filter.getFilterItems().add(new FilterItemInfo("ViewId", (Object)this.getSchemeHelper().getBgOrgViewId(), CompareType.EQUALS));
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        try {
            iBgOrgUnit = BgOrgUnitFactory.getRemoteInstance();
            unitCol = iBgOrgUnit.getBgOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (unitCol == null || unitCol.isEmpty()) {
            return null;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            set.add(unitCol.get(i).getOrgUnitID());
        }
        return set;
    }

    protected String getPropertyChooseUIName() {
        return BgPropertyChooseUI.class.getName();
    }

    protected void initBgPeriodInfo() {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this, false);
        try {
            dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
            dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        BgSchemeInfo _bgSchemeInfo = this.getBgSchemeInfo();
        if (_bgSchemeInfo != null) {
            dialog.setBgPeriodBeginDate(_bgSchemeInfo.getDateFrom());
            dialog.setBgPeriodEndDate(_bgSchemeInfo.getDateTo());
        }
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.addDataChangeListener((DataChangeListener)dialog);
        this.prmtBgPeriod.setEnabledMultiSelection(false);
    }

    protected void initTemplateFormBgScheme() throws Exception {
        BgSchemeInfo bgSchemeInfo = this.getBgSchemeInfo();
        BgTemplateCollection bgTemplateColl = null;
        if (bgSchemeInfo != null) {
            bgTemplateColl = this.getBgTemplateOfBgScheme(bgSchemeInfo.getId());
            for (int i = bgTemplateColl.size() - 1; i >= 0; --i) {
                if (!this.isRemoveTemplate(bgTemplateColl.get(i))) continue;
                bgTemplateColl.removeObject(i);
            }
        }
        boolean needRemove = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (bgTemplateColl != null && !bgTemplateColl.isEmpty()) {
            Object old = null;
            Set<String> oldIds = DimensionCommonHelper.getIds(this.prmtBgTemplate.getData());
            Set<String> ids = DimensionCommonHelper.getIds(bgTemplateColl.toArray());
            if (!oldIds.isEmpty() && ids.containsAll(oldIds)) {
                needRemove = false;
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
        }
        if (needRemove) {
            this.prmtBgTemplate.setData(null);
        }
        this.prmtBgTemplate.setEntityViewInfo(evi);
        RptSrcTypeEnum sourceType = BgNFCHelper.getSourceType((IUIObject)this);
        FilterInfo filter = MbgPermissionHelper.addBgTemplatePermission(sourceType, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgTemplate.getEntityViewInfo().getFilter(), bgSchemeInfo == null ? null : bgSchemeInfo.getId().toString(), true);
        this.prmtBgTemplate.getEntityViewInfo().setFilter(filter);
    }

    protected boolean isRemoveTemplate(BgTemplateInfo info) {
        return !this.checkBgTemplateType(info.getFormType().getValue());
    }

    protected boolean checkBgTemplateType(int bgTemplateFormType) {
        return true;
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId) throws Exception {
        FullOrgUnitInfo value = this.getOrgUnitInfo();
        if (value != null && value instanceof BgOrgUnitInfo[]) {
            HashSet<String> mutiOrgUnit = new HashSet<String>();
            BgOrgUnitInfo[] infos = (BgOrgUnitInfo[])value;
            for (int i = 0; i < infos.length; ++i) {
                String orgUnitID = infos[i].getOrgUnitID();
                mutiOrgUnit.add(orgUnitID);
            }
            return TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, mutiOrgUnit, false);
        }
        FullOrgUnitInfo org = this.editData.getOrgUnit();
        if (org == null) {
            org = SysContext.getSysContext().getCurrentCostUnit();
        }
        return TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, org.getId().toString());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setBgForm((BgFormInfo)this.prmtBgForm.getData());
        if (this.editData.getBgForm() != null && this.editData.getBgForm().getNumber() != null) {
            this.editData.setNumber(this.editData.getBgForm().getNumber());
        }
        Map old = BgCommHelper.transeToMap((IObjectCollection)this.editData.getRefOrgUnit(), (String[])new String[]{"orgUnitID"});
        List<String> bgOrgUnitIds = this.getSelectedOrgUnitIds();
        if (!old.keySet().containsAll(bgOrgUnitIds) || !bgOrgUnitIds.containsAll(old.keySet())) {
            this.editData.getRefOrgUnit().clear();
            for (String orgUnitId : bgOrgUnitIds) {
                if (old.containsKey(orgUnitId)) {
                    this.editData.getRefOrgUnit().add((BgDecomposeRefOrgUnitInfo)old.get(orgUnitId));
                    continue;
                }
                BgDecomposeRefOrgUnitInfo info = new BgDecomposeRefOrgUnitInfo();
                info.setBgDecomposeForm(this.editData);
                info.setOrgUnitID(BOSUuid.read((String)orgUnitId));
                this.editData.getRefOrgUnit().add(info);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (DimensionCommonHelper.isEmpty(this.prmtBgForm.getData())) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"checkDecomposeSelectForm")});
        }
        String thisId = "000000000000000000000000000=";
        if (this.editData != null && this.editData.getId() != null) {
            thisId = this.editData.getId().toString();
        }
        if (BgDecomposeFormFactory.getRemoteInstance().exists("where bgForm.id = '" + ((BgFormInfo)this.prmtBgForm.getData()).getId() + "' and isAssign = 0 and isAssignData = 0 and id <> '" + thisId + "'")) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"checkBgFormHasDec")});
        }
        List<String> bgOrgUnitIds = this.getSelectedOrgUnitIds();
        if (bgOrgUnitIds == null || bgOrgUnitIds.isEmpty()) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"checkDecomposeOrgUnit")});
        }
    }

    protected List<String> getSelectedOrgUnitIds() {
        return BgOrgUnitUtils.getSelectOrgUnitIds(this.treeOrgUnit);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        }
        BgOrgUnitUtils.selectOrgUnit(node, false);
        this.treeOrgUnit.updateUI();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), true);
        this.treeOrgUnit.expandOnLevel(7);
        this.treeOrgUnit.updateUI();
    }

    protected IObjectValue createNewData() {
        BgDecomposeFormInfo info = new BgDecomposeFormInfo();
        info.setBgScheme(this.getBgSchemeInfo());
        info.setOrgUnit(this.getOrgUnitInfo());
        info.setDecomposeUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setDecomposeTime(new Timestamp(System.currentTimeMillis()));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDecomposeFormFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("number");
        sic.add("bgForm.number");
        sic.add("refOrgUnit.id");
        sic.add("refOrgUnit.orgUnitId");
        sic.add("refOrgUnit.bgDecomposeForm.id");
        return sic;
    }

    protected FullOrgUnitInfo getOrgUnitInfo() {
        if (this.editData != null && this.editData.getOrgUnit() != null) {
            return this.editData.getOrgUnit();
        }
        if (this.getUIContext().get("BGORGUNIT_INFO") != null) {
            return ((BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO")).castToFullOrgUnitInfo();
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"398_BgOrgBasedListUI"));
        SysUtil.abort();
        return null;
    }

    @Override
    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        if (!DimensionCommonHelper.isEqualsPrmt(e.getNewValue(), e.getOldValue())) {
            this.setBgFormFilter();
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        if (!DimensionCommonHelper.isEqualsPrmt(e.getNewValue(), e.getOldValue())) {
            this.setBgFormFilter();
        }
    }

    @Override
    protected void prmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        if (!DimensionCommonHelper.isEqualsPrmt(e.getNewValue(), e.getOldValue())) {
            this.setBgFormFilter();
        }
    }

    @Override
    protected void prmtBgForm_dataChanged(DataChangeEvent e) throws Exception {
        this.afterBgFormChange(e.getOldValue(), e.getNewValue());
    }

    protected void afterBgFormChange(Object oldBgForm, Object newBgForm) throws Exception {
        BOSUuid newTid;
        boolean hasBgForm = newBgForm != null;
        this.btnSelectAll.setEnabled(hasBgForm);
        this.btnClearAll.setEnabled(hasBgForm);
        this.treeViewOrgUnit.setEnabled(hasBgForm);
        this.treeOrgUnit.setEnabled(hasBgForm);
        this.treeOrgUnit.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BgDecomposeFormEditUI.this.treeViewOrgUnit_mouseClicked(e);
            }
        });
        BOSUuid oldTid = oldBgForm != null ? ((BgFormInfo)oldBgForm).getBizTemplateId() : null;
        BOSUuid bOSUuid = newTid = newBgForm != null ? ((BgFormInfo)newBgForm).getBizTemplateId() : null;
        if (!ObjectUtil.equals((Object)oldTid, (Object)newTid)) {
            this.treeOrgUnit.setModel(BgOrgTreeHelper.clipAndCloneTreeModel(this.getOldTree(), null, true));
            BgOrgViewInfo bgOrgView = BgOrgViewFactory.getRemoteInstance().getBgOrgViewInfo("Select id, bgOrguniteDirectFold where id = '" + this.getSchemeHelper().getBgOrgViewId() + "'");
            this.setTreeCanSelect((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
            if (this.treeOrgUnit.getRowCount() > 0) {
                if (bgOrgView.getBgOrguniteDirectFold() != BgOrgunitViewFoldEnum.unfold) {
                    this.treeOrgUnit.expandOnLevel(2);
                } else {
                    this.treeOrgUnit.expandOnLevel(3);
                }
            }
            if (this.treeOrgUnit.getRowCount() > 0) {
                this.treeOrgUnit.setSelectionRow(0);
            }
            this.treeOrgUnit.updateUI();
        }
    }

    protected void treeViewOrgUnit_mouseClicked(MouseEvent e) {
    }

    protected void setBgFormFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getBgSchemeInfo();
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnitInfo();
        if (bgOrgUnit == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "000000000000000000000000000=" : bgScheme.getId().toString())));
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("state".toLowerCase(), state, CompareType.NOTINCLUDE));
        BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("orgUnit.id", (Object)(bgOrgUnit == null ? "000000000000000000000000000=" : bgOrgUnit.getId().toString())));
        BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        HashSet<Integer> processTypes = new HashSet<Integer>();
        processTypes.add(2);
        processTypes.add(4);
        BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("processType", processTypes, CompareType.INCLUDE));
        BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("bgVersion.isRollVersion", (Object)false, CompareType.EQUALS));
        if (this.prmtBgTemplate.getData() instanceof BgTemplateInfo) {
            BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("bgTemplate.id", (Object)((BgTemplateInfo)this.prmtBgTemplate.getData()).getId().toString()));
        } else {
            this.addBgPermission(bgScheme, evi, "bgTemplate.id");
            BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("bgTemplate.templateStatus", (Object)0));
        }
        if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
            BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("bgPeriod.id", (Object)((BgPeriodInfo)this.prmtBgPeriod.getData()).getId().toString()));
        }
        if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
            BgNFCHelper.replaceFilterItems(evi.getFilter(), new FilterItemInfo("bgVersion.id", (Object)((BgVersionInfo)this.prmtBgVersion.getData()).getId().toString()));
        }
        if (bgScheme != null) {
            this.addBgOrgUnitPremission(evi.getFilter(), bgScheme.getId().toString(), "orgUnit.id", bgOrgUnit);
        }
        this.prmtBgForm.setEntityViewInfo(evi);
        if (this.prmtBgForm.getData() instanceof BgFormInfo) {
            BgFormInfo oldInfo = (BgFormInfo)this.prmtBgForm.getData();
            boolean isClear = false;
            if (this.prmtBgTemplate.getData() instanceof BgTemplateInfo && !oldInfo.getBgTemplate().getId().equals((Object)((BgTemplateInfo)this.prmtBgTemplate.getData()).getId())) {
                isClear = true;
            }
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo && !oldInfo.getBgPeriod().getId().equals((Object)((BgPeriodInfo)this.prmtBgPeriod.getData()).getId())) {
                isClear = true;
            }
            if (this.prmtBgVersion.getData() instanceof BgVersionInfo && !oldInfo.getBgVersion().getId().equals((Object)((BgVersionInfo)this.prmtBgVersion.getData()).getId())) {
                isClear = true;
            }
            if (isClear) {
                this.prmtBgForm.setData(null);
            }
        }
    }

    protected void addBgOrgUnitPremission(FilterInfo filter, String bgSchemeId, String OrgFilterField, FullOrgUnitInfo bgOrgUnit) throws EASBizException, BOSException {
        Set bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), bgSchemeId);
        if (!bgOrgUnitPer.isEmpty()) {
            HashSet<String> orgUnitIdSet = new HashSet<String>();
            orgUnitIdSet.add(bgOrgUnit.getId().toString());
            HashSet<String> newOrgPerSet = new HashSet<String>();
            for (String orgunitid : orgUnitIdSet) {
                if (!bgOrgUnitPer.contains(orgunitid)) continue;
                newOrgPerSet.add(orgunitid);
            }
            FilterItemInfo items = null;
            items = newOrgPerSet.isEmpty() ? new FilterItemInfo(OrgFilterField, (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo(OrgFilterField, newOrgPerSet, CompareType.INCLUDE);
            if (filter.getFilterItems() != null) {
                Object fiInfo = null;
                String mask = filter.getMaskString();
                int size = filter.getFilterItems().size();
                filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
                if (orgUnitIdSet.isEmpty()) {
                    filter.getFilterItems().add(new FilterItemInfo(OrgFilterField, (Object)"000000000000000000000000000=", CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo(OrgFilterField, orgUnitIdSet, CompareType.INCLUDE));
                }
                filter.getFilterItems().add(items);
                mask = mask + " and ((#" + size + " and #" + (size + 1) + ") or #" + (size + 2) + ")";
                filter.setMaskString(mask);
            }
        }
    }

    public void addBgPermission(BgSchemeInfo bgScheme, EntityViewInfo evi, String filterField) {
        try {
            if (bgScheme != null) {
                BgSchemeInfo _bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select bgSchemeType.schemeType where id = '" + bgScheme.getId() + "'");
                MbgPermissionHelper.addFieldDataPermission(_bgScheme.getBgSchemeType().getSchemeType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), evi.getFilter(), MbgPermissionTypeEnum.TEMPLATE, filterField, bgScheme.getId().toString(), true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected BgSchemeInfo getBgSchemeInfo() {
        if (this.getUIContext().get("BGSCHEME_INFO") != null) {
            return (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        }
        if (this.editData != null && this.editData.getBgScheme() != null) {
            return this.editData.getBgScheme();
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
        SysUtil.abort();
        return null;
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            BgSchemeInfo info = this.getBgSchemeInfo();
            this.schemeHelper = new BgSchemeDimensionHelper(info.getId().toString());
        }
        return this.schemeHelper;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            this.clear();
            return;
        }
        try {
            AbstractObjectCollection col;
            String id = cp.getCustomerParam("BG_LINK_TEMPLATE_ID");
            if (!StringUtils.isEmpty((String)id) && (col = BgTemplateFactory.getRemoteInstance().getBgTemplateCollection("select id, number, name where id = '" + id + "'")) != null && !col.isEmpty()) {
                this.prmtBgTemplate.setData((Object)col.get(0));
            }
            if (!StringUtils.isEmpty((String)(id = cp.getCustomerParam("BG_LINK_PERIOD_ID"))) && (col = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection("select id, number, name where id = '" + id + "'")) != null && !col.isEmpty()) {
                this.prmtBgPeriod.setData((Object)col.get(0));
            }
            if (!StringUtils.isEmpty((String)(id = cp.getCustomerParam("BG_LINK_VERSION_ID"))) && (col = BgVersionFactory.getRemoteInstance().getBgVersionCollection("select id, number, name where id = '" + id + "'")) != null && !col.isEmpty()) {
                this.prmtBgVersion.setData((Object)col.get(0));
            }
            if (!StringUtils.isEmpty((String)(id = cp.getCustomerParam("BG_LINK_FORM_ID"))) && (col = BgFormFactory.getRemoteInstance().getBgFormCollection("select id, number, name, bgScheme.id, bgScheme.number, bgTemplate.id, bgTemplate.number, bgTemplate.name where id = '" + id + "'")) != null && !col.isEmpty()) {
                this.prmtBgForm.setData((Object)col.get(0));
            }
            if (!StringUtils.isEmpty((String)(id = cp.getCustomerParam("BG_LINK_ORGUNIT_ID")))) {
                List orgUnitIds = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(id));
                BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit, new HashSet<String>(orgUnitIds));
                this.treeOrgUnit.updateUI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    public CustomerParams getCustomerParams() {
        List<String> orgUnitIds;
        CustomerParams cp = new CustomerParams();
        if (this.prmtBgTemplate.getData() != null) {
            cp.addCustomerParam("BG_LINK_TEMPLATE_ID", ((BgTemplateInfo)this.prmtBgTemplate.getData()).getId().toString());
        }
        if (this.prmtBgPeriod.getData() != null) {
            cp.addCustomerParam("BG_LINK_PERIOD_ID", ((BgPeriodInfo)this.prmtBgPeriod.getData()).getId().toString());
        }
        if (this.prmtBgVersion.getData() != null) {
            cp.addCustomerParam("BG_LINK_VERSION_ID", ((BgVersionInfo)this.prmtBgVersion.getData()).getId().toString());
        }
        if (this.prmtBgForm.getData() != null) {
            cp.addCustomerParam("BG_LINK_FORM_ID", ((BgFormInfo)this.prmtBgForm.getData()).getId().toString());
        }
        if ((orgUnitIds = this.getSelectedOrgUnitIds()) != null && !orgUnitIds.isEmpty()) {
            cp.addCustomerParam("BG_LINK_ORGUNIT_ID", BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(orgUnitIds)));
        }
        return cp;
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        BgNFormListUI.addRollVersionFilter(this.prmtBgVersion);
    }

    public void clear() {
        this.prmtBgTemplate.setValue(null);
        this.prmtBgVersion.setValue(null);
        this.prmtBgPeriod.setValue(null);
        this.prmtBgForm.setValue(null);
        try {
            this.btnClearAll_actionPerformed(null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    class PropertyListener
    implements ActionListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set<String> set = new HashSet<String>();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDecomposeFormEditUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeFormEditUI.this.treeOrgUnit.getModel().getRoot();
            if (set != null) {
                set = BgDecomposeFormEditUI.this.getOrgIdByFid(set);
            }
            BgOrgUnitUtils.selectOrgUnitIds(node, set);
            BgDecomposeFormEditUI.this.treeOrgUnit.repaint();
        }
    }

    class CompanyListener
    implements ActionListener {
        CompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeFormEditUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgDecomposeFormEditUI.this.getCompanyIds());
            BgDecomposeFormEditUI.this.treeOrgUnit.repaint();
        }
    }

    class AllSubOrgUnitListener
    implements ActionListener {
        AllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeFormEditUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgDecomposeFormEditUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgUnitListener
    implements ActionListener {
        AllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgUnitUtils.selectOrgUnit(BgDecomposeFormEditUI.this.treeOrgUnit.getModel(), true);
            BgDecomposeFormEditUI.this.treeOrgUnit.repaint();
        }
    }

    class SubOrgUnitListener
    implements ActionListener {
        SubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeFormEditUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgDecomposeFormEditUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                if (BgDecomposeFormEditUI.this.prmtBgForm.getValue() == null) {
                    return;
                }
                BgDecomposeFormEditUI.this.getPopMenu().show((Component)BgDecomposeFormEditUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

