/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgDecomposeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgDecomposeGatherUI;
import com.kingdee.eas.ma.mbg.client.utils.BgOrgUnitLoadAllUtils;
import com.kingdee.eas.ma.mbg.client.utils.BgSheetSelectDialog;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgDecomposeGatherUI
extends AbstractBgDecomposeGatherUI {
    private static final long serialVersionUID = -3739440770191154356L;
    private static final Logger logger = CoreUIObject.getLogger(BgDecomposeGatherUI.class);
    public static final String BGFORMINFO = "BgDecomposeGatherUI_BGFORMINFO";
    public static final String BOOK = "BgDecomposeGatherUI_BOOK";
    private boolean isCancel = true;
    private BgFormInfo bgFormInfo = null;
    private Book book = null;
    private BgOrgUnitInfo currentBgOrgUnit = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Set<BOSUuid> companyIds = new HashSet<BOSUuid>();
    private TreeWillExpandListener listener = null;
    private TreeModel oldTree = null;
    private Set<String> noLeafOrgIds = null;
    private BgOrgUnitLoadAllUtils loadAllUtil = new BgOrgUnitLoadAllUtils((Component)((Object)this));
    private KDPopupMenu popMenu = new KDPopupMenu();
    Set<String> selectOrgUnitIds = null;
    List<BgOrgUnitInfo> orgUnitInfos = new ArrayList<BgOrgUnitInfo>();

    public Set<BOSUuid> getCompanyIds() {
        return this.companyIds;
    }

    public boolean isCalcBiz() {
        return this.cbxCalcBiz.isSelected();
    }

    public boolean isClearExpression() {
        return this.cbxClearExpression.isSelected();
    }

    public void onLoad() throws Exception {
        this.bgFormInfo = (BgFormInfo)this.getUIContext().get(BGFORMINFO);
        this.book = (Book)this.getUIContext().get(BOOK);
        this.initCompanyIds();
        this.schemeHelper = new BgSchemeDimensionHelper(this.bgFormInfo.getBgScheme().getId().toString());
        this.currentBgOrgUnit = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, number, name, orgUnitId, level, longNumber where orgUnitId = '" + this.bgFormInfo.getOrgUnit().getId() + "' and viewId = '" + this.schemeHelper.getBgOrgViewId() + "' and isVirtual = 0");
        super.onLoad();
        this.iniPoppMenu();
        this.cbxProcessType.addItem((Object)BgProcessEnum.C02);
        this.cbxProcessType.addItem((Object)BgProcessEnum.C04);
        this.cbxProcessType.addItem((Object)BgProcessEnum.C01);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtQuery, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtQuery.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgDecomposeGatherUI.this.btnQuery_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        BgDecomposeGatherUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.initBgOrgUnit(this.loadNoLeaf());
        this.initSheetName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)this.bgFormInfo.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)this.bgFormInfo.getFormType())) {
            this.cbxClearExpression.setVisible(true);
        } else {
            this.cbxClearExpression.setVisible(false);
            this.cbxClearExpression.setSelected(false);
        }
    }

    private void verifyOrgUnit() throws EASBizException, BOSException {
        if (!BgOrgUnitFactory.getRemoteInstance().exists("where isLeaf = 0 and viewId = '" + this.schemeHelper.getBgOrgViewId() + "' and longNumber like '" + this.currentBgOrgUnit.getLongNumber() + "!%'")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"checkHasChild"));
            SysUtil.abort();
        }
    }

    @Override
    protected void rdoAllSheet_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoAllSheet_itemStateChanged(e);
        if (this.rdoAllSheet.isSelected()) {
            this.prmtSheet.setEnabled(false);
        }
    }

    @Override
    protected void rdoSelectSheet_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoSelectSheet_itemStateChanged(e);
        if (this.rdoSelectSheet.isSelected()) {
            this.prmtSheet.setEnabled(true);
        }
    }

    private void initSheetName() {
        BgSheetSelectDialog f7 = new BgSheetSelectDialog((Object)this, this.book, this.prmtSheet, false);
        this.prmtSheet.setValue((Object)new String[]{this.book.getActiveSheet().getSheetName()});
    }

    protected void initCompanyIds() throws Exception {
        this.getCompanyIds().addAll(this.queryCompanyIds());
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance().queryCompanyIds();
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public Set<String> getNoLeafOrgIds() {
        return this.noLeafOrgIds;
    }

    public void setNoLeafOrgIds(Set<String> noLeafOrgIds) {
        this.noLeafOrgIds = noLeafOrgIds;
    }

    public void initBgOrgUnit(Set<String> noLeafOrgIds) throws Exception {
        this.setNoLeafOrgIds(noLeafOrgIds);
        if (this.getListener() == null) {
            this.setListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                    try {
                        BgOrgUnitUtils.addChildNode(node, BgDecomposeGatherUI.this.schemeHelper.getBgOrgViewId(), false);
                        BgOrgTreeHelper.resetLeaf(node, BgDecomposeGatherUI.this.getNoLeafOrgIds());
                    }
                    catch (Exception ex) {
                        BgDecomposeGatherUI.this.handUIException(ex);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
            this.treeOrgUnit.setRootVisible(false);
            this.treeOrgUnit.setShowCheckBox(true);
            this.treeOrgUnit.removeTreeWillExpandListener(this.getListener());
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, this.currentBgOrgUnit.getId().toString(), this.getListener(), this.schemeHelper.getBgOrgViewId(), false, null, true));
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            if (root != null && root.getChildCount() > 0) {
                ((DefaultKingdeeTreeNode)root.getChildAt(0)).setCheckBoxVisible(false);
            }
            this.treeOrgUnit.setModel(this.getOldTree());
            BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
            BgOrgTreeHelper.resetLeaf((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), this.getNoLeafOrgIds());
            if (root != null) {
                if (root.getChildCount() > 0) {
                    this.treeOrgUnit.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
                } else if (root.getUserObject() != null) {
                    this.treeOrgUnit.setSelectionNode(root);
                }
            }
            this.treeOrgUnit.expandOnLevel(3);
        }
    }

    private Set<String> loadNoLeaf() throws EASBizException, BOSException {
        return BgDecomposeFacadeFactory.getRemoteInstance().getDecomposeNoLeafOrgIds(this.schemeHelper.getBgOrgViewId());
    }

    private void loadOrgUnitTree() {
        this.loadAllUtil.loadAllOrgTree(this.treeOrgUnit);
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuery_actionPerformed(e);
        String txt = this.txtQuery.getText();
        if (StringUtils.isEmpty((String)txt)) {
            this.treeOrgUnit.setModel(this.getOldTree());
            this.treeOrgUnit.expandOnLevel(3);
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            return;
        }
        this.loadOrgUnitTree();
        TreeModel model = BgOrgTreeHelper.clipAndCloneTreeModel(this.getOldTree(), txt, true);
        this.treeOrgUnit.setModel(model);
        BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
        this.treeOrgUnit.expandAllNodes(true, (TreeNode)((DefaultKingdeeTreeNode)model.getRoot()));
    }

    protected void initListener() {
        super.initListener();
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new AllSubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectCompany"));
        menuItem.addActionListener((ActionListener)new CompanyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"leafOrgUnit"));
        menuItem.addActionListener((ActionListener)new LeafOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        BgOrgTreeHelper.selectAllPerformed(this.treeOrgUnit, false, true);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        this.loadOrgUnitTree();
        BgOrgTreeHelper.selectAllPerformed(this.treeOrgUnit, true, true);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        List<String> orgUnitIds = BgOrgUnitUtils.getSelectOrgUnitIds(this.treeOrgUnit);
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"selectAddOrg"));
            return;
        }
        if (this.rdoSelectSheet.isSelected() && DimensionCommonHelper.isEmpty(this.prmtSheet.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"checkSelectSheet"));
            return;
        }
        if (BgProcessEnum.C01.equals((Object)this.getProcessType()) && this.checkSelectedOrgUnit(orgUnitIds)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectedError"));
            return;
        }
        this.selectOrgUnitIds = new HashSet<String>(orgUnitIds);
        this.convertOrgUnitInfos(orgUnitIds);
        this.isCancel = false;
        this.destroyWindow();
    }

    private void convertOrgUnitInfos(List<String> orgUnitIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("orgUnitID");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", new HashSet<String>(orgUnitIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)this.schemeHelper.getBgOrgViewId(), CompareType.EQUALS));
        view.setFilter(filter);
        BgOrgUnitCollection coll = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.orgUnitInfos.add((BgOrgUnitInfo)iter.next());
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private boolean checkSelectedOrgUnit(List<String> orgUnitIds) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        evi.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)this.schemeHelper.getBgOrgViewId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", new HashSet<String>(orgUnitIds), CompareType.INCLUDE));
        evi.setFilter(filter);
        BgOrgUnitCollection coll = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        HashSet<String> longNumbers = new HashSet<String>();
        HashSet<String> numbers = new HashSet<String>();
        Iterator iterator = coll.iterator();
        String longNumber2 = null;
        while (iterator.hasNext()) {
            BgOrgUnitInfo info = (BgOrgUnitInfo)iterator.next();
            longNumber2 = info.getLongNumber();
            if (longNumber2 != null && longNumber2.contains("!")) {
                longNumbers.add(info.getLongNumber().substring(0, info.getLongNumber().lastIndexOf("!")));
            }
            numbers.add(info.getNumber());
        }
        for (String longNumber2 : longNumbers) {
            List alist = Arrays.asList((Object[])longNumber2.split("!"));
            if (Collections.disjoint(numbers, alist)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void cbxProcessType_itemStateChanged(ItemEvent e) throws Exception {
        BgProcessEnum processType = (BgProcessEnum)((Object)e.getItem());
        this.setListener(null);
        if (BgProcessEnum.C01.equals((Object)processType)) {
            this.initBgOrgUnit(null);
            ((KDMenuItem)this.getPopMenu().getComponent(this.getPopMenu().getComponentCount() - 1)).setVisible(true);
        } else {
            this.initBgOrgUnit(this.loadNoLeaf());
            ((KDMenuItem)this.getPopMenu().getComponent(this.getPopMenu().getComponentCount() - 1)).setVisible(false);
        }
    }

    public BgProcessEnum getProcessType() {
        return (BgProcessEnum)((Object)this.cbxProcessType.getSelectedItem());
    }

    public Set<String> getSelectOrgUnitIds() {
        return this.selectOrgUnitIds;
    }

    public List<BgOrgUnitInfo> getOrgUnitInfos() {
        return this.orgUnitInfos;
    }

    public String[] getSheetNames() {
        if (this.rdoAllSheet.isSelected()) {
            return null;
        }
        return (String[])this.prmtSheet.getData();
    }

    class LeafOrgUnitListener
    implements ActionListener {
        LeafOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            BgDecomposeGatherUI.this.loadOrgUnitTree();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeGatherUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectLeafOrgUnit(node, true);
            BgDecomposeGatherUI.this.treeOrgUnit.repaint();
        }
    }

    class CompanyListener
    implements ActionListener {
        CompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgDecomposeGatherUI.this.loadOrgUnitTree();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeGatherUI.this.treeOrgUnit.getLastSelectedPathComponent();
            if (node == null) {
                node = (DefaultKingdeeTreeNode)BgDecomposeGatherUI.this.treeOrgUnit.getModel().getRoot();
            }
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgDecomposeGatherUI.this.getCompanyIds());
            BgDecomposeGatherUI.this.treeOrgUnit.repaint();
        }
    }

    class AllSubOrgUnitListener
    implements ActionListener {
        AllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgDecomposeGatherUI.this.loadOrgUnitTree();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeGatherUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgDecomposeGatherUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgUnitListener
    implements ActionListener {
        AllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgDecomposeGatherUI.this.loadOrgUnitTree();
            BgOrgUnitUtils.selectOrgUnit(BgDecomposeGatherUI.this.treeOrgUnit.getModel(), true);
            BgDecomposeGatherUI.this.treeOrgUnit.repaint();
        }
    }

    class SubOrgUnitListener
    implements ActionListener {
        SubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgDecomposeGatherUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgDecomposeGatherUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgDecomposeGatherUI.this.getPopMenu().show((Component)BgDecomposeGatherUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

