/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.client.AbstractBgDynCalcSetUI;
import com.kingdee.eas.ma.mbg.client.BgDynDimSelectUI;
import com.kingdee.eas.ma.mbg.common.calcRow.ConstExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ExprParseHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.LeftBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.OperatorExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RightBracket;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class BgDynCalcSetUI
extends AbstractBgDynCalcSetUI {
    private static final long serialVersionUID = 1194295914246575578L;
    private static final Logger logger = CoreUIObject.getLogger(BgDynCalcSetUI.class);
    private boolean isReparse = false;
    private boolean isCancel = true;
    private String oldformula = null;
    private String formula;
    private String name;
    private Map<String, String> formulaMap = null;
    private String dataName = null;

    public String getFormula() {
        return this.formula;
    }

    protected void setFormula(String formula) {
        this.formula = formula;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.formulaMap = (Map)this.getUIContext().get("formulaMap");
        this.dataName = (String)this.getUIContext().get("dataName");
        this.oldformula = (String)this.getUIContext().get("formulaName");
        boolean isRef = (Boolean)this.getUIContext().get("isRef");
        if (isRef) {
            this.txtCalcName.setEnabled(false);
        }
        this.txtMain.setBorder(BorderFactory.createEtchedBorder());
        DefaultStyledDocument doc = new DefaultStyledDocument(){
            private static final long serialVersionUID = -7499312351538921650L;

            @Override
            protected void fireInsertUpdate(DocumentEvent e) {
                super.fireInsertUpdate(e);
                BgDynCalcSetUI.this.reParseDocumentStyle();
            }

            @Override
            protected void fireRemoveUpdate(DocumentEvent e) {
                super.fireRemoveUpdate(e);
                BgDynCalcSetUI.this.reParseDocumentStyle();
            }
        };
        this.txtMain.setStyledDocument((StyledDocument)doc);
        this.txtMain.setText(this.oldformula);
        this.txtCalcName.setText(this.dataName);
        String oprtState = (String)this.getUIContext().get("OprtState");
        if (oprtState.equals(OprtState.VIEW)) {
            this.btnOK.setEnabled(false);
        } else {
            this.btnOK.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reParseDocumentStyle() {
        if (!this.isReparse) {
            try {
                this.isReparse = true;
                String text = this.txtMain.getText();
                StyledDocument doc = this.txtMain.getStyledDocument();
                int position = this.txtMain.getCaretPosition();
                if (doc.getLength() > 0) {
                    doc.remove(0, doc.getLength());
                }
                ExprParseHelper.parseDocument(text, doc);
                this.txtMain.setCaretPosition(position);
            }
            catch (BadLocationException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
            finally {
                this.isReparse = false;
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.verifyInput();
        this.name = this.txtCalcName.getText();
        this.formula = this.txtMain.getText();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    private void verifyInput() {
        int i;
        OperatorExpr expr;
        List<IExpr> exprs;
        if (this.txtCalcName == null || StringUtils.isEmpty((String)this.txtCalcName.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"dynDimIsNull"));
            SysUtil.abort();
        }
        if (this.txtCalcName.getText().matches("[0-9]+")) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"containsChAndLet"));
            SysUtil.abort();
        } else if (!this.txtCalcName.getText().matches("^[a-z0-9A-z\u4e00-\u9fa5\\_\\.]+$")) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"onlyCludeTwoLet"));
            SysUtil.abort();
        }
        if (this.formulaMap != null && this.formulaMap.containsKey(this.txtCalcName.getText()) && (this.dataName == null || !this.txtCalcName.getText().equals(this.dataName))) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"dataNameRepeat"));
            SysUtil.abort();
        }
        if (this.txtMain == null || StringUtils.isEmpty((String)this.txtMain.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"requiredDimIsNull", (Object[])new Object[]{this.labFormula.getBoundLabelText()}));
            SysUtil.abort();
        }
        if ((exprs = ExprParseHelper.parse(this.txtMain.getText())).get(0) instanceof OperatorExpr && ((expr = (OperatorExpr)exprs.get(0)).getOperator().equals("+") || expr.getOperator().equals("*") || expr.getOperator().equals("/"))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"startByAMS"));
            SysUtil.abort();
        }
        if (exprs.get(exprs.size() - 1) instanceof OperatorExpr) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"endByOperator"));
            SysUtil.abort();
        }
        IExpr beforeExpr = null;
        int bracketCount = 0;
        for (i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) instanceof LeftBracket) {
                ++bracketCount;
                continue;
            }
            if (exprs.get(i) instanceof RightBracket) {
                if (beforeExpr == null || beforeExpr instanceof OperatorExpr) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"rightBrackedBeforeByOther"));
                    SysUtil.abort();
                }
                if (--bracketCount >= 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"brackedMustBoth"));
                SysUtil.abort();
                continue;
            }
            if (exprs.get(i) instanceof OperatorExpr) {
                if (i > 0 && exprs.get(i - 1) instanceof LeftBracket) {
                    if (exprs.get(i - 1) instanceof LeftBracket) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"leftBracketCannotAfterByOper"));
                        SysUtil.abort();
                    }
                } else if (beforeExpr instanceof OperatorExpr) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"operatorBetweenByOther"));
                    SysUtil.abort();
                }
                beforeExpr = exprs.get(i);
                continue;
            }
            if (beforeExpr != null && !(beforeExpr instanceof OperatorExpr)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"otherMustBeforeByOperator"));
                SysUtil.abort();
            }
            beforeExpr = exprs.get(i);
        }
        if (bracketCount != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"brackedMustBoth"));
            SysUtil.abort();
        }
        for (i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) instanceof LeftBracket || exprs.get(i) instanceof RightBracket || exprs.get(i) instanceof OperatorExpr || exprs.get(i) instanceof ConstExpr || this.formulaMap.containsKey(exprs.get(i).getSource())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"calFormulaError"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnDimSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnDimSelect_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"formulaMap", this.getUIContext().get("formulaMap"));
        uiContext.put((Object)"dataName", this.getUIContext().get("dataName"));
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDynDimSelectUI.class.getName(), (Map)uiContext);
        BgDynDimSelectUI ui = (BgDynDimSelectUI)window.getUIObject();
        window.show();
        if (!ui.isCancel()) {
            this.addText(ui.getDimName());
        }
        this.txtMain.requestFocus();
    }

    private void addText(String text) {
        this.txtMain.replaceSelection(text);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.addOperator("+");
    }

    @Override
    protected void btnSub_actionPerformed(ActionEvent e) throws Exception {
        super.btnSub_actionPerformed(e);
        this.addOperator("-");
    }

    @Override
    protected void btnMulti_actionPerformed(ActionEvent e) throws Exception {
        super.btnMulti_actionPerformed(e);
        this.addOperator("*");
    }

    @Override
    protected void btnDiv_actionPerformed(ActionEvent e) throws Exception {
        super.btnDiv_actionPerformed(e);
        this.addOperator("/");
    }

    private void addOperator(String operator) {
        this.addText(operator);
        this.txtMain.requestFocus();
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

