/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.BizCalcDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgDynMembersUI;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgPeriodFunctionDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgDynMembersUI
extends AbstractBgDynMembersUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = 9076015847448111604L;
    private static final Logger logger = CoreUIObject.getLogger(BgDynMembersUI.class);
    private String formula;
    private String name;
    private boolean isCancel = true;
    private Map<String, String> formulaMap = null;
    private String dataName = null;
    private Map<String, KDBizPromptBox> compMap = new HashMap<String, KDBizPromptBox>();
    private List<KDBizPromptBox> compList = new ArrayList<KDBizPromptBox>();
    private BgSchemeDimensionHelper schemeHelper = null;
    KDRadioButton kDRadioNotLeaf = new KDRadioButton();
    KDRadioButton kDRadioLeaf = new KDRadioButton();
    KDRadioButton kDRadioAll = new KDRadioButton();
    KDTextField txtName = null;
    public String[] requiredDim = new String[]{DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_SCENARIO_NUMBER, DimensionConstants.DEF_ELEMENT_NUMBER};

    public String getFormula() {
        return this.formula;
    }

    protected void setFormula(String formula) {
        this.formula = formula;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<KDBizPromptBox> getCompList() {
        return this.compList;
    }

    public Map<String, KDBizPromptBox> getCompMap() {
        return this.compMap;
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        String oprtState;
        super.onLoad();
        this.spMain.setHorizontalScrollBarPolicy(31);
        this.formulaMap = (Map)this.getUIContext().get("formulaMap");
        this.dataName = (String)this.getUIContext().get("dataName");
        this.initPanel();
        boolean isRef = (Boolean)this.getUIContext().get("isRef");
        if (isRef) {
            this.txtName.setEnabled(false);
        }
        if ((oprtState = (String)this.getUIContext().get("OprtState")).equals(OprtState.VIEW)) {
            this.btnOk.setEnabled(false);
        } else {
            this.btnOk.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initPanel() throws Exception {
        List allDimension = (List)this.getUIContext().get("allDimensions");
        Map memberMap = (Map)this.getUIContext().get("memberMap");
        if (allDimension != null) {
            int x = 0;
            int y = 10;
            int width = 348;
            int height = 19;
            int yCompGap = 15;
            int xCompGap = 20;
            int yindex = 0;
            int totalHeight = 0;
            boolean isShowOrg = this.getSchemeHelper() == null || !this.getSchemeHelper().isBgCsl();
            int skip = isShowOrg ? 0 : -1;
            int i = 0;
            while (i < allDimension.size()) {
                BgDimensionInfo dim = (BgDimensionInfo)allDimension.get(i);
                KDLabelContainer container = new KDLabelContainer();
                if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    container.setName("contDimName");
                    container.setBoundLabelText(BgNFSHelper.getHardCodeRes("bizName"));
                } else {
                    container.setName("cont" + dim.getNumber());
                    container.setBoundLabelText(dim.getName());
                }
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + (yindex + skip) * (height + yCompGap), width, height));
                this.pnlMain.add((Component)container, null);
                totalHeight += height + yCompGap;
                BgPeriodFunctionDialog dialog = null;
                if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    dialog = new BgPeriodFunctionDialog((CoreUIObject)this, false, false);
                    dialog.setBgSchemeID(this.schemeHelper.getBgSchemeId());
                    dialog.setOrgId((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    dialog.setDimension(this.getSchemeHelper().getDimension(dim.getNumber()));
                    dialog.setCanSelectUserPeriod(true);
                    dialog.setNeedFunctionType(false);
                    Set numSet = BizFacadeFactory.getRemoteInstance().queryPeriodType(this.schemeHelper.getBgSchemeId());
                    dialog.setBgPeriodTypeNumbers(numSet);
                } else {
                    dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dim.getNumber()), (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BizCalcDimensionMemberSelectDialog)dialog).setShowOusealup(false);
                    ((BizCalcDimensionMemberSelectDialog)dialog).setMulti(false);
                    if (this.getUIContext().get("isHiddenPartCsldim") instanceof Boolean) {
                        ((BizCalcDimensionMemberSelectDialog)dialog).setHiddenCslPartDim(((Boolean)this.getUIContext().get("isHiddenPartCsldim")).booleanValue());
                    }
                }
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                    this.txtName = new KDTextField();
                    this.txtName.setRequired(true);
                    this.txtName.setMaxLength(255);
                    if (this.dataName != null) {
                        this.txtName.setText(this.dataName);
                    }
                    container.setBoundEditor((JComponent)this.txtName);
                } else {
                    KDBizPromptBox prmt = new KDBizPromptBox();
                    prmt.setUserObject((Object)dim);
                    prmt.setName("prmt" + dim.getNumber());
                    prmt.setSelector((KDPromptSelector)dialog);
                    if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dim.getNumber()) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dim.getNumber()) || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dim.getNumber())) {
                        prmt.setRequired(true);
                    }
                    container.setBoundEditor((JComponent)prmt);
                    prmt.setEditFormatter((IFormatter)new CalcMemDispFormatter());
                    prmt.setDisplayFormatter((IFormatter)new CalcMemDispFormatter());
                    if (memberMap != null && memberMap.containsKey(dim.getNumber())) {
                        prmt.setData(memberMap.get(dim.getNumber()));
                    }
                    this.compList.add(prmt);
                }
                ++i;
                ++yindex;
            }
            if (this.isNeedProcessType()) {
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundLabelText(BgProcessHelper.DEF_PROCESS_NAME);
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + (yindex + skip) * (height + yCompGap), width, height));
                this.pnlMain.add((Component)container);
                totalHeight += height + yCompGap;
                KDBizPromptBox prmtBgProcess = BgExamineHelper.getBgProcessPrmBox(this, false);
                prmtBgProcess.setName("prmt" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundEditor((JComponent)prmtBgProcess);
                prmtBgProcess.setData((Object)BgProcessEnum.C01);
                if (memberMap != null) {
                    if (memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                        if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof BgDimensionMember) {
                            prmtBgProcess.setData((Object)BgProcessHelper.memberToEnum((BgDimensionMember)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)));
                        } else if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof Set) {
                            prmtBgProcess.setData(BgProcessHelper.membersToEnums((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)));
                        }
                    } else {
                        prmtBgProcess.setData(null);
                    }
                }
                this.compList.add(prmtBgProcess);
            }
            if ((double)(totalHeight += yCompGap) > this.spMain.getPreferredSize().getHeight() - (double)yCompGap) {
                int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 150;
                if (maxHeight > 700) {
                    maxHeight = 700;
                }
                int initHeight = this.spMain.getHeight();
                this.pnlMain.setPreferredSize(new Dimension(width, totalHeight + yCompGap));
                Dimension bounds = this.getPreferredSize();
                if (totalHeight > maxHeight - yCompGap) {
                    bounds.height = bounds.height + maxHeight - initHeight;
                    this.setPreferredSize(new Dimension(bounds.width, bounds.height));
                    this.spMain.setVerticalScrollBarPolicy(22);
                } else {
                    bounds.height = (int)((double)bounds.height + this.pnlMain.getPreferredSize().getHeight() - (double)initHeight);
                    this.setPreferredSize(new Dimension(bounds.width, bounds.height));
                    this.spMain.setVerticalScrollBarPolicy(21);
                }
            }
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.name = this.generateName();
        this.formula = this.generateFormula();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    protected String generateName() {
        if (this.txtName == null || StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"dynDimIsNull"));
            SysUtil.abort();
        }
        if (this.txtName.getText().matches("[0-9]+")) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"containsChAndLet"));
            SysUtil.abort();
        } else if (!this.txtName.getText().matches("^[a-z0-9A-z\u4e00-\u9fa5\\_\\.]+$")) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"onlyCludeTwoLet"));
            SysUtil.abort();
        }
        if (this.formulaMap != null && this.formulaMap.containsKey(this.txtName.getText()) && (this.dataName == null || !this.txtName.getText().equals(this.dataName))) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"dataNameRepeat"));
            SysUtil.abort();
        }
        return this.txtName.getText().trim();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected String generateFormula() {
        StringBuffer forStr = new StringBuffer();
        forStr.append("MBR").append(":").append("[");
        HashSet<String> type = new HashSet<String>();
        for (KDBizPromptBox prmt : this.compList) {
            BgDimensionMember dim = null;
            if (prmt.getData() != null) {
                if (prmt.getData() instanceof BgDimensionMember) {
                    dim = (BgDimensionMember)prmt.getData();
                } else if (prmt.getData() instanceof BgPeriodInfo) {
                    BgPeriodInfo p = (BgPeriodInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                } else if (prmt.getData() instanceof List) {
                    List periodVar = (List)prmt.getData();
                    if (!periodVar.isEmpty()) {
                        dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, (String)periodVar.get(0), (String)periodVar.get(0));
                        dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                    }
                } else if (prmt.getData() instanceof StringBuffer) {
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, prmt.getData().toString(), prmt.getData().toString());
                } else if (prmt.getData() instanceof BgProcessEnum) {
                    BgProcessEnum bEnum = (BgProcessEnum)((Object)prmt.getData());
                    dim = BgProcessHelper.getMember(bEnum.getName());
                }
            }
            if (dim == null) continue;
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR);
            if (dim.getSrcNumber() != null) {
                forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
            } else {
                forStr.append(dim.getNumber());
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            type.add(dim.getType());
        }
        if (this.compList.size() > 0) {
            forStr.delete(forStr.length() - 1, forStr.length()).append("]");
        }
        for (int i = 0; i < this.requiredDim.length; ++i) {
            if (type.contains(this.requiredDim[i])) continue;
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"requiredDimIsNull", (Object[])new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)this.requiredDim[i])}));
            SysUtil.abort();
        }
        return forStr.toString();
    }

    protected void resetDimDialog(String number) {
        BizCalcDimensionMemberSelectDialog dialog = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("orgUnitId");
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        BgOrgUnitCollection orgCol = null;
        String orgUnitId = null;
        try {
            orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)("getBgOrgUnitCollection error" + e.getMessage()));
        }
        if (orgCol != null && !orgCol.isEmpty()) {
            orgUnitId = orgCol.get(0).getOrgUnitID();
        }
        for (KDBizPromptBox prmt : this.compList) {
            String dimNumber = prmt.getName().substring(4);
            if (DimensionBaseConstants.necessary.contains(dimNumber) || DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimNumber) || "BG_Period1".equals(dimNumber) || "BG_Period2".equals(dimNumber)) continue;
            try {
                dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dimNumber), orgUnitId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ((BizCalcDimensionMemberSelectDialog)dialog).setMulti(false);
            prmt.setSelector(dialog);
        }
    }

    protected boolean isNeedProcessType() {
        return this.schemeHelper == null || !this.schemeHelper.getClass().getName().equals(DimensionConstants.CSLSCHEME_HELPER);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    protected class CalcMemDispFormatter
    implements IFormatter {
        protected CalcMemDispFormatter() {
        }

        public String valueToString(Object o) {
            if (o instanceof BgPeriodInfo) {
                BgPeriodInfo p = (BgPeriodInfo)o;
                return "[" + p.getNumber() + "]" + p.getName();
            }
            return o.toString();
        }

        public void applyPattern(String pattern) {
        }
    }
}

