/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.mbg.BgExamineGroupFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgExamineGroup;
import com.kingdee.eas.ma.mbg.client.AbstractBgExamineGroupEditUI;
import com.kingdee.eas.ma.mbg.client.BgExamineListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgExamineGroupEditUI
extends AbstractBgExamineGroupEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgExamineGroupEditUI.class);
    private BgSchemeInfo bgSchemeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
            this.setBgSchemeInfo((BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO"));
        }
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo) {
            this.setOrgUnitInfo((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        }
        super.onLoad();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
        }
        if ("PRE".equals(this.editData.getNumber())) {
            BgCommCHelper.disableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
            BgCommCHelper.disableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
        } else {
            BgCommCHelper.enableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
            BgCommCHelper.enableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.disEnabelTxtNumber();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initState();
    }

    protected void initState() {
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.disableAction((JButton)this.btnSubmit, null);
        }
    }

    protected IObjectValue createNewData() {
        BgExamineGroupInfo info = new BgExamineGroupInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setOrgUnit(this.getOrgUnitInfo() != null ? this.getOrgUnitInfo().castToFullOrgUnitInfo() : SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setBgScheme(this.getBgSchemeInfo());
        info.setIsCsl(false);
        return info;
    }

    protected IBgExamineGroup getBizInterface() throws Exception {
        return BgExamineGroupFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        super.actionEdit_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        super.actionAddNew_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        if (this.getBizInterface().isHasBgExamine((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"delete_group_has_bgExamine"));
            SysUtil.abort();
        } else if ("PRE".equals(this.editData.getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"delete_group_defaul"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (object instanceof BgExamineListUI) {
            ((BgExamineListUI)((Object)object)).newGroupNumber = this.txtNumber.getText();
        }
        super.actionSubmit_actionPerformed(e);
        if (object instanceof BgExamineListUI) {
            ((BgExamineListUI)((Object)object)).initTree();
            ((BgExamineListUI)((Object)object)).setSelectTreeNode();
            this.setSaved(false);
        }
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
    }

    private void disEnabelTxtNumber() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) || this.editData.getId() != null) {
            if (this.getBizInterface().isHasBgExamine((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEditable(true);
                this.txtNumber.setEnabled(true);
            }
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"NumberNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"haveEspecial"));
                SysUtil.abort();
            }
        }
        if (BgDBUtils.length((String)this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"NumberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = this.txtName.getText()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"NameNull"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("bgScheme.id"));
        return sic;
    }

    protected void isBgSchemeIsFiling() throws EASBizException, BOSException {
        if (this.getBgSchemeInfo() != null) {
            BgSchemeFactory.getRemoteInstance().checkFilling(this.getBgSchemeInfo().getId().toString());
        }
    }
}

