/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.ITableLocate;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.biz.BizStateEnum;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.RefBgTemplateRender;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupInfo;
import com.kingdee.eas.ma.mbg.BgExamineHistFactory;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgExamine;
import com.kingdee.eas.ma.mbg.IBgExamineGroup;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgExamineListUI;
import com.kingdee.eas.ma.mbg.client.BgExamineGroupEditUI;
import com.kingdee.eas.ma.mbg.client.BgExamineHistListUI;
import com.kingdee.eas.ma.mbg.client.BgExamineMainUI;
import com.kingdee.eas.ma.mbg.client.BgExaminePropertyEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineExportHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.ma.mbg.utils.XmlFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgExamineListUI
extends AbstractBgExamineListUI {
    private static final long serialVersionUID = -6621390514926434676L;
    private static final Logger logger = CoreUIObject.getLogger(BgExamineListUI.class);
    private boolean isOrgUnitChange = false;
    protected static final String ID_COL = "id";
    protected static final String BG_TEMPLATE_COL = "bgTemplate";
    protected static final String BG_TEMPLATE_ADJ_COL = "bgAdjTemplate";
    protected static final String STATE_COL = "state";
    private IMutexServiceControl imsc = MutexServiceControlFactory.getRemoteInstance();
    private OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    public String newGroupNumber = null;
    public static final String MODEL = "MODEL";
    public static final String MODEL_HISTVERSION = "HISTVERSION";
    public static final String MODEL_DELHIST = "DELHIST";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIContext().get("number") instanceof String) {
            String number = (String)this.getUIContext().get("number");
            IRow row = null;
            ICell cell = null;
            int row_index = -1;
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                row = this.tblMain.getRow(i);
                if (row == null || (cell = row.getCell("number")) == null || cell.getValue() == null || !cell.getValue().toString().equals(number)) continue;
                row_index = i;
                break;
            }
            if (this.tblMain.getRow(row_index) != null) {
                this.tblMain.getSelectManager().select(row_index, 0);
                this.tblMain.getLayoutManager().scrollRowToShow(row_index);
            } else {
                this.tblMain.getSelectManager().removeAll();
            }
        }
    }

    protected void init() throws Exception {
        this.prmtBgScheme.setEditable(false);
        this.prmtOrgUnit.setEditable(false);
        if (this.getUIContext().get("orgUnit.name") instanceof OrgUnitInfo) {
            this.unitInfo = (OrgUnitInfo)this.getUIContext().get("orgUnit.name");
        }
        BgCommCHelper.initOrgUnit((CoreUIObject)this, (KDBizPromptBox)this.prmtOrgUnit, (Object)this.getUnitInfo(), (String)this.getCtrlUnit().getId().toString(), (String)this.getListPermissionItem());
        if (this.getUIContext().get("ref_form") instanceof BgAccountInfo) {
            BgAccountInfo accInfo = (BgAccountInfo)this.getUIContext().get("ref_form");
            BgSchemeInfo schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(accInfo.getId()));
            this.prmtBgScheme.setData((Object)schemeInfo);
        }
        if (this.prmtBgScheme.getData() != null) {
            this.prmtBgTemplate.setEditable(false);
        }
        this.tblMain.getColumn(BG_TEMPLATE_COL).setRenderer((IBasicRender)new RefBgTemplateRender());
    }

    public void refreshList() throws Exception {
        ITableLocate locate = this.getTableLocate();
        super.refreshList();
        if (locate != null) {
            locate.locate();
        }
    }

    public OrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public CtrlUnitInfo getCtrlUnit() {
        return this.ctrlUnit;
    }

    protected String getListPermissionItem() {
        return "mbg_BgExamine01_list";
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            return new ObjectUuidPK(((OrgUnitInfo)this.prmtOrgUnit.getData()).getId());
        }
        return super.getOrgPK(action);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.tblMain.getHeadRow(0).getCell(BG_TEMPLATE_COL).setRenderer(null);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.switchCancelState();
    }

    protected void switchCancelState() {
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() == 1) {
            int index = this.tblMain.getSelectManager().getActiveRowIndex();
            if (((BizEnumValueDTO)this.tblMain.getRow(index).getCell(STATE_COL).getValue()).getInt() == 1) {
                this.btnCancelCancel.setEnabled(false);
                this.menuItemCancelCancel.setEnabled(false);
                this.btnCancel.setEnabled(true);
                this.menuItemCancel.setEnabled(true);
            } else if (((BizEnumValueDTO)this.tblMain.getRow(index).getCell(STATE_COL).getValue()).getInt() == 3) {
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
            } else {
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
            }
        } else {
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemProperty.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.menuItemImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnProperty.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemProperty.setEnabled(true);
        this.btnProperty.setEnabled(true);
        this.menuItemCopy.setEnabled(true);
        this.btnCopy.setEnabled(true);
        BgCommCHelper.enable((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel, (ItemAction)this.actionCancelCancel);
        BgCommCHelper.enable((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel, (ItemAction)this.actionCancel);
        this.treeView.setShowButton(false);
        this.btnGroupMoveTree.setVisible(false);
        this.btnGroupMoveTree.setEnabled(false);
        this.btnMoveTree.setVisible(false);
        this.btnMoveTree.setEnabled(false);
        this.menuItemMoveTree.setVisible(false);
        this.menuItemMoveTree.setEnabled(false);
        this.menuItemGroupMoveTree.setVisible(false);
        this.menuItemGroupMoveTree.setEnabled(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        super.actionAddNew_actionPerformed(e);
        this.refreshList();
    }

    protected void checkBeforeAction() throws EASBizException, BOSException {
        if (this.prmtBgScheme.getData() == null) {
            this.showSchemeNullWarning();
            SysUtil.abort();
        } else {
            this.isBgSchemeIsFiling();
        }
    }

    protected void showSchemeNullWarning() {
        MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"isNullBgScheme"));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext ctx = new UIContext((Object)this);
        BgExamineInfo bgExamine = (BgExamineInfo)BgExamineFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        ctx.put((Object)"ID", (Object)bgExamine.getId().toString());
        ctx.put((Object)"BgExamineInfo", (Object)bgExamine);
        BgSchemeInfo schemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        bgExamine.setBgScheme(schemeInfo);
        this.processUIContext(ctx);
        if (this.getUIWindow() instanceof UIModelDialog) {
            ((UIModelDialog)this.getUIWindow()).setVisible(false);
        }
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditMainUIName(), (Map)ctx, null, OprtState.VIEW);
        window.show();
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        this.checkSelected();
        this.checkSelectedExamineStatus();
        this.requestMutexForUpdate(this.getSelectedIdValues());
        UIContext ctx = new UIContext((Object)this);
        BgExamineInfo bgExamine = (BgExamineInfo)BgExamineFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        ctx.put((Object)"ID", (Object)bgExamine.getId().toString());
        ctx.put((Object)"BgExamineInfo", (Object)bgExamine);
        BgSchemeInfo schemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        bgExamine.setBgScheme(schemeInfo);
        this.processUIContext(ctx);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditMainUIName(), (Map)ctx, null, OprtState.EDIT);
        window.show();
        this.refreshList();
    }

    private void checkSelectedExamineStatus() {
        int iState;
        IRow row;
        BizEnumValueInfo state;
        int rowIndex = -1;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            rowIndex = selectRows[0];
        }
        if (rowIndex >= 0 && (state = (BizEnumValueInfo)(row = this.tblMain.getRow(rowIndex)).getCell(STATE_COL).getValue()) != null && 1 == (iState = state.getInt())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"saveAndCancelCanEdit"));
            SysUtil.abort();
        }
    }

    protected void requestMutexLock(String id) {
        boolean lock = this.imsc.requestObjIDForUpdate(id);
    }

    @Override
    public void actionProperty_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        this.checkSelected();
        super.actionCopy_actionPerformed(e);
        UIContext uicontext = new UIContext((Object)this);
        uicontext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uicontext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
        uicontext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
        uicontext.put((Object)BgBaseConstants.USER_INFO, (Object)SysContext.getSysContext().getCurrentUserInfo());
        uicontext.put((Object)"currBgExamineID", (Object)this.getSelectedKeyValue().toString());
        IUIWindow copyUI = UIFactory.createUIFactory().create(this.getEditUIName(), (Map)uicontext, null, OprtState.COPYADDNEW);
        copyUI.show();
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.tblMain.refresh();
        this.tblMain.getSelectManager().setActiveRowIndex(activeRowIndex);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        this.checkSelected();
        if (this.confirmRemove()) {
            Map result = null;
            ArrayList idList = this.getSelectedIdValues();
            ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
            HashMap inCorrectStateMap = new HashMap();
            for (String id : idList) {
                pkList.add(new ObjectUuidPK(id));
            }
            try {
                this.requestMutexForUpdate(idList);
                result = BgExamineFactory.getRemoteInstance().batchDelete(idList, ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)"delete error", (Throwable)ex);
                this.handUIExceptionAndAbort(ex);
            }
            StringBuffer resultMsg = new StringBuffer();
            StringBuffer numberStr = new StringBuffer();
            StringBuffer incorrectStr = new StringBuffer();
            Set tmpSet = null;
            if (result != null && result.size() > 0) {
                tmpSet = (Set)result.get("SavedMap");
                if (tmpSet != null && tmpSet.size() != 0) {
                    Iterator it = tmpSet.iterator();
                    while (it.hasNext()) {
                        incorrectStr.append((String)it.next()).append(",");
                    }
                    incorrectStr.delete(incorrectStr.length() - 1, incorrectStr.length());
                }
                if (StringUtils.isEmpty((String)incorrectStr.toString()) && StringUtils.isEmpty((String)numberStr.toString())) {
                    MsgBox.showWarning((String)EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"deleteSuccess"));
                    this.refreshList();
                    SysUtil.abort();
                } else {
                    if (!StringUtils.isEmpty((String)incorrectStr.toString())) {
                        resultMsg.append(EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"CantDeleteSavedState", (Object[])new Object[]{incorrectStr.toString()})).append("\n");
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"deleteFailDetail", (Object[])new Object[]{idList.size(), idList.size() - tmpSet.size(), tmpSet.size()}), (String)resultMsg.toString(), (int)2);
                }
            }
            this.refreshList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMutexForUpdate(List<String> idList) throws EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
        try {
            for (String id : idList) {
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        }
    }

    protected String getEditUIName() {
        return BgExaminePropertyEditUI.class.getName();
    }

    protected String getEditMainUIName() {
        return BgExamineMainUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgExamineFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        this.processUIContext(uiContext);
    }

    protected void processUIContext(UIContext uiContext) {
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, this.prmtOrgUnit.getData() != null ? ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString() : null);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
        uiContext.put((Object)"bgScheme", this.prmtBgScheme.getData());
        uiContext.put((Object)BgBaseConstants.USER_INFO, (Object)SysContext.getSysContext().getCurrentUserInfo());
        uiContext.put((Object)BgBaseConstants.BGTEMPLATE_INFO, this.prmtBgTemplate.getData());
        uiContext.put((Object)"BGEXAMINEGROUP", this.getSelectTreeObj());
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.fillTemplateList(e);
    }

    protected void fillTemplateList(KDTDataRequestEvent e) {
        if (this.prmtBgScheme.getData() == null) {
            return;
        }
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = firstRow; i <= lastRow; ++i) {
            String id = (String)this.tblMain.getRow(i).getCell(ID_COL).getValue();
            idSet.add(id);
        }
        if (idSet.size() > 0) {
            Map templateMap = null;
            try {
                templateMap = BgExamineRefBgTemplateFactory.getRemoteInstance().getRefBgTemplates(idSet);
            }
            catch (Exception exe) {
                ExceptionHandler.handle((Throwable)exe);
            }
            for (int i = firstRow; i <= lastRow; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = (String)row.getCell(ID_COL).getValue();
                if (templateMap == null || !templateMap.containsKey(id)) continue;
                List templates = (List)templateMap.get(id);
                row.getCell(BG_TEMPLATE_COL).setValue((Object)templates);
            }
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (e.getNewValue() == null) {
            if (!this.isOrgUnitChange) {
                this.isOrgUnitChange = false;
                this.showSchemeNullWarning();
                this.prmtBgScheme.setDataNoNotify(e.getOldValue());
                SysUtil.abort();
            } else {
                this.prmtBgTemplate.setEnabled(false);
            }
        } else {
            this.prmtBgTemplate.setEnabled(true);
            if (e.getOldValue() != null && e.getNewValue() != null && ((BgSchemeInfo)e.getOldValue()).getId().toString().equals(((BgSchemeInfo)e.getNewValue()).getId().toString())) {
                return;
            }
            this.prmtBgTemplate.setDataNoNotify(null);
            BgSchemeInfo bgScheme = (BgSchemeInfo)e.getNewValue();
            this.setBgTemplateView(bgScheme);
        }
        this.initTree();
        this.tblMain.refresh();
    }

    protected void setBgTemplateView(BgSchemeInfo bgScheme) throws Exception {
        if (bgScheme == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        this.prmtBgTemplate.setEntityViewInfo(view);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)(bgScheme != null ? bgScheme.getId().toString() : ""), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.id", null, CompareType.EMPTY));
        filter.setMaskString(" #0 AND ( #1 OR #2 ) ");
        filter = MbgPermissionHelper.addBgTemplatePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter, bgScheme != null ? bgScheme.getId().toString() : "", true);
        view.setFilter(filter);
    }

    @Override
    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgTemplate_dataChanged(e);
        this.tblMain.refresh();
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgTemplate_willShow(e);
        this.setBgSchemeView();
    }

    @Override
    protected void prmtBgTemplate_willShow(SelectorEvent e) throws Exception {
        super.prmtBgTemplate_willShow(e);
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"chooseBgScheme"));
            e.setCanceled(true);
        } else {
            this.setBgTemplateView((BgSchemeInfo)this.prmtBgScheme.getData());
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        if (e.getNewValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"isNullOrgUnit"));
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
        } else {
            this.setBgSchemeView();
            this.isOrgUnitChange = true;
            BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), false, (OrgUnitInfo)this.prmtOrgUnit.getValue());
            this.isOrgUnitChange = false;
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected void setBgSchemeView() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgSchemeType.schemeType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
        Set<String> tmpList = BgNFCHelper.getBgSchemeIds(((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId());
        BgNFCHelper.setSchemeIdFilter(tmpList, filter);
        this.prmtBgScheme.setEntityViewInfo(view);
        filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        this.processQueryExecutor(viewInfo);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void processQueryExecutor(EntityViewInfo viewInfo) {
        FilterInfo filter = viewInfo.getFilter();
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
        FilterItemInfo filterItem = new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "" : bgScheme.getId().toString()), CompareType.EQUALS);
        if (BgNFCHelper.findFilterItem(filter, "bgScheme.id") != null) {
            BgNFCHelper.removeFilterItems(filter, filterItem);
            filter.getFilterItems().add(filterItem);
        } else {
            filter.getFilterItems().add(filterItem);
            if (filter.getMaskString() == null) {
                filter.setMaskString("#" + (filter.getFilterItems().size() - 1));
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") AND #" + (filter.getFilterItems().size() - 1));
            }
        }
        BgTemplateInfo bgTemplate = (BgTemplateInfo)this.prmtBgTemplate.getData();
        if (bgTemplate != null) {
            FilterItemInfo tempFilterItem = new FilterItemInfo(ID_COL, (Object)("select FBgExamineID from T_MBG_BgExamineRefBgTemplate where FBgTemplateID = '" + bgTemplate.getId().toString() + "'"), CompareType.INNER);
            if (BgNFCHelper.findFilterItem(filter, ID_COL) != null) {
                BgNFCHelper.removeFilterItems(filter, tempFilterItem);
                filter.getFilterItems().add(tempFilterItem);
            } else {
                filter.getFilterItems().add(tempFilterItem);
                filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
            }
        } else if (BgNFCHelper.findFilterItem(filter, ID_COL) != null) {
            FilterItemInfo tempFilterItem = new FilterItemInfo(ID_COL, null, CompareType.INNER);
            BgNFCHelper.removeFilterItems(filter, tempFilterItem);
            filter.setMaskString(filter.getMaskString().substring(0, filter.getMaskString().lastIndexOf("AND")));
        }
        this.processOrgTreeFilter(filter);
    }

    protected void processOrgTreeFilter(FilterInfo filter) {
        FilterItemInfo filterItem = new FilterItemInfo("orgTree.id", null, CompareType.IS);
        if (BgNFCHelper.findFilterItem(filter, "orgTree.id") != null) {
            BgNFCHelper.removeFilterItems(filter, filterItem);
            filter.getFilterItems().add(filterItem);
        } else {
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("(" + filter.getMaskString() + ") AND #" + (filter.getFilterItems().size() - 1));
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.checkSelected();
        HashSet bgExaminieIds = new HashSet();
        bgExaminieIds.addAll(this.getSelectedIdValues());
        IBgExamine iBgExamine = (IBgExamine)this.getBizInterface();
        Map result = iBgExamine.batchCancel(bgExaminieIds);
        this.refreshList();
        this.tblMain.getSelectManager().select(selectIndex, 0);
        BgExamineHelper.dealWithErrorMsg((Component)((Object)this), result, true, false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.requestMutexForUpdate(this.getSelectedIdValues());
        super.actionCancelCancel_actionPerformed(e);
        this.checkSelected();
        String bgSchemeId = ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString();
        HashSet bgExamineIds = new HashSet();
        bgExamineIds.addAll(this.getSelectedIdValues());
        IBgExamine iBgExamine = (IBgExamine)this.getBizInterface();
        Map result = iBgExamine.cancelCancelColls(bgExamineIds, bgSchemeId);
        this.refreshList();
        this.tblMain.getSelectManager().select(selectIndex, 0);
        BgExamineHelper.dealWithErrorMsg((Component)((Object)this), result, false, false);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAction();
        UIContext ctx = new UIContext((Object)this);
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
        if (orgUnit == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"isNullOrgUnit"));
            return;
        }
        ctx.put((Object)"ORGUNIT_ID", (Object)orgUnit.getIdentity().toString());
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        if (bgSchemeInfo == null) {
            this.showSchemeNullWarning();
            return;
        }
        ctx.put((Object)"BGSCHEME_ID", (Object)bgSchemeInfo.getId().toString());
        ctx.put((Object)"BGEXAMINEGROUP", this.getSelectTreeObj());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.mbg.client.BgExamineImportUI", (Map)ctx, null, OprtState.VIEW);
        window.show();
        this.refresh(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        ArrayList<String> selectIds = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        int state = -1;
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            state = -1;
            if (row.getCell(STATE_COL).getValue() instanceof BizEnumValueInfo) {
                state = ((BizEnumValueInfo)row.getCell(STATE_COL).getValue()).getInt();
            } else if (row.getCell(STATE_COL).getValue() instanceof BizStateEnum) {
                state = ((BizStateEnum)row.getCell(STATE_COL).getValue()).getValue();
            }
            if (state != 1) continue;
            selectIds.add(row.getCell(ID_COL).getValue().toString());
        }
        if (selectIds.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"templateCannotExport"));
            return;
        }
        if (selectIds.size() != selectRows.length && (result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"templateCannotExport"))) == 2) {
            return;
        }
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForExp((Object)this);
        fileChooser.setDialogTitle(EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"bgExamineExport"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)new XmlFileFilter());
        fileChooser.setBounds(10, 10, 200, 200);
        String filePath = null;
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (filePath.lastIndexOf(".") != -1) {
                filePath = filePath.substring(0, filePath.lastIndexOf("."));
            }
            filePath = filePath + ".xml";
        }
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file.exists()) {
            int result2 = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileHasExisted"));
            if (result2 != 0) return;
            if (file.delete()) {
                file = new File(filePath);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                return;
            }
        }
        this.exportBgExamines(selectIds, file);
        new BgFileUtil().storeDefaultPathForEXP((Object)file, (Object)this);
        MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"bgExamineExportSuccess"));
    }

    protected void exportBgExamines(List<String> selectIds, File file) throws Exception {
        BgExamineExportHelper.exportBgExamine(selectIds, file);
    }

    private void isBgSchemeIsFiling() throws EASBizException, BOSException {
        BgSchemeInfo scheme;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo && (scheme = (BgSchemeInfo)this.prmtBgScheme.getData()) != null) {
            BgSchemeFactory.getRemoteInstance().checkFilling(scheme.getId().toString());
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BgExamineGroupFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(ID_COL);
        sic.add("name");
        sic.add("number");
        sic.add("isCsl");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("longnumber");
        sic.add("creator.id");
        sic.add("creator.number");
        sic.add("creator.name");
        sic.add("parent.id");
        sic.add("parent.name");
        sic.add("parent.number");
        sic.add("bgScheme.id");
        return sic;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo scheme = (BgSchemeInfo)this.prmtBgScheme.getData();
            filter.getFilterItems().add(new FilterItemInfo("isCsl", (Object)(this.isCsl() != false ? Boolean.TRUE : Boolean.FALSE), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)scheme.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"PRE", CompareType.EQUALS));
            filter.setMaskString("(#0 and  #1) or #2 )");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", null));
        }
        return filter;
    }

    protected Boolean isCsl() {
        return false;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
    }

    protected String getGroupEditUIName() {
        return BgExamineGroupEditUI.class.getName();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        Object obj;
        ObjectUuidPK groupPk = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && (obj = row.getCell(this.getQueryFieldName()).getValue()) != null) {
            groupPk = new ObjectUuidPK(obj.toString());
        }
        return groupPk;
    }

    protected String getQueryFieldName() {
        return "bgExamineGroup.id";
    }

    protected String getRootName() {
        return BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"bgExamineGroup");
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            SysUtil.abort();
        }
        super.actionGroupAddNew_actionPerformed(e);
        KDTreeNode node = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (this.hasExpandByAddnew() && node != null) {
            this.treeMain.expandAllNodes(true, (TreeNode)node);
        }
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        if (this.getSelectTreeObj() != null && this.getSelectTreeObj() instanceof BgExamineGroupInfo) {
            BgExamineGroupInfo bgExamineGroupInfo = (BgExamineGroupInfo)this.getSelectTreeObj();
            IBgExamineGroup iBgExamineGroup = BgExamineGroupFactory.getRemoteInstance();
            if (iBgExamineGroup.isHasBgExamine((IObjectPK)new ObjectUuidPK(bgExamineGroupInfo.getId()))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"delete_group_has_bgExamine"));
                SysUtil.abort();
            } else if ("PRE".equals(bgExamineGroupInfo.getNumber())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"delete_group_defaul"));
                SysUtil.abort();
            }
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        super.actionGroupEdit_actionPerformed(e);
    }

    protected boolean hasExpandByAddnew() {
        return true;
    }

    protected void initTree() throws Exception {
        super.initTree();
        KDTreeNode root = (KDTreeNode)this.treeMain.getModel().getRoot();
        if (root != null) {
            this.treeMain.expandAllNodes(true, (TreeNode)root);
        }
        if (this.newGroupNumber == null) {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
        } else {
            this.setSelectTreeNode();
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (e != null && e.getNewLeadSelectionPath() != null) {
            Object newObj = e.getNewLeadSelectionPath().getLastPathComponent();
            if (newObj != null && newObj instanceof KDTreeNode) {
                if (((KDTreeNode)newObj).getUserObject() instanceof String) {
                    BgCommCHelper.disableAction((JButton)this.btnGroupView, (JMenuItem)this.menuItemGroupView, (ItemAction)this.actionGroupView);
                    BgCommCHelper.disableAction((JButton)this.btnGroupEdit, (JMenuItem)this.menuItemGroupEdit, (ItemAction)this.actionGroupEdit);
                    BgCommCHelper.disableAction((JButton)this.btnGroupRemove, (JMenuItem)this.menuItemGroupRemove, (ItemAction)this.actionGroupRemove);
                } else if (((KDTreeNode)newObj).getUserObject() instanceof BgExamineGroupInfo) {
                    if (((BgExamineGroupInfo)((KDTreeNode)newObj).getUserObject()).getNumber().equals("PRE")) {
                        BgCommCHelper.disableAction((JButton)this.btnGroupEdit, (JMenuItem)this.menuItemGroupEdit, (ItemAction)this.actionGroupEdit);
                        BgCommCHelper.disableAction((JButton)this.btnGroupRemove, (JMenuItem)this.menuItemGroupRemove, (ItemAction)this.actionGroupRemove);
                    } else {
                        BgCommCHelper.enableAction((JButton)this.btnGroupEdit, (JMenuItem)this.menuItemGroupEdit, (ItemAction)this.actionGroupEdit);
                        BgCommCHelper.enableAction((JButton)this.btnGroupRemove, (JMenuItem)this.menuItemGroupRemove, (ItemAction)this.actionGroupRemove);
                    }
                    BgCommCHelper.enableAction((JButton)this.btnGroupView, (JMenuItem)this.menuItemGroupView, (ItemAction)this.actionGroupView);
                }
            } else {
                BgCommCHelper.enableAction((JButton)this.btnGroupView, (JMenuItem)this.menuItemGroupView, (ItemAction)this.actionGroupView);
                BgCommCHelper.enableAction((JButton)this.btnGroupEdit, (JMenuItem)this.menuItemGroupEdit, (ItemAction)this.actionGroupEdit);
                BgCommCHelper.enableAction((JButton)this.btnGroupRemove, (JMenuItem)this.menuItemGroupRemove, (ItemAction)this.actionGroupRemove);
            }
        }
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            menu.removeAll();
        }
        super.initPopmenu();
    }

    protected boolean checkIsSelectedOfLeaf() {
        return true;
    }

    public void setSelectTreeNode() throws Exception {
        KDTreeNode root = (KDTreeNode)this.treeMain.getModel().getRoot();
        BgExamineGroupInfo info = null;
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            KDTreeNode childAt = (KDTreeNode)root.getChildAt(i);
            if (childAt == null || !(childAt.getUserObject() instanceof BgExamineGroupInfo) || !(info = (BgExamineGroupInfo)childAt.getUserObject()).getNumber().toString().equals(this.newGroupNumber)) continue;
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)childAt);
            break;
        }
    }

    public Object getSelectTreeObj() {
        Object newObj;
        Object obj = null;
        if (this.treeMain.getSelectionPath() != null && (newObj = this.treeMain.getSelectionPath().getLastPathComponent()) instanceof KDTreeNode && ((KDTreeNode)newObj).getUserObject() instanceof BgExamineGroupInfo) {
            obj = ((KDTreeNode)newObj).getUserObject();
        }
        return obj;
    }

    protected BgSchemeInfo getSelectBgScheme() {
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            return (BgSchemeInfo)this.prmtBgScheme.getData();
        }
        return null;
    }

    @Override
    public void actionHistVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.showHisUI(MODEL_HISTVERSION);
    }

    @Override
    public void actionDelHist_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtBgScheme.getData() == null) {
            this.showSchemeNullWarning();
            SysUtil.abort();
        }
        if (!BgExamineHistFactory.getRemoteInstance().exists("select id where bgScheme.id = '" + this.getSelectBgScheme().getId().toString() + "' and isDelete = 1")) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"notExistsDel"));
            return;
        }
        this.showHisUI(MODEL_DELHIST);
    }

    private void showHisUI(String model) throws UIException {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)MODEL, (Object)model);
        if (MODEL_HISTVERSION.equals(model)) {
            ctx.put((Object)"IDList", (Object)this.getSelectedIdValues());
        }
        ctx.put((Object)"bgScheme", this.prmtBgScheme.getData());
        this.putUIContext(ctx);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getBgExamineHistUIName(), (Map)ctx, null);
        if (window instanceof UINewFrame) {
            UINewFrame frame = (UINewFrame)window;
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)screensize.getWidth();
            int height = (int)screensize.getHeight();
            width = Math.min(width, 1013);
            height = Math.min(height, 800);
            frame.setSize(width, height);
            window.show();
            frame.setExtendedState(6);
        } else {
            BgBaseHelper.setMaxDialog((IUIWindow)window);
            window.show();
        }
    }

    protected String getBgExamineHistUIName() {
        return BgExamineHistListUI.class.getName();
    }

    protected void putUIContext(UIContext ctx) {
    }
}

