/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioNodeCollection;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgExcuteAnalysisSelectScenUI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExcuteAnalysisSelectScenUI
extends AbstractBgExcuteAnalysisSelectScenUI {
    private static final long serialVersionUID = 7799654781297334860L;
    private static final Logger logger = CoreUIObject.getLogger(BgExcuteAnalysisSelectScenUI.class);
    protected static final String res = "com.kingdee.eas.ma.mbg.MBgAnalyseResource";
    protected static final String COL_BGNUMBER = "bgScenNumber";
    protected static final String COL_BGNAME = "bgScenName";
    protected static final String COL_ACTNUMBER = "actScenNumber";
    protected static final String COL_ACTNAME = "actScenName";
    private BgSchemeInfo schemeInfo = null;
    private Map<String, BgScenarioInfo> scenarioMap = null;
    private Set<String> allSenarioNum = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Set<String> actScenSet = null;
    private Map<String, Set<String>> returnMap = new LinkedHashMap<String, Set<String>>();
    private boolean isCancel = true;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.schemeInfo = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        this.allSenarioNum = (Set)this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO);
        this.scenarioMap = (Map)this.getUIContext().get(BgBaseConstants.BGTEMPLATE_INFO);
        this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        this.initTable();
        this.btnCreate.setEnabled(true);
    }

    private void initTable() throws BOSException {
        this.kDTable.checkParsed();
        String senarioNum = null;
        IRow row = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", this.schemeHelper.getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, true), CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)BgScenarioType.ActualData.getValue(), CompareType.EQUALS));
        BgScenarioCollection colls = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(viewInfo);
        this.actScenSet = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            this.actScenSet.add(colls.get(i).getNumber());
        }
        ArrayList<String> allSenarioNumList = new ArrayList<String>(this.allSenarioNum);
        Collections.sort(allSenarioNumList);
        this.kDTable.getColumn(COL_BGNUMBER).getStyleAttributes().setLocked(true);
        this.kDTable.getColumn(COL_ACTNUMBER).getStyleAttributes().setLocked(true);
        block1: for (int i = 0; i < allSenarioNumList.size(); ++i) {
            senarioNum = (String)allSenarioNumList.get(i);
            row = this.kDTable.addRow();
            row.getCell(COL_BGNUMBER).setValue((Object)senarioNum);
            row.getCell(COL_BGNAME).setValue((Object)this.scenarioMap.get(senarioNum).getName());
            BgScenarioNodeCollection coll = this.scenarioMap.get(senarioNum).getActScenarios();
            if (coll == null || coll.isEmpty()) continue;
            for (int j = 0; j < coll.size(); ++j) {
                if (coll.get(j).getActScenario() == null || !this.actScenSet.contains(coll.get(j).getActScenario().getNumber())) continue;
                row.getCell(COL_ACTNUMBER).setValue((Object)coll.get(j).getActScenario().getNumber());
                row.getCell(COL_ACTNAME).setValue((Object)coll.get(j).getActScenario().getName());
                continue block1;
            }
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        KDTSelectManager selectManager = this.kDTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
        }
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (this.kDTable.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            }
            for (int i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            this.kDTable.removeRow(rowIndex);
        }
    }

    @Override
    public void actionAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewLine_actionPerformed(e);
        this.kDTable.addRow();
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
        int activeRow = this.kDTable.getSelectManager().getActiveRowIndex();
        if (activeRow < 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        IRow fromRow = this.kDTable.getRow(activeRow);
        IRow toRow = this.kDTable.addRow(activeRow);
        toRow.getCell(COL_BGNUMBER).setValue(fromRow.getCell(COL_BGNUMBER).getValue());
        toRow.getCell(COL_BGNAME).setValue(fromRow.getCell(COL_BGNAME).getValue());
        toRow.getCell(COL_ACTNUMBER).setValue(fromRow.getCell(COL_ACTNUMBER).getValue());
        toRow.getCell(COL_ACTNAME).setValue(fromRow.getCell(COL_ACTNAME).getValue());
    }

    public Map<String, Set<String>> getReturnMap() {
        return this.returnMap;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    @Override
    public void actionCreate_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreate_actionPerformed(e);
        if (this.verify()) {
            int i;
            this.setCancel(false);
            this.returnMap.clear();
            IRow row = null;
            ArrayList<String> bgdatascen = new ArrayList<String>();
            HashMap map = new HashMap();
            for (i = 0; i < this.kDTable.getRowCount(); ++i) {
                row = this.kDTable.getRow(i);
                Object obj1 = row.getCell(COL_BGNUMBER).getValue();
                Object obj2 = row.getCell(COL_ACTNUMBER).getValue();
                if (obj1 == null && obj2 == null) continue;
                bgdatascen.add(obj1.toString());
                if (map.containsKey(obj1.toString())) {
                    ((Set)map.get(obj1.toString())).add(obj2.toString());
                    continue;
                }
                HashSet<String> actSet = new HashSet<String>();
                actSet.add(obj2.toString());
                map.put(obj1.toString(), actSet);
            }
            Collections.sort(bgdatascen);
            for (i = 0; i < bgdatascen.size(); ++i) {
                if (!map.containsKey(bgdatascen.get(i))) continue;
                this.returnMap.put((String)bgdatascen.get(i), (Set<String>)map.get(bgdatascen.get(i)));
            }
            if (!this.returnMap.isEmpty()) {
                this.getUIWindow().close();
            }
        }
    }

    private boolean verify() {
        IRow row = null;
        HashMap<String, Integer> keySet = new HashMap<String, Integer>();
        String key = null;
        String msg = null;
        if (this.kDTable.getRowCount() < 1) {
            return false;
        }
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            row = this.kDTable.getRow(i);
            Object obj1 = row.getCell(COL_BGNUMBER).getValue();
            Object obj2 = row.getCell(COL_ACTNUMBER).getValue();
            if (obj1 == null && obj2 == null) continue;
            if (obj1 == null) {
                msg = EASResource.getString((String)res, (String)"bgNumberIsNull", (Object[])new Object[]{i + 1});
                break;
            }
            if (obj2 == null) {
                msg = EASResource.getString((String)res, (String)"actNumberIsNull", (Object[])new Object[]{i + 1});
                break;
            }
            key = obj1.toString() + BgBaseConstants.COMBINATE_SPLITER_TABLE + obj2.toString();
            if (keySet.containsKey(key)) {
                msg = EASResource.getString((String)res, (String)"numberRepeat", (Object[])new Object[]{keySet.get(key), i + 1});
                break;
            }
            keySet.put(key, i + 1);
        }
        if (msg != null) {
            MsgBox.showWarning((Component)((Object)this), msg);
            return false;
        }
        return true;
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kDTable_tableClicked(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (colIndex == this.kDTable.getColumnIndex(COL_BGNAME)) {
            ICellEditor editor = this.kDTable.getCell(rowIndex, COL_BGNAME).getEditor();
            if (!(editor instanceof KDTDefaultCellEditor) || !(editor.getComponent() instanceof KDBizPromptBox)) {
                KDBizPromptBox prmtProBox = new KDBizPromptBox();
                prmtProBox.setEditable(false);
                prmtProBox.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
                prmtProBox.setDisplayFormat("$number$");
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(new FilterInfo());
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", this.allSenarioNum, CompareType.INCLUDE));
                prmtProBox.setEntityViewInfo(viewInfo);
                this.kDTable.getCell(rowIndex, COL_BGNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProBox));
                prmtProBox.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent e) {
                        BgScenarioInfo objNew = (BgScenarioInfo)e.getNewValue();
                        IRow row = BgExcuteAnalysisSelectScenUI.this.kDTable.getRow(BgExcuteAnalysisSelectScenUI.this.kDTable.getSelectManager().getActiveRowIndex());
                        if (objNew != null) {
                            BgExcuteAnalysisSelectScenUI.this.kDTable.getCell(row.getRowIndex(), BgExcuteAnalysisSelectScenUI.COL_BGNUMBER).setValue((Object)objNew.getNumber());
                        } else {
                            BgExcuteAnalysisSelectScenUI.this.kDTable.getCell(row.getRowIndex(), BgExcuteAnalysisSelectScenUI.COL_BGNUMBER).setValue(null);
                        }
                    }
                });
            }
        } else if (colIndex == this.kDTable.getColumnIndex(COL_ACTNAME)) {
            BgScenarioNodeCollection coll;
            ICellEditor editor = this.kDTable.getCell(rowIndex, COL_ACTNAME).getEditor();
            Object value = this.kDTable.getCell(rowIndex, COL_BGNUMBER).getValue();
            Set<String> actNumberSet = this.schemeHelper.getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, true);
            if (value != null && (coll = this.scenarioMap.get(value.toString()).getActScenarios()) != null && !coll.isEmpty()) {
                actNumberSet.clear();
                for (int j = 0; j < coll.size(); ++j) {
                    if (coll.get(j).getActScenario() == null || !this.actScenSet.contains(coll.get(j).getActScenario().getNumber())) continue;
                    actNumberSet.add(coll.get(j).getActScenario().getNumber());
                }
            }
            KDBizPromptBox prmtProBox = new KDBizPromptBox();
            prmtProBox.setEditable(false);
            prmtProBox.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
            prmtProBox.setDisplayFormat("$number$");
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", actNumberSet, CompareType.INCLUDE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)BgScenarioType.ActualData.getValue(), CompareType.EQUALS));
            prmtProBox.setEntityViewInfo(viewInfo);
            this.kDTable.getCell(rowIndex, COL_ACTNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProBox));
            prmtProBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    BgScenarioInfo objNew = (BgScenarioInfo)e.getNewValue();
                    IRow row = BgExcuteAnalysisSelectScenUI.this.kDTable.getRow(BgExcuteAnalysisSelectScenUI.this.kDTable.getSelectManager().getActiveRowIndex());
                    if (objNew != null) {
                        BgExcuteAnalysisSelectScenUI.this.kDTable.getCell(row.getRowIndex(), BgExcuteAnalysisSelectScenUI.COL_ACTNUMBER).setValue((Object)objNew.getNumber());
                    } else {
                        BgExcuteAnalysisSelectScenUI.this.kDTable.getCell(row.getRowIndex(), BgExcuteAnalysisSelectScenUI.COL_ACTNUMBER).setValue(null);
                    }
                }
            });
        }
    }
}

